/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The training result details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrainingResultV2 implements SdkPojo, Serializable,
        ToCopyableBuilder<TrainingResultV2.Builder, TrainingResultV2> {
    private static final SdkField<DataValidationMetrics> DATA_VALIDATION_METRICS_FIELD = SdkField
            .<DataValidationMetrics> builder(MarshallingType.SDK_POJO).memberName("dataValidationMetrics")
            .getter(getter(TrainingResultV2::dataValidationMetrics)).setter(setter(Builder::dataValidationMetrics))
            .constructor(DataValidationMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataValidationMetrics").build())
            .build();

    private static final SdkField<TrainingMetricsV2> TRAINING_METRICS_V2_FIELD = SdkField
            .<TrainingMetricsV2> builder(MarshallingType.SDK_POJO).memberName("trainingMetricsV2")
            .getter(getter(TrainingResultV2::trainingMetricsV2)).setter(setter(Builder::trainingMetricsV2))
            .constructor(TrainingMetricsV2::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingMetricsV2").build()).build();

    private static final SdkField<VariableImportanceMetrics> VARIABLE_IMPORTANCE_METRICS_FIELD = SdkField
            .<VariableImportanceMetrics> builder(MarshallingType.SDK_POJO).memberName("variableImportanceMetrics")
            .getter(getter(TrainingResultV2::variableImportanceMetrics)).setter(setter(Builder::variableImportanceMetrics))
            .constructor(VariableImportanceMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variableImportanceMetrics").build())
            .build();

    private static final SdkField<AggregatedVariablesImportanceMetrics> AGGREGATED_VARIABLES_IMPORTANCE_METRICS_FIELD = SdkField
            .<AggregatedVariablesImportanceMetrics> builder(MarshallingType.SDK_POJO)
            .memberName("aggregatedVariablesImportanceMetrics")
            .getter(getter(TrainingResultV2::aggregatedVariablesImportanceMetrics))
            .setter(setter(Builder::aggregatedVariablesImportanceMetrics))
            .constructor(AggregatedVariablesImportanceMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("aggregatedVariablesImportanceMetrics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_VALIDATION_METRICS_FIELD,
            TRAINING_METRICS_V2_FIELD, VARIABLE_IMPORTANCE_METRICS_FIELD, AGGREGATED_VARIABLES_IMPORTANCE_METRICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final DataValidationMetrics dataValidationMetrics;

    private final TrainingMetricsV2 trainingMetricsV2;

    private final VariableImportanceMetrics variableImportanceMetrics;

    private final AggregatedVariablesImportanceMetrics aggregatedVariablesImportanceMetrics;

    private TrainingResultV2(BuilderImpl builder) {
        this.dataValidationMetrics = builder.dataValidationMetrics;
        this.trainingMetricsV2 = builder.trainingMetricsV2;
        this.variableImportanceMetrics = builder.variableImportanceMetrics;
        this.aggregatedVariablesImportanceMetrics = builder.aggregatedVariablesImportanceMetrics;
    }

    /**
     * Returns the value of the DataValidationMetrics property for this object.
     * 
     * @return The value of the DataValidationMetrics property for this object.
     */
    public final DataValidationMetrics dataValidationMetrics() {
        return dataValidationMetrics;
    }

    /**
     * <p>
     * The training metric details.
     * </p>
     * 
     * @return The training metric details.
     */
    public final TrainingMetricsV2 trainingMetricsV2() {
        return trainingMetricsV2;
    }

    /**
     * Returns the value of the VariableImportanceMetrics property for this object.
     * 
     * @return The value of the VariableImportanceMetrics property for this object.
     */
    public final VariableImportanceMetrics variableImportanceMetrics() {
        return variableImportanceMetrics;
    }

    /**
     * <p>
     * The variable importance metrics of the aggregated variables.
     * </p>
     * <p>
     * Account Takeover Insights (ATI) model uses event variables from the login data you provide to continuously
     * calculate a set of variables (aggregated variables) based on historical events. For example, your ATI model might
     * calculate the number of times an user has logged in using the same IP address. In this case, event variables used
     * to derive the aggregated variables are <code>IP address</code> and <code>user</code>.
     * </p>
     * 
     * @return The variable importance metrics of the aggregated variables. </p>
     *         <p>
     *         Account Takeover Insights (ATI) model uses event variables from the login data you provide to
     *         continuously calculate a set of variables (aggregated variables) based on historical events. For example,
     *         your ATI model might calculate the number of times an user has logged in using the same IP address. In
     *         this case, event variables used to derive the aggregated variables are <code>IP address</code> and
     *         <code>user</code>.
     */
    public final AggregatedVariablesImportanceMetrics aggregatedVariablesImportanceMetrics() {
        return aggregatedVariablesImportanceMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataValidationMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(trainingMetricsV2());
        hashCode = 31 * hashCode + Objects.hashCode(variableImportanceMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(aggregatedVariablesImportanceMetrics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingResultV2)) {
            return false;
        }
        TrainingResultV2 other = (TrainingResultV2) obj;
        return Objects.equals(dataValidationMetrics(), other.dataValidationMetrics())
                && Objects.equals(trainingMetricsV2(), other.trainingMetricsV2())
                && Objects.equals(variableImportanceMetrics(), other.variableImportanceMetrics())
                && Objects.equals(aggregatedVariablesImportanceMetrics(), other.aggregatedVariablesImportanceMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrainingResultV2").add("DataValidationMetrics", dataValidationMetrics())
                .add("TrainingMetricsV2", trainingMetricsV2()).add("VariableImportanceMetrics", variableImportanceMetrics())
                .add("AggregatedVariablesImportanceMetrics", aggregatedVariablesImportanceMetrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataValidationMetrics":
            return Optional.ofNullable(clazz.cast(dataValidationMetrics()));
        case "trainingMetricsV2":
            return Optional.ofNullable(clazz.cast(trainingMetricsV2()));
        case "variableImportanceMetrics":
            return Optional.ofNullable(clazz.cast(variableImportanceMetrics()));
        case "aggregatedVariablesImportanceMetrics":
            return Optional.ofNullable(clazz.cast(aggregatedVariablesImportanceMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrainingResultV2, T> g) {
        return obj -> g.apply((TrainingResultV2) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrainingResultV2> {
        /**
         * Sets the value of the DataValidationMetrics property for this object.
         *
         * @param dataValidationMetrics
         *        The new value for the DataValidationMetrics property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataValidationMetrics(DataValidationMetrics dataValidationMetrics);

        /**
         * Sets the value of the DataValidationMetrics property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DataValidationMetrics.Builder} avoiding
         * the need to create one manually via {@link DataValidationMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataValidationMetrics.Builder#build()} is called immediately and
         * its result is passed to {@link #dataValidationMetrics(DataValidationMetrics)}.
         * 
         * @param dataValidationMetrics
         *        a consumer that will call methods on {@link DataValidationMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataValidationMetrics(DataValidationMetrics)
         */
        default Builder dataValidationMetrics(Consumer<DataValidationMetrics.Builder> dataValidationMetrics) {
            return dataValidationMetrics(DataValidationMetrics.builder().applyMutation(dataValidationMetrics).build());
        }

        /**
         * <p>
         * The training metric details.
         * </p>
         * 
         * @param trainingMetricsV2
         *        The training metric details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingMetricsV2(TrainingMetricsV2 trainingMetricsV2);

        /**
         * <p>
         * The training metric details.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrainingMetricsV2.Builder} avoiding the
         * need to create one manually via {@link TrainingMetricsV2#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrainingMetricsV2.Builder#build()} is called immediately and its
         * result is passed to {@link #trainingMetricsV2(TrainingMetricsV2)}.
         * 
         * @param trainingMetricsV2
         *        a consumer that will call methods on {@link TrainingMetricsV2.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingMetricsV2(TrainingMetricsV2)
         */
        default Builder trainingMetricsV2(Consumer<TrainingMetricsV2.Builder> trainingMetricsV2) {
            return trainingMetricsV2(TrainingMetricsV2.builder().applyMutation(trainingMetricsV2).build());
        }

        /**
         * Sets the value of the VariableImportanceMetrics property for this object.
         *
         * @param variableImportanceMetrics
         *        The new value for the VariableImportanceMetrics property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variableImportanceMetrics(VariableImportanceMetrics variableImportanceMetrics);

        /**
         * Sets the value of the VariableImportanceMetrics property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VariableImportanceMetrics.Builder}
         * avoiding the need to create one manually via {@link VariableImportanceMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VariableImportanceMetrics.Builder#build()} is called immediately
         * and its result is passed to {@link #variableImportanceMetrics(VariableImportanceMetrics)}.
         * 
         * @param variableImportanceMetrics
         *        a consumer that will call methods on {@link VariableImportanceMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #variableImportanceMetrics(VariableImportanceMetrics)
         */
        default Builder variableImportanceMetrics(Consumer<VariableImportanceMetrics.Builder> variableImportanceMetrics) {
            return variableImportanceMetrics(VariableImportanceMetrics.builder().applyMutation(variableImportanceMetrics).build());
        }

        /**
         * <p>
         * The variable importance metrics of the aggregated variables.
         * </p>
         * <p>
         * Account Takeover Insights (ATI) model uses event variables from the login data you provide to continuously
         * calculate a set of variables (aggregated variables) based on historical events. For example, your ATI model
         * might calculate the number of times an user has logged in using the same IP address. In this case, event
         * variables used to derive the aggregated variables are <code>IP address</code> and <code>user</code>.
         * </p>
         * 
         * @param aggregatedVariablesImportanceMetrics
         *        The variable importance metrics of the aggregated variables. </p>
         *        <p>
         *        Account Takeover Insights (ATI) model uses event variables from the login data you provide to
         *        continuously calculate a set of variables (aggregated variables) based on historical events. For
         *        example, your ATI model might calculate the number of times an user has logged in using the same IP
         *        address. In this case, event variables used to derive the aggregated variables are
         *        <code>IP address</code> and <code>user</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatedVariablesImportanceMetrics(AggregatedVariablesImportanceMetrics aggregatedVariablesImportanceMetrics);

        /**
         * <p>
         * The variable importance metrics of the aggregated variables.
         * </p>
         * <p>
         * Account Takeover Insights (ATI) model uses event variables from the login data you provide to continuously
         * calculate a set of variables (aggregated variables) based on historical events. For example, your ATI model
         * might calculate the number of times an user has logged in using the same IP address. In this case, event
         * variables used to derive the aggregated variables are <code>IP address</code> and <code>user</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AggregatedVariablesImportanceMetrics.Builder} avoiding the need to create one manually via
         * {@link AggregatedVariablesImportanceMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AggregatedVariablesImportanceMetrics.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #aggregatedVariablesImportanceMetrics(AggregatedVariablesImportanceMetrics)}.
         * 
         * @param aggregatedVariablesImportanceMetrics
         *        a consumer that will call methods on {@link AggregatedVariablesImportanceMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregatedVariablesImportanceMetrics(AggregatedVariablesImportanceMetrics)
         */
        default Builder aggregatedVariablesImportanceMetrics(
                Consumer<AggregatedVariablesImportanceMetrics.Builder> aggregatedVariablesImportanceMetrics) {
            return aggregatedVariablesImportanceMetrics(AggregatedVariablesImportanceMetrics.builder()
                    .applyMutation(aggregatedVariablesImportanceMetrics).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DataValidationMetrics dataValidationMetrics;

        private TrainingMetricsV2 trainingMetricsV2;

        private VariableImportanceMetrics variableImportanceMetrics;

        private AggregatedVariablesImportanceMetrics aggregatedVariablesImportanceMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingResultV2 model) {
            dataValidationMetrics(model.dataValidationMetrics);
            trainingMetricsV2(model.trainingMetricsV2);
            variableImportanceMetrics(model.variableImportanceMetrics);
            aggregatedVariablesImportanceMetrics(model.aggregatedVariablesImportanceMetrics);
        }

        public final DataValidationMetrics.Builder getDataValidationMetrics() {
            return dataValidationMetrics != null ? dataValidationMetrics.toBuilder() : null;
        }

        public final void setDataValidationMetrics(DataValidationMetrics.BuilderImpl dataValidationMetrics) {
            this.dataValidationMetrics = dataValidationMetrics != null ? dataValidationMetrics.build() : null;
        }

        @Override
        public final Builder dataValidationMetrics(DataValidationMetrics dataValidationMetrics) {
            this.dataValidationMetrics = dataValidationMetrics;
            return this;
        }

        public final TrainingMetricsV2.Builder getTrainingMetricsV2() {
            return trainingMetricsV2 != null ? trainingMetricsV2.toBuilder() : null;
        }

        public final void setTrainingMetricsV2(TrainingMetricsV2.BuilderImpl trainingMetricsV2) {
            this.trainingMetricsV2 = trainingMetricsV2 != null ? trainingMetricsV2.build() : null;
        }

        @Override
        public final Builder trainingMetricsV2(TrainingMetricsV2 trainingMetricsV2) {
            this.trainingMetricsV2 = trainingMetricsV2;
            return this;
        }

        public final VariableImportanceMetrics.Builder getVariableImportanceMetrics() {
            return variableImportanceMetrics != null ? variableImportanceMetrics.toBuilder() : null;
        }

        public final void setVariableImportanceMetrics(VariableImportanceMetrics.BuilderImpl variableImportanceMetrics) {
            this.variableImportanceMetrics = variableImportanceMetrics != null ? variableImportanceMetrics.build() : null;
        }

        @Override
        public final Builder variableImportanceMetrics(VariableImportanceMetrics variableImportanceMetrics) {
            this.variableImportanceMetrics = variableImportanceMetrics;
            return this;
        }

        public final AggregatedVariablesImportanceMetrics.Builder getAggregatedVariablesImportanceMetrics() {
            return aggregatedVariablesImportanceMetrics != null ? aggregatedVariablesImportanceMetrics.toBuilder() : null;
        }

        public final void setAggregatedVariablesImportanceMetrics(
                AggregatedVariablesImportanceMetrics.BuilderImpl aggregatedVariablesImportanceMetrics) {
            this.aggregatedVariablesImportanceMetrics = aggregatedVariablesImportanceMetrics != null ? aggregatedVariablesImportanceMetrics
                    .build() : null;
        }

        @Override
        public final Builder aggregatedVariablesImportanceMetrics(
                AggregatedVariablesImportanceMetrics aggregatedVariablesImportanceMetrics) {
            this.aggregatedVariablesImportanceMetrics = aggregatedVariablesImportanceMetrics;
            return this;
        }

        @Override
        public TrainingResultV2 build() {
            return new TrainingResultV2(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
