/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The model version evaluated for generating prediction.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluatedModelVersion implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluatedModelVersion.Builder, EvaluatedModelVersion> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(EvaluatedModelVersion::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()).build();

    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelVersion").getter(getter(EvaluatedModelVersion::modelVersion)).setter(setter(Builder::modelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVersion").build()).build();

    private static final SdkField<String> MODEL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelType").getter(getter(EvaluatedModelVersion::modelType)).setter(setter(Builder::modelType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelType").build()).build();

    private static final SdkField<List<ModelVersionEvaluation>> EVALUATIONS_FIELD = SdkField
            .<List<ModelVersionEvaluation>> builder(MarshallingType.LIST)
            .memberName("evaluations")
            .getter(getter(EvaluatedModelVersion::evaluations))
            .setter(setter(Builder::evaluations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelVersionEvaluation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelVersionEvaluation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD,
            MODEL_VERSION_FIELD, MODEL_TYPE_FIELD, EVALUATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String modelId;

    private final String modelVersion;

    private final String modelType;

    private final List<ModelVersionEvaluation> evaluations;

    private EvaluatedModelVersion(BuilderImpl builder) {
        this.modelId = builder.modelId;
        this.modelVersion = builder.modelVersion;
        this.modelType = builder.modelType;
        this.evaluations = builder.evaluations;
    }

    /**
     * <p>
     * The model ID.
     * </p>
     * 
     * @return The model ID.
     */
    public final String modelId() {
        return modelId;
    }

    /**
     * <p>
     * The model version.
     * </p>
     * 
     * @return The model version.
     */
    public final String modelVersion() {
        return modelVersion;
    }

    /**
     * <p>
     * The model type.
     * </p>
     * <p>
     * Valid values: <code>ONLINE_FRAUD_INSIGHTS</code> | <code>TRANSACTION_FRAUD_INSIGHTS</code>
     * </p>
     * 
     * @return The model type. </p>
     *         <p>
     *         Valid values: <code>ONLINE_FRAUD_INSIGHTS</code> | <code>TRANSACTION_FRAUD_INSIGHTS</code>
     */
    public final String modelType() {
        return modelType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Evaluations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEvaluations() {
        return evaluations != null && !(evaluations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Evaluations generated for the model version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvaluations} method.
     * </p>
     * 
     * @return Evaluations generated for the model version.
     */
    public final List<ModelVersionEvaluation> evaluations() {
        return evaluations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(modelType());
        hashCode = 31 * hashCode + Objects.hashCode(hasEvaluations() ? evaluations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluatedModelVersion)) {
            return false;
        }
        EvaluatedModelVersion other = (EvaluatedModelVersion) obj;
        return Objects.equals(modelId(), other.modelId()) && Objects.equals(modelVersion(), other.modelVersion())
                && Objects.equals(modelType(), other.modelType()) && hasEvaluations() == other.hasEvaluations()
                && Objects.equals(evaluations(), other.evaluations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluatedModelVersion").add("ModelId", modelId()).add("ModelVersion", modelVersion())
                .add("ModelType", modelType()).add("Evaluations", hasEvaluations() ? evaluations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "modelVersion":
            return Optional.ofNullable(clazz.cast(modelVersion()));
        case "modelType":
            return Optional.ofNullable(clazz.cast(modelType()));
        case "evaluations":
            return Optional.ofNullable(clazz.cast(evaluations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluatedModelVersion, T> g) {
        return obj -> g.apply((EvaluatedModelVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluatedModelVersion> {
        /**
         * <p>
         * The model ID.
         * </p>
         * 
         * @param modelId
         *        The model ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * The model version.
         * </p>
         * 
         * @param modelVersion
         *        The model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersion(String modelVersion);

        /**
         * <p>
         * The model type.
         * </p>
         * <p>
         * Valid values: <code>ONLINE_FRAUD_INSIGHTS</code> | <code>TRANSACTION_FRAUD_INSIGHTS</code>
         * </p>
         * 
         * @param modelType
         *        The model type. </p>
         *        <p>
         *        Valid values: <code>ONLINE_FRAUD_INSIGHTS</code> | <code>TRANSACTION_FRAUD_INSIGHTS</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelType(String modelType);

        /**
         * <p>
         * Evaluations generated for the model version.
         * </p>
         * 
         * @param evaluations
         *        Evaluations generated for the model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluations(Collection<ModelVersionEvaluation> evaluations);

        /**
         * <p>
         * Evaluations generated for the model version.
         * </p>
         * 
         * @param evaluations
         *        Evaluations generated for the model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluations(ModelVersionEvaluation... evaluations);

        /**
         * <p>
         * Evaluations generated for the model version.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.frauddetector.model.ModelVersionEvaluation.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.frauddetector.model.ModelVersionEvaluation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.frauddetector.model.ModelVersionEvaluation.Builder#build()} is called
         * immediately and its result is passed to {@link #evaluations(List<ModelVersionEvaluation>)}.
         * 
         * @param evaluations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.frauddetector.model.ModelVersionEvaluation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluations(java.util.Collection<ModelVersionEvaluation>)
         */
        Builder evaluations(Consumer<ModelVersionEvaluation.Builder>... evaluations);
    }

    static final class BuilderImpl implements Builder {
        private String modelId;

        private String modelVersion;

        private String modelType;

        private List<ModelVersionEvaluation> evaluations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluatedModelVersion model) {
            modelId(model.modelId);
            modelVersion(model.modelVersion);
            modelType(model.modelType);
            evaluations(model.evaluations);
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getModelVersion() {
            return modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final String getModelType() {
            return modelType;
        }

        public final void setModelType(String modelType) {
            this.modelType = modelType;
        }

        @Override
        public final Builder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        public final List<ModelVersionEvaluation.Builder> getEvaluations() {
            List<ModelVersionEvaluation.Builder> result = ListOfModelVersionEvaluationsCopier.copyToBuilder(this.evaluations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluations(Collection<ModelVersionEvaluation.BuilderImpl> evaluations) {
            this.evaluations = ListOfModelVersionEvaluationsCopier.copyFromBuilder(evaluations);
        }

        @Override
        public final Builder evaluations(Collection<ModelVersionEvaluation> evaluations) {
            this.evaluations = ListOfModelVersionEvaluationsCopier.copy(evaluations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluations(ModelVersionEvaluation... evaluations) {
            evaluations(Arrays.asList(evaluations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluations(Consumer<ModelVersionEvaluation.Builder>... evaluations) {
            evaluations(Stream.of(evaluations).map(c -> ModelVersionEvaluation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public EvaluatedModelVersion build() {
            return new EvaluatedModelVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
