/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.frauddetector.DefaultFraudDetectorBaseClientBuilder;
import software.amazon.awssdk.services.frauddetector.DefaultFraudDetectorClient;
import software.amazon.awssdk.services.frauddetector.FraudDetectorClient;
import software.amazon.awssdk.services.frauddetector.FraudDetectorClientBuilder;
import software.amazon.awssdk.services.frauddetector.FraudDetectorServiceClientConfiguration;
import software.amazon.awssdk.services.frauddetector.endpoints.FraudDetectorEndpointProvider;

@SdkInternalApi
final class DefaultFraudDetectorClientBuilder
extends DefaultFraudDetectorBaseClientBuilder<FraudDetectorClientBuilder, FraudDetectorClient>
implements FraudDetectorClientBuilder {
    DefaultFraudDetectorClientBuilder() {
    }

    @Override
    public DefaultFraudDetectorClientBuilder endpointProvider(FraudDetectorEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final FraudDetectorClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultFraudDetectorClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        FraudDetectorServiceClientConfiguration serviceClientConfiguration = FraudDetectorServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultFraudDetectorClient(serviceClientConfiguration, clientConfiguration);
    }
}

