/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ModelOutputDataFormat {
    TEXT_CSV("TEXT_CSV"),
    APPLICATION_JSONLINES("APPLICATION_JSONLINES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ModelOutputDataFormat> VALUE_MAP;
    private final String value;

    private ModelOutputDataFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelOutputDataFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelOutputDataFormat> knownValues() {
        EnumSet<ModelOutputDataFormat> knownValues = EnumSet.allOf(ModelOutputDataFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ModelOutputDataFormat.class, ModelOutputDataFormat::toString);
    }
}

