/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.frauddetector.internal.FraudDetectorServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.frauddetector.model.AccessDeniedException;
import software.amazon.awssdk.services.frauddetector.model.BatchCreateVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.BatchCreateVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.BatchGetVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.BatchGetVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.CancelBatchImportJobRequest;
import software.amazon.awssdk.services.frauddetector.model.CancelBatchImportJobResponse;
import software.amazon.awssdk.services.frauddetector.model.CancelBatchPredictionJobRequest;
import software.amazon.awssdk.services.frauddetector.model.CancelBatchPredictionJobResponse;
import software.amazon.awssdk.services.frauddetector.model.ConflictException;
import software.amazon.awssdk.services.frauddetector.model.CreateBatchImportJobRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateBatchImportJobResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateBatchPredictionJobRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateBatchPredictionJobResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateDetectorVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateDetectorVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateListRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateListResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateModelRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateModelResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateModelVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateModelVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateRuleRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateRuleResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteBatchImportJobRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteBatchImportJobResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteBatchPredictionJobRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteBatchPredictionJobResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteDetectorVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteDetectorVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteEntityTypeRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteEntityTypeResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventTypeRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventTypeResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventsByEventTypeRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventsByEventTypeResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteExternalModelRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteExternalModelResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteLabelRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteLabelResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteListRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteListResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteModelRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteModelResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteModelVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteModelVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteOutcomeRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteOutcomeResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteRuleRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteRuleResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.DescribeDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.DescribeDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsRequest;
import software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsResponse;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorException;
import software.amazon.awssdk.services.frauddetector.model.GetBatchImportJobsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetBatchImportJobsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetBatchPredictionJobsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetBatchPredictionJobsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetDeleteEventsByEventTypeStatusRequest;
import software.amazon.awssdk.services.frauddetector.model.GetDeleteEventsByEventTypeStatusResponse;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetEntityTypesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetEntityTypesResponse;
import software.amazon.awssdk.services.frauddetector.model.GetEventPredictionMetadataRequest;
import software.amazon.awssdk.services.frauddetector.model.GetEventPredictionMetadataResponse;
import software.amazon.awssdk.services.frauddetector.model.GetEventPredictionRequest;
import software.amazon.awssdk.services.frauddetector.model.GetEventPredictionResponse;
import software.amazon.awssdk.services.frauddetector.model.GetEventRequest;
import software.amazon.awssdk.services.frauddetector.model.GetEventResponse;
import software.amazon.awssdk.services.frauddetector.model.GetEventTypesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetEventTypesResponse;
import software.amazon.awssdk.services.frauddetector.model.GetExternalModelsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetExternalModelsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetKmsEncryptionKeyRequest;
import software.amazon.awssdk.services.frauddetector.model.GetKmsEncryptionKeyResponse;
import software.amazon.awssdk.services.frauddetector.model.GetLabelsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetLabelsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetListElementsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetListElementsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetListsMetadataRequest;
import software.amazon.awssdk.services.frauddetector.model.GetListsMetadataResponse;
import software.amazon.awssdk.services.frauddetector.model.GetModelVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.GetModelVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.GetModelsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetModelsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetOutcomesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetOutcomesResponse;
import software.amazon.awssdk.services.frauddetector.model.GetRulesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetRulesResponse;
import software.amazon.awssdk.services.frauddetector.model.GetVariablesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetVariablesResponse;
import software.amazon.awssdk.services.frauddetector.model.InternalServerException;
import software.amazon.awssdk.services.frauddetector.model.ListEventPredictionsRequest;
import software.amazon.awssdk.services.frauddetector.model.ListEventPredictionsResponse;
import software.amazon.awssdk.services.frauddetector.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.frauddetector.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.frauddetector.model.PutDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.PutDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.PutEntityTypeRequest;
import software.amazon.awssdk.services.frauddetector.model.PutEntityTypeResponse;
import software.amazon.awssdk.services.frauddetector.model.PutEventTypeRequest;
import software.amazon.awssdk.services.frauddetector.model.PutEventTypeResponse;
import software.amazon.awssdk.services.frauddetector.model.PutExternalModelRequest;
import software.amazon.awssdk.services.frauddetector.model.PutExternalModelResponse;
import software.amazon.awssdk.services.frauddetector.model.PutKmsEncryptionKeyRequest;
import software.amazon.awssdk.services.frauddetector.model.PutKmsEncryptionKeyResponse;
import software.amazon.awssdk.services.frauddetector.model.PutLabelRequest;
import software.amazon.awssdk.services.frauddetector.model.PutLabelResponse;
import software.amazon.awssdk.services.frauddetector.model.PutOutcomeRequest;
import software.amazon.awssdk.services.frauddetector.model.PutOutcomeResponse;
import software.amazon.awssdk.services.frauddetector.model.ResourceNotFoundException;
import software.amazon.awssdk.services.frauddetector.model.ResourceUnavailableException;
import software.amazon.awssdk.services.frauddetector.model.SendEventRequest;
import software.amazon.awssdk.services.frauddetector.model.SendEventResponse;
import software.amazon.awssdk.services.frauddetector.model.TagResourceRequest;
import software.amazon.awssdk.services.frauddetector.model.TagResourceResponse;
import software.amazon.awssdk.services.frauddetector.model.ThrottlingException;
import software.amazon.awssdk.services.frauddetector.model.UntagResourceRequest;
import software.amazon.awssdk.services.frauddetector.model.UntagResourceResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionMetadataRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionMetadataResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionStatusRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionStatusResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateEventLabelRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateEventLabelResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateListRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateListResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelVersionStatusRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelVersionStatusResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateRuleMetadataRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateRuleMetadataResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateRuleVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateRuleVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.ValidationException;
import software.amazon.awssdk.services.frauddetector.transform.BatchCreateVariableRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.BatchGetVariableRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.CancelBatchImportJobRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.CancelBatchPredictionJobRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.CreateBatchImportJobRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.CreateBatchPredictionJobRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.CreateDetectorVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.CreateListRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.CreateModelRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.CreateModelVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.CreateRuleRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.CreateVariableRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteBatchImportJobRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteBatchPredictionJobRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteDetectorRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteDetectorVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteEntityTypeRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteEventRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteEventTypeRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteEventsByEventTypeRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteExternalModelRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteLabelRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteListRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteModelRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteModelVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteOutcomeRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteRuleRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteVariableRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DescribeDetectorRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DescribeModelVersionsRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetBatchImportJobsRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetBatchPredictionJobsRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetDeleteEventsByEventTypeStatusRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetDetectorVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetDetectorsRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetEntityTypesRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetEventPredictionMetadataRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetEventPredictionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetEventRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetEventTypesRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetExternalModelsRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetKmsEncryptionKeyRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetLabelsRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetListElementsRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetListsMetadataRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetModelVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetModelsRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetOutcomesRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetRulesRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetVariablesRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.ListEventPredictionsRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.PutDetectorRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.PutEntityTypeRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.PutEventTypeRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.PutExternalModelRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.PutKmsEncryptionKeyRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.PutLabelRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.PutOutcomeRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.SendEventRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateDetectorVersionMetadataRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateDetectorVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateDetectorVersionStatusRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateEventLabelRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateListRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateModelRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateModelVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateModelVersionStatusRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateRuleMetadataRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateRuleVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateVariableRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link FraudDetectorAsyncClient}.
 *
 * @see FraudDetectorAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultFraudDetectorAsyncClient implements FraudDetectorAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultFraudDetectorAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultFraudDetectorAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Creates a batch of variables.
     * </p>
     *
     * @param batchCreateVariableRequest
     * @return A Java Future containing the result of the BatchCreateVariable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.BatchCreateVariable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchCreateVariable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchCreateVariableResponse> batchCreateVariable(
            BatchCreateVariableRequest batchCreateVariableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchCreateVariableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchCreateVariableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchCreateVariable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchCreateVariableResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchCreateVariableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchCreateVariableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchCreateVariableRequest, BatchCreateVariableResponse>()
                            .withOperationName("BatchCreateVariable").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchCreateVariableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchCreateVariableRequest));
            CompletableFuture<BatchCreateVariableResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a batch of variables.
     * </p>
     *
     * @param batchGetVariableRequest
     * @return A Java Future containing the result of the BatchGetVariable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.BatchGetVariable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchGetVariable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetVariableResponse> batchGetVariable(BatchGetVariableRequest batchGetVariableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetVariableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetVariableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetVariable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetVariableResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetVariableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetVariableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetVariableRequest, BatchGetVariableResponse>()
                            .withOperationName("BatchGetVariable").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetVariableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetVariableRequest));
            CompletableFuture<BatchGetVariableResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels an in-progress batch import job.
     * </p>
     *
     * @param cancelBatchImportJobRequest
     * @return A Java Future containing the result of the CancelBatchImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CancelBatchImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CancelBatchImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelBatchImportJobResponse> cancelBatchImportJob(
            CancelBatchImportJobRequest cancelBatchImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelBatchImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelBatchImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelBatchImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelBatchImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelBatchImportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelBatchImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelBatchImportJobRequest, CancelBatchImportJobResponse>()
                            .withOperationName("CancelBatchImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelBatchImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelBatchImportJobRequest));
            CompletableFuture<CancelBatchImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels the specified batch prediction job.
     * </p>
     *
     * @param cancelBatchPredictionJobRequest
     * @return A Java Future containing the result of the CancelBatchPredictionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CancelBatchPredictionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CancelBatchPredictionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelBatchPredictionJobResponse> cancelBatchPredictionJob(
            CancelBatchPredictionJobRequest cancelBatchPredictionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelBatchPredictionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelBatchPredictionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelBatchPredictionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelBatchPredictionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelBatchPredictionJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelBatchPredictionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelBatchPredictionJobRequest, CancelBatchPredictionJobResponse>()
                            .withOperationName("CancelBatchPredictionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelBatchPredictionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelBatchPredictionJobRequest));
            CompletableFuture<CancelBatchPredictionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a batch import job.
     * </p>
     *
     * @param createBatchImportJobRequest
     * @return A Java Future containing the result of the CreateBatchImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateBatchImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateBatchImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBatchImportJobResponse> createBatchImportJob(
            CreateBatchImportJobRequest createBatchImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBatchImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBatchImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBatchImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBatchImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateBatchImportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateBatchImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBatchImportJobRequest, CreateBatchImportJobResponse>()
                            .withOperationName("CreateBatchImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateBatchImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createBatchImportJobRequest));
            CompletableFuture<CreateBatchImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a batch prediction job.
     * </p>
     *
     * @param createBatchPredictionJobRequest
     * @return A Java Future containing the result of the CreateBatchPredictionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateBatchPredictionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateBatchPredictionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBatchPredictionJobResponse> createBatchPredictionJob(
            CreateBatchPredictionJobRequest createBatchPredictionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBatchPredictionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBatchPredictionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBatchPredictionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBatchPredictionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateBatchPredictionJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateBatchPredictionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBatchPredictionJobRequest, CreateBatchPredictionJobResponse>()
                            .withOperationName("CreateBatchPredictionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateBatchPredictionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createBatchPredictionJobRequest));
            CompletableFuture<CreateBatchPredictionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a detector version. The detector version starts in a <code>DRAFT</code> status.
     * </p>
     *
     * @param createDetectorVersionRequest
     * @return A Java Future containing the result of the CreateDetectorVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateDetectorVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDetectorVersionResponse> createDetectorVersion(
            CreateDetectorVersionRequest createDetectorVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDetectorVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDetectorVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDetectorVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDetectorVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDetectorVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDetectorVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDetectorVersionRequest, CreateDetectorVersionResponse>()
                            .withOperationName("CreateDetectorVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDetectorVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDetectorVersionRequest));
            CompletableFuture<CreateDetectorVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a list.
     * </p>
     * <p>
     * List is a set of input data for a variable in your event dataset. You use the input data in a rule that's
     * associated with your detector. For more information, see <a
     * href="https://docs.aws.amazon.com/frauddetector/latest/ug/lists.html">Lists</a>.
     * </p>
     *
     * @param createListRequest
     * @return A Java Future containing the result of the CreateList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateList" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateListResponse> createList(CreateListRequest createListRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createListRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateList");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateListResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateListResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateListResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateListRequest, CreateListResponse>().withOperationName("CreateList")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateListRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createListRequest));
            CompletableFuture<CreateListResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a model using the specified model type.
     * </p>
     *
     * @param createModelRequest
     * @return A Java Future containing the result of the CreateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateModel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateModelResponse> createModel(CreateModelRequest createModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateModelRequest, CreateModelResponse>()
                            .withOperationName("CreateModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createModelRequest));
            CompletableFuture<CreateModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a version of the model using the specified model type and model id.
     * </p>
     *
     * @param createModelVersionRequest
     * @return A Java Future containing the result of the CreateModelVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateModelVersionResponse> createModelVersion(CreateModelVersionRequest createModelVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createModelVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createModelVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModelVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateModelVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateModelVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateModelVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateModelVersionRequest, CreateModelVersionResponse>()
                            .withOperationName("CreateModelVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateModelVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createModelVersionRequest));
            CompletableFuture<CreateModelVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a rule for use with the specified detector.
     * </p>
     *
     * @param createRuleRequest
     * @return A Java Future containing the result of the CreateRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateRule" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRuleResponse> createRule(CreateRuleRequest createRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRuleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRuleRequest, CreateRuleResponse>().withOperationName("CreateRule")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRuleRequest));
            CompletableFuture<CreateRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a variable.
     * </p>
     *
     * @param createVariableRequest
     * @return A Java Future containing the result of the CreateVariable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateVariable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateVariable" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVariableResponse> createVariable(CreateVariableRequest createVariableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVariableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVariableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVariable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateVariableResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateVariableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateVariableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVariableRequest, CreateVariableResponse>()
                            .withOperationName("CreateVariable").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateVariableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createVariableRequest));
            CompletableFuture<CreateVariableResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified batch import job ID record. This action does not delete the data that was batch imported.
     * </p>
     *
     * @param deleteBatchImportJobRequest
     * @return A Java Future containing the result of the DeleteBatchImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteBatchImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteBatchImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBatchImportJobResponse> deleteBatchImportJob(
            DeleteBatchImportJobRequest deleteBatchImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBatchImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBatchImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBatchImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBatchImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBatchImportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBatchImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBatchImportJobRequest, DeleteBatchImportJobResponse>()
                            .withOperationName("DeleteBatchImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBatchImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBatchImportJobRequest));
            CompletableFuture<DeleteBatchImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a batch prediction job.
     * </p>
     *
     * @param deleteBatchPredictionJobRequest
     * @return A Java Future containing the result of the DeleteBatchPredictionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteBatchPredictionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteBatchPredictionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBatchPredictionJobResponse> deleteBatchPredictionJob(
            DeleteBatchPredictionJobRequest deleteBatchPredictionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBatchPredictionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBatchPredictionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBatchPredictionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBatchPredictionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBatchPredictionJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBatchPredictionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBatchPredictionJobRequest, DeleteBatchPredictionJobResponse>()
                            .withOperationName("DeleteBatchPredictionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBatchPredictionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBatchPredictionJobRequest));
            CompletableFuture<DeleteBatchPredictionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the detector. Before deleting a detector, you must first delete all detector versions and rule versions
     * associated with the detector.
     * </p>
     * <p>
     * When you delete a detector, Amazon Fraud Detector permanently deletes the detector and the data is no longer
     * stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteDetectorRequest
     * @return A Java Future containing the result of the DeleteDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteDetector" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDetectorResponse> deleteDetector(DeleteDetectorRequest deleteDetectorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDetectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDetectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDetector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDetectorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDetectorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDetectorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDetectorRequest, DeleteDetectorResponse>()
                            .withOperationName("DeleteDetector").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDetectorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDetectorRequest));
            CompletableFuture<DeleteDetectorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the detector version. You cannot delete detector versions that are in <code>ACTIVE</code> status.
     * </p>
     * <p>
     * When you delete a detector version, Amazon Fraud Detector permanently deletes the detector and the data is no
     * longer stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteDetectorVersionRequest
     * @return A Java Future containing the result of the DeleteDetectorVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteDetectorVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDetectorVersionResponse> deleteDetectorVersion(
            DeleteDetectorVersionRequest deleteDetectorVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDetectorVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDetectorVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDetectorVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDetectorVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDetectorVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDetectorVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDetectorVersionRequest, DeleteDetectorVersionResponse>()
                            .withOperationName("DeleteDetectorVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDetectorVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDetectorVersionRequest));
            CompletableFuture<DeleteDetectorVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an entity type.
     * </p>
     * <p>
     * You cannot delete an entity type that is included in an event type.
     * </p>
     * <p>
     * When you delete an entity type, Amazon Fraud Detector permanently deletes that entity type and the data is no
     * longer stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteEntityTypeRequest
     * @return A Java Future containing the result of the DeleteEntityType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteEntityType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEntityType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEntityTypeResponse> deleteEntityType(DeleteEntityTypeRequest deleteEntityTypeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEntityTypeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEntityTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEntityType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEntityTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEntityTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEntityTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEntityTypeRequest, DeleteEntityTypeResponse>()
                            .withOperationName("DeleteEntityType").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEntityTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEntityTypeRequest));
            CompletableFuture<DeleteEntityTypeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified event.
     * </p>
     * <p>
     * When you delete an event, Amazon Fraud Detector permanently deletes that event and the event data is no longer
     * stored in Amazon Fraud Detector. If <code>deleteAuditHistory</code> is <code>True</code>, event data is available
     * through search for up to 30 seconds after the delete operation is completed.
     * </p>
     *
     * @param deleteEventRequest
     * @return A Java Future containing the result of the DeleteEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEvent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEventResponse> deleteEvent(DeleteEventRequest deleteEventRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEventRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEventRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEvent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEventResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteEventResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEventResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEventRequest, DeleteEventResponse>()
                            .withOperationName("DeleteEvent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEventRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEventRequest));
            CompletableFuture<DeleteEventResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an event type.
     * </p>
     * <p>
     * You cannot delete an event type that is used in a detector or a model.
     * </p>
     * <p>
     * When you delete an event type, Amazon Fraud Detector permanently deletes that event type and the data is no
     * longer stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteEventTypeRequest
     * @return A Java Future containing the result of the DeleteEventType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteEventType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEventType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEventTypeResponse> deleteEventType(DeleteEventTypeRequest deleteEventTypeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEventTypeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEventTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEventType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEventTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEventTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEventTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEventTypeRequest, DeleteEventTypeResponse>()
                            .withOperationName("DeleteEventType").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEventTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEventTypeRequest));
            CompletableFuture<DeleteEventTypeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes all events of a particular event type.
     * </p>
     *
     * @param deleteEventsByEventTypeRequest
     * @return A Java Future containing the result of the DeleteEventsByEventType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteEventsByEventType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEventsByEventType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEventsByEventTypeResponse> deleteEventsByEventType(
            DeleteEventsByEventTypeRequest deleteEventsByEventTypeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEventsByEventTypeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEventsByEventTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEventsByEventType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEventsByEventTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEventsByEventTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEventsByEventTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEventsByEventTypeRequest, DeleteEventsByEventTypeResponse>()
                            .withOperationName("DeleteEventsByEventType").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEventsByEventTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEventsByEventTypeRequest));
            CompletableFuture<DeleteEventsByEventTypeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a SageMaker model from Amazon Fraud Detector.
     * </p>
     * <p>
     * You can remove an Amazon SageMaker model if it is not associated with a detector version. Removing a SageMaker
     * model disconnects it from Amazon Fraud Detector, but the model remains available in SageMaker.
     * </p>
     *
     * @param deleteExternalModelRequest
     * @return A Java Future containing the result of the DeleteExternalModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteExternalModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteExternalModel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteExternalModelResponse> deleteExternalModel(
            DeleteExternalModelRequest deleteExternalModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteExternalModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteExternalModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteExternalModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteExternalModelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteExternalModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteExternalModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteExternalModelRequest, DeleteExternalModelResponse>()
                            .withOperationName("DeleteExternalModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteExternalModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteExternalModelRequest));
            CompletableFuture<DeleteExternalModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a label.
     * </p>
     * <p>
     * You cannot delete labels that are included in an event type in Amazon Fraud Detector.
     * </p>
     * <p>
     * You cannot delete a label assigned to an event ID. You must first delete the relevant event ID.
     * </p>
     * <p>
     * When you delete a label, Amazon Fraud Detector permanently deletes that label and the data is no longer stored in
     * Amazon Fraud Detector.
     * </p>
     *
     * @param deleteLabelRequest
     * @return A Java Future containing the result of the DeleteLabel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteLabel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLabelResponse> deleteLabel(DeleteLabelRequest deleteLabelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLabelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLabelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLabel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteLabelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteLabelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteLabelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLabelRequest, DeleteLabelResponse>()
                            .withOperationName("DeleteLabel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteLabelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteLabelRequest));
            CompletableFuture<DeleteLabelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the list, provided it is not used in a rule.
     * </p>
     * <p>
     * When you delete a list, Amazon Fraud Detector permanently deletes that list and the elements in the list.
     * </p>
     *
     * @param deleteListRequest
     * @return A Java Future containing the result of the DeleteList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteList" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteListResponse> deleteList(DeleteListRequest deleteListRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteListRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteList");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteListResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteListResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteListResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteListRequest, DeleteListResponse>().withOperationName("DeleteList")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteListRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteListRequest));
            CompletableFuture<DeleteListResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a model.
     * </p>
     * <p>
     * You can delete models and model versions in Amazon Fraud Detector, provided that they are not associated with a
     * detector version.
     * </p>
     * <p>
     * When you delete a model, Amazon Fraud Detector permanently deletes that model and the data is no longer stored in
     * Amazon Fraud Detector.
     * </p>
     *
     * @param deleteModelRequest
     * @return A Java Future containing the result of the DeleteModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteModel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteModelResponse> deleteModel(DeleteModelRequest deleteModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteModelRequest, DeleteModelResponse>()
                            .withOperationName("DeleteModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteModelRequest));
            CompletableFuture<DeleteModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a model version.
     * </p>
     * <p>
     * You can delete models and model versions in Amazon Fraud Detector, provided that they are not associated with a
     * detector version.
     * </p>
     * <p>
     * When you delete a model version, Amazon Fraud Detector permanently deletes that model version and the data is no
     * longer stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteModelVersionRequest
     * @return A Java Future containing the result of the DeleteModelVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteModelVersionResponse> deleteModelVersion(DeleteModelVersionRequest deleteModelVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteModelVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteModelVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModelVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteModelVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteModelVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteModelVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteModelVersionRequest, DeleteModelVersionResponse>()
                            .withOperationName("DeleteModelVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteModelVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteModelVersionRequest));
            CompletableFuture<DeleteModelVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an outcome.
     * </p>
     * <p>
     * You cannot delete an outcome that is used in a rule version.
     * </p>
     * <p>
     * When you delete an outcome, Amazon Fraud Detector permanently deletes that outcome and the data is no longer
     * stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteOutcomeRequest
     * @return A Java Future containing the result of the DeleteOutcome operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteOutcome
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteOutcome" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteOutcomeResponse> deleteOutcome(DeleteOutcomeRequest deleteOutcomeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOutcomeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOutcomeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOutcome");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteOutcomeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteOutcomeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteOutcomeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteOutcomeRequest, DeleteOutcomeResponse>()
                            .withOperationName("DeleteOutcome").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteOutcomeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteOutcomeRequest));
            CompletableFuture<DeleteOutcomeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the rule. You cannot delete a rule if it is used by an <code>ACTIVE</code> or <code>INACTIVE</code>
     * detector version.
     * </p>
     * <p>
     * When you delete a rule, Amazon Fraud Detector permanently deletes that rule and the data is no longer stored in
     * Amazon Fraud Detector.
     * </p>
     *
     * @param deleteRuleRequest
     * @return A Java Future containing the result of the DeleteRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteRule" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRuleResponse> deleteRule(DeleteRuleRequest deleteRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRuleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRuleRequest, DeleteRuleResponse>().withOperationName("DeleteRule")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRuleRequest));
            CompletableFuture<DeleteRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a variable.
     * </p>
     * <p>
     * You can't delete variables that are included in an event type in Amazon Fraud Detector.
     * </p>
     * <p>
     * Amazon Fraud Detector automatically deletes model output variables and SageMaker model output variables when you
     * delete the model. You can't delete these variables manually.
     * </p>
     * <p>
     * When you delete a variable, Amazon Fraud Detector permanently deletes that variable and the data is no longer
     * stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteVariableRequest
     * @return A Java Future containing the result of the DeleteVariable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteVariable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteVariable" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVariableResponse> deleteVariable(DeleteVariableRequest deleteVariableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVariableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVariableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVariable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVariableResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteVariableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteVariableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVariableRequest, DeleteVariableResponse>()
                            .withOperationName("DeleteVariable").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteVariableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteVariableRequest));
            CompletableFuture<DeleteVariableResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets all versions for a specified detector.
     * </p>
     *
     * @param describeDetectorRequest
     * @return A Java Future containing the result of the DescribeDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DescribeDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeDetector"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDetectorResponse> describeDetector(DescribeDetectorRequest describeDetectorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDetectorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDetectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDetector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDetectorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDetectorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDetectorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDetectorRequest, DescribeDetectorResponse>()
                            .withOperationName("DescribeDetector").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDetectorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDetectorRequest));
            CompletableFuture<DescribeDetectorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets all of the model versions for the specified model type or for the specified model type and model ID. You can
     * also get details for a single, specified model version.
     * </p>
     *
     * @param describeModelVersionsRequest
     * @return A Java Future containing the result of the DescribeModelVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DescribeModelVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeModelVersionsResponse> describeModelVersions(
            DescribeModelVersionsRequest describeModelVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeModelVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeModelVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeModelVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeModelVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeModelVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeModelVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeModelVersionsRequest, DescribeModelVersionsResponse>()
                            .withOperationName("DescribeModelVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeModelVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeModelVersionsRequest));
            CompletableFuture<DescribeModelVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets all batch import jobs or a specific job of the specified ID. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 50 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 1 and 50. To get the next page results, provide the pagination
     * token from the <code>GetBatchImportJobsResponse</code> as part of your request. A null pagination token fetches
     * the records from the beginning.
     * </p>
     *
     * @param getBatchImportJobsRequest
     * @return A Java Future containing the result of the GetBatchImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetBatchImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetBatchImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBatchImportJobsResponse> getBatchImportJobs(GetBatchImportJobsRequest getBatchImportJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBatchImportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBatchImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBatchImportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBatchImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBatchImportJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBatchImportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBatchImportJobsRequest, GetBatchImportJobsResponse>()
                            .withOperationName("GetBatchImportJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBatchImportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBatchImportJobsRequest));
            CompletableFuture<GetBatchImportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets all batch prediction jobs or a specific job if you specify a job ID. This is a paginated API. If you provide
     * a null maxResults, this action retrieves a maximum of 50 records per page. If you provide a maxResults, the value
     * must be between 1 and 50. To get the next page results, provide the pagination token from the
     * GetBatchPredictionJobsResponse as part of your request. A null pagination token fetches the records from the
     * beginning.
     * </p>
     *
     * @param getBatchPredictionJobsRequest
     * @return A Java Future containing the result of the GetBatchPredictionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetBatchPredictionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetBatchPredictionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBatchPredictionJobsResponse> getBatchPredictionJobs(
            GetBatchPredictionJobsRequest getBatchPredictionJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBatchPredictionJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBatchPredictionJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBatchPredictionJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBatchPredictionJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBatchPredictionJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBatchPredictionJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBatchPredictionJobsRequest, GetBatchPredictionJobsResponse>()
                            .withOperationName("GetBatchPredictionJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBatchPredictionJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBatchPredictionJobsRequest));
            CompletableFuture<GetBatchPredictionJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the status of a <code>DeleteEventsByEventType</code> action.
     * </p>
     *
     * @param getDeleteEventsByEventTypeStatusRequest
     * @return A Java Future containing the result of the GetDeleteEventsByEventTypeStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetDeleteEventsByEventTypeStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDeleteEventsByEventTypeStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeleteEventsByEventTypeStatusResponse> getDeleteEventsByEventTypeStatus(
            GetDeleteEventsByEventTypeStatusRequest getDeleteEventsByEventTypeStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeleteEventsByEventTypeStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getDeleteEventsByEventTypeStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeleteEventsByEventTypeStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeleteEventsByEventTypeStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetDeleteEventsByEventTypeStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDeleteEventsByEventTypeStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeleteEventsByEventTypeStatusRequest, GetDeleteEventsByEventTypeStatusResponse>()
                            .withOperationName("GetDeleteEventsByEventTypeStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDeleteEventsByEventTypeStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDeleteEventsByEventTypeStatusRequest));
            CompletableFuture<GetDeleteEventsByEventTypeStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a particular detector version.
     * </p>
     *
     * @param getDetectorVersionRequest
     * @return A Java Future containing the result of the GetDetectorVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetDetectorVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDetectorVersionResponse> getDetectorVersion(GetDetectorVersionRequest getDetectorVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDetectorVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDetectorVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDetectorVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDetectorVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDetectorVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDetectorVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDetectorVersionRequest, GetDetectorVersionResponse>()
                            .withOperationName("GetDetectorVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDetectorVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDetectorVersionRequest));
            CompletableFuture<GetDetectorVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets all detectors or a single detector if a <code>detectorId</code> is specified. This is a paginated API. If
     * you provide a null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you
     * provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the
     * pagination token from the <code>GetDetectorsResponse</code> as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     *
     * @param getDetectorsRequest
     * @return A Java Future containing the result of the GetDetectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectors" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDetectorsResponse> getDetectors(GetDetectorsRequest getDetectorsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDetectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDetectorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDetectors");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDetectorsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetDetectorsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDetectorsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDetectorsRequest, GetDetectorsResponse>()
                            .withOperationName("GetDetectors").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDetectorsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDetectorsRequest));
            CompletableFuture<GetDetectorsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets all entity types or a specific entity type if a name is specified. This is a paginated API. If you provide a
     * null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination
     * token from the <code>GetEntityTypesResponse</code> as part of your request. A null pagination token fetches the
     * records from the beginning.
     * </p>
     *
     * @param getEntityTypesRequest
     * @return A Java Future containing the result of the GetEntityTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetEntityTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEntityTypes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetEntityTypesResponse> getEntityTypes(GetEntityTypesRequest getEntityTypesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEntityTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEntityTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEntityTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEntityTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEntityTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEntityTypesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEntityTypesRequest, GetEntityTypesResponse>()
                            .withOperationName("GetEntityTypes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEntityTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEntityTypesRequest));
            CompletableFuture<GetEntityTypesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves details of events stored with Amazon Fraud Detector. This action does not retrieve prediction results.
     * </p>
     *
     * @param getEventRequest
     * @return A Java Future containing the result of the GetEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEvent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetEventResponse> getEvent(GetEventRequest getEventRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEventRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEventRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEvent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEventResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetEventResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEventResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEventRequest, GetEventResponse>().withOperationName("GetEvent")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEventRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getEventRequest));
            CompletableFuture<GetEventResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Evaluates an event against a detector version. If a version ID is not provided, the detector’s (
     * <code>ACTIVE</code>) version is used.
     * </p>
     *
     * @param getEventPredictionRequest
     * @return A Java Future containing the result of the GetEventPrediction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>ResourceUnavailableException An exception indicating that the attached customer-owned (external)
     *         model threw an exception when Amazon Fraud Detector invoked the model.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetEventPrediction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventPrediction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetEventPredictionResponse> getEventPrediction(GetEventPredictionRequest getEventPredictionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEventPredictionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEventPredictionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEventPrediction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEventPredictionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEventPredictionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEventPredictionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEventPredictionRequest, GetEventPredictionResponse>()
                            .withOperationName("GetEventPrediction").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEventPredictionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEventPredictionRequest));
            CompletableFuture<GetEventPredictionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets details of the past fraud predictions for the specified event ID, event type, detector ID, and detector
     * version ID that was generated in the specified time period.
     * </p>
     *
     * @param getEventPredictionMetadataRequest
     * @return A Java Future containing the result of the GetEventPredictionMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetEventPredictionMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventPredictionMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetEventPredictionMetadataResponse> getEventPredictionMetadata(
            GetEventPredictionMetadataRequest getEventPredictionMetadataRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEventPredictionMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEventPredictionMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEventPredictionMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEventPredictionMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEventPredictionMetadataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEventPredictionMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEventPredictionMetadataRequest, GetEventPredictionMetadataResponse>()
                            .withOperationName("GetEventPredictionMetadata").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEventPredictionMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEventPredictionMetadataRequest));
            CompletableFuture<GetEventPredictionMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets all event types or a specific event type if name is provided. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination
     * token from the <code>GetEventTypesResponse</code> as part of your request. A null pagination token fetches the
     * records from the beginning.
     * </p>
     *
     * @param getEventTypesRequest
     * @return A Java Future containing the result of the GetEventTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetEventTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventTypes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetEventTypesResponse> getEventTypes(GetEventTypesRequest getEventTypesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEventTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEventTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEventTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEventTypesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetEventTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEventTypesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEventTypesRequest, GetEventTypesResponse>()
                            .withOperationName("GetEventTypes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEventTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEventTypesRequest));
            CompletableFuture<GetEventTypesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the details for one or more Amazon SageMaker models that have been imported into the service. This is a
     * paginated API. If you provide a null <code>maxResults</code>, this actions retrieves a maximum of 10 records per
     * page. If you provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results,
     * provide the pagination token from the <code>GetExternalModelsResult</code> as part of your request. A null
     * pagination token fetches the records from the beginning.
     * </p>
     *
     * @param getExternalModelsRequest
     * @return A Java Future containing the result of the GetExternalModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetExternalModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetExternalModels"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetExternalModelsResponse> getExternalModels(GetExternalModelsRequest getExternalModelsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getExternalModelsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getExternalModelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetExternalModels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetExternalModelsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetExternalModelsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetExternalModelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetExternalModelsRequest, GetExternalModelsResponse>()
                            .withOperationName("GetExternalModels").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetExternalModelsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getExternalModelsRequest));
            CompletableFuture<GetExternalModelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the encryption key if a KMS key has been specified to be used to encrypt content in Amazon Fraud Detector.
     * </p>
     *
     * @param getKmsEncryptionKeyRequest
     * @return A Java Future containing the result of the GetKMSEncryptionKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetKMSEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetKMSEncryptionKey"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetKmsEncryptionKeyResponse> getKMSEncryptionKey(
            GetKmsEncryptionKeyRequest getKmsEncryptionKeyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getKmsEncryptionKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getKmsEncryptionKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetKMSEncryptionKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetKmsEncryptionKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetKmsEncryptionKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetKmsEncryptionKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetKmsEncryptionKeyRequest, GetKmsEncryptionKeyResponse>()
                            .withOperationName("GetKMSEncryptionKey").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetKmsEncryptionKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getKmsEncryptionKeyRequest));
            CompletableFuture<GetKmsEncryptionKeyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets all labels or a specific label if name is provided. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 50 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 10 and 50. To get the next page results, provide the
     * pagination token from the <code>GetGetLabelsResponse</code> as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     *
     * @param getLabelsRequest
     * @return A Java Future containing the result of the GetLabels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetLabels" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetLabelsResponse> getLabels(GetLabelsRequest getLabelsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLabelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLabelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLabels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLabelsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetLabelsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLabelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLabelsRequest, GetLabelsResponse>().withOperationName("GetLabels")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetLabelsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getLabelsRequest));
            CompletableFuture<GetLabelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets all the elements in the specified list.
     * </p>
     *
     * @param getListElementsRequest
     * @return A Java Future containing the result of the GetListElements operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetListElements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetListElements" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetListElementsResponse> getListElements(GetListElementsRequest getListElementsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getListElementsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getListElementsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetListElements");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetListElementsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetListElementsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetListElementsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetListElementsRequest, GetListElementsResponse>()
                            .withOperationName("GetListElements").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetListElementsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getListElementsRequest));
            CompletableFuture<GetListElementsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the metadata of either all the lists under the account or the specified list.
     * </p>
     *
     * @param getListsMetadataRequest
     * @return A Java Future containing the result of the GetListsMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetListsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetListsMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetListsMetadataResponse> getListsMetadata(GetListsMetadataRequest getListsMetadataRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getListsMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getListsMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetListsMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetListsMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetListsMetadataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetListsMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetListsMetadataRequest, GetListsMetadataResponse>()
                            .withOperationName("GetListsMetadata").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetListsMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getListsMetadataRequest));
            CompletableFuture<GetListsMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the details of the specified model version.
     * </p>
     *
     * @param getModelVersionRequest
     * @return A Java Future containing the result of the GetModelVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModelVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetModelVersionResponse> getModelVersion(GetModelVersionRequest getModelVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getModelVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getModelVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetModelVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetModelVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetModelVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetModelVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetModelVersionRequest, GetModelVersionResponse>()
                            .withOperationName("GetModelVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetModelVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getModelVersionRequest));
            CompletableFuture<GetModelVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets one or more models. Gets all models for the Amazon Web Services account if no model type and no model id
     * provided. Gets all models for the Amazon Web Services account and model type, if the model type is specified but
     * model id is not provided. Gets a specific model if (model type, model id) tuple is specified.
     * </p>
     * <p>
     * This is a paginated API. If you provide a null <code>maxResults</code>, this action retrieves a maximum of 10
     * records per page. If you provide a <code>maxResults</code>, the value must be between 1 and 10. To get the next
     * page results, provide the pagination token from the response as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     *
     * @param getModelsRequest
     * @return A Java Future containing the result of the GetModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModels" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetModelsResponse> getModels(GetModelsRequest getModelsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getModelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getModelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetModels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetModelsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetModelsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetModelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetModelsRequest, GetModelsResponse>().withOperationName("GetModels")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetModelsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getModelsRequest));
            CompletableFuture<GetModelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets one or more outcomes. This is a paginated API. If you provide a null <code>maxResults</code>, this actions
     * retrieves a maximum of 100 records per page. If you provide a <code>maxResults</code>, the value must be between
     * 50 and 100. To get the next page results, provide the pagination token from the <code>GetOutcomesResult</code> as
     * part of your request. A null pagination token fetches the records from the beginning.
     * </p>
     *
     * @param getOutcomesRequest
     * @return A Java Future containing the result of the GetOutcomes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetOutcomes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetOutcomes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetOutcomesResponse> getOutcomes(GetOutcomesRequest getOutcomesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOutcomesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOutcomesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOutcomes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetOutcomesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetOutcomesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetOutcomesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOutcomesRequest, GetOutcomesResponse>()
                            .withOperationName("GetOutcomes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetOutcomesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getOutcomesRequest));
            CompletableFuture<GetOutcomesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get all rules for a detector (paginated) if <code>ruleId</code> and <code>ruleVersion</code> are not specified.
     * Gets all rules for the detector and the <code>ruleId</code> if present (paginated). Gets a specific rule if both
     * the <code>ruleId</code> and the <code>ruleVersion</code> are specified.
     * </p>
     * <p>
     * This is a paginated API. Providing null maxResults results in retrieving maximum of 100 records per page. If you
     * provide maxResults the value must be between 50 and 100. To get the next page result, a provide a pagination
     * token from GetRulesResult as part of your request. Null pagination token fetches the records from the beginning.
     * </p>
     *
     * @param getRulesRequest
     * @return A Java Future containing the result of the GetRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetRules" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetRulesResponse> getRules(GetRulesRequest getRulesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRulesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRulesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetRulesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRulesRequest, GetRulesResponse>().withOperationName("GetRules")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRulesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getRulesRequest));
            CompletableFuture<GetRulesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets all of the variables or the specific variable. This is a paginated API. Providing null
     * <code>maxSizePerPage</code> results in retrieving maximum of 100 records per page. If you provide
     * <code>maxSizePerPage</code> the value must be between 50 and 100. To get the next page result, a provide a
     * pagination token from <code>GetVariablesResult</code> as part of your request. Null pagination token fetches the
     * records from the beginning.
     * </p>
     *
     * @param getVariablesRequest
     * @return A Java Future containing the result of the GetVariables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetVariables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetVariables" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetVariablesResponse> getVariables(GetVariablesRequest getVariablesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getVariablesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVariablesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVariables");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVariablesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetVariablesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetVariablesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVariablesRequest, GetVariablesResponse>()
                            .withOperationName("GetVariables").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetVariablesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getVariablesRequest));
            CompletableFuture<GetVariablesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of past predictions. The list can be filtered by detector ID, detector version ID, event ID, event
     * type, or by specifying a time period. If filter is not specified, the most recent prediction is returned.
     * </p>
     * <p>
     * For example, the following filter lists all past predictions for <code>xyz</code> event type -
     * <code>{ "eventType":{ "value": "xyz" }” } </code>
     * </p>
     * <p>
     * This is a paginated API. If you provide a null <code>maxResults</code>, this action will retrieve a maximum of 10
     * records per page. If you provide a <code>maxResults</code>, the value must be between 50 and 100. To get the next
     * page results, provide the <code>nextToken</code> from the response as part of your request. A null
     * <code>nextToken</code> fetches the records from the beginning.
     * </p>
     *
     * @param listEventPredictionsRequest
     * @return A Java Future containing the result of the ListEventPredictions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.ListEventPredictions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/ListEventPredictions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEventPredictionsResponse> listEventPredictions(
            ListEventPredictionsRequest listEventPredictionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEventPredictionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEventPredictionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEventPredictions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEventPredictionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEventPredictionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListEventPredictionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEventPredictionsRequest, ListEventPredictionsResponse>()
                            .withOperationName("ListEventPredictions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListEventPredictionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listEventPredictionsRequest));
            CompletableFuture<ListEventPredictionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all tags associated with the resource. This is a paginated API. To get the next page results, provide the
     * pagination token from the response as part of your request. A null pagination token fetches the records from the
     * beginning.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates or updates a detector.
     * </p>
     *
     * @param putDetectorRequest
     * @return A Java Future containing the result of the PutDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutDetector" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutDetectorResponse> putDetector(PutDetectorRequest putDetectorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putDetectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putDetectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutDetector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutDetectorResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PutDetectorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutDetectorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutDetectorRequest, PutDetectorResponse>()
                            .withOperationName("PutDetector").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutDetectorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putDetectorRequest));
            CompletableFuture<PutDetectorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates or updates an entity type. An entity represents who is performing the event. As part of a fraud
     * prediction, you pass the entity ID to indicate the specific entity who performed the event. An entity type
     * classifies the entity. Example classifications include customer, merchant, or account.
     * </p>
     *
     * @param putEntityTypeRequest
     * @return A Java Future containing the result of the PutEntityType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutEntityType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutEntityType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutEntityTypeResponse> putEntityType(PutEntityTypeRequest putEntityTypeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putEntityTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putEntityTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutEntityType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutEntityTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PutEntityTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutEntityTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutEntityTypeRequest, PutEntityTypeResponse>()
                            .withOperationName("PutEntityType").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutEntityTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putEntityTypeRequest));
            CompletableFuture<PutEntityTypeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates or updates an event type. An event is a business activity that is evaluated for fraud risk. With Amazon
     * Fraud Detector, you generate fraud predictions for events. An event type defines the structure for an event sent
     * to Amazon Fraud Detector. This includes the variables sent as part of the event, the entity performing the event
     * (such as a customer), and the labels that classify the event. Example event types include online payment
     * transactions, account registrations, and authentications.
     * </p>
     *
     * @param putEventTypeRequest
     * @return A Java Future containing the result of the PutEventType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutEventType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutEventType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutEventTypeResponse> putEventType(PutEventTypeRequest putEventTypeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putEventTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putEventTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutEventType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutEventTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PutEventTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutEventTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutEventTypeRequest, PutEventTypeResponse>()
                            .withOperationName("PutEventType").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutEventTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putEventTypeRequest));
            CompletableFuture<PutEventTypeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates or updates an Amazon SageMaker model endpoint. You can also use this action to update the configuration
     * of the model endpoint, including the IAM role and/or the mapped variables.
     * </p>
     *
     * @param putExternalModelRequest
     * @return A Java Future containing the result of the PutExternalModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutExternalModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutExternalModel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutExternalModelResponse> putExternalModel(PutExternalModelRequest putExternalModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putExternalModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putExternalModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutExternalModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutExternalModelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutExternalModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutExternalModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutExternalModelRequest, PutExternalModelResponse>()
                            .withOperationName("PutExternalModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutExternalModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putExternalModelRequest));
            CompletableFuture<PutExternalModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Specifies the KMS key to be used to encrypt content in Amazon Fraud Detector.
     * </p>
     *
     * @param putKmsEncryptionKeyRequest
     * @return A Java Future containing the result of the PutKMSEncryptionKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutKMSEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutKMSEncryptionKey"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutKmsEncryptionKeyResponse> putKMSEncryptionKey(
            PutKmsEncryptionKeyRequest putKmsEncryptionKeyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putKmsEncryptionKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putKmsEncryptionKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutKMSEncryptionKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutKmsEncryptionKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutKmsEncryptionKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutKmsEncryptionKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutKmsEncryptionKeyRequest, PutKmsEncryptionKeyResponse>()
                            .withOperationName("PutKMSEncryptionKey").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutKmsEncryptionKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putKmsEncryptionKeyRequest));
            CompletableFuture<PutKmsEncryptionKeyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates or updates label. A label classifies an event as fraudulent or legitimate. Labels are associated with
     * event types and used to train supervised machine learning models in Amazon Fraud Detector.
     * </p>
     *
     * @param putLabelRequest
     * @return A Java Future containing the result of the PutLabel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutLabel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutLabelResponse> putLabel(PutLabelRequest putLabelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putLabelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putLabelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutLabel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutLabelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PutLabelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutLabelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutLabelRequest, PutLabelResponse>().withOperationName("PutLabel")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutLabelRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(putLabelRequest));
            CompletableFuture<PutLabelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates or updates an outcome.
     * </p>
     *
     * @param putOutcomeRequest
     * @return A Java Future containing the result of the PutOutcome operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutOutcome
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutOutcome" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutOutcomeResponse> putOutcome(PutOutcomeRequest putOutcomeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putOutcomeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putOutcomeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutOutcome");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutOutcomeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PutOutcomeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutOutcomeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutOutcomeRequest, PutOutcomeResponse>().withOperationName("PutOutcome")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutOutcomeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putOutcomeRequest));
            CompletableFuture<PutOutcomeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stores events in Amazon Fraud Detector without generating fraud predictions for those events. For example, you
     * can use <code>SendEvent</code> to upload a historical dataset, which you can then later use to train a model.
     * </p>
     *
     * @param sendEventRequest
     * @return A Java Future containing the result of the SendEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.SendEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/SendEvent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SendEventResponse> sendEvent(SendEventRequest sendEventRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(sendEventRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendEventRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendEvent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SendEventResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    SendEventResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SendEventResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SendEventRequest, SendEventResponse>().withOperationName("SendEvent")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SendEventRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(sendEventRequest));
            CompletableFuture<SendEventResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Assigns tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a detector version. The detector version attributes that you can update include models, external model
     * endpoints, rules, rule execution mode, and description. You can only update a <code>DRAFT</code> detector
     * version.
     * </p>
     *
     * @param updateDetectorVersionRequest
     * @return A Java Future containing the result of the UpdateDetectorVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateDetectorVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDetectorVersionResponse> updateDetectorVersion(
            UpdateDetectorVersionRequest updateDetectorVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDetectorVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDetectorVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDetectorVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDetectorVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDetectorVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDetectorVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDetectorVersionRequest, UpdateDetectorVersionResponse>()
                            .withOperationName("UpdateDetectorVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateDetectorVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateDetectorVersionRequest));
            CompletableFuture<UpdateDetectorVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the detector version's description. You can update the metadata for any detector version (
     * <code>DRAFT, ACTIVE,</code> or <code>INACTIVE</code>).
     * </p>
     *
     * @param updateDetectorVersionMetadataRequest
     * @return A Java Future containing the result of the UpdateDetectorVersionMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateDetectorVersionMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDetectorVersionMetadataResponse> updateDetectorVersionMetadata(
            UpdateDetectorVersionMetadataRequest updateDetectorVersionMetadataRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDetectorVersionMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateDetectorVersionMetadataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDetectorVersionMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDetectorVersionMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDetectorVersionMetadataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDetectorVersionMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDetectorVersionMetadataRequest, UpdateDetectorVersionMetadataResponse>()
                            .withOperationName("UpdateDetectorVersionMetadata").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateDetectorVersionMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateDetectorVersionMetadataRequest));
            CompletableFuture<UpdateDetectorVersionMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the detector version’s status. You can perform the following promotions or demotions using
     * <code>UpdateDetectorVersionStatus</code>: <code>DRAFT</code> to <code>ACTIVE</code>, <code>ACTIVE</code> to
     * <code>INACTIVE</code>, and <code>INACTIVE</code> to <code>ACTIVE</code>.
     * </p>
     *
     * @param updateDetectorVersionStatusRequest
     * @return A Java Future containing the result of the UpdateDetectorVersionStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateDetectorVersionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDetectorVersionStatusResponse> updateDetectorVersionStatus(
            UpdateDetectorVersionStatusRequest updateDetectorVersionStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDetectorVersionStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDetectorVersionStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDetectorVersionStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDetectorVersionStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDetectorVersionStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDetectorVersionStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDetectorVersionStatusRequest, UpdateDetectorVersionStatusResponse>()
                            .withOperationName("UpdateDetectorVersionStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateDetectorVersionStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateDetectorVersionStatusRequest));
            CompletableFuture<UpdateDetectorVersionStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the specified event with a new label.
     * </p>
     *
     * @param updateEventLabelRequest
     * @return A Java Future containing the result of the UpdateEventLabel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateEventLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateEventLabel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateEventLabelResponse> updateEventLabel(UpdateEventLabelRequest updateEventLabelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEventLabelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEventLabelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEventLabel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateEventLabelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateEventLabelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateEventLabelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateEventLabelRequest, UpdateEventLabelResponse>()
                            .withOperationName("UpdateEventLabel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateEventLabelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateEventLabelRequest));
            CompletableFuture<UpdateEventLabelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a list.
     * </p>
     *
     * @param updateListRequest
     * @return A Java Future containing the result of the UpdateList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateList" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateListResponse> updateList(UpdateListRequest updateListRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateListRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateList");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateListResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateListResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateListResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateListRequest, UpdateListResponse>().withOperationName("UpdateList")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateListRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateListRequest));
            CompletableFuture<UpdateListResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates model description.
     * </p>
     *
     * @param updateModelRequest
     * @return A Java Future containing the result of the UpdateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateModelResponse> updateModel(UpdateModelRequest updateModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateModelRequest, UpdateModelResponse>()
                            .withOperationName("UpdateModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateModelRequest));
            CompletableFuture<UpdateModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a model version. Updating a model version retrains an existing model version using updated training data
     * and produces a new minor version of the model. You can update the training data set location and data access role
     * attributes using this action. This action creates and trains a new minor version of the model, for example
     * version 1.01, 1.02, 1.03.
     * </p>
     *
     * @param updateModelVersionRequest
     * @return A Java Future containing the result of the UpdateModelVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateModelVersionResponse> updateModelVersion(UpdateModelVersionRequest updateModelVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateModelVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateModelVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateModelVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateModelVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateModelVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateModelVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateModelVersionRequest, UpdateModelVersionResponse>()
                            .withOperationName("UpdateModelVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateModelVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateModelVersionRequest));
            CompletableFuture<UpdateModelVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the status of a model version.
     * </p>
     * <p>
     * You can perform the following status updates:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Change the <code>TRAINING_IN_PROGRESS</code> status to <code>TRAINING_CANCELLED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change the <code>TRAINING_COMPLETE</code> status to <code>ACTIVE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change <code>ACTIVE</code> to <code>INACTIVE</code>.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateModelVersionStatusRequest
     * @return A Java Future containing the result of the UpdateModelVersionStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateModelVersionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateModelVersionStatusResponse> updateModelVersionStatus(
            UpdateModelVersionStatusRequest updateModelVersionStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateModelVersionStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateModelVersionStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateModelVersionStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateModelVersionStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateModelVersionStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateModelVersionStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateModelVersionStatusRequest, UpdateModelVersionStatusResponse>()
                            .withOperationName("UpdateModelVersionStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateModelVersionStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateModelVersionStatusRequest));
            CompletableFuture<UpdateModelVersionStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a rule's metadata. The description attribute can be updated.
     * </p>
     *
     * @param updateRuleMetadataRequest
     * @return A Java Future containing the result of the UpdateRuleMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateRuleMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRuleMetadataResponse> updateRuleMetadata(UpdateRuleMetadataRequest updateRuleMetadataRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRuleMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRuleMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRuleMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRuleMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateRuleMetadataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateRuleMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRuleMetadataRequest, UpdateRuleMetadataResponse>()
                            .withOperationName("UpdateRuleMetadata").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateRuleMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateRuleMetadataRequest));
            CompletableFuture<UpdateRuleMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a rule version resulting in a new rule version. Updates a rule version resulting in a new rule version
     * (version 1, 2, 3 ...).
     * </p>
     *
     * @param updateRuleVersionRequest
     * @return A Java Future containing the result of the UpdateRuleVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateRuleVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRuleVersionResponse> updateRuleVersion(UpdateRuleVersionRequest updateRuleVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRuleVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRuleVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRuleVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRuleVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateRuleVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateRuleVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRuleVersionRequest, UpdateRuleVersionResponse>()
                            .withOperationName("UpdateRuleVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateRuleVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateRuleVersionRequest));
            CompletableFuture<UpdateRuleVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a variable.
     * </p>
     *
     * @param updateVariableRequest
     * @return A Java Future containing the result of the UpdateVariable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateVariable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateVariable" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateVariableResponse> updateVariable(UpdateVariableRequest updateVariableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateVariableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateVariableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVariable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateVariableResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateVariableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateVariableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateVariableRequest, UpdateVariableResponse>()
                            .withOperationName("UpdateVariable").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateVariableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateVariableRequest));
            CompletableFuture<UpdateVariableResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final FraudDetectorServiceClientConfiguration serviceClientConfiguration() {
        return new FraudDetectorServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(FraudDetectorException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceUnavailableException")
                                .exceptionBuilderSupplier(ResourceUnavailableException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        FraudDetectorServiceClientConfigurationBuilder serviceConfigBuilder = new FraudDetectorServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
