/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The prediction explanations that provide insight into how each event variable impacted the model version's fraud
 * prediction score.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredictionExplanations implements SdkPojo, Serializable,
        ToCopyableBuilder<PredictionExplanations.Builder, PredictionExplanations> {
    private static final SdkField<List<VariableImpactExplanation>> VARIABLE_IMPACT_EXPLANATIONS_FIELD = SdkField
            .<List<VariableImpactExplanation>> builder(MarshallingType.LIST)
            .memberName("variableImpactExplanations")
            .getter(getter(PredictionExplanations::variableImpactExplanations))
            .setter(setter(Builder::variableImpactExplanations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variableImpactExplanations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VariableImpactExplanation> builder(MarshallingType.SDK_POJO)
                                            .constructor(VariableImpactExplanation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AggregatedVariablesImpactExplanation>> AGGREGATED_VARIABLES_IMPACT_EXPLANATIONS_FIELD = SdkField
            .<List<AggregatedVariablesImpactExplanation>> builder(MarshallingType.LIST)
            .memberName("aggregatedVariablesImpactExplanations")
            .getter(getter(PredictionExplanations::aggregatedVariablesImpactExplanations))
            .setter(setter(Builder::aggregatedVariablesImpactExplanations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("aggregatedVariablesImpactExplanations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AggregatedVariablesImpactExplanation> builder(MarshallingType.SDK_POJO)
                                            .constructor(AggregatedVariablesImpactExplanation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VARIABLE_IMPACT_EXPLANATIONS_FIELD, AGGREGATED_VARIABLES_IMPACT_EXPLANATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<VariableImpactExplanation> variableImpactExplanations;

    private final List<AggregatedVariablesImpactExplanation> aggregatedVariablesImpactExplanations;

    private PredictionExplanations(BuilderImpl builder) {
        this.variableImpactExplanations = builder.variableImpactExplanations;
        this.aggregatedVariablesImpactExplanations = builder.aggregatedVariablesImpactExplanations;
    }

    /**
     * For responses, this returns true if the service returned a value for the VariableImpactExplanations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasVariableImpactExplanations() {
        return variableImpactExplanations != null && !(variableImpactExplanations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details of the event variable's impact on the prediction score.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVariableImpactExplanations} method.
     * </p>
     * 
     * @return The details of the event variable's impact on the prediction score.
     */
    public final List<VariableImpactExplanation> variableImpactExplanations() {
        return variableImpactExplanations;
    }

    /**
     * For responses, this returns true if the service returned a value for the AggregatedVariablesImpactExplanations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAggregatedVariablesImpactExplanations() {
        return aggregatedVariablesImpactExplanations != null
                && !(aggregatedVariablesImpactExplanations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details of the aggregated variables impact on the prediction score.
     * </p>
     * <p>
     * Account Takeover Insights (ATI) model uses event variables from the login data you provide to continuously
     * calculate a set of variables (aggregated variables) based on historical events. For example, your ATI model might
     * calculate the number of times an user has logged in using the same IP address. In this case, event variables used
     * to derive the aggregated variables are <code>IP address</code> and <code>user</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregatedVariablesImpactExplanations}
     * method.
     * </p>
     * 
     * @return The details of the aggregated variables impact on the prediction score. </p>
     *         <p>
     *         Account Takeover Insights (ATI) model uses event variables from the login data you provide to
     *         continuously calculate a set of variables (aggregated variables) based on historical events. For example,
     *         your ATI model might calculate the number of times an user has logged in using the same IP address. In
     *         this case, event variables used to derive the aggregated variables are <code>IP address</code> and
     *         <code>user</code>.
     */
    public final List<AggregatedVariablesImpactExplanation> aggregatedVariablesImpactExplanations() {
        return aggregatedVariablesImpactExplanations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasVariableImpactExplanations() ? variableImpactExplanations() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAggregatedVariablesImpactExplanations() ? aggregatedVariablesImpactExplanations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictionExplanations)) {
            return false;
        }
        PredictionExplanations other = (PredictionExplanations) obj;
        return hasVariableImpactExplanations() == other.hasVariableImpactExplanations()
                && Objects.equals(variableImpactExplanations(), other.variableImpactExplanations())
                && hasAggregatedVariablesImpactExplanations() == other.hasAggregatedVariablesImpactExplanations()
                && Objects.equals(aggregatedVariablesImpactExplanations(), other.aggregatedVariablesImpactExplanations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("PredictionExplanations")
                .add("VariableImpactExplanations", hasVariableImpactExplanations() ? variableImpactExplanations() : null)
                .add("AggregatedVariablesImpactExplanations",
                        hasAggregatedVariablesImpactExplanations() ? aggregatedVariablesImpactExplanations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "variableImpactExplanations":
            return Optional.ofNullable(clazz.cast(variableImpactExplanations()));
        case "aggregatedVariablesImpactExplanations":
            return Optional.ofNullable(clazz.cast(aggregatedVariablesImpactExplanations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PredictionExplanations, T> g) {
        return obj -> g.apply((PredictionExplanations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PredictionExplanations> {
        /**
         * <p>
         * The details of the event variable's impact on the prediction score.
         * </p>
         * 
         * @param variableImpactExplanations
         *        The details of the event variable's impact on the prediction score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variableImpactExplanations(Collection<VariableImpactExplanation> variableImpactExplanations);

        /**
         * <p>
         * The details of the event variable's impact on the prediction score.
         * </p>
         * 
         * @param variableImpactExplanations
         *        The details of the event variable's impact on the prediction score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variableImpactExplanations(VariableImpactExplanation... variableImpactExplanations);

        /**
         * <p>
         * The details of the event variable's impact on the prediction score.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.frauddetector.model.VariableImpactExplanation.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.frauddetector.model.VariableImpactExplanation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.frauddetector.model.VariableImpactExplanation.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #variableImpactExplanations(List<VariableImpactExplanation>)}.
         * 
         * @param variableImpactExplanations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.frauddetector.model.VariableImpactExplanation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #variableImpactExplanations(java.util.Collection<VariableImpactExplanation>)
         */
        Builder variableImpactExplanations(Consumer<VariableImpactExplanation.Builder>... variableImpactExplanations);

        /**
         * <p>
         * The details of the aggregated variables impact on the prediction score.
         * </p>
         * <p>
         * Account Takeover Insights (ATI) model uses event variables from the login data you provide to continuously
         * calculate a set of variables (aggregated variables) based on historical events. For example, your ATI model
         * might calculate the number of times an user has logged in using the same IP address. In this case, event
         * variables used to derive the aggregated variables are <code>IP address</code> and <code>user</code>.
         * </p>
         * 
         * @param aggregatedVariablesImpactExplanations
         *        The details of the aggregated variables impact on the prediction score. </p>
         *        <p>
         *        Account Takeover Insights (ATI) model uses event variables from the login data you provide to
         *        continuously calculate a set of variables (aggregated variables) based on historical events. For
         *        example, your ATI model might calculate the number of times an user has logged in using the same IP
         *        address. In this case, event variables used to derive the aggregated variables are
         *        <code>IP address</code> and <code>user</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatedVariablesImpactExplanations(
                Collection<AggregatedVariablesImpactExplanation> aggregatedVariablesImpactExplanations);

        /**
         * <p>
         * The details of the aggregated variables impact on the prediction score.
         * </p>
         * <p>
         * Account Takeover Insights (ATI) model uses event variables from the login data you provide to continuously
         * calculate a set of variables (aggregated variables) based on historical events. For example, your ATI model
         * might calculate the number of times an user has logged in using the same IP address. In this case, event
         * variables used to derive the aggregated variables are <code>IP address</code> and <code>user</code>.
         * </p>
         * 
         * @param aggregatedVariablesImpactExplanations
         *        The details of the aggregated variables impact on the prediction score. </p>
         *        <p>
         *        Account Takeover Insights (ATI) model uses event variables from the login data you provide to
         *        continuously calculate a set of variables (aggregated variables) based on historical events. For
         *        example, your ATI model might calculate the number of times an user has logged in using the same IP
         *        address. In this case, event variables used to derive the aggregated variables are
         *        <code>IP address</code> and <code>user</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatedVariablesImpactExplanations(
                AggregatedVariablesImpactExplanation... aggregatedVariablesImpactExplanations);

        /**
         * <p>
         * The details of the aggregated variables impact on the prediction score.
         * </p>
         * <p>
         * Account Takeover Insights (ATI) model uses event variables from the login data you provide to continuously
         * calculate a set of variables (aggregated variables) based on historical events. For example, your ATI model
         * might calculate the number of times an user has logged in using the same IP address. In this case, event
         * variables used to derive the aggregated variables are <code>IP address</code> and <code>user</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.frauddetector.model.AggregatedVariablesImpactExplanation.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.frauddetector.model.AggregatedVariablesImpactExplanation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.frauddetector.model.AggregatedVariablesImpactExplanation.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #aggregatedVariablesImpactExplanations(List<AggregatedVariablesImpactExplanation>)}.
         * 
         * @param aggregatedVariablesImpactExplanations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.frauddetector.model.AggregatedVariablesImpactExplanation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregatedVariablesImpactExplanations(java.util.Collection<AggregatedVariablesImpactExplanation>)
         */
        Builder aggregatedVariablesImpactExplanations(
                Consumer<AggregatedVariablesImpactExplanation.Builder>... aggregatedVariablesImpactExplanations);
    }

    static final class BuilderImpl implements Builder {
        private List<VariableImpactExplanation> variableImpactExplanations = DefaultSdkAutoConstructList.getInstance();

        private List<AggregatedVariablesImpactExplanation> aggregatedVariablesImpactExplanations = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PredictionExplanations model) {
            variableImpactExplanations(model.variableImpactExplanations);
            aggregatedVariablesImpactExplanations(model.aggregatedVariablesImpactExplanations);
        }

        public final List<VariableImpactExplanation.Builder> getVariableImpactExplanations() {
            List<VariableImpactExplanation.Builder> result = _listOfVariableImpactExplanationsCopier
                    .copyToBuilder(this.variableImpactExplanations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariableImpactExplanations(
                Collection<VariableImpactExplanation.BuilderImpl> variableImpactExplanations) {
            this.variableImpactExplanations = _listOfVariableImpactExplanationsCopier.copyFromBuilder(variableImpactExplanations);
        }

        @Override
        public final Builder variableImpactExplanations(Collection<VariableImpactExplanation> variableImpactExplanations) {
            this.variableImpactExplanations = _listOfVariableImpactExplanationsCopier.copy(variableImpactExplanations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variableImpactExplanations(VariableImpactExplanation... variableImpactExplanations) {
            variableImpactExplanations(Arrays.asList(variableImpactExplanations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variableImpactExplanations(Consumer<VariableImpactExplanation.Builder>... variableImpactExplanations) {
            variableImpactExplanations(Stream.of(variableImpactExplanations)
                    .map(c -> VariableImpactExplanation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AggregatedVariablesImpactExplanation.Builder> getAggregatedVariablesImpactExplanations() {
            List<AggregatedVariablesImpactExplanation.Builder> result = ListOfAggregatedVariablesImpactExplanationsCopier
                    .copyToBuilder(this.aggregatedVariablesImpactExplanations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregatedVariablesImpactExplanations(
                Collection<AggregatedVariablesImpactExplanation.BuilderImpl> aggregatedVariablesImpactExplanations) {
            this.aggregatedVariablesImpactExplanations = ListOfAggregatedVariablesImpactExplanationsCopier
                    .copyFromBuilder(aggregatedVariablesImpactExplanations);
        }

        @Override
        public final Builder aggregatedVariablesImpactExplanations(
                Collection<AggregatedVariablesImpactExplanation> aggregatedVariablesImpactExplanations) {
            this.aggregatedVariablesImpactExplanations = ListOfAggregatedVariablesImpactExplanationsCopier
                    .copy(aggregatedVariablesImpactExplanations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedVariablesImpactExplanations(
                AggregatedVariablesImpactExplanation... aggregatedVariablesImpactExplanations) {
            aggregatedVariablesImpactExplanations(Arrays.asList(aggregatedVariablesImpactExplanations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedVariablesImpactExplanations(
                Consumer<AggregatedVariablesImpactExplanation.Builder>... aggregatedVariablesImpactExplanations) {
            aggregatedVariablesImpactExplanations(Stream.of(aggregatedVariablesImpactExplanations)
                    .map(c -> AggregatedVariablesImpactExplanation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PredictionExplanations build() {
            return new PredictionExplanations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
