/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the event variable's impact on the prediction score.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VariableImpactExplanation implements SdkPojo, Serializable,
        ToCopyableBuilder<VariableImpactExplanation.Builder, VariableImpactExplanation> {
    private static final SdkField<String> EVENT_VARIABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventVariableName").getter(getter(VariableImpactExplanation::eventVariableName))
            .setter(setter(Builder::eventVariableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventVariableName").build()).build();

    private static final SdkField<String> RELATIVE_IMPACT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relativeImpact").getter(getter(VariableImpactExplanation::relativeImpact))
            .setter(setter(Builder::relativeImpact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relativeImpact").build()).build();

    private static final SdkField<Float> LOG_ODDS_IMPACT_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("logOddsImpact").getter(getter(VariableImpactExplanation::logOddsImpact))
            .setter(setter(Builder::logOddsImpact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logOddsImpact").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_VARIABLE_NAME_FIELD,
            RELATIVE_IMPACT_FIELD, LOG_ODDS_IMPACT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String eventVariableName;

    private final String relativeImpact;

    private final Float logOddsImpact;

    private VariableImpactExplanation(BuilderImpl builder) {
        this.eventVariableName = builder.eventVariableName;
        this.relativeImpact = builder.relativeImpact;
        this.logOddsImpact = builder.logOddsImpact;
    }

    /**
     * <p>
     * The event variable name.
     * </p>
     * 
     * @return The event variable name.
     */
    public final String eventVariableName() {
        return eventVariableName;
    }

    /**
     * <p>
     * The event variable's relative impact in terms of magnitude on the prediction scores. The relative impact values
     * consist of a numerical rating (0-5, 5 being the highest) and direction (increased/decreased) impact of the fraud
     * risk.
     * </p>
     * 
     * @return The event variable's relative impact in terms of magnitude on the prediction scores. The relative impact
     *         values consist of a numerical rating (0-5, 5 being the highest) and direction (increased/decreased)
     *         impact of the fraud risk.
     */
    public final String relativeImpact() {
        return relativeImpact;
    }

    /**
     * <p>
     * The raw, uninterpreted value represented as log-odds of the fraud. These values are usually between -10 to +10,
     * but range from - infinity to + infinity.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A positive value indicates that the variable drove the risk score up.
     * </p>
     * </li>
     * <li>
     * <p>
     * A negative value indicates that the variable drove the risk score down.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The raw, uninterpreted value represented as log-odds of the fraud. These values are usually between -10
     *         to +10, but range from - infinity to + infinity.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         A positive value indicates that the variable drove the risk score up.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A negative value indicates that the variable drove the risk score down.
     *         </p>
     *         </li>
     */
    public final Float logOddsImpact() {
        return logOddsImpact;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventVariableName());
        hashCode = 31 * hashCode + Objects.hashCode(relativeImpact());
        hashCode = 31 * hashCode + Objects.hashCode(logOddsImpact());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VariableImpactExplanation)) {
            return false;
        }
        VariableImpactExplanation other = (VariableImpactExplanation) obj;
        return Objects.equals(eventVariableName(), other.eventVariableName())
                && Objects.equals(relativeImpact(), other.relativeImpact())
                && Objects.equals(logOddsImpact(), other.logOddsImpact());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VariableImpactExplanation").add("EventVariableName", eventVariableName())
                .add("RelativeImpact", relativeImpact()).add("LogOddsImpact", logOddsImpact()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventVariableName":
            return Optional.ofNullable(clazz.cast(eventVariableName()));
        case "relativeImpact":
            return Optional.ofNullable(clazz.cast(relativeImpact()));
        case "logOddsImpact":
            return Optional.ofNullable(clazz.cast(logOddsImpact()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VariableImpactExplanation, T> g) {
        return obj -> g.apply((VariableImpactExplanation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VariableImpactExplanation> {
        /**
         * <p>
         * The event variable name.
         * </p>
         * 
         * @param eventVariableName
         *        The event variable name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventVariableName(String eventVariableName);

        /**
         * <p>
         * The event variable's relative impact in terms of magnitude on the prediction scores. The relative impact
         * values consist of a numerical rating (0-5, 5 being the highest) and direction (increased/decreased) impact of
         * the fraud risk.
         * </p>
         * 
         * @param relativeImpact
         *        The event variable's relative impact in terms of magnitude on the prediction scores. The relative
         *        impact values consist of a numerical rating (0-5, 5 being the highest) and direction
         *        (increased/decreased) impact of the fraud risk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relativeImpact(String relativeImpact);

        /**
         * <p>
         * The raw, uninterpreted value represented as log-odds of the fraud. These values are usually between -10 to
         * +10, but range from - infinity to + infinity.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A positive value indicates that the variable drove the risk score up.
         * </p>
         * </li>
         * <li>
         * <p>
         * A negative value indicates that the variable drove the risk score down.
         * </p>
         * </li>
         * </ul>
         * 
         * @param logOddsImpact
         *        The raw, uninterpreted value represented as log-odds of the fraud. These values are usually between
         *        -10 to +10, but range from - infinity to + infinity.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        A positive value indicates that the variable drove the risk score up.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A negative value indicates that the variable drove the risk score down.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logOddsImpact(Float logOddsImpact);
    }

    static final class BuilderImpl implements Builder {
        private String eventVariableName;

        private String relativeImpact;

        private Float logOddsImpact;

        private BuilderImpl() {
        }

        private BuilderImpl(VariableImpactExplanation model) {
            eventVariableName(model.eventVariableName);
            relativeImpact(model.relativeImpact);
            logOddsImpact(model.logOddsImpact);
        }

        public final String getEventVariableName() {
            return eventVariableName;
        }

        public final void setEventVariableName(String eventVariableName) {
            this.eventVariableName = eventVariableName;
        }

        @Override
        public final Builder eventVariableName(String eventVariableName) {
            this.eventVariableName = eventVariableName;
            return this;
        }

        public final String getRelativeImpact() {
            return relativeImpact;
        }

        public final void setRelativeImpact(String relativeImpact) {
            this.relativeImpact = relativeImpact;
        }

        @Override
        public final Builder relativeImpact(String relativeImpact) {
            this.relativeImpact = relativeImpact;
            return this;
        }

        public final Float getLogOddsImpact() {
            return logOddsImpact;
        }

        public final void setLogOddsImpact(Float logOddsImpact) {
            this.logOddsImpact = logOddsImpact;
        }

        @Override
        public final Builder logOddsImpact(Float logOddsImpact) {
            this.logOddsImpact = logOddsImpact;
            return this;
        }

        @Override
        public VariableImpactExplanation build() {
            return new VariableImpactExplanation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
