/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetListsMetadataResponse extends FraudDetectorResponse implements
        ToCopyableBuilder<GetListsMetadataResponse.Builder, GetListsMetadataResponse> {
    private static final SdkField<List<AllowDenyList>> LISTS_FIELD = SdkField
            .<List<AllowDenyList>> builder(MarshallingType.LIST)
            .memberName("lists")
            .getter(getter(GetListsMetadataResponse::lists))
            .setter(setter(Builder::lists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lists").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AllowDenyList> builder(MarshallingType.SDK_POJO)
                                            .constructor(AllowDenyList::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetListsMetadataResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(LISTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<AllowDenyList> lists;

    private final String nextToken;

    private GetListsMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.lists = builder.lists;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Lists property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasLists() {
        return lists != null && !(lists instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata of the specified list or all lists under the account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLists} method.
     * </p>
     * 
     * @return The metadata of the specified list or all lists under the account.
     */
    public final List<AllowDenyList> lists() {
        return lists;
    }

    /**
     * <p>
     * The next page token.
     * </p>
     * 
     * @return The next page token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLists() ? lists() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetListsMetadataResponse)) {
            return false;
        }
        GetListsMetadataResponse other = (GetListsMetadataResponse) obj;
        return hasLists() == other.hasLists() && Objects.equals(lists(), other.lists())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetListsMetadataResponse").add("Lists", hasLists() ? lists() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lists":
            return Optional.ofNullable(clazz.cast(lists()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetListsMetadataResponse, T> g) {
        return obj -> g.apply((GetListsMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetListsMetadataResponse> {
        /**
         * <p>
         * The metadata of the specified list or all lists under the account.
         * </p>
         * 
         * @param lists
         *        The metadata of the specified list or all lists under the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lists(Collection<AllowDenyList> lists);

        /**
         * <p>
         * The metadata of the specified list or all lists under the account.
         * </p>
         * 
         * @param lists
         *        The metadata of the specified list or all lists under the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lists(AllowDenyList... lists);

        /**
         * <p>
         * The metadata of the specified list or all lists under the account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.frauddetector.model.AllowDenyList.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.frauddetector.model.AllowDenyList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.frauddetector.model.AllowDenyList.Builder#build()} is called
         * immediately and its result is passed to {@link #lists(List<AllowDenyList>)}.
         * 
         * @param lists
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.frauddetector.model.AllowDenyList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lists(java.util.Collection<AllowDenyList>)
         */
        Builder lists(Consumer<AllowDenyList.Builder>... lists);

        /**
         * <p>
         * The next page token.
         * </p>
         * 
         * @param nextToken
         *        The next page token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FraudDetectorResponse.BuilderImpl implements Builder {
        private List<AllowDenyList> lists = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetListsMetadataResponse model) {
            super(model);
            lists(model.lists);
            nextToken(model.nextToken);
        }

        public final List<AllowDenyList.Builder> getLists() {
            List<AllowDenyList.Builder> result = AllowDenyListsCopier.copyToBuilder(this.lists);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLists(Collection<AllowDenyList.BuilderImpl> lists) {
            this.lists = AllowDenyListsCopier.copyFromBuilder(lists);
        }

        @Override
        public final Builder lists(Collection<AllowDenyList> lists) {
            this.lists = AllowDenyListsCopier.copy(lists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lists(AllowDenyList... lists) {
            lists(Arrays.asList(lists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lists(Consumer<AllowDenyList.Builder>... lists) {
            lists(Stream.of(lists).map(c -> AllowDenyList.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetListsMetadataResponse build() {
            return new GetListsMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
