/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.LabelSchema;
import software.amazon.awssdk.services.frauddetector.model.ListOfStringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrainingDataSchema
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrainingDataSchema> {
    private static final SdkField<List<String>> MODEL_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("modelVariables").getter(TrainingDataSchema.getter(TrainingDataSchema::modelVariables)).setter(TrainingDataSchema.setter(Builder::modelVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVariables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LabelSchema> LABEL_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("labelSchema").getter(TrainingDataSchema.getter(TrainingDataSchema::labelSchema)).setter(TrainingDataSchema.setter(Builder::labelSchema)).constructor(LabelSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labelSchema").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_VARIABLES_FIELD, LABEL_SCHEMA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TrainingDataSchema.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> modelVariables;
    private final LabelSchema labelSchema;

    private TrainingDataSchema(BuilderImpl builder) {
        this.modelVariables = builder.modelVariables;
        this.labelSchema = builder.labelSchema;
    }

    public final boolean hasModelVariables() {
        return this.modelVariables != null && !(this.modelVariables instanceof SdkAutoConstructList);
    }

    public final List<String> modelVariables() {
        return this.modelVariables;
    }

    public final LabelSchema labelSchema() {
        return this.labelSchema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelVariables() ? this.modelVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.labelSchema());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingDataSchema)) {
            return false;
        }
        TrainingDataSchema other = (TrainingDataSchema)obj;
        return this.hasModelVariables() == other.hasModelVariables() && Objects.equals(this.modelVariables(), other.modelVariables()) && Objects.equals(this.labelSchema(), other.labelSchema());
    }

    public final String toString() {
        return ToString.builder((String)"TrainingDataSchema").add("ModelVariables", this.hasModelVariables() ? this.modelVariables() : null).add("LabelSchema", (Object)this.labelSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelVariables": {
                return Optional.ofNullable(clazz.cast(this.modelVariables()));
            }
            case "labelSchema": {
                return Optional.ofNullable(clazz.cast(this.labelSchema()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("modelVariables", MODEL_VARIABLES_FIELD);
        map.put("labelSchema", LABEL_SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrainingDataSchema, T> g) {
        return obj -> g.apply((TrainingDataSchema)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> modelVariables = DefaultSdkAutoConstructList.getInstance();
        private LabelSchema labelSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingDataSchema model) {
            this.modelVariables(model.modelVariables);
            this.labelSchema(model.labelSchema);
        }

        public final Collection<String> getModelVariables() {
            if (this.modelVariables instanceof SdkAutoConstructList) {
                return null;
            }
            return this.modelVariables;
        }

        public final void setModelVariables(Collection<String> modelVariables) {
            this.modelVariables = ListOfStringsCopier.copy(modelVariables);
        }

        @Override
        public final Builder modelVariables(Collection<String> modelVariables) {
            this.modelVariables = ListOfStringsCopier.copy(modelVariables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVariables(String ... modelVariables) {
            this.modelVariables(Arrays.asList(modelVariables));
            return this;
        }

        public final LabelSchema.Builder getLabelSchema() {
            return this.labelSchema != null ? this.labelSchema.toBuilder() : null;
        }

        public final void setLabelSchema(LabelSchema.BuilderImpl labelSchema) {
            this.labelSchema = labelSchema != null ? labelSchema.build() : null;
        }

        @Override
        public final Builder labelSchema(LabelSchema labelSchema) {
            this.labelSchema = labelSchema;
            return this;
        }

        public TrainingDataSchema build() {
            return new TrainingDataSchema(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrainingDataSchema> {
        public Builder modelVariables(Collection<String> var1);

        public Builder modelVariables(String ... var1);

        public Builder labelSchema(LabelSchema var1);

        default public Builder labelSchema(Consumer<LabelSchema.Builder> labelSchema) {
            return this.labelSchema((LabelSchema)((LabelSchema.Builder)LabelSchema.builder().applyMutation(labelSchema)).build());
        }
    }
}

