/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.OFIMetricDataPoint;
import software.amazon.awssdk.services.frauddetector.model.OFIMetricDataPointsListCopier;
import software.amazon.awssdk.services.frauddetector.model.OFIModelPerformance;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OFITrainingMetricsValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OFITrainingMetricsValue> {
    private static final SdkField<List<OFIMetricDataPoint>> METRIC_DATA_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricDataPoints").getter(OFITrainingMetricsValue.getter(OFITrainingMetricsValue::metricDataPoints)).setter(OFITrainingMetricsValue.setter(Builder::metricDataPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricDataPoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OFIMetricDataPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OFIModelPerformance> MODEL_PERFORMANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("modelPerformance").getter(OFITrainingMetricsValue.getter(OFITrainingMetricsValue::modelPerformance)).setter(OFITrainingMetricsValue.setter(Builder::modelPerformance)).constructor(OFIModelPerformance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelPerformance").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_DATA_POINTS_FIELD, MODEL_PERFORMANCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OFITrainingMetricsValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<OFIMetricDataPoint> metricDataPoints;
    private final OFIModelPerformance modelPerformance;

    private OFITrainingMetricsValue(BuilderImpl builder) {
        this.metricDataPoints = builder.metricDataPoints;
        this.modelPerformance = builder.modelPerformance;
    }

    public final boolean hasMetricDataPoints() {
        return this.metricDataPoints != null && !(this.metricDataPoints instanceof SdkAutoConstructList);
    }

    public final List<OFIMetricDataPoint> metricDataPoints() {
        return this.metricDataPoints;
    }

    public final OFIModelPerformance modelPerformance() {
        return this.modelPerformance;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricDataPoints() ? this.metricDataPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPerformance());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OFITrainingMetricsValue)) {
            return false;
        }
        OFITrainingMetricsValue other = (OFITrainingMetricsValue)obj;
        return this.hasMetricDataPoints() == other.hasMetricDataPoints() && Objects.equals(this.metricDataPoints(), other.metricDataPoints()) && Objects.equals(this.modelPerformance(), other.modelPerformance());
    }

    public final String toString() {
        return ToString.builder((String)"OFITrainingMetricsValue").add("MetricDataPoints", this.hasMetricDataPoints() ? this.metricDataPoints() : null).add("ModelPerformance", (Object)this.modelPerformance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metricDataPoints": {
                return Optional.ofNullable(clazz.cast(this.metricDataPoints()));
            }
            case "modelPerformance": {
                return Optional.ofNullable(clazz.cast(this.modelPerformance()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("metricDataPoints", METRIC_DATA_POINTS_FIELD);
        map.put("modelPerformance", MODEL_PERFORMANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OFITrainingMetricsValue, T> g) {
        return obj -> g.apply((OFITrainingMetricsValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<OFIMetricDataPoint> metricDataPoints = DefaultSdkAutoConstructList.getInstance();
        private OFIModelPerformance modelPerformance;

        private BuilderImpl() {
        }

        private BuilderImpl(OFITrainingMetricsValue model) {
            this.metricDataPoints(model.metricDataPoints);
            this.modelPerformance(model.modelPerformance);
        }

        public final List<OFIMetricDataPoint.Builder> getMetricDataPoints() {
            List<OFIMetricDataPoint.Builder> result = OFIMetricDataPointsListCopier.copyToBuilder(this.metricDataPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricDataPoints(Collection<OFIMetricDataPoint.BuilderImpl> metricDataPoints) {
            this.metricDataPoints = OFIMetricDataPointsListCopier.copyFromBuilder(metricDataPoints);
        }

        @Override
        public final Builder metricDataPoints(Collection<OFIMetricDataPoint> metricDataPoints) {
            this.metricDataPoints = OFIMetricDataPointsListCopier.copy(metricDataPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataPoints(OFIMetricDataPoint ... metricDataPoints) {
            this.metricDataPoints(Arrays.asList(metricDataPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataPoints(Consumer<OFIMetricDataPoint.Builder> ... metricDataPoints) {
            this.metricDataPoints(Stream.of(metricDataPoints).map(c -> (OFIMetricDataPoint)((OFIMetricDataPoint.Builder)OFIMetricDataPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final OFIModelPerformance.Builder getModelPerformance() {
            return this.modelPerformance != null ? this.modelPerformance.toBuilder() : null;
        }

        public final void setModelPerformance(OFIModelPerformance.BuilderImpl modelPerformance) {
            this.modelPerformance = modelPerformance != null ? modelPerformance.build() : null;
        }

        @Override
        public final Builder modelPerformance(OFIModelPerformance modelPerformance) {
            this.modelPerformance = modelPerformance;
            return this;
        }

        public OFITrainingMetricsValue build() {
            return new OFITrainingMetricsValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OFITrainingMetricsValue> {
        public Builder metricDataPoints(Collection<OFIMetricDataPoint> var1);

        public Builder metricDataPoints(OFIMetricDataPoint ... var1);

        public Builder metricDataPoints(Consumer<OFIMetricDataPoint.Builder> ... var1);

        public Builder modelPerformance(OFIModelPerformance var1);

        default public Builder modelPerformance(Consumer<OFIModelPerformance.Builder> modelPerformance) {
            return this.modelPerformance((OFIModelPerformance)((OFIModelPerformance.Builder)OFIModelPerformance.builder().applyMutation(modelPerformance)).build());
        }
    }
}

