/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.ListOfModelVersionsCopier;
import software.amazon.awssdk.services.frauddetector.model.ListOfStringsCopier;
import software.amazon.awssdk.services.frauddetector.model.ModelVersion;
import software.amazon.awssdk.services.frauddetector.model.Rule;
import software.amazon.awssdk.services.frauddetector.model.RuleExecutionMode;
import software.amazon.awssdk.services.frauddetector.model.RuleListCopier;
import software.amazon.awssdk.services.frauddetector.model.Tag;
import software.amazon.awssdk.services.frauddetector.model._tagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDetectorVersionRequest
extends FraudDetectorRequest
implements ToCopyableBuilder<Builder, CreateDetectorVersionRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorId").getter(CreateDetectorVersionRequest.getter(CreateDetectorVersionRequest::detectorId)).setter(CreateDetectorVersionRequest.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateDetectorVersionRequest.getter(CreateDetectorVersionRequest::description)).setter(CreateDetectorVersionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> EXTERNAL_MODEL_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("externalModelEndpoints").getter(CreateDetectorVersionRequest.getter(CreateDetectorVersionRequest::externalModelEndpoints)).setter(CreateDetectorVersionRequest.setter(Builder::externalModelEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalModelEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Rule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rules").getter(CreateDetectorVersionRequest.getter(CreateDetectorVersionRequest::rules)).setter(CreateDetectorVersionRequest.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Rule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ModelVersion>> MODEL_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("modelVersions").getter(CreateDetectorVersionRequest.getter(CreateDetectorVersionRequest::modelVersions)).setter(CreateDetectorVersionRequest.setter(Builder::modelVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RULE_EXECUTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleExecutionMode").getter(CreateDetectorVersionRequest.getter(CreateDetectorVersionRequest::ruleExecutionModeAsString)).setter(CreateDetectorVersionRequest.setter(Builder::ruleExecutionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleExecutionMode").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateDetectorVersionRequest.getter(CreateDetectorVersionRequest::tags)).setter(CreateDetectorVersionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, DESCRIPTION_FIELD, EXTERNAL_MODEL_ENDPOINTS_FIELD, RULES_FIELD, MODEL_VERSIONS_FIELD, RULE_EXECUTION_MODE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDetectorVersionRequest.memberNameToFieldInitializer();
    private final String detectorId;
    private final String description;
    private final List<String> externalModelEndpoints;
    private final List<Rule> rules;
    private final List<ModelVersion> modelVersions;
    private final String ruleExecutionMode;
    private final List<Tag> tags;

    private CreateDetectorVersionRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.description = builder.description;
        this.externalModelEndpoints = builder.externalModelEndpoints;
        this.rules = builder.rules;
        this.modelVersions = builder.modelVersions;
        this.ruleExecutionMode = builder.ruleExecutionMode;
        this.tags = builder.tags;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasExternalModelEndpoints() {
        return this.externalModelEndpoints != null && !(this.externalModelEndpoints instanceof SdkAutoConstructList);
    }

    public final List<String> externalModelEndpoints() {
        return this.externalModelEndpoints;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<Rule> rules() {
        return this.rules;
    }

    public final boolean hasModelVersions() {
        return this.modelVersions != null && !(this.modelVersions instanceof SdkAutoConstructList);
    }

    public final List<ModelVersion> modelVersions() {
        return this.modelVersions;
    }

    public final RuleExecutionMode ruleExecutionMode() {
        return RuleExecutionMode.fromValue(this.ruleExecutionMode);
    }

    public final String ruleExecutionModeAsString() {
        return this.ruleExecutionMode;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExternalModelEndpoints() ? this.externalModelEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelVersions() ? this.modelVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleExecutionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDetectorVersionRequest)) {
            return false;
        }
        CreateDetectorVersionRequest other = (CreateDetectorVersionRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.description(), other.description()) && this.hasExternalModelEndpoints() == other.hasExternalModelEndpoints() && Objects.equals(this.externalModelEndpoints(), other.externalModelEndpoints()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && this.hasModelVersions() == other.hasModelVersions() && Objects.equals(this.modelVersions(), other.modelVersions()) && Objects.equals(this.ruleExecutionModeAsString(), other.ruleExecutionModeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDetectorVersionRequest").add("DetectorId", (Object)this.detectorId()).add("Description", (Object)this.description()).add("ExternalModelEndpoints", this.hasExternalModelEndpoints() ? this.externalModelEndpoints() : null).add("Rules", this.hasRules() ? this.rules() : null).add("ModelVersions", this.hasModelVersions() ? this.modelVersions() : null).add("RuleExecutionMode", (Object)this.ruleExecutionModeAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "externalModelEndpoints": {
                return Optional.ofNullable(clazz.cast(this.externalModelEndpoints()));
            }
            case "rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "modelVersions": {
                return Optional.ofNullable(clazz.cast(this.modelVersions()));
            }
            case "ruleExecutionMode": {
                return Optional.ofNullable(clazz.cast(this.ruleExecutionModeAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("detectorId", DETECTOR_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("externalModelEndpoints", EXTERNAL_MODEL_ENDPOINTS_FIELD);
        map.put("rules", RULES_FIELD);
        map.put("modelVersions", MODEL_VERSIONS_FIELD);
        map.put("ruleExecutionMode", RULE_EXECUTION_MODE_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDetectorVersionRequest, T> g) {
        return obj -> g.apply((CreateDetectorVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private String description;
        private List<String> externalModelEndpoints = DefaultSdkAutoConstructList.getInstance();
        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();
        private List<ModelVersion> modelVersions = DefaultSdkAutoConstructList.getInstance();
        private String ruleExecutionMode;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDetectorVersionRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.description(model.description);
            this.externalModelEndpoints(model.externalModelEndpoints);
            this.rules(model.rules);
            this.modelVersions(model.modelVersions);
            this.ruleExecutionMode(model.ruleExecutionMode);
            this.tags(model.tags);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getExternalModelEndpoints() {
            if (this.externalModelEndpoints instanceof SdkAutoConstructList) {
                return null;
            }
            return this.externalModelEndpoints;
        }

        public final void setExternalModelEndpoints(Collection<String> externalModelEndpoints) {
            this.externalModelEndpoints = ListOfStringsCopier.copy(externalModelEndpoints);
        }

        @Override
        public final Builder externalModelEndpoints(Collection<String> externalModelEndpoints) {
            this.externalModelEndpoints = ListOfStringsCopier.copy(externalModelEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalModelEndpoints(String ... externalModelEndpoints) {
            this.externalModelEndpoints(Arrays.asList(externalModelEndpoints));
            return this;
        }

        public final List<Rule.Builder> getRules() {
            List<Rule.Builder> result = RuleListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RuleListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (Rule)((Rule.Builder)Rule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ModelVersion.Builder> getModelVersions() {
            List<ModelVersion.Builder> result = ListOfModelVersionsCopier.copyToBuilder(this.modelVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelVersions(Collection<ModelVersion.BuilderImpl> modelVersions) {
            this.modelVersions = ListOfModelVersionsCopier.copyFromBuilder(modelVersions);
        }

        @Override
        public final Builder modelVersions(Collection<ModelVersion> modelVersions) {
            this.modelVersions = ListOfModelVersionsCopier.copy(modelVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVersions(ModelVersion ... modelVersions) {
            this.modelVersions(Arrays.asList(modelVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVersions(Consumer<ModelVersion.Builder> ... modelVersions) {
            this.modelVersions(Stream.of(modelVersions).map(c -> (ModelVersion)((ModelVersion.Builder)ModelVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRuleExecutionMode() {
            return this.ruleExecutionMode;
        }

        public final void setRuleExecutionMode(String ruleExecutionMode) {
            this.ruleExecutionMode = ruleExecutionMode;
        }

        @Override
        public final Builder ruleExecutionMode(String ruleExecutionMode) {
            this.ruleExecutionMode = ruleExecutionMode;
            return this;
        }

        @Override
        public final Builder ruleExecutionMode(RuleExecutionMode ruleExecutionMode) {
            this.ruleExecutionMode(ruleExecutionMode == null ? null : ruleExecutionMode.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = _tagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDetectorVersionRequest build() {
            return new CreateDetectorVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FraudDetectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDetectorVersionRequest> {
        public Builder detectorId(String var1);

        public Builder description(String var1);

        public Builder externalModelEndpoints(Collection<String> var1);

        public Builder externalModelEndpoints(String ... var1);

        public Builder rules(Collection<Rule> var1);

        public Builder rules(Rule ... var1);

        public Builder rules(Consumer<Rule.Builder> ... var1);

        public Builder modelVersions(Collection<ModelVersion> var1);

        public Builder modelVersions(ModelVersion ... var1);

        public Builder modelVersions(Consumer<ModelVersion.Builder> ... var1);

        public Builder ruleExecutionMode(String var1);

        public Builder ruleExecutionMode(RuleExecutionMode var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

