/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * You can use the Amazon Web Services Free Tier API to query programmatically your Free Tier usage data.
 * </p>
 * <p>
 * Free Tier tracks your monthly usage data for all free tier offers that are associated with your Amazon Web Services
 * account. You can use the Free Tier API to filter and show only the data that you want.
 * </p>
 * <p>
 * Service endpoint
 * </p>
 * <p>
 * The Free Tier API provides the following endpoint:
 * </p>
 * <ul>
 * <li>
 * <p>
 * https://freetier.us-east-1.api.aws
 * </p>
 * </li>
 * </ul>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-free-tier.html">Using the Amazon Web
 * Services Free Tier</a> in the <i>Billing User Guide</i>.
 * </p>
 */
package software.amazon.awssdk.services.freetier;