/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.freetier.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Dimension {
    SERVICE("SERVICE"),
    OPERATION("OPERATION"),
    USAGE_TYPE("USAGE_TYPE"),
    REGION("REGION"),
    FREE_TIER_TYPE("FREE_TIER_TYPE"),
    DESCRIPTION("DESCRIPTION"),
    USAGE_PERCENTAGE("USAGE_PERCENTAGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Dimension> VALUE_MAP;
    private final String value;

    private Dimension(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Dimension fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Dimension> knownValues() {
        EnumSet<Dimension> knownValues = EnumSet.allOf(Dimension.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Dimension.class, Dimension::toString);
    }
}

