/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.freetier.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.freetier.model.DimensionValues;
import software.amazon.awssdk.services.freetier.model.ExpressionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Expression
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Expression> {
    private static final SdkField<List<Expression>> AND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("And").getter(Expression.getter(Expression::and)).setter(Expression.setter(Builder::and)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("And").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DimensionValues> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Dimensions").getter(Expression.getter(Expression::dimensions)).setter(Expression.setter(Builder::dimensions)).constructor(DimensionValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build()}).build();
    private static final SdkField<Expression> NOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Not").getter(Expression.getter(Expression::not)).setter(Expression.setter(Builder::not)).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Not").build()}).build();
    private static final SdkField<List<Expression>> OR_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Or").getter(Expression.getter(Expression::or)).setter(Expression.setter(Builder::or)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Or").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AND_FIELD, DIMENSIONS_FIELD, NOT_FIELD, OR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("And", AND_FIELD);
            this.put("Dimensions", DIMENSIONS_FIELD);
            this.put("Not", NOT_FIELD);
            this.put("Or", OR_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<Expression> and;
    private final DimensionValues dimensions;
    private final Expression not;
    private final List<Expression> or;

    private Expression(BuilderImpl builder) {
        this.and = builder.and;
        this.dimensions = builder.dimensions;
        this.not = builder.not;
        this.or = builder.or;
    }

    public final boolean hasAnd() {
        return this.and != null && !(this.and instanceof SdkAutoConstructList);
    }

    public final List<Expression> and() {
        return this.and;
    }

    public final DimensionValues dimensions() {
        return this.dimensions;
    }

    public final Expression not() {
        return this.not;
    }

    public final boolean hasOr() {
        return this.or != null && !(this.or instanceof SdkAutoConstructList);
    }

    public final List<Expression> or() {
        return this.or;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnd() ? this.and() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.not());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOr() ? this.or() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Expression)) {
            return false;
        }
        Expression other = (Expression)obj;
        return this.hasAnd() == other.hasAnd() && Objects.equals(this.and(), other.and()) && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.not(), other.not()) && this.hasOr() == other.hasOr() && Objects.equals(this.or(), other.or());
    }

    public final String toString() {
        return ToString.builder((String)"Expression").add("And", this.hasAnd() ? this.and() : null).add("Dimensions", (Object)this.dimensions()).add("Not", (Object)this.not()).add("Or", this.hasOr() ? this.or() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "And": {
                return Optional.ofNullable(clazz.cast(this.and()));
            }
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "Not": {
                return Optional.ofNullable(clazz.cast(this.not()));
            }
            case "Or": {
                return Optional.ofNullable(clazz.cast(this.or()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Expression, T> g) {
        return obj -> g.apply((Expression)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Expression> and = DefaultSdkAutoConstructList.getInstance();
        private DimensionValues dimensions;
        private Expression not;
        private List<Expression> or = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Expression model) {
            this.and(model.and);
            this.dimensions(model.dimensions);
            this.not(model.not);
            this.or(model.or);
        }

        public final List<Builder> getAnd() {
            List<Builder> result = ExpressionsCopier.copyToBuilder(this.and);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnd(Collection<BuilderImpl> and) {
            this.and = ExpressionsCopier.copyFromBuilder(and);
        }

        @Override
        public final Builder and(Collection<Expression> and) {
            this.and = ExpressionsCopier.copy(and);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(Expression ... and) {
            this.and(Arrays.asList(and));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(Consumer<Builder> ... and) {
            this.and(Stream.of(and).map(c -> (Expression)((Builder)Expression.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DimensionValues.Builder getDimensions() {
            return this.dimensions != null ? this.dimensions.toBuilder() : null;
        }

        public final void setDimensions(DimensionValues.BuilderImpl dimensions) {
            this.dimensions = dimensions != null ? dimensions.build() : null;
        }

        @Override
        public final Builder dimensions(DimensionValues dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final Builder getNot() {
            return this.not != null ? this.not.toBuilder() : null;
        }

        public final void setNot(BuilderImpl not) {
            this.not = not != null ? not.build() : null;
        }

        @Override
        public final Builder not(Expression not) {
            this.not = not;
            return this;
        }

        public final List<Builder> getOr() {
            List<Builder> result = ExpressionsCopier.copyToBuilder(this.or);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOr(Collection<BuilderImpl> or) {
            this.or = ExpressionsCopier.copyFromBuilder(or);
        }

        @Override
        public final Builder or(Collection<Expression> or) {
            this.or = ExpressionsCopier.copy(or);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder or(Expression ... or) {
            this.or(Arrays.asList(or));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder or(Consumer<Builder> ... or) {
            this.or(Stream.of(or).map(c -> (Expression)((Builder)Expression.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Expression build() {
            return new Expression(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Expression> {
        public Builder and(Collection<Expression> var1);

        public Builder and(Expression ... var1);

        public Builder and(Consumer<Builder> ... var1);

        public Builder dimensions(DimensionValues var1);

        default public Builder dimensions(Consumer<DimensionValues.Builder> dimensions) {
            return this.dimensions((DimensionValues)((DimensionValues.Builder)DimensionValues.builder().applyMutation(dimensions)).build());
        }

        public Builder not(Expression var1);

        default public Builder not(Consumer<Builder> not) {
            return this.not((Expression)((Builder)Expression.builder().applyMutation(not)).build());
        }

        public Builder or(Collection<Expression> var1);

        public Builder or(Expression ... var1);

        public Builder or(Consumer<Builder> ... var1);
    }
}

