/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.freetier.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Use <code>Expression</code> to filter in the <code>GetFreeTierUsage</code> API operation.
 * </p>
 * <p>
 * You can use the following patterns:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Simple dimension values (<code>Dimensions</code> root operator)
 * </p>
 * </li>
 * <li>
 * <p>
 * Complex expressions with logical operators (<code>AND</code>, <code>NOT</code>, and <code>OR</code> root operators).
 * </p>
 * </li>
 * </ul>
 * <p>
 * For <i>simple dimension values</i>, you can set the dimension name, values, and match type for the filters that you
 * plan to use.
 * </p>
 * <p>
 * <b>Example for simple dimension values</b>
 * </p>
 * <p>
 * You can filter to match exactly for <code>REGION==us-east-1 OR REGION==us-west-1</code>.
 * </p>
 * <p>
 * The corresponding <code>Expression</code> appears like the following:
 * <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ], "MatchOptions": ["EQUALS"] } }</code>
 * </p>
 * <p>
 * As shown in the previous example, lists of dimension values are combined with <code>OR</code> when you apply the
 * filter.
 * </p>
 * <p>
 * For <i>complex expressions with logical operators</i>, you can have nested expressions to use the logical operators
 * and specify advanced filtering.
 * </p>
 * <p>
 * <b>Example for complex expressions with logical operators</b>
 * </p>
 * <p>
 * You can filter by
 * <code>((REGION == us-east-1 OR REGION == us-west-1) OR (SERVICE CONTAINS AWSLambda)) AND (USAGE_TYPE !CONTAINS DataTransfer)</code>
 * .
 * </p>
 * <p>
 * The corresponding <code>Expression</code> appears like the following:
 * <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ], "MatchOptions": ["EQUALS"] }}, {"Dimensions": { "Key": "SERVICE", "Values": ["AWSLambda"], "MatchOptions": ["CONTAINS"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"], "MatchOptions": ["CONTAINS"] }}} ] }</code>
 * </p>
 * <p>
 * In the following <b>Contents</b>, you must specify exactly one of the following root operators.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Expression implements SdkPojo, Serializable, ToCopyableBuilder<Expression.Builder, Expression> {
    private static final SdkField<List<Expression>> OR_FIELD = SdkField
            .<List<Expression>> builder(MarshallingType.LIST)
            .memberName("Or")
            .getter(getter(Expression::or))
            .setter(setter(Builder::or))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Or").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Expression> builder(MarshallingType.SDK_POJO)
                                            .constructor(Expression::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Expression>> AND_FIELD = SdkField
            .<List<Expression>> builder(MarshallingType.LIST)
            .memberName("And")
            .getter(getter(Expression::and))
            .setter(setter(Builder::and))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("And").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Expression> builder(MarshallingType.SDK_POJO)
                                            .constructor(Expression::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Expression> NOT_FIELD = SdkField.<Expression> builder(MarshallingType.SDK_POJO)
            .memberName("Not").getter(getter(Expression::not)).setter(setter(Builder::not)).constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Not").build()).build();

    private static final SdkField<DimensionValues> DIMENSIONS_FIELD = SdkField
            .<DimensionValues> builder(MarshallingType.SDK_POJO).memberName("Dimensions").getter(getter(Expression::dimensions))
            .setter(setter(Builder::dimensions)).constructor(DimensionValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OR_FIELD, AND_FIELD,
            NOT_FIELD, DIMENSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Expression> or;

    private final List<Expression> and;

    private final Expression not;

    private final DimensionValues dimensions;

    private Expression(BuilderImpl builder) {
        this.or = builder.or;
        this.and = builder.and;
        this.not = builder.not;
        this.dimensions = builder.dimensions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Or property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasOr() {
        return or != null && !(or instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Return results that match any of the <code>Expressions</code> that you specified. in the array.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOr} method.
     * </p>
     * 
     * @return Return results that match any of the <code>Expressions</code> that you specified. in the array.
     */
    public final List<Expression> or() {
        return or;
    }

    /**
     * For responses, this returns true if the service returned a value for the And property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasAnd() {
        return and != null && !(and instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Return results that match all <code>Expressions</code> that you specified in the array.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnd} method.
     * </p>
     * 
     * @return Return results that match all <code>Expressions</code> that you specified in the array.
     */
    public final List<Expression> and() {
        return and;
    }

    /**
     * <p>
     * Return results that don’t match the <code>Expression</code> that you specified.
     * </p>
     * 
     * @return Return results that don’t match the <code>Expression</code> that you specified.
     */
    public final Expression not() {
        return not;
    }

    /**
     * <p>
     * The specific dimension, values, and match type to filter objects with.
     * </p>
     * 
     * @return The specific dimension, values, and match type to filter objects with.
     */
    public final DimensionValues dimensions() {
        return dimensions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOr() ? or() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAnd() ? and() : null);
        hashCode = 31 * hashCode + Objects.hashCode(not());
        hashCode = 31 * hashCode + Objects.hashCode(dimensions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Expression)) {
            return false;
        }
        Expression other = (Expression) obj;
        return hasOr() == other.hasOr() && Objects.equals(or(), other.or()) && hasAnd() == other.hasAnd()
                && Objects.equals(and(), other.and()) && Objects.equals(not(), other.not())
                && Objects.equals(dimensions(), other.dimensions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Expression").add("Or", hasOr() ? or() : null).add("And", hasAnd() ? and() : null)
                .add("Not", not()).add("Dimensions", dimensions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Or":
            return Optional.ofNullable(clazz.cast(or()));
        case "And":
            return Optional.ofNullable(clazz.cast(and()));
        case "Not":
            return Optional.ofNullable(clazz.cast(not()));
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Or", OR_FIELD);
        map.put("And", AND_FIELD);
        map.put("Not", NOT_FIELD);
        map.put("Dimensions", DIMENSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Expression, T> g) {
        return obj -> g.apply((Expression) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Expression> {
        /**
         * <p>
         * Return results that match any of the <code>Expressions</code> that you specified. in the array.
         * </p>
         * 
         * @param or
         *        Return results that match any of the <code>Expressions</code> that you specified. in the array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder or(Collection<Expression> or);

        /**
         * <p>
         * Return results that match any of the <code>Expressions</code> that you specified. in the array.
         * </p>
         * 
         * @param or
         *        Return results that match any of the <code>Expressions</code> that you specified. in the array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder or(Expression... or);

        /**
         * <p>
         * Return results that match any of the <code>Expressions</code> that you specified. in the array.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.freetier.model.Expression.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.freetier.model.Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.freetier.model.Expression.Builder#build()} is called immediately and
         * its result is passed to {@link #or(List<Expression>)}.
         * 
         * @param or
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.freetier.model.Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #or(java.util.Collection<Expression>)
         */
        Builder or(Consumer<Builder>... or);

        /**
         * <p>
         * Return results that match all <code>Expressions</code> that you specified in the array.
         * </p>
         * 
         * @param and
         *        Return results that match all <code>Expressions</code> that you specified in the array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder and(Collection<Expression> and);

        /**
         * <p>
         * Return results that match all <code>Expressions</code> that you specified in the array.
         * </p>
         * 
         * @param and
         *        Return results that match all <code>Expressions</code> that you specified in the array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder and(Expression... and);

        /**
         * <p>
         * Return results that match all <code>Expressions</code> that you specified in the array.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.freetier.model.Expression.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.freetier.model.Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.freetier.model.Expression.Builder#build()} is called immediately and
         * its result is passed to {@link #and(List<Expression>)}.
         * 
         * @param and
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.freetier.model.Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #and(java.util.Collection<Expression>)
         */
        Builder and(Consumer<Builder>... and);

        /**
         * <p>
         * Return results that don’t match the <code>Expression</code> that you specified.
         * </p>
         * 
         * @param not
         *        Return results that don’t match the <code>Expression</code> that you specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder not(Expression not);

        /**
         * <p>
         * Return results that don’t match the <code>Expression</code> that you specified.
         * </p>
         * This is a convenience method that creates an instance of the {@link Expression.Builder} avoiding the need to
         * create one manually via {@link Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #not(Expression)}.
         * 
         * @param not
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #not(Expression)
         */
        default Builder not(Consumer<Builder> not) {
            return not(Expression.builder().applyMutation(not).build());
        }

        /**
         * <p>
         * The specific dimension, values, and match type to filter objects with.
         * </p>
         * 
         * @param dimensions
         *        The specific dimension, values, and match type to filter objects with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(DimensionValues dimensions);

        /**
         * <p>
         * The specific dimension, values, and match type to filter objects with.
         * </p>
         * This is a convenience method that creates an instance of the {@link DimensionValues.Builder} avoiding the
         * need to create one manually via {@link DimensionValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DimensionValues.Builder#build()} is called immediately and its
         * result is passed to {@link #dimensions(DimensionValues)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on {@link DimensionValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(DimensionValues)
         */
        default Builder dimensions(Consumer<DimensionValues.Builder> dimensions) {
            return dimensions(DimensionValues.builder().applyMutation(dimensions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<Expression> or = DefaultSdkAutoConstructList.getInstance();

        private List<Expression> and = DefaultSdkAutoConstructList.getInstance();

        private Expression not;

        private DimensionValues dimensions;

        private BuilderImpl() {
        }

        private BuilderImpl(Expression model) {
            or(model.or);
            and(model.and);
            not(model.not);
            dimensions(model.dimensions);
        }

        public final List<Builder> getOr() {
            List<Builder> result = ExpressionsCopier.copyToBuilder(this.or);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOr(Collection<BuilderImpl> or) {
            this.or = ExpressionsCopier.copyFromBuilder(or);
        }

        @Override
        public final Builder or(Collection<Expression> or) {
            this.or = ExpressionsCopier.copy(or);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder or(Expression... or) {
            or(Arrays.asList(or));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder or(Consumer<Builder>... or) {
            or(Stream.of(or).map(c -> Expression.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getAnd() {
            List<Builder> result = ExpressionsCopier.copyToBuilder(this.and);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnd(Collection<BuilderImpl> and) {
            this.and = ExpressionsCopier.copyFromBuilder(and);
        }

        @Override
        public final Builder and(Collection<Expression> and) {
            this.and = ExpressionsCopier.copy(and);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(Expression... and) {
            and(Arrays.asList(and));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(Consumer<Builder>... and) {
            and(Stream.of(and).map(c -> Expression.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Builder getNot() {
            return not != null ? not.toBuilder() : null;
        }

        public final void setNot(BuilderImpl not) {
            this.not = not != null ? not.build() : null;
        }

        @Override
        public final Builder not(Expression not) {
            this.not = not;
            return this;
        }

        public final DimensionValues.Builder getDimensions() {
            return dimensions != null ? dimensions.toBuilder() : null;
        }

        public final void setDimensions(DimensionValues.BuilderImpl dimensions) {
            this.dimensions = dimensions != null ? dimensions.build() : null;
        }

        @Override
        public final Builder dimensions(DimensionValues dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        @Override
        public Expression build() {
            return new Expression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
