/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.freetier.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpgradeAccountPlanRequest extends FreeTierRequest implements
        ToCopyableBuilder<UpgradeAccountPlanRequest.Builder, UpgradeAccountPlanRequest> {
    private static final SdkField<String> ACCOUNT_PLAN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountPlanType").getter(getter(UpgradeAccountPlanRequest::accountPlanTypeAsString))
            .setter(setter(Builder::accountPlanType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountPlanType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_PLAN_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountPlanType;

    private UpgradeAccountPlanRequest(BuilderImpl builder) {
        super(builder);
        this.accountPlanType = builder.accountPlanType;
    }

    /**
     * <p>
     * The target account plan type. This makes it explicit about the change and latest value of the
     * <code>accountPlanType</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountPlanType}
     * will return {@link AccountPlanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #accountPlanTypeAsString}.
     * </p>
     * 
     * @return The target account plan type. This makes it explicit about the change and latest value of the
     *         <code>accountPlanType</code>.
     * @see AccountPlanType
     */
    public final AccountPlanType accountPlanType() {
        return AccountPlanType.fromValue(accountPlanType);
    }

    /**
     * <p>
     * The target account plan type. This makes it explicit about the change and latest value of the
     * <code>accountPlanType</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountPlanType}
     * will return {@link AccountPlanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #accountPlanTypeAsString}.
     * </p>
     * 
     * @return The target account plan type. This makes it explicit about the change and latest value of the
     *         <code>accountPlanType</code>.
     * @see AccountPlanType
     */
    public final String accountPlanTypeAsString() {
        return accountPlanType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountPlanTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeAccountPlanRequest)) {
            return false;
        }
        UpgradeAccountPlanRequest other = (UpgradeAccountPlanRequest) obj;
        return Objects.equals(accountPlanTypeAsString(), other.accountPlanTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpgradeAccountPlanRequest").add("AccountPlanType", accountPlanTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountPlanType":
            return Optional.ofNullable(clazz.cast(accountPlanTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountPlanType", ACCOUNT_PLAN_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpgradeAccountPlanRequest, T> g) {
        return obj -> g.apply((UpgradeAccountPlanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FreeTierRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpgradeAccountPlanRequest> {
        /**
         * <p>
         * The target account plan type. This makes it explicit about the change and latest value of the
         * <code>accountPlanType</code>.
         * </p>
         * 
         * @param accountPlanType
         *        The target account plan type. This makes it explicit about the change and latest value of the
         *        <code>accountPlanType</code>.
         * @see AccountPlanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountPlanType
         */
        Builder accountPlanType(String accountPlanType);

        /**
         * <p>
         * The target account plan type. This makes it explicit about the change and latest value of the
         * <code>accountPlanType</code>.
         * </p>
         * 
         * @param accountPlanType
         *        The target account plan type. This makes it explicit about the change and latest value of the
         *        <code>accountPlanType</code>.
         * @see AccountPlanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountPlanType
         */
        Builder accountPlanType(AccountPlanType accountPlanType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FreeTierRequest.BuilderImpl implements Builder {
        private String accountPlanType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpgradeAccountPlanRequest model) {
            super(model);
            accountPlanType(model.accountPlanType);
        }

        public final String getAccountPlanType() {
            return accountPlanType;
        }

        public final void setAccountPlanType(String accountPlanType) {
            this.accountPlanType = accountPlanType;
        }

        @Override
        public final Builder accountPlanType(String accountPlanType) {
            this.accountPlanType = accountPlanType;
            return this;
        }

        @Override
        public final Builder accountPlanType(AccountPlanType accountPlanType) {
            this.accountPlanType(accountPlanType == null ? null : accountPlanType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpgradeAccountPlanRequest build() {
            return new UpgradeAccountPlanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
