/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.fsx.model.AssociateFileSystemAliasesRequest;
import software.amazon.awssdk.services.fsx.model.AssociateFileSystemAliasesResponse;
import software.amazon.awssdk.services.fsx.model.CancelDataRepositoryTaskRequest;
import software.amazon.awssdk.services.fsx.model.CancelDataRepositoryTaskResponse;
import software.amazon.awssdk.services.fsx.model.CopyBackupRequest;
import software.amazon.awssdk.services.fsx.model.CopyBackupResponse;
import software.amazon.awssdk.services.fsx.model.CreateBackupRequest;
import software.amazon.awssdk.services.fsx.model.CreateBackupResponse;
import software.amazon.awssdk.services.fsx.model.CreateDataRepositoryTaskRequest;
import software.amazon.awssdk.services.fsx.model.CreateDataRepositoryTaskResponse;
import software.amazon.awssdk.services.fsx.model.CreateFileSystemFromBackupRequest;
import software.amazon.awssdk.services.fsx.model.CreateFileSystemFromBackupResponse;
import software.amazon.awssdk.services.fsx.model.CreateFileSystemRequest;
import software.amazon.awssdk.services.fsx.model.CreateFileSystemResponse;
import software.amazon.awssdk.services.fsx.model.DeleteBackupRequest;
import software.amazon.awssdk.services.fsx.model.DeleteBackupResponse;
import software.amazon.awssdk.services.fsx.model.DeleteFileSystemRequest;
import software.amazon.awssdk.services.fsx.model.DeleteFileSystemResponse;
import software.amazon.awssdk.services.fsx.model.DescribeBackupsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeBackupsResponse;
import software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksRequest;
import software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksResponse;
import software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesRequest;
import software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesResponse;
import software.amazon.awssdk.services.fsx.model.DescribeFileSystemsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeFileSystemsResponse;
import software.amazon.awssdk.services.fsx.model.DisassociateFileSystemAliasesRequest;
import software.amazon.awssdk.services.fsx.model.DisassociateFileSystemAliasesResponse;
import software.amazon.awssdk.services.fsx.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.fsx.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.fsx.model.TagResourceRequest;
import software.amazon.awssdk.services.fsx.model.TagResourceResponse;
import software.amazon.awssdk.services.fsx.model.UntagResourceRequest;
import software.amazon.awssdk.services.fsx.model.UntagResourceResponse;
import software.amazon.awssdk.services.fsx.model.UpdateFileSystemRequest;
import software.amazon.awssdk.services.fsx.model.UpdateFileSystemResponse;
import software.amazon.awssdk.services.fsx.paginators.DescribeBackupsPublisher;
import software.amazon.awssdk.services.fsx.paginators.DescribeDataRepositoryTasksPublisher;
import software.amazon.awssdk.services.fsx.paginators.DescribeFileSystemAliasesPublisher;
import software.amazon.awssdk.services.fsx.paginators.DescribeFileSystemsPublisher;

/**
 * Service client for accessing Amazon FSx asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Amazon FSx is a fully managed service that makes it easy for storage and application administrators to launch and use
 * shared file storage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface FSxAsyncClient extends SdkClient {
    String SERVICE_NAME = "fsx";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "fsx";

    /**
     * Create a {@link FSxAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static FSxAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link FSxAsyncClient}.
     */
    static FSxAsyncClientBuilder builder() {
        return new DefaultFSxAsyncClientBuilder();
    }

    /**
     * <p>
     * Use this action to associate one or more Domain Name Server (DNS) aliases with an existing Amazon FSx for Windows
     * File Server file system. A file systen can have a maximum of 50 DNS aliases associated with it at any one time.
     * If you try to associate a DNS alias that is already associated with the file system, FSx takes no action on that
     * alias in the request. For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html">Working with DNS Aliases</a>
     * and <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/walkthrough05-file-system-custom-CNAME.html">
     * Walkthrough 5: Using DNS aliases to access your file system</a>, including additional steps you must take to be
     * able to access your file system using a DNS alias.
     * </p>
     * <p>
     * The system response shows the DNS aliases that Amazon FSx is attempting to associate with the file system. Use
     * the API operation to monitor the status of the aliases Amazon FSx is associating with the file system.
     * </p>
     *
     * @param associateFileSystemAliasesRequest
     *        The request object specifying one or more DNS alias names to associate with an Amazon FSx for Windows File
     *        Server file system.
     * @return A Java Future containing the result of the AssociateFileSystemAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.AssociateFileSystemAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/AssociateFileSystemAliases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateFileSystemAliasesResponse> associateFileSystemAliases(
            AssociateFileSystemAliasesRequest associateFileSystemAliasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this action to associate one or more Domain Name Server (DNS) aliases with an existing Amazon FSx for Windows
     * File Server file system. A file systen can have a maximum of 50 DNS aliases associated with it at any one time.
     * If you try to associate a DNS alias that is already associated with the file system, FSx takes no action on that
     * alias in the request. For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html">Working with DNS Aliases</a>
     * and <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/walkthrough05-file-system-custom-CNAME.html">
     * Walkthrough 5: Using DNS aliases to access your file system</a>, including additional steps you must take to be
     * able to access your file system using a DNS alias.
     * </p>
     * <p>
     * The system response shows the DNS aliases that Amazon FSx is attempting to associate with the file system. Use
     * the API operation to monitor the status of the aliases Amazon FSx is associating with the file system.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateFileSystemAliasesRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateFileSystemAliasesRequest#builder()}
     * </p>
     *
     * @param associateFileSystemAliasesRequest
     *        A {@link Consumer} that will call methods on {@link AssociateFileSystemAliasesRequest.Builder} to create a
     *        request. The request object specifying one or more DNS alias names to associate with an Amazon FSx for
     *        Windows File Server file system.
     * @return A Java Future containing the result of the AssociateFileSystemAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.AssociateFileSystemAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/AssociateFileSystemAliases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateFileSystemAliasesResponse> associateFileSystemAliases(
            Consumer<AssociateFileSystemAliasesRequest.Builder> associateFileSystemAliasesRequest) {
        return associateFileSystemAliases(AssociateFileSystemAliasesRequest.builder()
                .applyMutation(associateFileSystemAliasesRequest).build());
    }

    /**
     * <p>
     * Cancels an existing Amazon FSx for Lustre data repository task if that task is in either the <code>PENDING</code>
     * or <code>EXECUTING</code> state. When you cancel a task, Amazon FSx does the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Any files that FSx has already exported are not reverted.
     * </p>
     * </li>
     * <li>
     * <p>
     * FSx continues to export any files that are "in-flight" when the cancel operation is received.
     * </p>
     * </li>
     * <li>
     * <p>
     * FSx does not export any files that have not yet been exported.
     * </p>
     * </li>
     * </ul>
     *
     * @param cancelDataRepositoryTaskRequest
     *        Cancels a data repository task.
     * @return A Java Future containing the result of the CancelDataRepositoryTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>UnsupportedOperationException The requested operation is not supported for this resource or API.</li>
     *         <li>DataRepositoryTaskNotFoundException The data repository task or tasks you specified could not be
     *         found.</li>
     *         <li>DataRepositoryTaskEndedException The data repository task could not be canceled because the task has
     *         already ended.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.CancelDataRepositoryTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CancelDataRepositoryTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelDataRepositoryTaskResponse> cancelDataRepositoryTask(
            CancelDataRepositoryTaskRequest cancelDataRepositoryTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an existing Amazon FSx for Lustre data repository task if that task is in either the <code>PENDING</code>
     * or <code>EXECUTING</code> state. When you cancel a task, Amazon FSx does the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Any files that FSx has already exported are not reverted.
     * </p>
     * </li>
     * <li>
     * <p>
     * FSx continues to export any files that are "in-flight" when the cancel operation is received.
     * </p>
     * </li>
     * <li>
     * <p>
     * FSx does not export any files that have not yet been exported.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelDataRepositoryTaskRequest.Builder} avoiding
     * the need to create one manually via {@link CancelDataRepositoryTaskRequest#builder()}
     * </p>
     *
     * @param cancelDataRepositoryTaskRequest
     *        A {@link Consumer} that will call methods on {@link CancelDataRepositoryTaskRequest.Builder} to create a
     *        request. Cancels a data repository task.
     * @return A Java Future containing the result of the CancelDataRepositoryTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>UnsupportedOperationException The requested operation is not supported for this resource or API.</li>
     *         <li>DataRepositoryTaskNotFoundException The data repository task or tasks you specified could not be
     *         found.</li>
     *         <li>DataRepositoryTaskEndedException The data repository task could not be canceled because the task has
     *         already ended.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.CancelDataRepositoryTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CancelDataRepositoryTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelDataRepositoryTaskResponse> cancelDataRepositoryTask(
            Consumer<CancelDataRepositoryTaskRequest.Builder> cancelDataRepositoryTaskRequest) {
        return cancelDataRepositoryTask(CancelDataRepositoryTaskRequest.builder().applyMutation(cancelDataRepositoryTaskRequest)
                .build());
    }

    /**
     * <p>
     * Copies an existing backup within the same AWS account to another Region (cross-Region copy) or within the same
     * Region (in-Region copy). You can have up to five backup copy requests in progress to a single destination Region
     * per account.
     * </p>
     * <p>
     * You can use cross-Region backup copies for cross-region disaster recovery. You periodically take backups and copy
     * them to another Region so that in the event of a disaster in the primary Region, you can restore from backup and
     * recover availability quickly in the other Region. You can make cross-Region copies only within your AWS
     * partition.
     * </p>
     * <p>
     * You can also use backup copies to clone your file data set to another Region or within the same Region.
     * </p>
     * <p>
     * You can use the <code>SourceRegion</code> parameter to specify the AWS Region from which the backup will be
     * copied. For example, if you make the call from the <code>us-west-1</code> Region and want to copy a backup from
     * the <code>us-east-2</code> Region, you specify <code>us-east-2</code> in the <code>SourceRegion</code> parameter
     * to make a cross-Region copy. If you don't specify a Region, the backup copy is created in the same Region where
     * the request is sent from (in-Region copy).
     * </p>
     * <p>
     * For more information on creating backup copies, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/copy-backups.html"> Copying backups</a> in the
     * <i>Amazon FSx for Windows User Guide</i> and <a
     * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/copy-backups.html">Copying backups</a> in the <i>Amazon
     * FSx for Lustre User Guide</i>.
     * </p>
     *
     * @param copyBackupRequest
     * @return A Java Future containing the result of the CopyBackup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>BackupNotFoundException No Amazon FSx backups were found based upon the supplied parameters.</li>
     *         <li>ServiceLimitExceededException An error indicating that a particular service limit was exceeded. You
     *         can increase some service limits by contacting AWS Support.</li>
     *         <li>UnsupportedOperationException The requested operation is not supported for this resource or API.</li>
     *         <li>IncompatibleParameterErrorException The error returned when a second request is received with the
     *         same client request token but different parameters settings. A client request token should always
     *         uniquely identify a single request.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>InvalidSourceKmsKeyException The AWS Key Management Service (AWS KMS) key of the source backup is
     *         invalid.</li>
     *         <li>InvalidDestinationKmsKeyException The AWS Key Management Service (AWS KMS) key of the destination
     *         backup is invalid.</li>
     *         <li>InvalidRegionException The Region provided for <code>Source Region</code> is invalid or is in a
     *         different AWS partition.</li>
     *         <li>SourceBackupUnavailableException The request was rejected because the lifecycle status of the source
     *         backup is not <code>AVAILABLE</code>.</li>
     *         <li>IncompatibleRegionForMultiAzException Amazon FSx doesn't support Multi-AZ Windows File Server copy
     *         backup in the destination Region, so the copied backup can't be restored.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.CopyBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CopyBackup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CopyBackupResponse> copyBackup(CopyBackupRequest copyBackupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies an existing backup within the same AWS account to another Region (cross-Region copy) or within the same
     * Region (in-Region copy). You can have up to five backup copy requests in progress to a single destination Region
     * per account.
     * </p>
     * <p>
     * You can use cross-Region backup copies for cross-region disaster recovery. You periodically take backups and copy
     * them to another Region so that in the event of a disaster in the primary Region, you can restore from backup and
     * recover availability quickly in the other Region. You can make cross-Region copies only within your AWS
     * partition.
     * </p>
     * <p>
     * You can also use backup copies to clone your file data set to another Region or within the same Region.
     * </p>
     * <p>
     * You can use the <code>SourceRegion</code> parameter to specify the AWS Region from which the backup will be
     * copied. For example, if you make the call from the <code>us-west-1</code> Region and want to copy a backup from
     * the <code>us-east-2</code> Region, you specify <code>us-east-2</code> in the <code>SourceRegion</code> parameter
     * to make a cross-Region copy. If you don't specify a Region, the backup copy is created in the same Region where
     * the request is sent from (in-Region copy).
     * </p>
     * <p>
     * For more information on creating backup copies, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/copy-backups.html"> Copying backups</a> in the
     * <i>Amazon FSx for Windows User Guide</i> and <a
     * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/copy-backups.html">Copying backups</a> in the <i>Amazon
     * FSx for Lustre User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyBackupRequest.Builder} avoiding the need to
     * create one manually via {@link CopyBackupRequest#builder()}
     * </p>
     *
     * @param copyBackupRequest
     *        A {@link Consumer} that will call methods on {@link CopyBackupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CopyBackup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>BackupNotFoundException No Amazon FSx backups were found based upon the supplied parameters.</li>
     *         <li>ServiceLimitExceededException An error indicating that a particular service limit was exceeded. You
     *         can increase some service limits by contacting AWS Support.</li>
     *         <li>UnsupportedOperationException The requested operation is not supported for this resource or API.</li>
     *         <li>IncompatibleParameterErrorException The error returned when a second request is received with the
     *         same client request token but different parameters settings. A client request token should always
     *         uniquely identify a single request.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>InvalidSourceKmsKeyException The AWS Key Management Service (AWS KMS) key of the source backup is
     *         invalid.</li>
     *         <li>InvalidDestinationKmsKeyException The AWS Key Management Service (AWS KMS) key of the destination
     *         backup is invalid.</li>
     *         <li>InvalidRegionException The Region provided for <code>Source Region</code> is invalid or is in a
     *         different AWS partition.</li>
     *         <li>SourceBackupUnavailableException The request was rejected because the lifecycle status of the source
     *         backup is not <code>AVAILABLE</code>.</li>
     *         <li>IncompatibleRegionForMultiAzException Amazon FSx doesn't support Multi-AZ Windows File Server copy
     *         backup in the destination Region, so the copied backup can't be restored.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.CopyBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CopyBackup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CopyBackupResponse> copyBackup(Consumer<CopyBackupRequest.Builder> copyBackupRequest) {
        return copyBackup(CopyBackupRequest.builder().applyMutation(copyBackupRequest).build());
    }

    /**
     * <p>
     * Creates a backup of an existing Amazon FSx file system. Creating regular backups for your file system is a best
     * practice, enabling you to restore a file system from a backup if an issue arises with the original file system.
     * </p>
     * <p>
     * For Amazon FSx for Lustre file systems, you can create a backup only for file systems with the following
     * configuration:
     * </p>
     * <ul>
     * <li>
     * <p>
     * a Persistent deployment type
     * </p>
     * </li>
     * <li>
     * <p>
     * is <i>not</i> linked to a data respository.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about backing up Amazon FSx for Lustre file systems, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html">Working with FSx for Lustre
     * backups</a>.
     * </p>
     * <p>
     * For more information about backing up Amazon FSx for Windows file systems, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html">Working with FSx for Windows
     * backups</a>.
     * </p>
     * <p>
     * If a backup with the specified client request token exists, and the parameters match, this operation returns the
     * description of the existing backup. If a backup specified client request token exists, and the parameters don't
     * match, this operation returns <code>IncompatibleParameterError</code>. If a backup with the specified client
     * request token doesn't exist, <code>CreateBackup</code> does the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creates a new Amazon FSx backup with an assigned ID, and an initial lifecycle state of <code>CREATING</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Returns the description of the backup.
     * </p>
     * </li>
     * </ul>
     * <p>
     * By using the idempotent operation, you can retry a <code>CreateBackup</code> operation without the risk of
     * creating an extra backup. This approach can be useful when an initial call fails in a way that makes it unclear
     * whether a backup was created. If you use the same client request token and the initial call created a backup, the
     * operation returns a successful result because all the parameters are the same.
     * </p>
     * <p>
     * The <code>CreateBackup</code> operation returns while the backup's lifecycle state is still <code>CREATING</code>
     * . You can check the backup creation status by calling the <a>DescribeBackups</a> operation, which returns the
     * backup state along with other information.
     * </p>
     *
     * @param createBackupRequest
     *        The request object for the <code>CreateBackup</code> operation.
     * @return A Java Future containing the result of the CreateBackup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>UnsupportedOperationException The requested operation is not supported for this resource or API.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>BackupInProgressException Another backup is already under way. Wait for completion before initiating
     *         additional backups of this file system.</li>
     *         <li>IncompatibleParameterErrorException The error returned when a second request is received with the
     *         same client request token but different parameters settings. A client request token should always
     *         uniquely identify a single request.</li>
     *         <li>ServiceLimitExceededException An error indicating that a particular service limit was exceeded. You
     *         can increase some service limits by contacting AWS Support.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.CreateBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateBackup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBackupResponse> createBackup(CreateBackupRequest createBackupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a backup of an existing Amazon FSx file system. Creating regular backups for your file system is a best
     * practice, enabling you to restore a file system from a backup if an issue arises with the original file system.
     * </p>
     * <p>
     * For Amazon FSx for Lustre file systems, you can create a backup only for file systems with the following
     * configuration:
     * </p>
     * <ul>
     * <li>
     * <p>
     * a Persistent deployment type
     * </p>
     * </li>
     * <li>
     * <p>
     * is <i>not</i> linked to a data respository.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about backing up Amazon FSx for Lustre file systems, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html">Working with FSx for Lustre
     * backups</a>.
     * </p>
     * <p>
     * For more information about backing up Amazon FSx for Windows file systems, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html">Working with FSx for Windows
     * backups</a>.
     * </p>
     * <p>
     * If a backup with the specified client request token exists, and the parameters match, this operation returns the
     * description of the existing backup. If a backup specified client request token exists, and the parameters don't
     * match, this operation returns <code>IncompatibleParameterError</code>. If a backup with the specified client
     * request token doesn't exist, <code>CreateBackup</code> does the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creates a new Amazon FSx backup with an assigned ID, and an initial lifecycle state of <code>CREATING</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Returns the description of the backup.
     * </p>
     * </li>
     * </ul>
     * <p>
     * By using the idempotent operation, you can retry a <code>CreateBackup</code> operation without the risk of
     * creating an extra backup. This approach can be useful when an initial call fails in a way that makes it unclear
     * whether a backup was created. If you use the same client request token and the initial call created a backup, the
     * operation returns a successful result because all the parameters are the same.
     * </p>
     * <p>
     * The <code>CreateBackup</code> operation returns while the backup's lifecycle state is still <code>CREATING</code>
     * . You can check the backup creation status by calling the <a>DescribeBackups</a> operation, which returns the
     * backup state along with other information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBackupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBackupRequest#builder()}
     * </p>
     *
     * @param createBackupRequest
     *        A {@link Consumer} that will call methods on {@link CreateBackupRequest.Builder} to create a request. The
     *        request object for the <code>CreateBackup</code> operation.
     * @return A Java Future containing the result of the CreateBackup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>UnsupportedOperationException The requested operation is not supported for this resource or API.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>BackupInProgressException Another backup is already under way. Wait for completion before initiating
     *         additional backups of this file system.</li>
     *         <li>IncompatibleParameterErrorException The error returned when a second request is received with the
     *         same client request token but different parameters settings. A client request token should always
     *         uniquely identify a single request.</li>
     *         <li>ServiceLimitExceededException An error indicating that a particular service limit was exceeded. You
     *         can increase some service limits by contacting AWS Support.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.CreateBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateBackup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBackupResponse> createBackup(Consumer<CreateBackupRequest.Builder> createBackupRequest) {
        return createBackup(CreateBackupRequest.builder().applyMutation(createBackupRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon FSx for Lustre data repository task. You use data repository tasks to perform bulk operations
     * between your Amazon FSx file system and its linked data repository. An example of a data repository task is
     * exporting any data and metadata changes, including POSIX metadata, to files, directories, and symbolic links
     * (symlinks) from your FSx file system to its linked data repository. A <code>CreateDataRepositoryTask</code>
     * operation will fail if a data repository is not linked to the FSx file system. To learn more about data
     * repository tasks, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-repository-tasks.html">Data Repository Tasks</a>.
     * To learn more about linking a data repository to your file system, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-fs-linked-data-repo.html">Linking your file
     * system to an S3 bucket</a>.
     * </p>
     *
     * @param createDataRepositoryTaskRequest
     * @return A Java Future containing the result of the CreateDataRepositoryTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>UnsupportedOperationException The requested operation is not supported for this resource or API.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>IncompatibleParameterErrorException The error returned when a second request is received with the
     *         same client request token but different parameters settings. A client request token should always
     *         uniquely identify a single request.</li>
     *         <li>ServiceLimitExceededException An error indicating that a particular service limit was exceeded. You
     *         can increase some service limits by contacting AWS Support.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>DataRepositoryTaskExecutingException An existing data repository task is currently executing on the
     *         file system. Wait until the existing task has completed, then create the new task.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.CreateDataRepositoryTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateDataRepositoryTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDataRepositoryTaskResponse> createDataRepositoryTask(
            CreateDataRepositoryTaskRequest createDataRepositoryTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon FSx for Lustre data repository task. You use data repository tasks to perform bulk operations
     * between your Amazon FSx file system and its linked data repository. An example of a data repository task is
     * exporting any data and metadata changes, including POSIX metadata, to files, directories, and symbolic links
     * (symlinks) from your FSx file system to its linked data repository. A <code>CreateDataRepositoryTask</code>
     * operation will fail if a data repository is not linked to the FSx file system. To learn more about data
     * repository tasks, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-repository-tasks.html">Data Repository Tasks</a>.
     * To learn more about linking a data repository to your file system, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-fs-linked-data-repo.html">Linking your file
     * system to an S3 bucket</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataRepositoryTaskRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDataRepositoryTaskRequest#builder()}
     * </p>
     *
     * @param createDataRepositoryTaskRequest
     *        A {@link Consumer} that will call methods on {@link CreateDataRepositoryTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDataRepositoryTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>UnsupportedOperationException The requested operation is not supported for this resource or API.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>IncompatibleParameterErrorException The error returned when a second request is received with the
     *         same client request token but different parameters settings. A client request token should always
     *         uniquely identify a single request.</li>
     *         <li>ServiceLimitExceededException An error indicating that a particular service limit was exceeded. You
     *         can increase some service limits by contacting AWS Support.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>DataRepositoryTaskExecutingException An existing data repository task is currently executing on the
     *         file system. Wait until the existing task has completed, then create the new task.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.CreateDataRepositoryTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateDataRepositoryTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDataRepositoryTaskResponse> createDataRepositoryTask(
            Consumer<CreateDataRepositoryTaskRequest.Builder> createDataRepositoryTaskRequest) {
        return createDataRepositoryTask(CreateDataRepositoryTaskRequest.builder().applyMutation(createDataRepositoryTaskRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new, empty Amazon FSx file system.
     * </p>
     * <p>
     * If a file system with the specified client request token exists and the parameters match,
     * <code>CreateFileSystem</code> returns the description of the existing file system. If a file system specified
     * client request token exists and the parameters don't match, this call returns
     * <code>IncompatibleParameterError</code>. If a file system with the specified client request token doesn't exist,
     * <code>CreateFileSystem</code> does the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creates a new, empty Amazon FSx file system with an assigned ID, and an initial lifecycle state of
     * <code>CREATING</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Returns the description of the file system.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation requires a client request token in the request that Amazon FSx uses to ensure idempotent creation.
     * This means that calling the operation multiple times with the same client request token has no effect. By using
     * the idempotent operation, you can retry a <code>CreateFileSystem</code> operation without the risk of creating an
     * extra file system. This approach can be useful when an initial call fails in a way that makes it unclear whether
     * a file system was created. Examples are if a transport level timeout occurred, or your connection was reset. If
     * you use the same client request token and the initial call created a file system, the client receives success as
     * long as the parameters are the same.
     * </p>
     * <note>
     * <p>
     * The <code>CreateFileSystem</code> call returns while the file system's lifecycle state is still
     * <code>CREATING</code>. You can check the file-system creation status by calling the <a>DescribeFileSystems</a>
     * operation, which returns the file system state along with other information.
     * </p>
     * </note>
     *
     * @param createFileSystemRequest
     *        The request object used to create a new Amazon FSx file system.
     * @return A Java Future containing the result of the CreateFileSystem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>ActiveDirectoryErrorException An Active Directory error.</li>
     *         <li>IncompatibleParameterErrorException The error returned when a second request is received with the
     *         same client request token but different parameters settings. A client request token should always
     *         uniquely identify a single request.</li>
     *         <li>InvalidImportPathException The path provided for data repository import isn't valid.</li>
     *         <li>InvalidExportPathException The path provided for data repository export isn't valid.</li>
     *         <li>InvalidNetworkSettingsException One or more network settings specified in the request are invalid.
     *         <code>InvalidVpcId</code> means that the ID passed for the virtual private cloud (VPC) is invalid.
     *         <code>InvalidSubnetIds</code> returns the list of IDs for subnets that are either invalid or not part of
     *         the VPC specified. <code>InvalidSecurityGroupIds</code> returns the list of IDs for security groups that
     *         are either invalid or not part of the VPC specified.</li>
     *         <li>InvalidPerUnitStorageThroughputException An invalid value for <code>PerUnitStorageThroughput</code>
     *         was provided. Please create your file system again, using a valid value.</li>
     *         <li>ServiceLimitExceededException An error indicating that a particular service limit was exceeded. You
     *         can increase some service limits by contacting AWS Support.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>MissingFileSystemConfigurationException A file system configuration is required for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.CreateFileSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateFileSystem" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFileSystemResponse> createFileSystem(CreateFileSystemRequest createFileSystemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new, empty Amazon FSx file system.
     * </p>
     * <p>
     * If a file system with the specified client request token exists and the parameters match,
     * <code>CreateFileSystem</code> returns the description of the existing file system. If a file system specified
     * client request token exists and the parameters don't match, this call returns
     * <code>IncompatibleParameterError</code>. If a file system with the specified client request token doesn't exist,
     * <code>CreateFileSystem</code> does the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creates a new, empty Amazon FSx file system with an assigned ID, and an initial lifecycle state of
     * <code>CREATING</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Returns the description of the file system.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation requires a client request token in the request that Amazon FSx uses to ensure idempotent creation.
     * This means that calling the operation multiple times with the same client request token has no effect. By using
     * the idempotent operation, you can retry a <code>CreateFileSystem</code> operation without the risk of creating an
     * extra file system. This approach can be useful when an initial call fails in a way that makes it unclear whether
     * a file system was created. Examples are if a transport level timeout occurred, or your connection was reset. If
     * you use the same client request token and the initial call created a file system, the client receives success as
     * long as the parameters are the same.
     * </p>
     * <note>
     * <p>
     * The <code>CreateFileSystem</code> call returns while the file system's lifecycle state is still
     * <code>CREATING</code>. You can check the file-system creation status by calling the <a>DescribeFileSystems</a>
     * operation, which returns the file system state along with other information.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFileSystemRequest.Builder} avoiding the need
     * to create one manually via {@link CreateFileSystemRequest#builder()}
     * </p>
     *
     * @param createFileSystemRequest
     *        A {@link Consumer} that will call methods on {@link CreateFileSystemRequest.Builder} to create a request.
     *        The request object used to create a new Amazon FSx file system.
     * @return A Java Future containing the result of the CreateFileSystem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>ActiveDirectoryErrorException An Active Directory error.</li>
     *         <li>IncompatibleParameterErrorException The error returned when a second request is received with the
     *         same client request token but different parameters settings. A client request token should always
     *         uniquely identify a single request.</li>
     *         <li>InvalidImportPathException The path provided for data repository import isn't valid.</li>
     *         <li>InvalidExportPathException The path provided for data repository export isn't valid.</li>
     *         <li>InvalidNetworkSettingsException One or more network settings specified in the request are invalid.
     *         <code>InvalidVpcId</code> means that the ID passed for the virtual private cloud (VPC) is invalid.
     *         <code>InvalidSubnetIds</code> returns the list of IDs for subnets that are either invalid or not part of
     *         the VPC specified. <code>InvalidSecurityGroupIds</code> returns the list of IDs for security groups that
     *         are either invalid or not part of the VPC specified.</li>
     *         <li>InvalidPerUnitStorageThroughputException An invalid value for <code>PerUnitStorageThroughput</code>
     *         was provided. Please create your file system again, using a valid value.</li>
     *         <li>ServiceLimitExceededException An error indicating that a particular service limit was exceeded. You
     *         can increase some service limits by contacting AWS Support.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>MissingFileSystemConfigurationException A file system configuration is required for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.CreateFileSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateFileSystem" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFileSystemResponse> createFileSystem(
            Consumer<CreateFileSystemRequest.Builder> createFileSystemRequest) {
        return createFileSystem(CreateFileSystemRequest.builder().applyMutation(createFileSystemRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon FSx file system from an existing Amazon FSx backup.
     * </p>
     * <p>
     * If a file system with the specified client request token exists and the parameters match, this operation returns
     * the description of the file system. If a client request token specified by the file system exists and the
     * parameters don't match, this call returns <code>IncompatibleParameterError</code>. If a file system with the
     * specified client request token doesn't exist, this operation does the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creates a new Amazon FSx file system from backup with an assigned ID, and an initial lifecycle state of
     * <code>CREATING</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Returns the description of the file system.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Parameters like Active Directory, default share name, automatic backup, and backup settings default to the
     * parameters of the file system that was backed up, unless overridden. You can explicitly supply other settings.
     * </p>
     * <p>
     * By using the idempotent operation, you can retry a <code>CreateFileSystemFromBackup</code> call without the risk
     * of creating an extra file system. This approach can be useful when an initial call fails in a way that makes it
     * unclear whether a file system was created. Examples are if a transport level timeout occurred, or your connection
     * was reset. If you use the same client request token and the initial call created a file system, the client
     * receives success as long as the parameters are the same.
     * </p>
     * <note>
     * <p>
     * The <code>CreateFileSystemFromBackup</code> call returns while the file system's lifecycle state is still
     * <code>CREATING</code>. You can check the file-system creation status by calling the <a>DescribeFileSystems</a>
     * operation, which returns the file system state along with other information.
     * </p>
     * </note>
     *
     * @param createFileSystemFromBackupRequest
     *        The request object for the <code>CreateFileSystemFromBackup</code> operation.
     * @return A Java Future containing the result of the CreateFileSystemFromBackup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>ActiveDirectoryErrorException An Active Directory error.</li>
     *         <li>IncompatibleParameterErrorException The error returned when a second request is received with the
     *         same client request token but different parameters settings. A client request token should always
     *         uniquely identify a single request.</li>
     *         <li>InvalidNetworkSettingsException One or more network settings specified in the request are invalid.
     *         <code>InvalidVpcId</code> means that the ID passed for the virtual private cloud (VPC) is invalid.
     *         <code>InvalidSubnetIds</code> returns the list of IDs for subnets that are either invalid or not part of
     *         the VPC specified. <code>InvalidSecurityGroupIds</code> returns the list of IDs for security groups that
     *         are either invalid or not part of the VPC specified.</li>
     *         <li>InvalidPerUnitStorageThroughputException An invalid value for <code>PerUnitStorageThroughput</code>
     *         was provided. Please create your file system again, using a valid value.</li>
     *         <li>ServiceLimitExceededException An error indicating that a particular service limit was exceeded. You
     *         can increase some service limits by contacting AWS Support.</li>
     *         <li>BackupNotFoundException No Amazon FSx backups were found based upon the supplied parameters.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>MissingFileSystemConfigurationException A file system configuration is required for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.CreateFileSystemFromBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateFileSystemFromBackup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFileSystemFromBackupResponse> createFileSystemFromBackup(
            CreateFileSystemFromBackupRequest createFileSystemFromBackupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon FSx file system from an existing Amazon FSx backup.
     * </p>
     * <p>
     * If a file system with the specified client request token exists and the parameters match, this operation returns
     * the description of the file system. If a client request token specified by the file system exists and the
     * parameters don't match, this call returns <code>IncompatibleParameterError</code>. If a file system with the
     * specified client request token doesn't exist, this operation does the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creates a new Amazon FSx file system from backup with an assigned ID, and an initial lifecycle state of
     * <code>CREATING</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Returns the description of the file system.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Parameters like Active Directory, default share name, automatic backup, and backup settings default to the
     * parameters of the file system that was backed up, unless overridden. You can explicitly supply other settings.
     * </p>
     * <p>
     * By using the idempotent operation, you can retry a <code>CreateFileSystemFromBackup</code> call without the risk
     * of creating an extra file system. This approach can be useful when an initial call fails in a way that makes it
     * unclear whether a file system was created. Examples are if a transport level timeout occurred, or your connection
     * was reset. If you use the same client request token and the initial call created a file system, the client
     * receives success as long as the parameters are the same.
     * </p>
     * <note>
     * <p>
     * The <code>CreateFileSystemFromBackup</code> call returns while the file system's lifecycle state is still
     * <code>CREATING</code>. You can check the file-system creation status by calling the <a>DescribeFileSystems</a>
     * operation, which returns the file system state along with other information.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFileSystemFromBackupRequest.Builder} avoiding
     * the need to create one manually via {@link CreateFileSystemFromBackupRequest#builder()}
     * </p>
     *
     * @param createFileSystemFromBackupRequest
     *        A {@link Consumer} that will call methods on {@link CreateFileSystemFromBackupRequest.Builder} to create a
     *        request. The request object for the <code>CreateFileSystemFromBackup</code> operation.
     * @return A Java Future containing the result of the CreateFileSystemFromBackup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>ActiveDirectoryErrorException An Active Directory error.</li>
     *         <li>IncompatibleParameterErrorException The error returned when a second request is received with the
     *         same client request token but different parameters settings. A client request token should always
     *         uniquely identify a single request.</li>
     *         <li>InvalidNetworkSettingsException One or more network settings specified in the request are invalid.
     *         <code>InvalidVpcId</code> means that the ID passed for the virtual private cloud (VPC) is invalid.
     *         <code>InvalidSubnetIds</code> returns the list of IDs for subnets that are either invalid or not part of
     *         the VPC specified. <code>InvalidSecurityGroupIds</code> returns the list of IDs for security groups that
     *         are either invalid or not part of the VPC specified.</li>
     *         <li>InvalidPerUnitStorageThroughputException An invalid value for <code>PerUnitStorageThroughput</code>
     *         was provided. Please create your file system again, using a valid value.</li>
     *         <li>ServiceLimitExceededException An error indicating that a particular service limit was exceeded. You
     *         can increase some service limits by contacting AWS Support.</li>
     *         <li>BackupNotFoundException No Amazon FSx backups were found based upon the supplied parameters.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>MissingFileSystemConfigurationException A file system configuration is required for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.CreateFileSystemFromBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateFileSystemFromBackup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFileSystemFromBackupResponse> createFileSystemFromBackup(
            Consumer<CreateFileSystemFromBackupRequest.Builder> createFileSystemFromBackupRequest) {
        return createFileSystemFromBackup(CreateFileSystemFromBackupRequest.builder()
                .applyMutation(createFileSystemFromBackupRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon FSx backup, deleting its contents. After deletion, the backup no longer exists, and its data is
     * gone.
     * </p>
     * <p>
     * The <code>DeleteBackup</code> call returns instantly. The backup will not show up in later
     * <code>DescribeBackups</code> calls.
     * </p>
     * <important>
     * <p>
     * The data in a deleted backup is also deleted and can't be recovered by any means.
     * </p>
     * </important>
     *
     * @param deleteBackupRequest
     *        The request object for <code>DeleteBackup</code> operation.
     * @return A Java Future containing the result of the DeleteBackup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>BackupInProgressException Another backup is already under way. Wait for completion before initiating
     *         additional backups of this file system.</li>
     *         <li>BackupNotFoundException No Amazon FSx backups were found based upon the supplied parameters.</li>
     *         <li>BackupRestoringException You can't delete a backup while it's being used to restore a file system.</li>
     *         <li>IncompatibleParameterErrorException The error returned when a second request is received with the
     *         same client request token but different parameters settings. A client request token should always
     *         uniquely identify a single request.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>BackupBeingCopiedException You can't delete a backup while it's being copied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DeleteBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DeleteBackup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBackupResponse> deleteBackup(DeleteBackupRequest deleteBackupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon FSx backup, deleting its contents. After deletion, the backup no longer exists, and its data is
     * gone.
     * </p>
     * <p>
     * The <code>DeleteBackup</code> call returns instantly. The backup will not show up in later
     * <code>DescribeBackups</code> calls.
     * </p>
     * <important>
     * <p>
     * The data in a deleted backup is also deleted and can't be recovered by any means.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBackupRequest#builder()}
     * </p>
     *
     * @param deleteBackupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBackupRequest.Builder} to create a request. The
     *        request object for <code>DeleteBackup</code> operation.
     * @return A Java Future containing the result of the DeleteBackup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>BackupInProgressException Another backup is already under way. Wait for completion before initiating
     *         additional backups of this file system.</li>
     *         <li>BackupNotFoundException No Amazon FSx backups were found based upon the supplied parameters.</li>
     *         <li>BackupRestoringException You can't delete a backup while it's being used to restore a file system.</li>
     *         <li>IncompatibleParameterErrorException The error returned when a second request is received with the
     *         same client request token but different parameters settings. A client request token should always
     *         uniquely identify a single request.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>BackupBeingCopiedException You can't delete a backup while it's being copied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DeleteBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DeleteBackup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBackupResponse> deleteBackup(Consumer<DeleteBackupRequest.Builder> deleteBackupRequest) {
        return deleteBackup(DeleteBackupRequest.builder().applyMutation(deleteBackupRequest).build());
    }

    /**
     * <p>
     * Deletes a file system, deleting its contents. After deletion, the file system no longer exists, and its data is
     * gone. Any existing automatic backups will also be deleted.
     * </p>
     * <p>
     * By default, when you delete an Amazon FSx for Windows File Server file system, a final backup is created upon
     * deletion. This final backup is not subject to the file system's retention policy, and must be manually deleted.
     * </p>
     * <p>
     * The <code>DeleteFileSystem</code> action returns while the file system has the <code>DELETING</code> status. You
     * can check the file system deletion status by calling the <a>DescribeFileSystems</a> action, which returns a list
     * of file systems in your account. If you pass the file system ID for a deleted file system, the
     * <a>DescribeFileSystems</a> returns a <code>FileSystemNotFound</code> error.
     * </p>
     * <note>
     * <p>
     * Deleting an Amazon FSx for Lustre file system will fail with a 400 BadRequest if a data repository task is in a
     * <code>PENDING</code> or <code>EXECUTING</code> state.
     * </p>
     * </note> <important>
     * <p>
     * The data in a deleted file system is also deleted and can't be recovered by any means.
     * </p>
     * </important>
     *
     * @param deleteFileSystemRequest
     *        The request object for <code>DeleteFileSystem</code> operation.
     * @return A Java Future containing the result of the DeleteFileSystem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>IncompatibleParameterErrorException The error returned when a second request is received with the
     *         same client request token but different parameters settings. A client request token should always
     *         uniquely identify a single request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>ServiceLimitExceededException An error indicating that a particular service limit was exceeded. You
     *         can increase some service limits by contacting AWS Support.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DeleteFileSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DeleteFileSystem" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFileSystemResponse> deleteFileSystem(DeleteFileSystemRequest deleteFileSystemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a file system, deleting its contents. After deletion, the file system no longer exists, and its data is
     * gone. Any existing automatic backups will also be deleted.
     * </p>
     * <p>
     * By default, when you delete an Amazon FSx for Windows File Server file system, a final backup is created upon
     * deletion. This final backup is not subject to the file system's retention policy, and must be manually deleted.
     * </p>
     * <p>
     * The <code>DeleteFileSystem</code> action returns while the file system has the <code>DELETING</code> status. You
     * can check the file system deletion status by calling the <a>DescribeFileSystems</a> action, which returns a list
     * of file systems in your account. If you pass the file system ID for a deleted file system, the
     * <a>DescribeFileSystems</a> returns a <code>FileSystemNotFound</code> error.
     * </p>
     * <note>
     * <p>
     * Deleting an Amazon FSx for Lustre file system will fail with a 400 BadRequest if a data repository task is in a
     * <code>PENDING</code> or <code>EXECUTING</code> state.
     * </p>
     * </note> <important>
     * <p>
     * The data in a deleted file system is also deleted and can't be recovered by any means.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFileSystemRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteFileSystemRequest#builder()}
     * </p>
     *
     * @param deleteFileSystemRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFileSystemRequest.Builder} to create a request.
     *        The request object for <code>DeleteFileSystem</code> operation.
     * @return A Java Future containing the result of the DeleteFileSystem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>IncompatibleParameterErrorException The error returned when a second request is received with the
     *         same client request token but different parameters settings. A client request token should always
     *         uniquely identify a single request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>ServiceLimitExceededException An error indicating that a particular service limit was exceeded. You
     *         can increase some service limits by contacting AWS Support.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DeleteFileSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DeleteFileSystem" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFileSystemResponse> deleteFileSystem(
            Consumer<DeleteFileSystemRequest.Builder> deleteFileSystemRequest) {
        return deleteFileSystem(DeleteFileSystemRequest.builder().applyMutation(deleteFileSystemRequest).build());
    }

    /**
     * <p>
     * Returns the description of specific Amazon FSx backups, if a <code>BackupIds</code> value is provided for that
     * backup. Otherwise, it returns all backups owned by your AWS account in the AWS Region of the endpoint that you're
     * calling.
     * </p>
     * <p>
     * When retrieving all backups, you can optionally specify the <code>MaxResults</code> parameter to limit the number
     * of backups in a response. If more backups remain, Amazon FSx returns a <code>NextToken</code> value in the
     * response. In this case, send a later request with the <code>NextToken</code> request parameter set to the value
     * of <code>NextToken</code> from the last response.
     * </p>
     * <p>
     * This action is used in an iterative process to retrieve a list of your backups. <code>DescribeBackups</code> is
     * called first without a <code>NextToken</code>value. Then the action continues to be called with the
     * <code>NextToken</code> parameter set to the value of the last <code>NextToken</code> value until a response has
     * no <code>NextToken</code>.
     * </p>
     * <p>
     * When using this action, keep the following in mind:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The implementation might return fewer than <code>MaxResults</code> file system descriptions while still including
     * a <code>NextToken</code> value.
     * </p>
     * </li>
     * <li>
     * <p>
     * The order of backups returned in the response of one <code>DescribeBackups</code> call and the order of backups
     * returned across the responses of a multi-call iteration is unspecified.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeBackupsRequest
     *        The request object for <code>DescribeBackups</code> operation.
     * @return A Java Future containing the result of the DescribeBackups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>BackupNotFoundException No Amazon FSx backups were found based upon the supplied parameters.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DescribeBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeBackups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeBackupsResponse> describeBackups(DescribeBackupsRequest describeBackupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description of specific Amazon FSx backups, if a <code>BackupIds</code> value is provided for that
     * backup. Otherwise, it returns all backups owned by your AWS account in the AWS Region of the endpoint that you're
     * calling.
     * </p>
     * <p>
     * When retrieving all backups, you can optionally specify the <code>MaxResults</code> parameter to limit the number
     * of backups in a response. If more backups remain, Amazon FSx returns a <code>NextToken</code> value in the
     * response. In this case, send a later request with the <code>NextToken</code> request parameter set to the value
     * of <code>NextToken</code> from the last response.
     * </p>
     * <p>
     * This action is used in an iterative process to retrieve a list of your backups. <code>DescribeBackups</code> is
     * called first without a <code>NextToken</code>value. Then the action continues to be called with the
     * <code>NextToken</code> parameter set to the value of the last <code>NextToken</code> value until a response has
     * no <code>NextToken</code>.
     * </p>
     * <p>
     * When using this action, keep the following in mind:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The implementation might return fewer than <code>MaxResults</code> file system descriptions while still including
     * a <code>NextToken</code> value.
     * </p>
     * </li>
     * <li>
     * <p>
     * The order of backups returned in the response of one <code>DescribeBackups</code> call and the order of backups
     * returned across the responses of a multi-call iteration is unspecified.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBackupsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeBackupsRequest#builder()}
     * </p>
     *
     * @param describeBackupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBackupsRequest.Builder} to create a request.
     *        The request object for <code>DescribeBackups</code> operation.
     * @return A Java Future containing the result of the DescribeBackups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>BackupNotFoundException No Amazon FSx backups were found based upon the supplied parameters.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DescribeBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeBackups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeBackupsResponse> describeBackups(
            Consumer<DescribeBackupsRequest.Builder> describeBackupsRequest) {
        return describeBackups(DescribeBackupsRequest.builder().applyMutation(describeBackupsRequest).build());
    }

    /**
     * <p>
     * Returns the description of specific Amazon FSx backups, if a <code>BackupIds</code> value is provided for that
     * backup. Otherwise, it returns all backups owned by your AWS account in the AWS Region of the endpoint that you're
     * calling.
     * </p>
     * <p>
     * When retrieving all backups, you can optionally specify the <code>MaxResults</code> parameter to limit the number
     * of backups in a response. If more backups remain, Amazon FSx returns a <code>NextToken</code> value in the
     * response. In this case, send a later request with the <code>NextToken</code> request parameter set to the value
     * of <code>NextToken</code> from the last response.
     * </p>
     * <p>
     * This action is used in an iterative process to retrieve a list of your backups. <code>DescribeBackups</code> is
     * called first without a <code>NextToken</code>value. Then the action continues to be called with the
     * <code>NextToken</code> parameter set to the value of the last <code>NextToken</code> value until a response has
     * no <code>NextToken</code>.
     * </p>
     * <p>
     * When using this action, keep the following in mind:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The implementation might return fewer than <code>MaxResults</code> file system descriptions while still including
     * a <code>NextToken</code> value.
     * </p>
     * </li>
     * <li>
     * <p>
     * The order of backups returned in the response of one <code>DescribeBackups</code> call and the order of backups
     * returned across the responses of a multi-call iteration is unspecified.
     * </p>
     * </li>
     * </ul>
     *
     * @return A Java Future containing the result of the DescribeBackups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>BackupNotFoundException No Amazon FSx backups were found based upon the supplied parameters.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DescribeBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeBackups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeBackupsResponse> describeBackups() {
        return describeBackups(DescribeBackupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the description of specific Amazon FSx backups, if a <code>BackupIds</code> value is provided for that
     * backup. Otherwise, it returns all backups owned by your AWS account in the AWS Region of the endpoint that you're
     * calling.
     * </p>
     * <p>
     * When retrieving all backups, you can optionally specify the <code>MaxResults</code> parameter to limit the number
     * of backups in a response. If more backups remain, Amazon FSx returns a <code>NextToken</code> value in the
     * response. In this case, send a later request with the <code>NextToken</code> request parameter set to the value
     * of <code>NextToken</code> from the last response.
     * </p>
     * <p>
     * This action is used in an iterative process to retrieve a list of your backups. <code>DescribeBackups</code> is
     * called first without a <code>NextToken</code>value. Then the action continues to be called with the
     * <code>NextToken</code> parameter set to the value of the last <code>NextToken</code> value until a response has
     * no <code>NextToken</code>.
     * </p>
     * <p>
     * When using this action, keep the following in mind:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The implementation might return fewer than <code>MaxResults</code> file system descriptions while still including
     * a <code>NextToken</code> value.
     * </p>
     * </li>
     * <li>
     * <p>
     * The order of backups returned in the response of one <code>DescribeBackups</code> call and the order of backups
     * returned across the responses of a multi-call iteration is unspecified.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of {@link #describeBackups(software.amazon.awssdk.services.fsx.model.DescribeBackupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fsx.paginators.DescribeBackupsPublisher publisher = client.describeBackupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fsx.paginators.DescribeBackupsPublisher publisher = client.describeBackupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fsx.model.DescribeBackupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fsx.model.DescribeBackupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeBackups(software.amazon.awssdk.services.fsx.model.DescribeBackupsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>BackupNotFoundException No Amazon FSx backups were found based upon the supplied parameters.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DescribeBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeBackups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeBackupsPublisher describeBackupsPaginator() {
        return describeBackupsPaginator(DescribeBackupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the description of specific Amazon FSx backups, if a <code>BackupIds</code> value is provided for that
     * backup. Otherwise, it returns all backups owned by your AWS account in the AWS Region of the endpoint that you're
     * calling.
     * </p>
     * <p>
     * When retrieving all backups, you can optionally specify the <code>MaxResults</code> parameter to limit the number
     * of backups in a response. If more backups remain, Amazon FSx returns a <code>NextToken</code> value in the
     * response. In this case, send a later request with the <code>NextToken</code> request parameter set to the value
     * of <code>NextToken</code> from the last response.
     * </p>
     * <p>
     * This action is used in an iterative process to retrieve a list of your backups. <code>DescribeBackups</code> is
     * called first without a <code>NextToken</code>value. Then the action continues to be called with the
     * <code>NextToken</code> parameter set to the value of the last <code>NextToken</code> value until a response has
     * no <code>NextToken</code>.
     * </p>
     * <p>
     * When using this action, keep the following in mind:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The implementation might return fewer than <code>MaxResults</code> file system descriptions while still including
     * a <code>NextToken</code> value.
     * </p>
     * </li>
     * <li>
     * <p>
     * The order of backups returned in the response of one <code>DescribeBackups</code> call and the order of backups
     * returned across the responses of a multi-call iteration is unspecified.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of {@link #describeBackups(software.amazon.awssdk.services.fsx.model.DescribeBackupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fsx.paginators.DescribeBackupsPublisher publisher = client.describeBackupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fsx.paginators.DescribeBackupsPublisher publisher = client.describeBackupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fsx.model.DescribeBackupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fsx.model.DescribeBackupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeBackups(software.amazon.awssdk.services.fsx.model.DescribeBackupsRequest)} operation.</b>
     * </p>
     *
     * @param describeBackupsRequest
     *        The request object for <code>DescribeBackups</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>BackupNotFoundException No Amazon FSx backups were found based upon the supplied parameters.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DescribeBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeBackups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeBackupsPublisher describeBackupsPaginator(DescribeBackupsRequest describeBackupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description of specific Amazon FSx backups, if a <code>BackupIds</code> value is provided for that
     * backup. Otherwise, it returns all backups owned by your AWS account in the AWS Region of the endpoint that you're
     * calling.
     * </p>
     * <p>
     * When retrieving all backups, you can optionally specify the <code>MaxResults</code> parameter to limit the number
     * of backups in a response. If more backups remain, Amazon FSx returns a <code>NextToken</code> value in the
     * response. In this case, send a later request with the <code>NextToken</code> request parameter set to the value
     * of <code>NextToken</code> from the last response.
     * </p>
     * <p>
     * This action is used in an iterative process to retrieve a list of your backups. <code>DescribeBackups</code> is
     * called first without a <code>NextToken</code>value. Then the action continues to be called with the
     * <code>NextToken</code> parameter set to the value of the last <code>NextToken</code> value until a response has
     * no <code>NextToken</code>.
     * </p>
     * <p>
     * When using this action, keep the following in mind:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The implementation might return fewer than <code>MaxResults</code> file system descriptions while still including
     * a <code>NextToken</code> value.
     * </p>
     * </li>
     * <li>
     * <p>
     * The order of backups returned in the response of one <code>DescribeBackups</code> call and the order of backups
     * returned across the responses of a multi-call iteration is unspecified.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of {@link #describeBackups(software.amazon.awssdk.services.fsx.model.DescribeBackupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fsx.paginators.DescribeBackupsPublisher publisher = client.describeBackupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fsx.paginators.DescribeBackupsPublisher publisher = client.describeBackupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fsx.model.DescribeBackupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fsx.model.DescribeBackupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeBackups(software.amazon.awssdk.services.fsx.model.DescribeBackupsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBackupsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeBackupsRequest#builder()}
     * </p>
     *
     * @param describeBackupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBackupsRequest.Builder} to create a request.
     *        The request object for <code>DescribeBackups</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>BackupNotFoundException No Amazon FSx backups were found based upon the supplied parameters.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DescribeBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeBackups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeBackupsPublisher describeBackupsPaginator(Consumer<DescribeBackupsRequest.Builder> describeBackupsRequest) {
        return describeBackupsPaginator(DescribeBackupsRequest.builder().applyMutation(describeBackupsRequest).build());
    }

    /**
     * <p>
     * Returns the description of specific Amazon FSx for Lustre data repository tasks, if one or more
     * <code>TaskIds</code> values are provided in the request, or if filters are used in the request. You can use
     * filters to narrow the response to include just tasks for specific file systems, or tasks in a specific lifecycle
     * state. Otherwise, it returns all data repository tasks owned by your AWS account in the AWS Region of the
     * endpoint that you're calling.
     * </p>
     * <p>
     * When retrieving all tasks, you can paginate the response by using the optional <code>MaxResults</code> parameter
     * to limit the number of tasks returned in a response. If more tasks remain, Amazon FSx returns a
     * <code>NextToken</code> value in the response. In this case, send a later request with the <code>NextToken</code>
     * request parameter set to the value of <code>NextToken</code> from the last response.
     * </p>
     *
     * @param describeDataRepositoryTasksRequest
     * @return A Java Future containing the result of the DescribeDataRepositoryTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>DataRepositoryTaskNotFoundException The data repository task or tasks you specified could not be
     *         found.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DescribeDataRepositoryTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeDataRepositoryTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDataRepositoryTasksResponse> describeDataRepositoryTasks(
            DescribeDataRepositoryTasksRequest describeDataRepositoryTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description of specific Amazon FSx for Lustre data repository tasks, if one or more
     * <code>TaskIds</code> values are provided in the request, or if filters are used in the request. You can use
     * filters to narrow the response to include just tasks for specific file systems, or tasks in a specific lifecycle
     * state. Otherwise, it returns all data repository tasks owned by your AWS account in the AWS Region of the
     * endpoint that you're calling.
     * </p>
     * <p>
     * When retrieving all tasks, you can paginate the response by using the optional <code>MaxResults</code> parameter
     * to limit the number of tasks returned in a response. If more tasks remain, Amazon FSx returns a
     * <code>NextToken</code> value in the response. In this case, send a later request with the <code>NextToken</code>
     * request parameter set to the value of <code>NextToken</code> from the last response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataRepositoryTasksRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDataRepositoryTasksRequest#builder()}
     * </p>
     *
     * @param describeDataRepositoryTasksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDataRepositoryTasksRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeDataRepositoryTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>DataRepositoryTaskNotFoundException The data repository task or tasks you specified could not be
     *         found.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DescribeDataRepositoryTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeDataRepositoryTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDataRepositoryTasksResponse> describeDataRepositoryTasks(
            Consumer<DescribeDataRepositoryTasksRequest.Builder> describeDataRepositoryTasksRequest) {
        return describeDataRepositoryTasks(DescribeDataRepositoryTasksRequest.builder()
                .applyMutation(describeDataRepositoryTasksRequest).build());
    }

    /**
     * <p>
     * Returns the description of specific Amazon FSx for Lustre data repository tasks, if one or more
     * <code>TaskIds</code> values are provided in the request, or if filters are used in the request. You can use
     * filters to narrow the response to include just tasks for specific file systems, or tasks in a specific lifecycle
     * state. Otherwise, it returns all data repository tasks owned by your AWS account in the AWS Region of the
     * endpoint that you're calling.
     * </p>
     * <p>
     * When retrieving all tasks, you can paginate the response by using the optional <code>MaxResults</code> parameter
     * to limit the number of tasks returned in a response. If more tasks remain, Amazon FSx returns a
     * <code>NextToken</code> value in the response. In this case, send a later request with the <code>NextToken</code>
     * request parameter set to the value of <code>NextToken</code> from the last response.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDataRepositoryTasks(software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fsx.paginators.DescribeDataRepositoryTasksPublisher publisher = client.describeDataRepositoryTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fsx.paginators.DescribeDataRepositoryTasksPublisher publisher = client.describeDataRepositoryTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDataRepositoryTasks(software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDataRepositoryTasksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>DataRepositoryTaskNotFoundException The data repository task or tasks you specified could not be
     *         found.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DescribeDataRepositoryTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeDataRepositoryTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDataRepositoryTasksPublisher describeDataRepositoryTasksPaginator(
            DescribeDataRepositoryTasksRequest describeDataRepositoryTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description of specific Amazon FSx for Lustre data repository tasks, if one or more
     * <code>TaskIds</code> values are provided in the request, or if filters are used in the request. You can use
     * filters to narrow the response to include just tasks for specific file systems, or tasks in a specific lifecycle
     * state. Otherwise, it returns all data repository tasks owned by your AWS account in the AWS Region of the
     * endpoint that you're calling.
     * </p>
     * <p>
     * When retrieving all tasks, you can paginate the response by using the optional <code>MaxResults</code> parameter
     * to limit the number of tasks returned in a response. If more tasks remain, Amazon FSx returns a
     * <code>NextToken</code> value in the response. In this case, send a later request with the <code>NextToken</code>
     * request parameter set to the value of <code>NextToken</code> from the last response.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDataRepositoryTasks(software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fsx.paginators.DescribeDataRepositoryTasksPublisher publisher = client.describeDataRepositoryTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fsx.paginators.DescribeDataRepositoryTasksPublisher publisher = client.describeDataRepositoryTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDataRepositoryTasks(software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataRepositoryTasksRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDataRepositoryTasksRequest#builder()}
     * </p>
     *
     * @param describeDataRepositoryTasksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDataRepositoryTasksRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>DataRepositoryTaskNotFoundException The data repository task or tasks you specified could not be
     *         found.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DescribeDataRepositoryTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeDataRepositoryTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDataRepositoryTasksPublisher describeDataRepositoryTasksPaginator(
            Consumer<DescribeDataRepositoryTasksRequest.Builder> describeDataRepositoryTasksRequest) {
        return describeDataRepositoryTasksPaginator(DescribeDataRepositoryTasksRequest.builder()
                .applyMutation(describeDataRepositoryTasksRequest).build());
    }

    /**
     * <p>
     * Returns the DNS aliases that are associated with the specified Amazon FSx for Windows File Server file system. A
     * history of all DNS aliases that have been associated with and disassociated from the file system is available in
     * the list of <a>AdministrativeAction</a> provided in the <a>DescribeFileSystems</a> operation response.
     * </p>
     *
     * @param describeFileSystemAliasesRequest
     *        The request object for <code>DescribeFileSystemAliases</code> operation.
     * @return A Java Future containing the result of the DescribeFileSystemAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DescribeFileSystemAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeFileSystemAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeFileSystemAliasesResponse> describeFileSystemAliases(
            DescribeFileSystemAliasesRequest describeFileSystemAliasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the DNS aliases that are associated with the specified Amazon FSx for Windows File Server file system. A
     * history of all DNS aliases that have been associated with and disassociated from the file system is available in
     * the list of <a>AdministrativeAction</a> provided in the <a>DescribeFileSystems</a> operation response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFileSystemAliasesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeFileSystemAliasesRequest#builder()}
     * </p>
     *
     * @param describeFileSystemAliasesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFileSystemAliasesRequest.Builder} to create a
     *        request. The request object for <code>DescribeFileSystemAliases</code> operation.
     * @return A Java Future containing the result of the DescribeFileSystemAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DescribeFileSystemAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeFileSystemAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeFileSystemAliasesResponse> describeFileSystemAliases(
            Consumer<DescribeFileSystemAliasesRequest.Builder> describeFileSystemAliasesRequest) {
        return describeFileSystemAliases(DescribeFileSystemAliasesRequest.builder()
                .applyMutation(describeFileSystemAliasesRequest).build());
    }

    /**
     * <p>
     * Returns the DNS aliases that are associated with the specified Amazon FSx for Windows File Server file system. A
     * history of all DNS aliases that have been associated with and disassociated from the file system is available in
     * the list of <a>AdministrativeAction</a> provided in the <a>DescribeFileSystems</a> operation response.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFileSystemAliases(software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fsx.paginators.DescribeFileSystemAliasesPublisher publisher = client.describeFileSystemAliasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fsx.paginators.DescribeFileSystemAliasesPublisher publisher = client.describeFileSystemAliasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFileSystemAliases(software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFileSystemAliasesRequest
     *        The request object for <code>DescribeFileSystemAliases</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DescribeFileSystemAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeFileSystemAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeFileSystemAliasesPublisher describeFileSystemAliasesPaginator(
            DescribeFileSystemAliasesRequest describeFileSystemAliasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the DNS aliases that are associated with the specified Amazon FSx for Windows File Server file system. A
     * history of all DNS aliases that have been associated with and disassociated from the file system is available in
     * the list of <a>AdministrativeAction</a> provided in the <a>DescribeFileSystems</a> operation response.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFileSystemAliases(software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fsx.paginators.DescribeFileSystemAliasesPublisher publisher = client.describeFileSystemAliasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fsx.paginators.DescribeFileSystemAliasesPublisher publisher = client.describeFileSystemAliasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFileSystemAliases(software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFileSystemAliasesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeFileSystemAliasesRequest#builder()}
     * </p>
     *
     * @param describeFileSystemAliasesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFileSystemAliasesRequest.Builder} to create a
     *        request. The request object for <code>DescribeFileSystemAliases</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DescribeFileSystemAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeFileSystemAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeFileSystemAliasesPublisher describeFileSystemAliasesPaginator(
            Consumer<DescribeFileSystemAliasesRequest.Builder> describeFileSystemAliasesRequest) {
        return describeFileSystemAliasesPaginator(DescribeFileSystemAliasesRequest.builder()
                .applyMutation(describeFileSystemAliasesRequest).build());
    }

    /**
     * <p>
     * Returns the description of specific Amazon FSx file systems, if a <code>FileSystemIds</code> value is provided
     * for that file system. Otherwise, it returns descriptions of all file systems owned by your AWS account in the AWS
     * Region of the endpoint that you're calling.
     * </p>
     * <p>
     * When retrieving all file system descriptions, you can optionally specify the <code>MaxResults</code> parameter to
     * limit the number of descriptions in a response. If more file system descriptions remain, Amazon FSx returns a
     * <code>NextToken</code> value in the response. In this case, send a later request with the <code>NextToken</code>
     * request parameter set to the value of <code>NextToken</code> from the last response.
     * </p>
     * <p>
     * This action is used in an iterative process to retrieve a list of your file system descriptions.
     * <code>DescribeFileSystems</code> is called first without a <code>NextToken</code>value. Then the action continues
     * to be called with the <code>NextToken</code> parameter set to the value of the last <code>NextToken</code> value
     * until a response has no <code>NextToken</code>.
     * </p>
     * <p>
     * When using this action, keep the following in mind:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The implementation might return fewer than <code>MaxResults</code> file system descriptions while still including
     * a <code>NextToken</code> value.
     * </p>
     * </li>
     * <li>
     * <p>
     * The order of file systems returned in the response of one <code>DescribeFileSystems</code> call and the order of
     * file systems returned across the responses of a multicall iteration is unspecified.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeFileSystemsRequest
     *        The request object for <code>DescribeFileSystems</code> operation.
     * @return A Java Future containing the result of the DescribeFileSystems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DescribeFileSystems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeFileSystems" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeFileSystemsResponse> describeFileSystems(
            DescribeFileSystemsRequest describeFileSystemsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description of specific Amazon FSx file systems, if a <code>FileSystemIds</code> value is provided
     * for that file system. Otherwise, it returns descriptions of all file systems owned by your AWS account in the AWS
     * Region of the endpoint that you're calling.
     * </p>
     * <p>
     * When retrieving all file system descriptions, you can optionally specify the <code>MaxResults</code> parameter to
     * limit the number of descriptions in a response. If more file system descriptions remain, Amazon FSx returns a
     * <code>NextToken</code> value in the response. In this case, send a later request with the <code>NextToken</code>
     * request parameter set to the value of <code>NextToken</code> from the last response.
     * </p>
     * <p>
     * This action is used in an iterative process to retrieve a list of your file system descriptions.
     * <code>DescribeFileSystems</code> is called first without a <code>NextToken</code>value. Then the action continues
     * to be called with the <code>NextToken</code> parameter set to the value of the last <code>NextToken</code> value
     * until a response has no <code>NextToken</code>.
     * </p>
     * <p>
     * When using this action, keep the following in mind:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The implementation might return fewer than <code>MaxResults</code> file system descriptions while still including
     * a <code>NextToken</code> value.
     * </p>
     * </li>
     * <li>
     * <p>
     * The order of file systems returned in the response of one <code>DescribeFileSystems</code> call and the order of
     * file systems returned across the responses of a multicall iteration is unspecified.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFileSystemsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFileSystemsRequest#builder()}
     * </p>
     *
     * @param describeFileSystemsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFileSystemsRequest.Builder} to create a
     *        request. The request object for <code>DescribeFileSystems</code> operation.
     * @return A Java Future containing the result of the DescribeFileSystems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DescribeFileSystems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeFileSystems" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeFileSystemsResponse> describeFileSystems(
            Consumer<DescribeFileSystemsRequest.Builder> describeFileSystemsRequest) {
        return describeFileSystems(DescribeFileSystemsRequest.builder().applyMutation(describeFileSystemsRequest).build());
    }

    /**
     * <p>
     * Returns the description of specific Amazon FSx file systems, if a <code>FileSystemIds</code> value is provided
     * for that file system. Otherwise, it returns descriptions of all file systems owned by your AWS account in the AWS
     * Region of the endpoint that you're calling.
     * </p>
     * <p>
     * When retrieving all file system descriptions, you can optionally specify the <code>MaxResults</code> parameter to
     * limit the number of descriptions in a response. If more file system descriptions remain, Amazon FSx returns a
     * <code>NextToken</code> value in the response. In this case, send a later request with the <code>NextToken</code>
     * request parameter set to the value of <code>NextToken</code> from the last response.
     * </p>
     * <p>
     * This action is used in an iterative process to retrieve a list of your file system descriptions.
     * <code>DescribeFileSystems</code> is called first without a <code>NextToken</code>value. Then the action continues
     * to be called with the <code>NextToken</code> parameter set to the value of the last <code>NextToken</code> value
     * until a response has no <code>NextToken</code>.
     * </p>
     * <p>
     * When using this action, keep the following in mind:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The implementation might return fewer than <code>MaxResults</code> file system descriptions while still including
     * a <code>NextToken</code> value.
     * </p>
     * </li>
     * <li>
     * <p>
     * The order of file systems returned in the response of one <code>DescribeFileSystems</code> call and the order of
     * file systems returned across the responses of a multicall iteration is unspecified.
     * </p>
     * </li>
     * </ul>
     *
     * @return A Java Future containing the result of the DescribeFileSystems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DescribeFileSystems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeFileSystems" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeFileSystemsResponse> describeFileSystems() {
        return describeFileSystems(DescribeFileSystemsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the description of specific Amazon FSx file systems, if a <code>FileSystemIds</code> value is provided
     * for that file system. Otherwise, it returns descriptions of all file systems owned by your AWS account in the AWS
     * Region of the endpoint that you're calling.
     * </p>
     * <p>
     * When retrieving all file system descriptions, you can optionally specify the <code>MaxResults</code> parameter to
     * limit the number of descriptions in a response. If more file system descriptions remain, Amazon FSx returns a
     * <code>NextToken</code> value in the response. In this case, send a later request with the <code>NextToken</code>
     * request parameter set to the value of <code>NextToken</code> from the last response.
     * </p>
     * <p>
     * This action is used in an iterative process to retrieve a list of your file system descriptions.
     * <code>DescribeFileSystems</code> is called first without a <code>NextToken</code>value. Then the action continues
     * to be called with the <code>NextToken</code> parameter set to the value of the last <code>NextToken</code> value
     * until a response has no <code>NextToken</code>.
     * </p>
     * <p>
     * When using this action, keep the following in mind:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The implementation might return fewer than <code>MaxResults</code> file system descriptions while still including
     * a <code>NextToken</code> value.
     * </p>
     * </li>
     * <li>
     * <p>
     * The order of file systems returned in the response of one <code>DescribeFileSystems</code> call and the order of
     * file systems returned across the responses of a multicall iteration is unspecified.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFileSystems(software.amazon.awssdk.services.fsx.model.DescribeFileSystemsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fsx.paginators.DescribeFileSystemsPublisher publisher = client.describeFileSystemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fsx.paginators.DescribeFileSystemsPublisher publisher = client.describeFileSystemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fsx.model.DescribeFileSystemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fsx.model.DescribeFileSystemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFileSystems(software.amazon.awssdk.services.fsx.model.DescribeFileSystemsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DescribeFileSystems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeFileSystems" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeFileSystemsPublisher describeFileSystemsPaginator() {
        return describeFileSystemsPaginator(DescribeFileSystemsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the description of specific Amazon FSx file systems, if a <code>FileSystemIds</code> value is provided
     * for that file system. Otherwise, it returns descriptions of all file systems owned by your AWS account in the AWS
     * Region of the endpoint that you're calling.
     * </p>
     * <p>
     * When retrieving all file system descriptions, you can optionally specify the <code>MaxResults</code> parameter to
     * limit the number of descriptions in a response. If more file system descriptions remain, Amazon FSx returns a
     * <code>NextToken</code> value in the response. In this case, send a later request with the <code>NextToken</code>
     * request parameter set to the value of <code>NextToken</code> from the last response.
     * </p>
     * <p>
     * This action is used in an iterative process to retrieve a list of your file system descriptions.
     * <code>DescribeFileSystems</code> is called first without a <code>NextToken</code>value. Then the action continues
     * to be called with the <code>NextToken</code> parameter set to the value of the last <code>NextToken</code> value
     * until a response has no <code>NextToken</code>.
     * </p>
     * <p>
     * When using this action, keep the following in mind:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The implementation might return fewer than <code>MaxResults</code> file system descriptions while still including
     * a <code>NextToken</code> value.
     * </p>
     * </li>
     * <li>
     * <p>
     * The order of file systems returned in the response of one <code>DescribeFileSystems</code> call and the order of
     * file systems returned across the responses of a multicall iteration is unspecified.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFileSystems(software.amazon.awssdk.services.fsx.model.DescribeFileSystemsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fsx.paginators.DescribeFileSystemsPublisher publisher = client.describeFileSystemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fsx.paginators.DescribeFileSystemsPublisher publisher = client.describeFileSystemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fsx.model.DescribeFileSystemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fsx.model.DescribeFileSystemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFileSystems(software.amazon.awssdk.services.fsx.model.DescribeFileSystemsRequest)} operation.</b>
     * </p>
     *
     * @param describeFileSystemsRequest
     *        The request object for <code>DescribeFileSystems</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DescribeFileSystems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeFileSystems" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeFileSystemsPublisher describeFileSystemsPaginator(DescribeFileSystemsRequest describeFileSystemsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description of specific Amazon FSx file systems, if a <code>FileSystemIds</code> value is provided
     * for that file system. Otherwise, it returns descriptions of all file systems owned by your AWS account in the AWS
     * Region of the endpoint that you're calling.
     * </p>
     * <p>
     * When retrieving all file system descriptions, you can optionally specify the <code>MaxResults</code> parameter to
     * limit the number of descriptions in a response. If more file system descriptions remain, Amazon FSx returns a
     * <code>NextToken</code> value in the response. In this case, send a later request with the <code>NextToken</code>
     * request parameter set to the value of <code>NextToken</code> from the last response.
     * </p>
     * <p>
     * This action is used in an iterative process to retrieve a list of your file system descriptions.
     * <code>DescribeFileSystems</code> is called first without a <code>NextToken</code>value. Then the action continues
     * to be called with the <code>NextToken</code> parameter set to the value of the last <code>NextToken</code> value
     * until a response has no <code>NextToken</code>.
     * </p>
     * <p>
     * When using this action, keep the following in mind:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The implementation might return fewer than <code>MaxResults</code> file system descriptions while still including
     * a <code>NextToken</code> value.
     * </p>
     * </li>
     * <li>
     * <p>
     * The order of file systems returned in the response of one <code>DescribeFileSystems</code> call and the order of
     * file systems returned across the responses of a multicall iteration is unspecified.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFileSystems(software.amazon.awssdk.services.fsx.model.DescribeFileSystemsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fsx.paginators.DescribeFileSystemsPublisher publisher = client.describeFileSystemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fsx.paginators.DescribeFileSystemsPublisher publisher = client.describeFileSystemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fsx.model.DescribeFileSystemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fsx.model.DescribeFileSystemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFileSystems(software.amazon.awssdk.services.fsx.model.DescribeFileSystemsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFileSystemsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFileSystemsRequest#builder()}
     * </p>
     *
     * @param describeFileSystemsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFileSystemsRequest.Builder} to create a
     *        request. The request object for <code>DescribeFileSystems</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DescribeFileSystems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeFileSystems" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeFileSystemsPublisher describeFileSystemsPaginator(
            Consumer<DescribeFileSystemsRequest.Builder> describeFileSystemsRequest) {
        return describeFileSystemsPaginator(DescribeFileSystemsRequest.builder().applyMutation(describeFileSystemsRequest)
                .build());
    }

    /**
     * <p>
     * Use this action to disassociate, or remove, one or more Domain Name Service (DNS) aliases from an Amazon FSx for
     * Windows File Server file system. If you attempt to disassociate a DNS alias that is not associated with the file
     * system, Amazon FSx responds with a 400 Bad Request. For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html">Working with DNS
     * Aliases</a>.
     * </p>
     * <p>
     * The system generated response showing the DNS aliases that Amazon FSx is attempting to disassociate from the file
     * system. Use the API operation to monitor the status of the aliases Amazon FSx is disassociating with the file
     * system.
     * </p>
     *
     * @param disassociateFileSystemAliasesRequest
     *        The request object of DNS aliases to disassociate from an Amazon FSx for Windows File Server file system.
     * @return A Java Future containing the result of the DisassociateFileSystemAliases operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DisassociateFileSystemAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DisassociateFileSystemAliases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateFileSystemAliasesResponse> disassociateFileSystemAliases(
            DisassociateFileSystemAliasesRequest disassociateFileSystemAliasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this action to disassociate, or remove, one or more Domain Name Service (DNS) aliases from an Amazon FSx for
     * Windows File Server file system. If you attempt to disassociate a DNS alias that is not associated with the file
     * system, Amazon FSx responds with a 400 Bad Request. For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html">Working with DNS
     * Aliases</a>.
     * </p>
     * <p>
     * The system generated response showing the DNS aliases that Amazon FSx is attempting to disassociate from the file
     * system. Use the API operation to monitor the status of the aliases Amazon FSx is disassociating with the file
     * system.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateFileSystemAliasesRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateFileSystemAliasesRequest#builder()}
     * </p>
     *
     * @param disassociateFileSystemAliasesRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateFileSystemAliasesRequest.Builder} to
     *        create a request. The request object of DNS aliases to disassociate from an Amazon FSx for Windows File
     *        Server file system.
     * @return A Java Future containing the result of the DisassociateFileSystemAliases operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.DisassociateFileSystemAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DisassociateFileSystemAliases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateFileSystemAliasesResponse> disassociateFileSystemAliases(
            Consumer<DisassociateFileSystemAliasesRequest.Builder> disassociateFileSystemAliasesRequest) {
        return disassociateFileSystemAliases(DisassociateFileSystemAliasesRequest.builder()
                .applyMutation(disassociateFileSystemAliasesRequest).build());
    }

    /**
     * <p>
     * Lists tags for an Amazon FSx file systems and backups in the case of Amazon FSx for Windows File Server.
     * </p>
     * <p>
     * When retrieving all tags, you can optionally specify the <code>MaxResults</code> parameter to limit the number of
     * tags in a response. If more tags remain, Amazon FSx returns a <code>NextToken</code> value in the response. In
     * this case, send a later request with the <code>NextToken</code> request parameter set to the value of
     * <code>NextToken</code> from the last response.
     * </p>
     * <p>
     * This action is used in an iterative process to retrieve a list of your tags. <code>ListTagsForResource</code> is
     * called first without a <code>NextToken</code>value. Then the action continues to be called with the
     * <code>NextToken</code> parameter set to the value of the last <code>NextToken</code> value until a response has
     * no <code>NextToken</code>.
     * </p>
     * <p>
     * When using this action, keep the following in mind:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The implementation might return fewer than <code>MaxResults</code> file system descriptions while still including
     * a <code>NextToken</code> value.
     * </p>
     * </li>
     * <li>
     * <p>
     * The order of tags returned in the response of one <code>ListTagsForResource</code> call and the order of tags
     * returned across the responses of a multi-call iteration is unspecified.
     * </p>
     * </li>
     * </ul>
     *
     * @param listTagsForResourceRequest
     *        The request object for <code>ListTagsForResource</code> operation.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>ResourceNotFoundException The resource specified by the Amazon Resource Name (ARN) can't be found.</li>
     *         <li>NotServiceResourceErrorException The resource specified for the tagging operation is not a resource
     *         type owned by Amazon FSx. Use the API of the relevant service to perform the operation.</li>
     *         <li>ResourceDoesNotSupportTaggingException The resource specified does not support tagging.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tags for an Amazon FSx file systems and backups in the case of Amazon FSx for Windows File Server.
     * </p>
     * <p>
     * When retrieving all tags, you can optionally specify the <code>MaxResults</code> parameter to limit the number of
     * tags in a response. If more tags remain, Amazon FSx returns a <code>NextToken</code> value in the response. In
     * this case, send a later request with the <code>NextToken</code> request parameter set to the value of
     * <code>NextToken</code> from the last response.
     * </p>
     * <p>
     * This action is used in an iterative process to retrieve a list of your tags. <code>ListTagsForResource</code> is
     * called first without a <code>NextToken</code>value. Then the action continues to be called with the
     * <code>NextToken</code> parameter set to the value of the last <code>NextToken</code> value until a response has
     * no <code>NextToken</code>.
     * </p>
     * <p>
     * When using this action, keep the following in mind:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The implementation might return fewer than <code>MaxResults</code> file system descriptions while still including
     * a <code>NextToken</code> value.
     * </p>
     * </li>
     * <li>
     * <p>
     * The order of tags returned in the response of one <code>ListTagsForResource</code> call and the order of tags
     * returned across the responses of a multi-call iteration is unspecified.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request. The request object for <code>ListTagsForResource</code> operation.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>ResourceNotFoundException The resource specified by the Amazon Resource Name (ARN) can't be found.</li>
     *         <li>NotServiceResourceErrorException The resource specified for the tagging operation is not a resource
     *         type owned by Amazon FSx. Use the API of the relevant service to perform the operation.</li>
     *         <li>ResourceDoesNotSupportTaggingException The resource specified does not support tagging.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Tags an Amazon FSx resource.
     * </p>
     *
     * @param tagResourceRequest
     *        The request object for the <code>TagResource</code> operation.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>ResourceNotFoundException The resource specified by the Amazon Resource Name (ARN) can't be found.</li>
     *         <li>NotServiceResourceErrorException The resource specified for the tagging operation is not a resource
     *         type owned by Amazon FSx. Use the API of the relevant service to perform the operation.</li>
     *         <li>ResourceDoesNotSupportTaggingException The resource specified does not support tagging.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags an Amazon FSx resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request. The
     *        request object for the <code>TagResource</code> operation.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>ResourceNotFoundException The resource specified by the Amazon Resource Name (ARN) can't be found.</li>
     *         <li>NotServiceResourceErrorException The resource specified for the tagging operation is not a resource
     *         type owned by Amazon FSx. Use the API of the relevant service to perform the operation.</li>
     *         <li>ResourceDoesNotSupportTaggingException The resource specified does not support tagging.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * This action removes a tag from an Amazon FSx resource.
     * </p>
     *
     * @param untagResourceRequest
     *        The request object for <code>UntagResource</code> action.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>ResourceNotFoundException The resource specified by the Amazon Resource Name (ARN) can't be found.</li>
     *         <li>NotServiceResourceErrorException The resource specified for the tagging operation is not a resource
     *         type owned by Amazon FSx. Use the API of the relevant service to perform the operation.</li>
     *         <li>ResourceDoesNotSupportTaggingException The resource specified does not support tagging.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action removes a tag from an Amazon FSx resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request. The
     *        request object for <code>UntagResource</code> action.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>ResourceNotFoundException The resource specified by the Amazon Resource Name (ARN) can't be found.</li>
     *         <li>NotServiceResourceErrorException The resource specified for the tagging operation is not a resource
     *         type owned by Amazon FSx. Use the API of the relevant service to perform the operation.</li>
     *         <li>ResourceDoesNotSupportTaggingException The resource specified does not support tagging.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Use this operation to update the configuration of an existing Amazon FSx file system. You can update multiple
     * properties in a single request.
     * </p>
     * <p>
     * For Amazon FSx for Windows File Server file systems, you can update the following properties:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AutomaticBackupRetentionDays
     * </p>
     * </li>
     * <li>
     * <p>
     * DailyAutomaticBackupStartTime
     * </p>
     * </li>
     * <li>
     * <p>
     * SelfManagedActiveDirectoryConfiguration
     * </p>
     * </li>
     * <li>
     * <p>
     * StorageCapacity
     * </p>
     * </li>
     * <li>
     * <p>
     * ThroughputCapacity
     * </p>
     * </li>
     * <li>
     * <p>
     * WeeklyMaintenanceStartTime
     * </p>
     * </li>
     * </ul>
     * <p>
     * For Amazon FSx for Lustre file systems, you can update the following properties:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AutoImportPolicy
     * </p>
     * </li>
     * <li>
     * <p>
     * AutomaticBackupRetentionDays
     * </p>
     * </li>
     * <li>
     * <p>
     * DailyAutomaticBackupStartTime
     * </p>
     * </li>
     * <li>
     * <p>
     * StorageCapacity
     * </p>
     * </li>
     * <li>
     * <p>
     * WeeklyMaintenanceStartTime
     * </p>
     * </li>
     * </ul>
     *
     * @param updateFileSystemRequest
     *        The request object for the <code>UpdateFileSystem</code> operation.
     * @return A Java Future containing the result of the UpdateFileSystem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>UnsupportedOperationException The requested operation is not supported for this resource or API.</li>
     *         <li>IncompatibleParameterErrorException The error returned when a second request is received with the
     *         same client request token but different parameters settings. A client request token should always
     *         uniquely identify a single request.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>MissingFileSystemConfigurationException A file system configuration is required for this operation.</li>
     *         <li>ServiceLimitExceededException An error indicating that a particular service limit was exceeded. You
     *         can increase some service limits by contacting AWS Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.UpdateFileSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/UpdateFileSystem" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFileSystemResponse> updateFileSystem(UpdateFileSystemRequest updateFileSystemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to update the configuration of an existing Amazon FSx file system. You can update multiple
     * properties in a single request.
     * </p>
     * <p>
     * For Amazon FSx for Windows File Server file systems, you can update the following properties:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AutomaticBackupRetentionDays
     * </p>
     * </li>
     * <li>
     * <p>
     * DailyAutomaticBackupStartTime
     * </p>
     * </li>
     * <li>
     * <p>
     * SelfManagedActiveDirectoryConfiguration
     * </p>
     * </li>
     * <li>
     * <p>
     * StorageCapacity
     * </p>
     * </li>
     * <li>
     * <p>
     * ThroughputCapacity
     * </p>
     * </li>
     * <li>
     * <p>
     * WeeklyMaintenanceStartTime
     * </p>
     * </li>
     * </ul>
     * <p>
     * For Amazon FSx for Lustre file systems, you can update the following properties:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AutoImportPolicy
     * </p>
     * </li>
     * <li>
     * <p>
     * AutomaticBackupRetentionDays
     * </p>
     * </li>
     * <li>
     * <p>
     * DailyAutomaticBackupStartTime
     * </p>
     * </li>
     * <li>
     * <p>
     * StorageCapacity
     * </p>
     * </li>
     * <li>
     * <p>
     * WeeklyMaintenanceStartTime
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFileSystemRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateFileSystemRequest#builder()}
     * </p>
     *
     * @param updateFileSystemRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFileSystemRequest.Builder} to create a request.
     *        The request object for the <code>UpdateFileSystem</code> operation.
     * @return A Java Future containing the result of the UpdateFileSystem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A generic error indicating a failure with a client request.</li>
     *         <li>UnsupportedOperationException The requested operation is not supported for this resource or API.</li>
     *         <li>IncompatibleParameterErrorException The error returned when a second request is received with the
     *         same client request token but different parameters settings. A client request token should always
     *         uniquely identify a single request.</li>
     *         <li>InternalServerErrorException A generic error indicating a server-side failure.</li>
     *         <li>FileSystemNotFoundException No Amazon FSx file systems were found based upon supplied parameters.</li>
     *         <li>MissingFileSystemConfigurationException A file system configuration is required for this operation.</li>
     *         <li>ServiceLimitExceededException An error indicating that a particular service limit was exceeded. You
     *         can increase some service limits by contacting AWS Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FSxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FSxAsyncClient.UpdateFileSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/UpdateFileSystem" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFileSystemResponse> updateFileSystem(
            Consumer<UpdateFileSystemRequest.Builder> updateFileSystemRequest) {
        return updateFileSystem(UpdateFileSystemRequest.builder().applyMutation(updateFileSystemRequest).build());
    }
}
