/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A DNS alias that is associated with the file system. You can use a DNS alias to access a file system using
 * user-defined DNS names, in addition to the default DNS name that Amazon FSx assigns to the file system. For more
 * information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html">DNS
 * aliases</a> in the <i>FSx for Windows File Server User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Alias implements SdkPojo, Serializable, ToCopyableBuilder<Alias.Builder, Alias> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Alias::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Lifecycle").getter(getter(Alias::lifecycleAsString)).setter(setter(Builder::lifecycle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, LIFECYCLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String lifecycle;

    private Alias(BuilderImpl builder) {
        this.name = builder.name;
        this.lifecycle = builder.lifecycle;
    }

    /**
     * <p>
     * The name of the DNS alias. The alias name has to meet the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Formatted as a fully-qualified domain name (FQDN), <code>hostname.domain</code>, for example,
     * <code>accounting.example.com</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can contain alphanumeric characters, the underscore (_), and the hyphen (-).
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot start or end with a hyphen.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can start with a numeric.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For DNS names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify
     * them: as uppercase letters, lowercase letters, or the corresponding letters in escape codes.
     * </p>
     * 
     * @return The name of the DNS alias. The alias name has to meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Formatted as a fully-qualified domain name (FQDN), <code>hostname.domain</code>, for example,
     *         <code>accounting.example.com</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can contain alphanumeric characters, the underscore (_), and the hyphen (-).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot start or end with a hyphen.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can start with a numeric.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For DNS names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you
     *         specify them: as uppercase letters, lowercase letters, or the corresponding letters in escape codes.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Describes the state of the DNS alias.
     * </p>
     * <ul>
     * <li>
     * <p>
     * AVAILABLE - The DNS alias is associated with an Amazon FSx file system.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATING - Amazon FSx is creating the DNS alias and associating it with the file system.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE_FAILED - Amazon FSx was unable to associate the DNS alias with the file system.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING - Amazon FSx is disassociating the DNS alias from the file system and deleting it.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE_FAILED - Amazon FSx was unable to disassocate the DNS alias from the file system.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link AliasLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lifecycleAsString}.
     * </p>
     * 
     * @return Describes the state of the DNS alias.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         AVAILABLE - The DNS alias is associated with an Amazon FSx file system.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATING - Amazon FSx is creating the DNS alias and associating it with the file system.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_FAILED - Amazon FSx was unable to associate the DNS alias with the file system.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING - Amazon FSx is disassociating the DNS alias from the file system and deleting it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE_FAILED - Amazon FSx was unable to disassocate the DNS alias from the file system.
     *         </p>
     *         </li>
     * @see AliasLifecycle
     */
    public final AliasLifecycle lifecycle() {
        return AliasLifecycle.fromValue(lifecycle);
    }

    /**
     * <p>
     * Describes the state of the DNS alias.
     * </p>
     * <ul>
     * <li>
     * <p>
     * AVAILABLE - The DNS alias is associated with an Amazon FSx file system.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATING - Amazon FSx is creating the DNS alias and associating it with the file system.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE_FAILED - Amazon FSx was unable to associate the DNS alias with the file system.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING - Amazon FSx is disassociating the DNS alias from the file system and deleting it.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE_FAILED - Amazon FSx was unable to disassocate the DNS alias from the file system.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link AliasLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lifecycleAsString}.
     * </p>
     * 
     * @return Describes the state of the DNS alias.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         AVAILABLE - The DNS alias is associated with an Amazon FSx file system.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATING - Amazon FSx is creating the DNS alias and associating it with the file system.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_FAILED - Amazon FSx was unable to associate the DNS alias with the file system.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING - Amazon FSx is disassociating the DNS alias from the file system and deleting it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE_FAILED - Amazon FSx was unable to disassocate the DNS alias from the file system.
     *         </p>
     *         </li>
     * @see AliasLifecycle
     */
    public final String lifecycleAsString() {
        return lifecycle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Alias)) {
            return false;
        }
        Alias other = (Alias) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(lifecycleAsString(), other.lifecycleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Alias").add("Name", name()).add("Lifecycle", lifecycleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Alias, T> g) {
        return obj -> g.apply((Alias) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Alias> {
        /**
         * <p>
         * The name of the DNS alias. The alias name has to meet the following requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Formatted as a fully-qualified domain name (FQDN), <code>hostname.domain</code>, for example,
         * <code>accounting.example.com</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can contain alphanumeric characters, the underscore (_), and the hyphen (-).
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot start or end with a hyphen.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can start with a numeric.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For DNS names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you
         * specify them: as uppercase letters, lowercase letters, or the corresponding letters in escape codes.
         * </p>
         * 
         * @param name
         *        The name of the DNS alias. The alias name has to meet the following requirements:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Formatted as a fully-qualified domain name (FQDN), <code>hostname.domain</code>, for example,
         *        <code>accounting.example.com</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can contain alphanumeric characters, the underscore (_), and the hyphen (-).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot start or end with a hyphen.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can start with a numeric.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For DNS names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how
         *        you specify them: as uppercase letters, lowercase letters, or the corresponding letters in escape
         *        codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Describes the state of the DNS alias.
         * </p>
         * <ul>
         * <li>
         * <p>
         * AVAILABLE - The DNS alias is associated with an Amazon FSx file system.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATING - Amazon FSx is creating the DNS alias and associating it with the file system.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE_FAILED - Amazon FSx was unable to associate the DNS alias with the file system.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING - Amazon FSx is disassociating the DNS alias from the file system and deleting it.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE_FAILED - Amazon FSx was unable to disassocate the DNS alias from the file system.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lifecycle
         *        Describes the state of the DNS alias.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        AVAILABLE - The DNS alias is associated with an Amazon FSx file system.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATING - Amazon FSx is creating the DNS alias and associating it with the file system.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE_FAILED - Amazon FSx was unable to associate the DNS alias with the file system.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING - Amazon FSx is disassociating the DNS alias from the file system and deleting it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE_FAILED - Amazon FSx was unable to disassocate the DNS alias from the file system.
         *        </p>
         *        </li>
         * @see AliasLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AliasLifecycle
         */
        Builder lifecycle(String lifecycle);

        /**
         * <p>
         * Describes the state of the DNS alias.
         * </p>
         * <ul>
         * <li>
         * <p>
         * AVAILABLE - The DNS alias is associated with an Amazon FSx file system.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATING - Amazon FSx is creating the DNS alias and associating it with the file system.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE_FAILED - Amazon FSx was unable to associate the DNS alias with the file system.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING - Amazon FSx is disassociating the DNS alias from the file system and deleting it.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE_FAILED - Amazon FSx was unable to disassocate the DNS alias from the file system.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lifecycle
         *        Describes the state of the DNS alias.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        AVAILABLE - The DNS alias is associated with an Amazon FSx file system.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATING - Amazon FSx is creating the DNS alias and associating it with the file system.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE_FAILED - Amazon FSx was unable to associate the DNS alias with the file system.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING - Amazon FSx is disassociating the DNS alias from the file system and deleting it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE_FAILED - Amazon FSx was unable to disassocate the DNS alias from the file system.
         *        </p>
         *        </li>
         * @see AliasLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AliasLifecycle
         */
        Builder lifecycle(AliasLifecycle lifecycle);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String lifecycle;

        private BuilderImpl() {
        }

        private BuilderImpl(Alias model) {
            name(model.name);
            lifecycle(model.lifecycle);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getLifecycle() {
            return lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(AliasLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public Alias build() {
            return new Alias(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
