/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * <p>
 * The lifecycle status of the backup.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>AVAILABLE</code> - The backup is fully available.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>PENDING</code> - For user-initiated backups on Lustre file systems only; Amazon FSx has not started creating
 * the backup.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>CREATING</code> - Amazon FSx is creating the new user-intiated backup
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>TRANSFERRING</code> - For user-initiated backups on Lustre file systems only; Amazon FSx is backing up the file
 * system.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>COPYING</code> - Amazon FSx is copying the backup.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DELETED</code> - Amazon FSx deleted the backup and it is no longer available.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>FAILED</code> - Amazon FSx could not complete the backup.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public enum BackupLifecycle {
    AVAILABLE("AVAILABLE"),

    CREATING("CREATING"),

    TRANSFERRING("TRANSFERRING"),

    DELETED("DELETED"),

    FAILED("FAILED"),

    PENDING("PENDING"),

    COPYING("COPYING"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private BackupLifecycle(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return BackupLifecycle corresponding to the value
     */
    public static BackupLifecycle fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(BackupLifecycle.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link BackupLifecycle}s
     */
    public static Set<BackupLifecycle> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
