/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Lustre configuration for the file system being created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFileSystemLustreConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateFileSystemLustreConfiguration.Builder, CreateFileSystemLustreConfiguration> {
    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WeeklyMaintenanceStartTime")
            .getter(getter(CreateFileSystemLustreConfiguration::weeklyMaintenanceStartTime))
            .setter(setter(Builder::weeklyMaintenanceStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build())
            .build();

    private static final SdkField<String> IMPORT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImportPath").getter(getter(CreateFileSystemLustreConfiguration::importPath))
            .setter(setter(Builder::importPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportPath").build()).build();

    private static final SdkField<String> EXPORT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportPath").getter(getter(CreateFileSystemLustreConfiguration::exportPath))
            .setter(setter(Builder::exportPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportPath").build()).build();

    private static final SdkField<Integer> IMPORTED_FILE_CHUNK_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ImportedFileChunkSize").getter(getter(CreateFileSystemLustreConfiguration::importedFileChunkSize))
            .setter(setter(Builder::importedFileChunkSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportedFileChunkSize").build())
            .build();

    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentType").getter(getter(CreateFileSystemLustreConfiguration::deploymentTypeAsString))
            .setter(setter(Builder::deploymentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentType").build()).build();

    private static final SdkField<String> AUTO_IMPORT_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoImportPolicy").getter(getter(CreateFileSystemLustreConfiguration::autoImportPolicyAsString))
            .setter(setter(Builder::autoImportPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoImportPolicy").build()).build();

    private static final SdkField<Integer> PER_UNIT_STORAGE_THROUGHPUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("PerUnitStorageThroughput")
            .getter(getter(CreateFileSystemLustreConfiguration::perUnitStorageThroughput))
            .setter(setter(Builder::perUnitStorageThroughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerUnitStorageThroughput").build())
            .build();

    private static final SdkField<String> DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DailyAutomaticBackupStartTime")
            .getter(getter(CreateFileSystemLustreConfiguration::dailyAutomaticBackupStartTime))
            .setter(setter(Builder::dailyAutomaticBackupStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyAutomaticBackupStartTime")
                    .build()).build();

    private static final SdkField<Integer> AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AutomaticBackupRetentionDays")
            .getter(getter(CreateFileSystemLustreConfiguration::automaticBackupRetentionDays))
            .setter(setter(Builder::automaticBackupRetentionDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticBackupRetentionDays")
                    .build()).build();

    private static final SdkField<Boolean> COPY_TAGS_TO_BACKUPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToBackups").getter(getter(CreateFileSystemLustreConfiguration::copyTagsToBackups))
            .setter(setter(Builder::copyTagsToBackups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToBackups").build()).build();

    private static final SdkField<String> DRIVE_CACHE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DriveCacheType").getter(getter(CreateFileSystemLustreConfiguration::driveCacheTypeAsString))
            .setter(setter(Builder::driveCacheType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriveCacheType").build()).build();

    private static final SdkField<String> DATA_COMPRESSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataCompressionType").getter(getter(CreateFileSystemLustreConfiguration::dataCompressionTypeAsString))
            .setter(setter(Builder::dataCompressionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCompressionType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            WEEKLY_MAINTENANCE_START_TIME_FIELD, IMPORT_PATH_FIELD, EXPORT_PATH_FIELD, IMPORTED_FILE_CHUNK_SIZE_FIELD,
            DEPLOYMENT_TYPE_FIELD, AUTO_IMPORT_POLICY_FIELD, PER_UNIT_STORAGE_THROUGHPUT_FIELD,
            DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD, AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD, COPY_TAGS_TO_BACKUPS_FIELD,
            DRIVE_CACHE_TYPE_FIELD, DATA_COMPRESSION_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String weeklyMaintenanceStartTime;

    private final String importPath;

    private final String exportPath;

    private final Integer importedFileChunkSize;

    private final String deploymentType;

    private final String autoImportPolicy;

    private final Integer perUnitStorageThroughput;

    private final String dailyAutomaticBackupStartTime;

    private final Integer automaticBackupRetentionDays;

    private final Boolean copyTagsToBackups;

    private final String driveCacheType;

    private final String dataCompressionType;

    private CreateFileSystemLustreConfiguration(BuilderImpl builder) {
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.importPath = builder.importPath;
        this.exportPath = builder.exportPath;
        this.importedFileChunkSize = builder.importedFileChunkSize;
        this.deploymentType = builder.deploymentType;
        this.autoImportPolicy = builder.autoImportPolicy;
        this.perUnitStorageThroughput = builder.perUnitStorageThroughput;
        this.dailyAutomaticBackupStartTime = builder.dailyAutomaticBackupStartTime;
        this.automaticBackupRetentionDays = builder.automaticBackupRetentionDays;
        this.copyTagsToBackups = builder.copyTagsToBackups;
        this.driveCacheType = builder.driveCacheType;
        this.dataCompressionType = builder.dataCompressionType;
    }

    /**
     * <p>
     * (Optional) The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone, where
     * d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
     * </p>
     * 
     * @return (Optional) The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time
     *         zone, where d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
     */
    public final String weeklyMaintenanceStartTime() {
        return weeklyMaintenanceStartTime;
    }

    /**
     * <p>
     * (Optional) The path to the Amazon S3 bucket (including the optional prefix) that you're using as the data
     * repository for your Amazon FSx for Lustre file system. The root of your FSx for Lustre file system will be mapped
     * to the root of the Amazon S3 bucket you select. An example is <code>s3://import-bucket/optional-prefix</code>. If
     * you specify a prefix after the Amazon S3 bucket name, only object keys with that prefix are loaded into the file
     * system.
     * </p>
     * 
     * @return (Optional) The path to the Amazon S3 bucket (including the optional prefix) that you're using as the data
     *         repository for your Amazon FSx for Lustre file system. The root of your FSx for Lustre file system will
     *         be mapped to the root of the Amazon S3 bucket you select. An example is
     *         <code>s3://import-bucket/optional-prefix</code>. If you specify a prefix after the Amazon S3 bucket name,
     *         only object keys with that prefix are loaded into the file system.
     */
    public final String importPath() {
        return importPath;
    }

    /**
     * <p>
     * (Optional) The path in Amazon S3 where the root of your Amazon FSx file system is exported. The path must use the
     * same Amazon S3 bucket as specified in ImportPath. You can provide an optional prefix to which new and changed
     * data is to be exported from your Amazon FSx for Lustre file system. If an <code>ExportPath</code> value is not
     * provided, Amazon FSx sets a default export path, <code>s3://import-bucket/FSxLustre[creation-timestamp]</code>.
     * The timestamp is in UTC format, for example <code>s3://import-bucket/FSxLustre20181105T222312Z</code>.
     * </p>
     * <p>
     * The Amazon S3 export bucket must be the same as the import bucket specified by <code>ImportPath</code>. If you
     * only specify a bucket name, such as <code>s3://import-bucket</code>, you get a 1:1 mapping of file system objects
     * to S3 bucket objects. This mapping means that the input data in S3 is overwritten on export. If you provide a
     * custom prefix in the export path, such as <code>s3://import-bucket/[custom-optional-prefix]</code>, Amazon FSx
     * exports the contents of your file system to that export prefix in the Amazon S3 bucket.
     * </p>
     * 
     * @return (Optional) The path in Amazon S3 where the root of your Amazon FSx file system is exported. The path must
     *         use the same Amazon S3 bucket as specified in ImportPath. You can provide an optional prefix to which new
     *         and changed data is to be exported from your Amazon FSx for Lustre file system. If an
     *         <code>ExportPath</code> value is not provided, Amazon FSx sets a default export path,
     *         <code>s3://import-bucket/FSxLustre[creation-timestamp]</code>. The timestamp is in UTC format, for
     *         example <code>s3://import-bucket/FSxLustre20181105T222312Z</code>.</p>
     *         <p>
     *         The Amazon S3 export bucket must be the same as the import bucket specified by <code>ImportPath</code>.
     *         If you only specify a bucket name, such as <code>s3://import-bucket</code>, you get a 1:1 mapping of file
     *         system objects to S3 bucket objects. This mapping means that the input data in S3 is overwritten on
     *         export. If you provide a custom prefix in the export path, such as
     *         <code>s3://import-bucket/[custom-optional-prefix]</code>, Amazon FSx exports the contents of your file
     *         system to that export prefix in the Amazon S3 bucket.
     */
    public final String exportPath() {
        return exportPath;
    }

    /**
     * <p>
     * (Optional) For files imported from a data repository, this value determines the stripe count and maximum amount
     * of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be
     * striped across is limited by the total number of disks that make up the file system.
     * </p>
     * <p>
     * The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a
     * maximum size of 5 TB.
     * </p>
     * 
     * @return (Optional) For files imported from a data repository, this value determines the stripe count and maximum
     *         amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a
     *         single file can be striped across is limited by the total number of disks that make up the file
     *         system.</p>
     *         <p>
     *         The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3
     *         objects have a maximum size of 5 TB.
     */
    public final Integer importedFileChunkSize() {
        return importedFileChunkSize;
    }

    /**
     * <p>
     * Choose <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment types when you need temporary storage and
     * shorter-term processing of data. The <code>SCRATCH_2</code> deployment type provides in-transit encryption of
     * data and higher burst throughput capacity than <code>SCRATCH_1</code>.
     * </p>
     * <p>
     * Choose <code>PERSISTENT_1</code> deployment type for longer-term storage and workloads and encryption of data in
     * transit. To learn more about deployment types, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html"> FSx for Lustre Deployment
     * Options</a>.
     * </p>
     * <p>
     * Encryption of data in-transit is automatically enabled when you access a <code>SCRATCH_2</code> or
     * <code>PERSISTENT_1</code> file system from Amazon EC2 instances that <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data- protection.html">support this feature</a>.
     * (Default = <code>SCRATCH_1</code>)
     * </p>
     * <p>
     * Encryption of data in-transit for <code>SCRATCH_2</code> and <code>PERSISTENT_1</code> deployment types is
     * supported when accessed from supported instance types in supported AWS Regions. To learn more, <a
     * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html">Encrypting Data in
     * Transit</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link LustreDeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return Choose <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment types when you need temporary storage
     *         and shorter-term processing of data. The <code>SCRATCH_2</code> deployment type provides in-transit
     *         encryption of data and higher burst throughput capacity than <code>SCRATCH_1</code>.</p>
     *         <p>
     *         Choose <code>PERSISTENT_1</code> deployment type for longer-term storage and workloads and encryption of
     *         data in transit. To learn more about deployment types, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html"> FSx for Lustre
     *         Deployment Options</a>.
     *         </p>
     *         <p>
     *         Encryption of data in-transit is automatically enabled when you access a <code>SCRATCH_2</code> or
     *         <code>PERSISTENT_1</code> file system from Amazon EC2 instances that <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data- protection.html">support this
     *         feature</a>. (Default = <code>SCRATCH_1</code>)
     *         </p>
     *         <p>
     *         Encryption of data in-transit for <code>SCRATCH_2</code> and <code>PERSISTENT_1</code> deployment types
     *         is supported when accessed from supported instance types in supported AWS Regions. To learn more, <a
     *         href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html">Encrypting Data
     *         in Transit</a>.
     * @see LustreDeploymentType
     */
    public final LustreDeploymentType deploymentType() {
        return LustreDeploymentType.fromValue(deploymentType);
    }

    /**
     * <p>
     * Choose <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment types when you need temporary storage and
     * shorter-term processing of data. The <code>SCRATCH_2</code> deployment type provides in-transit encryption of
     * data and higher burst throughput capacity than <code>SCRATCH_1</code>.
     * </p>
     * <p>
     * Choose <code>PERSISTENT_1</code> deployment type for longer-term storage and workloads and encryption of data in
     * transit. To learn more about deployment types, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html"> FSx for Lustre Deployment
     * Options</a>.
     * </p>
     * <p>
     * Encryption of data in-transit is automatically enabled when you access a <code>SCRATCH_2</code> or
     * <code>PERSISTENT_1</code> file system from Amazon EC2 instances that <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data- protection.html">support this feature</a>.
     * (Default = <code>SCRATCH_1</code>)
     * </p>
     * <p>
     * Encryption of data in-transit for <code>SCRATCH_2</code> and <code>PERSISTENT_1</code> deployment types is
     * supported when accessed from supported instance types in supported AWS Regions. To learn more, <a
     * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html">Encrypting Data in
     * Transit</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link LustreDeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return Choose <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment types when you need temporary storage
     *         and shorter-term processing of data. The <code>SCRATCH_2</code> deployment type provides in-transit
     *         encryption of data and higher burst throughput capacity than <code>SCRATCH_1</code>.</p>
     *         <p>
     *         Choose <code>PERSISTENT_1</code> deployment type for longer-term storage and workloads and encryption of
     *         data in transit. To learn more about deployment types, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html"> FSx for Lustre
     *         Deployment Options</a>.
     *         </p>
     *         <p>
     *         Encryption of data in-transit is automatically enabled when you access a <code>SCRATCH_2</code> or
     *         <code>PERSISTENT_1</code> file system from Amazon EC2 instances that <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data- protection.html">support this
     *         feature</a>. (Default = <code>SCRATCH_1</code>)
     *         </p>
     *         <p>
     *         Encryption of data in-transit for <code>SCRATCH_2</code> and <code>PERSISTENT_1</code> deployment types
     *         is supported when accessed from supported instance types in supported AWS Regions. To learn more, <a
     *         href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html">Encrypting Data
     *         in Transit</a>.
     * @see LustreDeploymentType
     */
    public final String deploymentTypeAsString() {
        return deploymentType;
    }

    /**
     * <p>
     * (Optional) When you create your file system, your existing S3 objects appear as file and directory listings. Use
     * this property to choose how Amazon FSx keeps your file and directory listings up to date as you add or modify
     * objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates file and directory listings from the
     * linked S3 bucket when the file system is created. FSx does not update file and directory listings for any new or
     * changed objects after choosing this option.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports directory listings of any new objects added
     * to the linked S3 bucket that do not currently exist in the FSx file system.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports file and directory listings of any
     * new objects added to the S3 bucket and any existing objects that are changed in the S3 bucket after you choose
     * this option.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html">Automatically import updates
     * from your S3 bucket</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoImportPolicy}
     * will return {@link AutoImportPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #autoImportPolicyAsString}.
     * </p>
     * 
     * @return (Optional) When you create your file system, your existing S3 objects appear as file and directory
     *         listings. Use this property to choose how Amazon FSx keeps your file and directory listings up to date as
     *         you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the following
     *         values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates file and directory listings from
     *         the linked S3 bucket when the file system is created. FSx does not update file and directory listings for
     *         any new or changed objects after choosing this option.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports directory listings of any new
     *         objects added to the linked S3 bucket that do not currently exist in the FSx file system.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports file and directory listings
     *         of any new objects added to the S3 bucket and any existing objects that are changed in the S3 bucket
     *         after you choose this option.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html">Automatically import
     *         updates from your S3 bucket</a>.
     * @see AutoImportPolicyType
     */
    public final AutoImportPolicyType autoImportPolicy() {
        return AutoImportPolicyType.fromValue(autoImportPolicy);
    }

    /**
     * <p>
     * (Optional) When you create your file system, your existing S3 objects appear as file and directory listings. Use
     * this property to choose how Amazon FSx keeps your file and directory listings up to date as you add or modify
     * objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates file and directory listings from the
     * linked S3 bucket when the file system is created. FSx does not update file and directory listings for any new or
     * changed objects after choosing this option.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports directory listings of any new objects added
     * to the linked S3 bucket that do not currently exist in the FSx file system.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports file and directory listings of any
     * new objects added to the S3 bucket and any existing objects that are changed in the S3 bucket after you choose
     * this option.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html">Automatically import updates
     * from your S3 bucket</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoImportPolicy}
     * will return {@link AutoImportPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #autoImportPolicyAsString}.
     * </p>
     * 
     * @return (Optional) When you create your file system, your existing S3 objects appear as file and directory
     *         listings. Use this property to choose how Amazon FSx keeps your file and directory listings up to date as
     *         you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the following
     *         values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates file and directory listings from
     *         the linked S3 bucket when the file system is created. FSx does not update file and directory listings for
     *         any new or changed objects after choosing this option.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports directory listings of any new
     *         objects added to the linked S3 bucket that do not currently exist in the FSx file system.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports file and directory listings
     *         of any new objects added to the S3 bucket and any existing objects that are changed in the S3 bucket
     *         after you choose this option.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html">Automatically import
     *         updates from your S3 bucket</a>.
     * @see AutoImportPolicyType
     */
    public final String autoImportPolicyAsString() {
        return autoImportPolicy;
    }

    /**
     * <p>
     * Required for the <code>PERSISTENT_1</code> deployment type, describes the amount of read and write throughput for
     * each 1 tebibyte of storage, in MB/s/TiB. File system throughput capacity is calculated by multiplying ﬁle system
     * storage capacity (TiB) by the PerUnitStorageThroughput (MB/s/TiB). For a 2.4 TiB ﬁle system, provisioning 50
     * MB/s/TiB of PerUnitStorageThroughput yields 120 MB/s of ﬁle system throughput. You pay for the amount of
     * throughput that you provision.
     * </p>
     * <p>
     * Valid values for SSD storage: 50, 100, 200. Valid values for HDD storage: 12, 40.
     * </p>
     * 
     * @return Required for the <code>PERSISTENT_1</code> deployment type, describes the amount of read and write
     *         throughput for each 1 tebibyte of storage, in MB/s/TiB. File system throughput capacity is calculated by
     *         multiplying ﬁle system storage capacity (TiB) by the PerUnitStorageThroughput (MB/s/TiB). For a 2.4 TiB
     *         ﬁle system, provisioning 50 MB/s/TiB of PerUnitStorageThroughput yields 120 MB/s of ﬁle system
     *         throughput. You pay for the amount of throughput that you provision. </p>
     *         <p>
     *         Valid values for SSD storage: 50, 100, 200. Valid values for HDD storage: 12, 40.
     */
    public final Integer perUnitStorageThroughput() {
        return perUnitStorageThroughput;
    }

    /**
     * Returns the value of the DailyAutomaticBackupStartTime property for this object.
     * 
     * @return The value of the DailyAutomaticBackupStartTime property for this object.
     */
    public final String dailyAutomaticBackupStartTime() {
        return dailyAutomaticBackupStartTime;
    }

    /**
     * Returns the value of the AutomaticBackupRetentionDays property for this object.
     * 
     * @return The value of the AutomaticBackupRetentionDays property for this object.
     */
    public final Integer automaticBackupRetentionDays() {
        return automaticBackupRetentionDays;
    }

    /**
     * <p>
     * (Optional) Not available to use with file systems that are linked to a data repository. A boolean flag indicating
     * whether tags for the file system should be copied to backups. The default value is false. If it's set to true,
     * all file system tags are copied to all automatic and user-initiated backups when the user doesn't specify any
     * backup-specific tags. If this value is true, and you specify one or more backup tags, only the specified tags are
     * copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from
     * the file system, regardless of this value.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html">Working with backups</a>.
     * </p>
     * 
     * @return (Optional) Not available to use with file systems that are linked to a data repository. A boolean flag
     *         indicating whether tags for the file system should be copied to backups. The default value is false. If
     *         it's set to true, all file system tags are copied to all automatic and user-initiated backups when the
     *         user doesn't specify any backup-specific tags. If this value is true, and you specify one or more backup
     *         tags, only the specified tags are copied to backups. If you specify one or more tags when creating a
     *         user-initiated backup, no tags are copied from the file system, regardless of this value.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html">Working with
     *         backups</a>.
     */
    public final Boolean copyTagsToBackups() {
        return copyTagsToBackups;
    }

    /**
     * <p>
     * The type of drive cache used by PERSISTENT_1 file systems that are provisioned with HDD storage devices. This
     * parameter is required when storage type is HDD. Set to <code>READ</code>, improve the performance for frequently
     * accessed files and allows 20% of the total storage capacity of the file system to be cached.
     * </p>
     * <p>
     * This parameter is required when <code>StorageType</code> is set to HDD.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #driveCacheType}
     * will return {@link DriveCacheType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #driveCacheTypeAsString}.
     * </p>
     * 
     * @return The type of drive cache used by PERSISTENT_1 file systems that are provisioned with HDD storage devices.
     *         This parameter is required when storage type is HDD. Set to <code>READ</code>, improve the performance
     *         for frequently accessed files and allows 20% of the total storage capacity of the file system to be
     *         cached. </p>
     *         <p>
     *         This parameter is required when <code>StorageType</code> is set to HDD.
     * @see DriveCacheType
     */
    public final DriveCacheType driveCacheType() {
        return DriveCacheType.fromValue(driveCacheType);
    }

    /**
     * <p>
     * The type of drive cache used by PERSISTENT_1 file systems that are provisioned with HDD storage devices. This
     * parameter is required when storage type is HDD. Set to <code>READ</code>, improve the performance for frequently
     * accessed files and allows 20% of the total storage capacity of the file system to be cached.
     * </p>
     * <p>
     * This parameter is required when <code>StorageType</code> is set to HDD.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #driveCacheType}
     * will return {@link DriveCacheType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #driveCacheTypeAsString}.
     * </p>
     * 
     * @return The type of drive cache used by PERSISTENT_1 file systems that are provisioned with HDD storage devices.
     *         This parameter is required when storage type is HDD. Set to <code>READ</code>, improve the performance
     *         for frequently accessed files and allows 20% of the total storage capacity of the file system to be
     *         cached. </p>
     *         <p>
     *         This parameter is required when <code>StorageType</code> is set to HDD.
     * @see DriveCacheType
     */
    public final String driveCacheTypeAsString() {
        return driveCacheType;
    }

    /**
     * <p>
     * Sets the data compression configuration for the file system. <code>DataCompressionType</code> can have the
     * following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code> - (Default) Data compression is turned off when the file system is created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LZ4</code> - Data compression is turned on with the LZ4 algorithm.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataCompressionType} will return {@link DataCompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataCompressionTypeAsString}.
     * </p>
     * 
     * @return Sets the data compression configuration for the file system. <code>DataCompressionType</code> can have
     *         the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code> - (Default) Data compression is turned off when the file system is created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LZ4</code> - Data compression is turned on with the LZ4 algorithm.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data
     *         compression</a>.
     * @see DataCompressionType
     */
    public final DataCompressionType dataCompressionType() {
        return DataCompressionType.fromValue(dataCompressionType);
    }

    /**
     * <p>
     * Sets the data compression configuration for the file system. <code>DataCompressionType</code> can have the
     * following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code> - (Default) Data compression is turned off when the file system is created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LZ4</code> - Data compression is turned on with the LZ4 algorithm.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataCompressionType} will return {@link DataCompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataCompressionTypeAsString}.
     * </p>
     * 
     * @return Sets the data compression configuration for the file system. <code>DataCompressionType</code> can have
     *         the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code> - (Default) Data compression is turned off when the file system is created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LZ4</code> - Data compression is turned on with the LZ4 algorithm.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data
     *         compression</a>.
     * @see DataCompressionType
     */
    public final String dataCompressionTypeAsString() {
        return dataCompressionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(importPath());
        hashCode = 31 * hashCode + Objects.hashCode(exportPath());
        hashCode = 31 * hashCode + Objects.hashCode(importedFileChunkSize());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoImportPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(perUnitStorageThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(dailyAutomaticBackupStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(automaticBackupRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToBackups());
        hashCode = 31 * hashCode + Objects.hashCode(driveCacheTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataCompressionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFileSystemLustreConfiguration)) {
            return false;
        }
        CreateFileSystemLustreConfiguration other = (CreateFileSystemLustreConfiguration) obj;
        return Objects.equals(weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime())
                && Objects.equals(importPath(), other.importPath()) && Objects.equals(exportPath(), other.exportPath())
                && Objects.equals(importedFileChunkSize(), other.importedFileChunkSize())
                && Objects.equals(deploymentTypeAsString(), other.deploymentTypeAsString())
                && Objects.equals(autoImportPolicyAsString(), other.autoImportPolicyAsString())
                && Objects.equals(perUnitStorageThroughput(), other.perUnitStorageThroughput())
                && Objects.equals(dailyAutomaticBackupStartTime(), other.dailyAutomaticBackupStartTime())
                && Objects.equals(automaticBackupRetentionDays(), other.automaticBackupRetentionDays())
                && Objects.equals(copyTagsToBackups(), other.copyTagsToBackups())
                && Objects.equals(driveCacheTypeAsString(), other.driveCacheTypeAsString())
                && Objects.equals(dataCompressionTypeAsString(), other.dataCompressionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFileSystemLustreConfiguration")
                .add("WeeklyMaintenanceStartTime", weeklyMaintenanceStartTime()).add("ImportPath", importPath())
                .add("ExportPath", exportPath()).add("ImportedFileChunkSize", importedFileChunkSize())
                .add("DeploymentType", deploymentTypeAsString()).add("AutoImportPolicy", autoImportPolicyAsString())
                .add("PerUnitStorageThroughput", perUnitStorageThroughput())
                .add("DailyAutomaticBackupStartTime", dailyAutomaticBackupStartTime())
                .add("AutomaticBackupRetentionDays", automaticBackupRetentionDays())
                .add("CopyTagsToBackups", copyTagsToBackups()).add("DriveCacheType", driveCacheTypeAsString())
                .add("DataCompressionType", dataCompressionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WeeklyMaintenanceStartTime":
            return Optional.ofNullable(clazz.cast(weeklyMaintenanceStartTime()));
        case "ImportPath":
            return Optional.ofNullable(clazz.cast(importPath()));
        case "ExportPath":
            return Optional.ofNullable(clazz.cast(exportPath()));
        case "ImportedFileChunkSize":
            return Optional.ofNullable(clazz.cast(importedFileChunkSize()));
        case "DeploymentType":
            return Optional.ofNullable(clazz.cast(deploymentTypeAsString()));
        case "AutoImportPolicy":
            return Optional.ofNullable(clazz.cast(autoImportPolicyAsString()));
        case "PerUnitStorageThroughput":
            return Optional.ofNullable(clazz.cast(perUnitStorageThroughput()));
        case "DailyAutomaticBackupStartTime":
            return Optional.ofNullable(clazz.cast(dailyAutomaticBackupStartTime()));
        case "AutomaticBackupRetentionDays":
            return Optional.ofNullable(clazz.cast(automaticBackupRetentionDays()));
        case "CopyTagsToBackups":
            return Optional.ofNullable(clazz.cast(copyTagsToBackups()));
        case "DriveCacheType":
            return Optional.ofNullable(clazz.cast(driveCacheTypeAsString()));
        case "DataCompressionType":
            return Optional.ofNullable(clazz.cast(dataCompressionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFileSystemLustreConfiguration, T> g) {
        return obj -> g.apply((CreateFileSystemLustreConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateFileSystemLustreConfiguration> {
        /**
         * <p>
         * (Optional) The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone,
         * where d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
         * </p>
         * 
         * @param weeklyMaintenanceStartTime
         *        (Optional) The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time
         *        zone, where d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime);

        /**
         * <p>
         * (Optional) The path to the Amazon S3 bucket (including the optional prefix) that you're using as the data
         * repository for your Amazon FSx for Lustre file system. The root of your FSx for Lustre file system will be
         * mapped to the root of the Amazon S3 bucket you select. An example is
         * <code>s3://import-bucket/optional-prefix</code>. If you specify a prefix after the Amazon S3 bucket name,
         * only object keys with that prefix are loaded into the file system.
         * </p>
         * 
         * @param importPath
         *        (Optional) The path to the Amazon S3 bucket (including the optional prefix) that you're using as the
         *        data repository for your Amazon FSx for Lustre file system. The root of your FSx for Lustre file
         *        system will be mapped to the root of the Amazon S3 bucket you select. An example is
         *        <code>s3://import-bucket/optional-prefix</code>. If you specify a prefix after the Amazon S3 bucket
         *        name, only object keys with that prefix are loaded into the file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importPath(String importPath);

        /**
         * <p>
         * (Optional) The path in Amazon S3 where the root of your Amazon FSx file system is exported. The path must use
         * the same Amazon S3 bucket as specified in ImportPath. You can provide an optional prefix to which new and
         * changed data is to be exported from your Amazon FSx for Lustre file system. If an <code>ExportPath</code>
         * value is not provided, Amazon FSx sets a default export path,
         * <code>s3://import-bucket/FSxLustre[creation-timestamp]</code>. The timestamp is in UTC format, for example
         * <code>s3://import-bucket/FSxLustre20181105T222312Z</code>.
         * </p>
         * <p>
         * The Amazon S3 export bucket must be the same as the import bucket specified by <code>ImportPath</code>. If
         * you only specify a bucket name, such as <code>s3://import-bucket</code>, you get a 1:1 mapping of file system
         * objects to S3 bucket objects. This mapping means that the input data in S3 is overwritten on export. If you
         * provide a custom prefix in the export path, such as <code>s3://import-bucket/[custom-optional-prefix]</code>,
         * Amazon FSx exports the contents of your file system to that export prefix in the Amazon S3 bucket.
         * </p>
         * 
         * @param exportPath
         *        (Optional) The path in Amazon S3 where the root of your Amazon FSx file system is exported. The path
         *        must use the same Amazon S3 bucket as specified in ImportPath. You can provide an optional prefix to
         *        which new and changed data is to be exported from your Amazon FSx for Lustre file system. If an
         *        <code>ExportPath</code> value is not provided, Amazon FSx sets a default export path,
         *        <code>s3://import-bucket/FSxLustre[creation-timestamp]</code>. The timestamp is in UTC format, for
         *        example <code>s3://import-bucket/FSxLustre20181105T222312Z</code>.</p>
         *        <p>
         *        The Amazon S3 export bucket must be the same as the import bucket specified by <code>ImportPath</code>
         *        . If you only specify a bucket name, such as <code>s3://import-bucket</code>, you get a 1:1 mapping of
         *        file system objects to S3 bucket objects. This mapping means that the input data in S3 is overwritten
         *        on export. If you provide a custom prefix in the export path, such as
         *        <code>s3://import-bucket/[custom-optional-prefix]</code>, Amazon FSx exports the contents of your file
         *        system to that export prefix in the Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportPath(String exportPath);

        /**
         * <p>
         * (Optional) For files imported from a data repository, this value determines the stripe count and maximum
         * amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single
         * file can be striped across is limited by the total number of disks that make up the file system.
         * </p>
         * <p>
         * The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects
         * have a maximum size of 5 TB.
         * </p>
         * 
         * @param importedFileChunkSize
         *        (Optional) For files imported from a data repository, this value determines the stripe count and
         *        maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks
         *        that a single file can be striped across is limited by the total number of disks that make up the file
         *        system.</p>
         *        <p>
         *        The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3
         *        objects have a maximum size of 5 TB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedFileChunkSize(Integer importedFileChunkSize);

        /**
         * <p>
         * Choose <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment types when you need temporary storage and
         * shorter-term processing of data. The <code>SCRATCH_2</code> deployment type provides in-transit encryption of
         * data and higher burst throughput capacity than <code>SCRATCH_1</code>.
         * </p>
         * <p>
         * Choose <code>PERSISTENT_1</code> deployment type for longer-term storage and workloads and encryption of data
         * in transit. To learn more about deployment types, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html"> FSx for Lustre
         * Deployment Options</a>.
         * </p>
         * <p>
         * Encryption of data in-transit is automatically enabled when you access a <code>SCRATCH_2</code> or
         * <code>PERSISTENT_1</code> file system from Amazon EC2 instances that <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data- protection.html">support this feature</a>.
         * (Default = <code>SCRATCH_1</code>)
         * </p>
         * <p>
         * Encryption of data in-transit for <code>SCRATCH_2</code> and <code>PERSISTENT_1</code> deployment types is
         * supported when accessed from supported instance types in supported AWS Regions. To learn more, <a
         * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html">Encrypting Data in
         * Transit</a>.
         * </p>
         * 
         * @param deploymentType
         *        Choose <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment types when you need temporary
         *        storage and shorter-term processing of data. The <code>SCRATCH_2</code> deployment type provides
         *        in-transit encryption of data and higher burst throughput capacity than <code>SCRATCH_1</code>.</p>
         *        <p>
         *        Choose <code>PERSISTENT_1</code> deployment type for longer-term storage and workloads and encryption
         *        of data in transit. To learn more about deployment types, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html"> FSx for Lustre
         *        Deployment Options</a>.
         *        </p>
         *        <p>
         *        Encryption of data in-transit is automatically enabled when you access a <code>SCRATCH_2</code> or
         *        <code>PERSISTENT_1</code> file system from Amazon EC2 instances that <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data- protection.html">support this
         *        feature</a>. (Default = <code>SCRATCH_1</code>)
         *        </p>
         *        <p>
         *        Encryption of data in-transit for <code>SCRATCH_2</code> and <code>PERSISTENT_1</code> deployment
         *        types is supported when accessed from supported instance types in supported AWS Regions. To learn
         *        more, <a
         *        href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html">Encrypting
         *        Data in Transit</a>.
         * @see LustreDeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LustreDeploymentType
         */
        Builder deploymentType(String deploymentType);

        /**
         * <p>
         * Choose <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment types when you need temporary storage and
         * shorter-term processing of data. The <code>SCRATCH_2</code> deployment type provides in-transit encryption of
         * data and higher burst throughput capacity than <code>SCRATCH_1</code>.
         * </p>
         * <p>
         * Choose <code>PERSISTENT_1</code> deployment type for longer-term storage and workloads and encryption of data
         * in transit. To learn more about deployment types, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html"> FSx for Lustre
         * Deployment Options</a>.
         * </p>
         * <p>
         * Encryption of data in-transit is automatically enabled when you access a <code>SCRATCH_2</code> or
         * <code>PERSISTENT_1</code> file system from Amazon EC2 instances that <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data- protection.html">support this feature</a>.
         * (Default = <code>SCRATCH_1</code>)
         * </p>
         * <p>
         * Encryption of data in-transit for <code>SCRATCH_2</code> and <code>PERSISTENT_1</code> deployment types is
         * supported when accessed from supported instance types in supported AWS Regions. To learn more, <a
         * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html">Encrypting Data in
         * Transit</a>.
         * </p>
         * 
         * @param deploymentType
         *        Choose <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment types when you need temporary
         *        storage and shorter-term processing of data. The <code>SCRATCH_2</code> deployment type provides
         *        in-transit encryption of data and higher burst throughput capacity than <code>SCRATCH_1</code>.</p>
         *        <p>
         *        Choose <code>PERSISTENT_1</code> deployment type for longer-term storage and workloads and encryption
         *        of data in transit. To learn more about deployment types, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html"> FSx for Lustre
         *        Deployment Options</a>.
         *        </p>
         *        <p>
         *        Encryption of data in-transit is automatically enabled when you access a <code>SCRATCH_2</code> or
         *        <code>PERSISTENT_1</code> file system from Amazon EC2 instances that <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data- protection.html">support this
         *        feature</a>. (Default = <code>SCRATCH_1</code>)
         *        </p>
         *        <p>
         *        Encryption of data in-transit for <code>SCRATCH_2</code> and <code>PERSISTENT_1</code> deployment
         *        types is supported when accessed from supported instance types in supported AWS Regions. To learn
         *        more, <a
         *        href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html">Encrypting
         *        Data in Transit</a>.
         * @see LustreDeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LustreDeploymentType
         */
        Builder deploymentType(LustreDeploymentType deploymentType);

        /**
         * <p>
         * (Optional) When you create your file system, your existing S3 objects appear as file and directory listings.
         * Use this property to choose how Amazon FSx keeps your file and directory listings up to date as you add or
         * modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates file and directory listings from the
         * linked S3 bucket when the file system is created. FSx does not update file and directory listings for any new
         * or changed objects after choosing this option.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports directory listings of any new objects
         * added to the linked S3 bucket that do not currently exist in the FSx file system.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports file and directory listings of
         * any new objects added to the S3 bucket and any existing objects that are changed in the S3 bucket after you
         * choose this option.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html">Automatically import
         * updates from your S3 bucket</a>.
         * </p>
         * 
         * @param autoImportPolicy
         *        (Optional) When you create your file system, your existing S3 objects appear as file and directory
         *        listings. Use this property to choose how Amazon FSx keeps your file and directory listings up to date
         *        as you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the
         *        following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates file and directory listings
         *        from the linked S3 bucket when the file system is created. FSx does not update file and directory
         *        listings for any new or changed objects after choosing this option.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports directory listings of any new
         *        objects added to the linked S3 bucket that do not currently exist in the FSx file system.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports file and directory
         *        listings of any new objects added to the S3 bucket and any existing objects that are changed in the S3
         *        bucket after you choose this option.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html">Automatically
         *        import updates from your S3 bucket</a>.
         * @see AutoImportPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoImportPolicyType
         */
        Builder autoImportPolicy(String autoImportPolicy);

        /**
         * <p>
         * (Optional) When you create your file system, your existing S3 objects appear as file and directory listings.
         * Use this property to choose how Amazon FSx keeps your file and directory listings up to date as you add or
         * modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates file and directory listings from the
         * linked S3 bucket when the file system is created. FSx does not update file and directory listings for any new
         * or changed objects after choosing this option.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports directory listings of any new objects
         * added to the linked S3 bucket that do not currently exist in the FSx file system.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports file and directory listings of
         * any new objects added to the S3 bucket and any existing objects that are changed in the S3 bucket after you
         * choose this option.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html">Automatically import
         * updates from your S3 bucket</a>.
         * </p>
         * 
         * @param autoImportPolicy
         *        (Optional) When you create your file system, your existing S3 objects appear as file and directory
         *        listings. Use this property to choose how Amazon FSx keeps your file and directory listings up to date
         *        as you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the
         *        following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates file and directory listings
         *        from the linked S3 bucket when the file system is created. FSx does not update file and directory
         *        listings for any new or changed objects after choosing this option.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports directory listings of any new
         *        objects added to the linked S3 bucket that do not currently exist in the FSx file system.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports file and directory
         *        listings of any new objects added to the S3 bucket and any existing objects that are changed in the S3
         *        bucket after you choose this option.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html">Automatically
         *        import updates from your S3 bucket</a>.
         * @see AutoImportPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoImportPolicyType
         */
        Builder autoImportPolicy(AutoImportPolicyType autoImportPolicy);

        /**
         * <p>
         * Required for the <code>PERSISTENT_1</code> deployment type, describes the amount of read and write throughput
         * for each 1 tebibyte of storage, in MB/s/TiB. File system throughput capacity is calculated by multiplying ﬁle
         * system storage capacity (TiB) by the PerUnitStorageThroughput (MB/s/TiB). For a 2.4 TiB ﬁle system,
         * provisioning 50 MB/s/TiB of PerUnitStorageThroughput yields 120 MB/s of ﬁle system throughput. You pay for
         * the amount of throughput that you provision.
         * </p>
         * <p>
         * Valid values for SSD storage: 50, 100, 200. Valid values for HDD storage: 12, 40.
         * </p>
         * 
         * @param perUnitStorageThroughput
         *        Required for the <code>PERSISTENT_1</code> deployment type, describes the amount of read and write
         *        throughput for each 1 tebibyte of storage, in MB/s/TiB. File system throughput capacity is calculated
         *        by multiplying ﬁle system storage capacity (TiB) by the PerUnitStorageThroughput (MB/s/TiB). For a 2.4
         *        TiB ﬁle system, provisioning 50 MB/s/TiB of PerUnitStorageThroughput yields 120 MB/s of ﬁle system
         *        throughput. You pay for the amount of throughput that you provision. </p>
         *        <p>
         *        Valid values for SSD storage: 50, 100, 200. Valid values for HDD storage: 12, 40.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder perUnitStorageThroughput(Integer perUnitStorageThroughput);

        /**
         * Sets the value of the DailyAutomaticBackupStartTime property for this object.
         *
         * @param dailyAutomaticBackupStartTime
         *        The new value for the DailyAutomaticBackupStartTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime);

        /**
         * Sets the value of the AutomaticBackupRetentionDays property for this object.
         *
         * @param automaticBackupRetentionDays
         *        The new value for the AutomaticBackupRetentionDays property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays);

        /**
         * <p>
         * (Optional) Not available to use with file systems that are linked to a data repository. A boolean flag
         * indicating whether tags for the file system should be copied to backups. The default value is false. If it's
         * set to true, all file system tags are copied to all automatic and user-initiated backups when the user
         * doesn't specify any backup-specific tags. If this value is true, and you specify one or more backup tags,
         * only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated
         * backup, no tags are copied from the file system, regardless of this value.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html">Working with backups</a>.
         * </p>
         * 
         * @param copyTagsToBackups
         *        (Optional) Not available to use with file systems that are linked to a data repository. A boolean flag
         *        indicating whether tags for the file system should be copied to backups. The default value is false.
         *        If it's set to true, all file system tags are copied to all automatic and user-initiated backups when
         *        the user doesn't specify any backup-specific tags. If this value is true, and you specify one or more
         *        backup tags, only the specified tags are copied to backups. If you specify one or more tags when
         *        creating a user-initiated backup, no tags are copied from the file system, regardless of this
         *        value.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html">Working with
         *        backups</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToBackups(Boolean copyTagsToBackups);

        /**
         * <p>
         * The type of drive cache used by PERSISTENT_1 file systems that are provisioned with HDD storage devices. This
         * parameter is required when storage type is HDD. Set to <code>READ</code>, improve the performance for
         * frequently accessed files and allows 20% of the total storage capacity of the file system to be cached.
         * </p>
         * <p>
         * This parameter is required when <code>StorageType</code> is set to HDD.
         * </p>
         * 
         * @param driveCacheType
         *        The type of drive cache used by PERSISTENT_1 file systems that are provisioned with HDD storage
         *        devices. This parameter is required when storage type is HDD. Set to <code>READ</code>, improve the
         *        performance for frequently accessed files and allows 20% of the total storage capacity of the file
         *        system to be cached. </p>
         *        <p>
         *        This parameter is required when <code>StorageType</code> is set to HDD.
         * @see DriveCacheType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DriveCacheType
         */
        Builder driveCacheType(String driveCacheType);

        /**
         * <p>
         * The type of drive cache used by PERSISTENT_1 file systems that are provisioned with HDD storage devices. This
         * parameter is required when storage type is HDD. Set to <code>READ</code>, improve the performance for
         * frequently accessed files and allows 20% of the total storage capacity of the file system to be cached.
         * </p>
         * <p>
         * This parameter is required when <code>StorageType</code> is set to HDD.
         * </p>
         * 
         * @param driveCacheType
         *        The type of drive cache used by PERSISTENT_1 file systems that are provisioned with HDD storage
         *        devices. This parameter is required when storage type is HDD. Set to <code>READ</code>, improve the
         *        performance for frequently accessed files and allows 20% of the total storage capacity of the file
         *        system to be cached. </p>
         *        <p>
         *        This parameter is required when <code>StorageType</code> is set to HDD.
         * @see DriveCacheType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DriveCacheType
         */
        Builder driveCacheType(DriveCacheType driveCacheType);

        /**
         * <p>
         * Sets the data compression configuration for the file system. <code>DataCompressionType</code> can have the
         * following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code> - (Default) Data compression is turned off when the file system is created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LZ4</code> - Data compression is turned on with the LZ4 algorithm.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a>.
         * </p>
         * 
         * @param dataCompressionType
         *        Sets the data compression configuration for the file system. <code>DataCompressionType</code> can have
         *        the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code> - (Default) Data compression is turned off when the file system is created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LZ4</code> - Data compression is turned on with the LZ4 algorithm.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data
         *        compression</a>.
         * @see DataCompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataCompressionType
         */
        Builder dataCompressionType(String dataCompressionType);

        /**
         * <p>
         * Sets the data compression configuration for the file system. <code>DataCompressionType</code> can have the
         * following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code> - (Default) Data compression is turned off when the file system is created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LZ4</code> - Data compression is turned on with the LZ4 algorithm.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a>.
         * </p>
         * 
         * @param dataCompressionType
         *        Sets the data compression configuration for the file system. <code>DataCompressionType</code> can have
         *        the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code> - (Default) Data compression is turned off when the file system is created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LZ4</code> - Data compression is turned on with the LZ4 algorithm.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data
         *        compression</a>.
         * @see DataCompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataCompressionType
         */
        Builder dataCompressionType(DataCompressionType dataCompressionType);
    }

    static final class BuilderImpl implements Builder {
        private String weeklyMaintenanceStartTime;

        private String importPath;

        private String exportPath;

        private Integer importedFileChunkSize;

        private String deploymentType;

        private String autoImportPolicy;

        private Integer perUnitStorageThroughput;

        private String dailyAutomaticBackupStartTime;

        private Integer automaticBackupRetentionDays;

        private Boolean copyTagsToBackups;

        private String driveCacheType;

        private String dataCompressionType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFileSystemLustreConfiguration model) {
            weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            importPath(model.importPath);
            exportPath(model.exportPath);
            importedFileChunkSize(model.importedFileChunkSize);
            deploymentType(model.deploymentType);
            autoImportPolicy(model.autoImportPolicy);
            perUnitStorageThroughput(model.perUnitStorageThroughput);
            dailyAutomaticBackupStartTime(model.dailyAutomaticBackupStartTime);
            automaticBackupRetentionDays(model.automaticBackupRetentionDays);
            copyTagsToBackups(model.copyTagsToBackups);
            driveCacheType(model.driveCacheType);
            dataCompressionType(model.dataCompressionType);
        }

        public final String getWeeklyMaintenanceStartTime() {
            return weeklyMaintenanceStartTime;
        }

        @Override
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        public final String getImportPath() {
            return importPath;
        }

        @Override
        public final Builder importPath(String importPath) {
            this.importPath = importPath;
            return this;
        }

        public final void setImportPath(String importPath) {
            this.importPath = importPath;
        }

        public final String getExportPath() {
            return exportPath;
        }

        @Override
        public final Builder exportPath(String exportPath) {
            this.exportPath = exportPath;
            return this;
        }

        public final void setExportPath(String exportPath) {
            this.exportPath = exportPath;
        }

        public final Integer getImportedFileChunkSize() {
            return importedFileChunkSize;
        }

        @Override
        public final Builder importedFileChunkSize(Integer importedFileChunkSize) {
            this.importedFileChunkSize = importedFileChunkSize;
            return this;
        }

        public final void setImportedFileChunkSize(Integer importedFileChunkSize) {
            this.importedFileChunkSize = importedFileChunkSize;
        }

        public final String getDeploymentType() {
            return deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(LustreDeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        public final String getAutoImportPolicy() {
            return autoImportPolicy;
        }

        @Override
        public final Builder autoImportPolicy(String autoImportPolicy) {
            this.autoImportPolicy = autoImportPolicy;
            return this;
        }

        @Override
        public final Builder autoImportPolicy(AutoImportPolicyType autoImportPolicy) {
            this.autoImportPolicy(autoImportPolicy == null ? null : autoImportPolicy.toString());
            return this;
        }

        public final void setAutoImportPolicy(String autoImportPolicy) {
            this.autoImportPolicy = autoImportPolicy;
        }

        public final Integer getPerUnitStorageThroughput() {
            return perUnitStorageThroughput;
        }

        @Override
        public final Builder perUnitStorageThroughput(Integer perUnitStorageThroughput) {
            this.perUnitStorageThroughput = perUnitStorageThroughput;
            return this;
        }

        public final void setPerUnitStorageThroughput(Integer perUnitStorageThroughput) {
            this.perUnitStorageThroughput = perUnitStorageThroughput;
        }

        public final String getDailyAutomaticBackupStartTime() {
            return dailyAutomaticBackupStartTime;
        }

        @Override
        public final Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
            return this;
        }

        public final void setDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
        }

        public final Integer getAutomaticBackupRetentionDays() {
            return automaticBackupRetentionDays;
        }

        @Override
        public final Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
            return this;
        }

        public final void setAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
        }

        public final Boolean getCopyTagsToBackups() {
            return copyTagsToBackups;
        }

        @Override
        public final Builder copyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
            return this;
        }

        public final void setCopyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
        }

        public final String getDriveCacheType() {
            return driveCacheType;
        }

        @Override
        public final Builder driveCacheType(String driveCacheType) {
            this.driveCacheType = driveCacheType;
            return this;
        }

        @Override
        public final Builder driveCacheType(DriveCacheType driveCacheType) {
            this.driveCacheType(driveCacheType == null ? null : driveCacheType.toString());
            return this;
        }

        public final void setDriveCacheType(String driveCacheType) {
            this.driveCacheType = driveCacheType;
        }

        public final String getDataCompressionType() {
            return dataCompressionType;
        }

        @Override
        public final Builder dataCompressionType(String dataCompressionType) {
            this.dataCompressionType = dataCompressionType;
            return this;
        }

        @Override
        public final Builder dataCompressionType(DataCompressionType dataCompressionType) {
            this.dataCompressionType(dataCompressionType == null ? null : dataCompressionType.toString());
            return this;
        }

        public final void setDataCompressionType(String dataCompressionType) {
            this.dataCompressionType = dataCompressionType;
        }

        @Override
        public CreateFileSystemLustreConfiguration build() {
            return new CreateFileSystemLustreConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
