/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration object for the Amazon FSx for Lustre file system being deleted in the <code>DeleteFileSystem</code>
 * operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFileSystemLustreConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DeleteFileSystemLustreConfiguration.Builder, DeleteFileSystemLustreConfiguration> {
    private static final SdkField<Boolean> SKIP_FINAL_BACKUP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SkipFinalBackup").getter(getter(DeleteFileSystemLustreConfiguration::skipFinalBackup))
            .setter(setter(Builder::skipFinalBackup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkipFinalBackup").build()).build();

    private static final SdkField<List<Tag>> FINAL_BACKUP_TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("FinalBackupTags")
            .getter(getter(DeleteFileSystemLustreConfiguration::finalBackupTags))
            .setter(setter(Builder::finalBackupTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalBackupTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SKIP_FINAL_BACKUP_FIELD,
            FINAL_BACKUP_TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean skipFinalBackup;

    private final List<Tag> finalBackupTags;

    private DeleteFileSystemLustreConfiguration(BuilderImpl builder) {
        this.skipFinalBackup = builder.skipFinalBackup;
        this.finalBackupTags = builder.finalBackupTags;
    }

    /**
     * <p>
     * Set <code>SkipFinalBackup</code> to false if you want to take a final backup of the file system you are deleting.
     * By default, Amazon FSx will not take a final backup on your behalf when the <code>DeleteFileSystem</code>
     * operation is invoked. (Default = true)
     * </p>
     * 
     * @return Set <code>SkipFinalBackup</code> to false if you want to take a final backup of the file system you are
     *         deleting. By default, Amazon FSx will not take a final backup on your behalf when the
     *         <code>DeleteFileSystem</code> operation is invoked. (Default = true)
     */
    public final Boolean skipFinalBackup() {
        return skipFinalBackup;
    }

    /**
     * Returns true if the FinalBackupTags property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasFinalBackupTags() {
        return finalBackupTags != null && !(finalBackupTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Use if <code>SkipFinalBackup</code> is set to <code>false</code>, and you want to apply an array of tags to the
     * final backup. If you have set the file system property <code>CopyTagsToBackups</code> to true, and you specify
     * one or more <code>FinalBackupTags</code> when deleting a file system, Amazon FSx will not copy any existing file
     * system tags to the backup.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFinalBackupTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Use if <code>SkipFinalBackup</code> is set to <code>false</code>, and you want to apply an array of tags
     *         to the final backup. If you have set the file system property <code>CopyTagsToBackups</code> to true, and
     *         you specify one or more <code>FinalBackupTags</code> when deleting a file system, Amazon FSx will not
     *         copy any existing file system tags to the backup.
     */
    public final List<Tag> finalBackupTags() {
        return finalBackupTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(skipFinalBackup());
        hashCode = 31 * hashCode + Objects.hashCode(hasFinalBackupTags() ? finalBackupTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFileSystemLustreConfiguration)) {
            return false;
        }
        DeleteFileSystemLustreConfiguration other = (DeleteFileSystemLustreConfiguration) obj;
        return Objects.equals(skipFinalBackup(), other.skipFinalBackup()) && hasFinalBackupTags() == other.hasFinalBackupTags()
                && Objects.equals(finalBackupTags(), other.finalBackupTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteFileSystemLustreConfiguration").add("SkipFinalBackup", skipFinalBackup())
                .add("FinalBackupTags", hasFinalBackupTags() ? finalBackupTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SkipFinalBackup":
            return Optional.ofNullable(clazz.cast(skipFinalBackup()));
        case "FinalBackupTags":
            return Optional.ofNullable(clazz.cast(finalBackupTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFileSystemLustreConfiguration, T> g) {
        return obj -> g.apply((DeleteFileSystemLustreConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeleteFileSystemLustreConfiguration> {
        /**
         * <p>
         * Set <code>SkipFinalBackup</code> to false if you want to take a final backup of the file system you are
         * deleting. By default, Amazon FSx will not take a final backup on your behalf when the
         * <code>DeleteFileSystem</code> operation is invoked. (Default = true)
         * </p>
         * 
         * @param skipFinalBackup
         *        Set <code>SkipFinalBackup</code> to false if you want to take a final backup of the file system you
         *        are deleting. By default, Amazon FSx will not take a final backup on your behalf when the
         *        <code>DeleteFileSystem</code> operation is invoked. (Default = true)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipFinalBackup(Boolean skipFinalBackup);

        /**
         * <p>
         * Use if <code>SkipFinalBackup</code> is set to <code>false</code>, and you want to apply an array of tags to
         * the final backup. If you have set the file system property <code>CopyTagsToBackups</code> to true, and you
         * specify one or more <code>FinalBackupTags</code> when deleting a file system, Amazon FSx will not copy any
         * existing file system tags to the backup.
         * </p>
         * 
         * @param finalBackupTags
         *        Use if <code>SkipFinalBackup</code> is set to <code>false</code>, and you want to apply an array of
         *        tags to the final backup. If you have set the file system property <code>CopyTagsToBackups</code> to
         *        true, and you specify one or more <code>FinalBackupTags</code> when deleting a file system, Amazon FSx
         *        will not copy any existing file system tags to the backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalBackupTags(Collection<Tag> finalBackupTags);

        /**
         * <p>
         * Use if <code>SkipFinalBackup</code> is set to <code>false</code>, and you want to apply an array of tags to
         * the final backup. If you have set the file system property <code>CopyTagsToBackups</code> to true, and you
         * specify one or more <code>FinalBackupTags</code> when deleting a file system, Amazon FSx will not copy any
         * existing file system tags to the backup.
         * </p>
         * 
         * @param finalBackupTags
         *        Use if <code>SkipFinalBackup</code> is set to <code>false</code>, and you want to apply an array of
         *        tags to the final backup. If you have set the file system property <code>CopyTagsToBackups</code> to
         *        true, and you specify one or more <code>FinalBackupTags</code> when deleting a file system, Amazon FSx
         *        will not copy any existing file system tags to the backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalBackupTags(Tag... finalBackupTags);

        /**
         * <p>
         * Use if <code>SkipFinalBackup</code> is set to <code>false</code>, and you want to apply an array of tags to
         * the final backup. If you have set the file system property <code>CopyTagsToBackups</code> to true, and you
         * specify one or more <code>FinalBackupTags</code> when deleting a file system, Amazon FSx will not copy any
         * existing file system tags to the backup.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #finalBackupTags(List<Tag>)}.
         * 
         * @param finalBackupTags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #finalBackupTags(List<Tag>)
         */
        Builder finalBackupTags(Consumer<Tag.Builder>... finalBackupTags);
    }

    static final class BuilderImpl implements Builder {
        private Boolean skipFinalBackup;

        private List<Tag> finalBackupTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFileSystemLustreConfiguration model) {
            skipFinalBackup(model.skipFinalBackup);
            finalBackupTags(model.finalBackupTags);
        }

        public final Boolean getSkipFinalBackup() {
            return skipFinalBackup;
        }

        @Override
        public final Builder skipFinalBackup(Boolean skipFinalBackup) {
            this.skipFinalBackup = skipFinalBackup;
            return this;
        }

        public final void setSkipFinalBackup(Boolean skipFinalBackup) {
            this.skipFinalBackup = skipFinalBackup;
        }

        public final List<Tag.Builder> getFinalBackupTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.finalBackupTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder finalBackupTags(Collection<Tag> finalBackupTags) {
            this.finalBackupTags = TagsCopier.copy(finalBackupTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder finalBackupTags(Tag... finalBackupTags) {
            finalBackupTags(Arrays.asList(finalBackupTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder finalBackupTags(Consumer<Tag.Builder>... finalBackupTags) {
            finalBackupTags(Stream.of(finalBackupTags).map(c -> Tag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFinalBackupTags(Collection<Tag.BuilderImpl> finalBackupTags) {
            this.finalBackupTags = TagsCopier.copyFromBuilder(finalBackupTags);
        }

        @Override
        public DeleteFileSystemLustreConfiguration build() {
            return new DeleteFileSystemLustreConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
