/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response object for <code>DescribeFileSystems</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFileSystemsResponse extends FSxResponse implements
        ToCopyableBuilder<DescribeFileSystemsResponse.Builder, DescribeFileSystemsResponse> {
    private static final SdkField<List<FileSystem>> FILE_SYSTEMS_FIELD = SdkField
            .<List<FileSystem>> builder(MarshallingType.LIST)
            .memberName("FileSystems")
            .getter(getter(DescribeFileSystemsResponse::fileSystems))
            .setter(setter(Builder::fileSystems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FileSystem> builder(MarshallingType.SDK_POJO)
                                            .constructor(FileSystem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeFileSystemsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEMS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<FileSystem> fileSystems;

    private final String nextToken;

    private DescribeFileSystemsResponse(BuilderImpl builder) {
        super(builder);
        this.fileSystems = builder.fileSystems;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the FileSystems property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFileSystems() {
        return fileSystems != null && !(fileSystems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of file system descriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFileSystems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of file system descriptions.
     */
    public final List<FileSystem> fileSystems() {
        return fileSystems;
    }

    /**
     * <p>
     * Present if there are more file systems than returned in the response (String). You can use the
     * <code>NextToken</code> value in the later request to fetch the descriptions.
     * </p>
     * 
     * @return Present if there are more file systems than returned in the response (String). You can use the
     *         <code>NextToken</code> value in the later request to fetch the descriptions.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFileSystems() ? fileSystems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFileSystemsResponse)) {
            return false;
        }
        DescribeFileSystemsResponse other = (DescribeFileSystemsResponse) obj;
        return hasFileSystems() == other.hasFileSystems() && Objects.equals(fileSystems(), other.fileSystems())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFileSystemsResponse").add("FileSystems", hasFileSystems() ? fileSystems() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileSystems":
            return Optional.ofNullable(clazz.cast(fileSystems()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFileSystemsResponse, T> g) {
        return obj -> g.apply((DescribeFileSystemsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFileSystemsResponse> {
        /**
         * <p>
         * An array of file system descriptions.
         * </p>
         * 
         * @param fileSystems
         *        An array of file system descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystems(Collection<FileSystem> fileSystems);

        /**
         * <p>
         * An array of file system descriptions.
         * </p>
         * 
         * @param fileSystems
         *        An array of file system descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystems(FileSystem... fileSystems);

        /**
         * <p>
         * An array of file system descriptions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FileSystem>.Builder} avoiding the need to
         * create one manually via {@link List<FileSystem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FileSystem>.Builder#build()} is called immediately and its
         * result is passed to {@link #fileSystems(List<FileSystem>)}.
         * 
         * @param fileSystems
         *        a consumer that will call methods on {@link List<FileSystem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileSystems(List<FileSystem>)
         */
        Builder fileSystems(Consumer<FileSystem.Builder>... fileSystems);

        /**
         * <p>
         * Present if there are more file systems than returned in the response (String). You can use the
         * <code>NextToken</code> value in the later request to fetch the descriptions.
         * </p>
         * 
         * @param nextToken
         *        Present if there are more file systems than returned in the response (String). You can use the
         *        <code>NextToken</code> value in the later request to fetch the descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FSxResponse.BuilderImpl implements Builder {
        private List<FileSystem> fileSystems = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFileSystemsResponse model) {
            super(model);
            fileSystems(model.fileSystems);
            nextToken(model.nextToken);
        }

        public final List<FileSystem.Builder> getFileSystems() {
            List<FileSystem.Builder> result = FileSystemsCopier.copyToBuilder(this.fileSystems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder fileSystems(Collection<FileSystem> fileSystems) {
            this.fileSystems = FileSystemsCopier.copy(fileSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystems(FileSystem... fileSystems) {
            fileSystems(Arrays.asList(fileSystems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystems(Consumer<FileSystem.Builder>... fileSystems) {
            fileSystems(Stream.of(fileSystems).map(c -> FileSystem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFileSystems(Collection<FileSystem.BuilderImpl> fileSystems) {
            this.fileSystems = FileSystemsCopier.copyFromBuilder(fileSystems);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeFileSystemsResponse build() {
            return new DescribeFileSystemsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
