/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a data repository association's automatic export policy. The <code>AutoExportPolicy</code> defines the
 * types of updated objects on the file system that will be automatically exported to the data repository. As you
 * create, modify, or delete files, Amazon FSx automatically exports the defined changes asynchronously once your
 * application finishes modifying the file.
 * </p>
 * <p>
 * This <code>AutoExportPolicy</code> is supported only for file systems with the <code>Persistent_2</code> deployment
 * type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoExportPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoExportPolicy.Builder, AutoExportPolicy> {
    private static final SdkField<List<String>> EVENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Events")
            .getter(getter(AutoExportPolicy::eventsAsStrings))
            .setter(setter(Builder::eventsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> events;

    private AutoExportPolicy(BuilderImpl builder) {
        this.events = builder.events;
    }

    /**
     * <p>
     * The <code>AutoExportPolicy</code> can have the following event values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NEW</code> - Amazon FSx automatically exports new files and directories to the data repository as they are
     * added to the file system.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CHANGED</code> - Amazon FSx automatically exports changes to files and directories on the file system to
     * the data repository.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> - Files and directories are automatically deleted on the data repository when they are
     * deleted on the file system.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can define any combination of event types for your <code>AutoExportPolicy</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvents} method.
     * </p>
     * 
     * @return The <code>AutoExportPolicy</code> can have the following event values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NEW</code> - Amazon FSx automatically exports new files and directories to the data repository as
     *         they are added to the file system.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CHANGED</code> - Amazon FSx automatically exports changes to files and directories on the file
     *         system to the data repository.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code> - Files and directories are automatically deleted on the data repository when they
     *         are deleted on the file system.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can define any combination of event types for your <code>AutoExportPolicy</code>.
     */
    public final List<EventType> events() {
        return EventTypesCopier.copyStringToEnum(events);
    }

    /**
     * For responses, this returns true if the service returned a value for the Events property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <code>AutoExportPolicy</code> can have the following event values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NEW</code> - Amazon FSx automatically exports new files and directories to the data repository as they are
     * added to the file system.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CHANGED</code> - Amazon FSx automatically exports changes to files and directories on the file system to
     * the data repository.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> - Files and directories are automatically deleted on the data repository when they are
     * deleted on the file system.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can define any combination of event types for your <code>AutoExportPolicy</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvents} method.
     * </p>
     * 
     * @return The <code>AutoExportPolicy</code> can have the following event values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NEW</code> - Amazon FSx automatically exports new files and directories to the data repository as
     *         they are added to the file system.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CHANGED</code> - Amazon FSx automatically exports changes to files and directories on the file
     *         system to the data repository.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code> - Files and directories are automatically deleted on the data repository when they
     *         are deleted on the file system.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can define any combination of event types for your <code>AutoExportPolicy</code>.
     */
    public final List<String> eventsAsStrings() {
        return events;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEvents() ? eventsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoExportPolicy)) {
            return false;
        }
        AutoExportPolicy other = (AutoExportPolicy) obj;
        return hasEvents() == other.hasEvents() && Objects.equals(eventsAsStrings(), other.eventsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoExportPolicy").add("Events", hasEvents() ? eventsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Events":
            return Optional.ofNullable(clazz.cast(eventsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoExportPolicy, T> g) {
        return obj -> g.apply((AutoExportPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoExportPolicy> {
        /**
         * <p>
         * The <code>AutoExportPolicy</code> can have the following event values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NEW</code> - Amazon FSx automatically exports new files and directories to the data repository as they
         * are added to the file system.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CHANGED</code> - Amazon FSx automatically exports changes to files and directories on the file system
         * to the data repository.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code> - Files and directories are automatically deleted on the data repository when they are
         * deleted on the file system.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can define any combination of event types for your <code>AutoExportPolicy</code>.
         * </p>
         * 
         * @param events
         *        The <code>AutoExportPolicy</code> can have the following event values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NEW</code> - Amazon FSx automatically exports new files and directories to the data repository
         *        as they are added to the file system.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHANGED</code> - Amazon FSx automatically exports changes to files and directories on the file
         *        system to the data repository.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code> - Files and directories are automatically deleted on the data repository when
         *        they are deleted on the file system.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can define any combination of event types for your <code>AutoExportPolicy</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventsWithStrings(Collection<String> events);

        /**
         * <p>
         * The <code>AutoExportPolicy</code> can have the following event values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NEW</code> - Amazon FSx automatically exports new files and directories to the data repository as they
         * are added to the file system.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CHANGED</code> - Amazon FSx automatically exports changes to files and directories on the file system
         * to the data repository.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code> - Files and directories are automatically deleted on the data repository when they are
         * deleted on the file system.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can define any combination of event types for your <code>AutoExportPolicy</code>.
         * </p>
         * 
         * @param events
         *        The <code>AutoExportPolicy</code> can have the following event values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NEW</code> - Amazon FSx automatically exports new files and directories to the data repository
         *        as they are added to the file system.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHANGED</code> - Amazon FSx automatically exports changes to files and directories on the file
         *        system to the data repository.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code> - Files and directories are automatically deleted on the data repository when
         *        they are deleted on the file system.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can define any combination of event types for your <code>AutoExportPolicy</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventsWithStrings(String... events);

        /**
         * <p>
         * The <code>AutoExportPolicy</code> can have the following event values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NEW</code> - Amazon FSx automatically exports new files and directories to the data repository as they
         * are added to the file system.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CHANGED</code> - Amazon FSx automatically exports changes to files and directories on the file system
         * to the data repository.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code> - Files and directories are automatically deleted on the data repository when they are
         * deleted on the file system.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can define any combination of event types for your <code>AutoExportPolicy</code>.
         * </p>
         * 
         * @param events
         *        The <code>AutoExportPolicy</code> can have the following event values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NEW</code> - Amazon FSx automatically exports new files and directories to the data repository
         *        as they are added to the file system.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHANGED</code> - Amazon FSx automatically exports changes to files and directories on the file
         *        system to the data repository.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code> - Files and directories are automatically deleted on the data repository when
         *        they are deleted on the file system.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can define any combination of event types for your <code>AutoExportPolicy</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<EventType> events);

        /**
         * <p>
         * The <code>AutoExportPolicy</code> can have the following event values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NEW</code> - Amazon FSx automatically exports new files and directories to the data repository as they
         * are added to the file system.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CHANGED</code> - Amazon FSx automatically exports changes to files and directories on the file system
         * to the data repository.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code> - Files and directories are automatically deleted on the data repository when they are
         * deleted on the file system.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can define any combination of event types for your <code>AutoExportPolicy</code>.
         * </p>
         * 
         * @param events
         *        The <code>AutoExportPolicy</code> can have the following event values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NEW</code> - Amazon FSx automatically exports new files and directories to the data repository
         *        as they are added to the file system.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHANGED</code> - Amazon FSx automatically exports changes to files and directories on the file
         *        system to the data repository.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code> - Files and directories are automatically deleted on the data repository when
         *        they are deleted on the file system.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can define any combination of event types for your <code>AutoExportPolicy</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(EventType... events);
    }

    static final class BuilderImpl implements Builder {
        private List<String> events = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoExportPolicy model) {
            eventsWithStrings(model.events);
        }

        public final Collection<String> getEvents() {
            if (events instanceof SdkAutoConstructList) {
                return null;
            }
            return events;
        }

        public final void setEvents(Collection<String> events) {
            this.events = EventTypesCopier.copy(events);
        }

        @Override
        @Transient
        public final Builder eventsWithStrings(Collection<String> events) {
            this.events = EventTypesCopier.copy(events);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventsWithStrings(String... events) {
            eventsWithStrings(Arrays.asList(events));
            return this;
        }

        @Override
        @Transient
        public final Builder events(Collection<EventType> events) {
            this.events = EventTypesCopier.copyEnumToString(events);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder events(EventType... events) {
            events(Arrays.asList(events));
            return this;
        }

        @Override
        public AutoExportPolicy build() {
            return new AutoExportPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
