/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request object for the <code>CreateBackup</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBackupRequest extends FSxRequest implements
        ToCopyableBuilder<CreateBackupRequest.Builder, CreateBackupRequest> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemId").getter(getter(CreateBackupRequest::fileSystemId)).setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateBackupRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateBackupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeId").getter(getter(CreateBackupRequest::volumeId)).setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD, VOLUME_ID_FIELD));

    private final String fileSystemId;

    private final String clientRequestToken;

    private final List<Tag> tags;

    private final String volumeId;

    private CreateBackupRequest(BuilderImpl builder) {
        super(builder);
        this.fileSystemId = builder.fileSystemId;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
        this.volumeId = builder.volumeId;
    }

    /**
     * <p>
     * The ID of the file system to back up.
     * </p>
     * 
     * @return The ID of the file system to back up.
     */
    public final String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation. This string
     * is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services
     * SDK.
     * </p>
     * 
     * @return (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation. This
     *         string is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon
     *         Web Services SDK.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Optional) The tags to apply to the backup at backup creation. The key value of the <code>Name</code> tag appears
     * in the console as the backup name. If you have set <code>CopyTagsToBackups</code> to <code>true</code>, and you
     * specify one or more tags using the <code>CreateBackup</code> operation, no existing file system tags are copied
     * from the file system to the backup.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return (Optional) The tags to apply to the backup at backup creation. The key value of the <code>Name</code> tag
     *         appears in the console as the backup name. If you have set <code>CopyTagsToBackups</code> to
     *         <code>true</code>, and you specify one or more tags using the <code>CreateBackup</code> operation, no
     *         existing file system tags are copied from the file system to the backup.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * (Optional) The ID of the FSx for ONTAP volume to back up.
     * </p>
     * 
     * @return (Optional) The ID of the FSx for ONTAP volume to back up.
     */
    public final String volumeId() {
        return volumeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackupRequest)) {
            return false;
        }
        CreateBackupRequest other = (CreateBackupRequest) obj;
        return Objects.equals(fileSystemId(), other.fileSystemId())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(volumeId(), other.volumeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBackupRequest").add("FileSystemId", fileSystemId())
                .add("ClientRequestToken", clientRequestToken()).add("Tags", hasTags() ? tags() : null)
                .add("VolumeId", volumeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBackupRequest, T> g) {
        return obj -> g.apply((CreateBackupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateBackupRequest> {
        /**
         * <p>
         * The ID of the file system to back up.
         * </p>
         * 
         * @param fileSystemId
         *        The ID of the file system to back up.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation. This
         * string is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web
         * Services SDK.
         * </p>
         * 
         * @param clientRequestToken
         *        (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation.
         *        This string is automatically filled on your behalf when you use the Command Line Interface (CLI) or an
         *        Amazon Web Services SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * (Optional) The tags to apply to the backup at backup creation. The key value of the <code>Name</code> tag
         * appears in the console as the backup name. If you have set <code>CopyTagsToBackups</code> to
         * <code>true</code>, and you specify one or more tags using the <code>CreateBackup</code> operation, no
         * existing file system tags are copied from the file system to the backup.
         * </p>
         * 
         * @param tags
         *        (Optional) The tags to apply to the backup at backup creation. The key value of the <code>Name</code>
         *        tag appears in the console as the backup name. If you have set <code>CopyTagsToBackups</code> to
         *        <code>true</code>, and you specify one or more tags using the <code>CreateBackup</code> operation, no
         *        existing file system tags are copied from the file system to the backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * (Optional) The tags to apply to the backup at backup creation. The key value of the <code>Name</code> tag
         * appears in the console as the backup name. If you have set <code>CopyTagsToBackups</code> to
         * <code>true</code>, and you specify one or more tags using the <code>CreateBackup</code> operation, no
         * existing file system tags are copied from the file system to the backup.
         * </p>
         * 
         * @param tags
         *        (Optional) The tags to apply to the backup at backup creation. The key value of the <code>Name</code>
         *        tag appears in the console as the backup name. If you have set <code>CopyTagsToBackups</code> to
         *        <code>true</code>, and you specify one or more tags using the <code>CreateBackup</code> operation, no
         *        existing file system tags are copied from the file system to the backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * (Optional) The tags to apply to the backup at backup creation. The key value of the <code>Name</code> tag
         * appears in the console as the backup name. If you have set <code>CopyTagsToBackups</code> to
         * <code>true</code>, and you specify one or more tags using the <code>CreateBackup</code> operation, no
         * existing file system tags are copied from the file system to the backup.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * (Optional) The ID of the FSx for ONTAP volume to back up.
         * </p>
         * 
         * @param volumeId
         *        (Optional) The ID of the FSx for ONTAP volume to back up.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FSxRequest.BuilderImpl implements Builder {
        private String fileSystemId;

        private String clientRequestToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String volumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackupRequest model) {
            super(model);
            fileSystemId(model.fileSystemId);
            clientRequestToken(model.clientRequestToken);
            tags(model.tags);
            volumeId(model.volumeId);
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        @Transient
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        @Transient
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBackupRequest build() {
            return new CreateBackupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
