/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataRepositoryAssociationRequest extends FSxRequest implements
        ToCopyableBuilder<CreateDataRepositoryAssociationRequest.Builder, CreateDataRepositoryAssociationRequest> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemId").getter(getter(CreateDataRepositoryAssociationRequest::fileSystemId))
            .setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()).build();

    private static final SdkField<String> FILE_SYSTEM_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemPath").getter(getter(CreateDataRepositoryAssociationRequest::fileSystemPath))
            .setter(setter(Builder::fileSystemPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemPath").build()).build();

    private static final SdkField<String> DATA_REPOSITORY_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataRepositoryPath").getter(getter(CreateDataRepositoryAssociationRequest::dataRepositoryPath))
            .setter(setter(Builder::dataRepositoryPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRepositoryPath").build())
            .build();

    private static final SdkField<Boolean> BATCH_IMPORT_META_DATA_ON_CREATE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("BatchImportMetaDataOnCreate")
            .getter(getter(CreateDataRepositoryAssociationRequest::batchImportMetaDataOnCreate))
            .setter(setter(Builder::batchImportMetaDataOnCreate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchImportMetaDataOnCreate")
                    .build()).build();

    private static final SdkField<Integer> IMPORTED_FILE_CHUNK_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ImportedFileChunkSize").getter(getter(CreateDataRepositoryAssociationRequest::importedFileChunkSize))
            .setter(setter(Builder::importedFileChunkSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportedFileChunkSize").build())
            .build();

    private static final SdkField<S3DataRepositoryConfiguration> S3_FIELD = SdkField
            .<S3DataRepositoryConfiguration> builder(MarshallingType.SDK_POJO).memberName("S3")
            .getter(getter(CreateDataRepositoryAssociationRequest::s3)).setter(setter(Builder::s3))
            .constructor(S3DataRepositoryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateDataRepositoryAssociationRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateDataRepositoryAssociationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD,
            FILE_SYSTEM_PATH_FIELD, DATA_REPOSITORY_PATH_FIELD, BATCH_IMPORT_META_DATA_ON_CREATE_FIELD,
            IMPORTED_FILE_CHUNK_SIZE_FIELD, S3_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD));

    private final String fileSystemId;

    private final String fileSystemPath;

    private final String dataRepositoryPath;

    private final Boolean batchImportMetaDataOnCreate;

    private final Integer importedFileChunkSize;

    private final S3DataRepositoryConfiguration s3;

    private final String clientRequestToken;

    private final List<Tag> tags;

    private CreateDataRepositoryAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.fileSystemId = builder.fileSystemId;
        this.fileSystemPath = builder.fileSystemPath;
        this.dataRepositoryPath = builder.dataRepositoryPath;
        this.batchImportMetaDataOnCreate = builder.batchImportMetaDataOnCreate;
        this.importedFileChunkSize = builder.importedFileChunkSize;
        this.s3 = builder.s3;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    /**
     * Returns the value of the FileSystemId property for this object.
     * 
     * @return The value of the FileSystemId property for this object.
     */
    public final String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * A path on the file system that points to a high-level directory (such as <code>/ns1/</code>) or subdirectory
     * (such as <code>/ns1/subdir/</code>) that will be mapped 1-1 with <code>DataRepositoryPath</code>. The leading
     * forward slash in the name is required. Two data repository associations cannot have overlapping file system
     * paths. For example, if a data repository is associated with file system path <code>/ns1/</code>, then you cannot
     * link another data repository with file system path <code>/ns1/ns2</code>.
     * </p>
     * <p>
     * This path specifies where in your file system files will be exported from or imported to. This file system
     * directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.
     * </p>
     * 
     * @return A path on the file system that points to a high-level directory (such as <code>/ns1/</code>) or
     *         subdirectory (such as <code>/ns1/subdir/</code>) that will be mapped 1-1 with
     *         <code>DataRepositoryPath</code>. The leading forward slash in the name is required. Two data repository
     *         associations cannot have overlapping file system paths. For example, if a data repository is associated
     *         with file system path <code>/ns1/</code>, then you cannot link another data repository with file system
     *         path <code>/ns1/ns2</code>.</p>
     *         <p>
     *         This path specifies where in your file system files will be exported from or imported to. This file
     *         system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the
     *         directory.
     */
    public final String fileSystemPath() {
        return fileSystemPath;
    }

    /**
     * <p>
     * The path to the Amazon S3 data repository that will be linked to the file system. The path can be an S3 bucket or
     * prefix in the format <code>s3://myBucket/myPrefix/</code>. This path specifies where in the S3 data repository
     * files will be imported from or exported to.
     * </p>
     * 
     * @return The path to the Amazon S3 data repository that will be linked to the file system. The path can be an S3
     *         bucket or prefix in the format <code>s3://myBucket/myPrefix/</code>. This path specifies where in the S3
     *         data repository files will be imported from or exported to.
     */
    public final String dataRepositoryPath() {
        return dataRepositoryPath;
    }

    /**
     * <p>
     * Set to <code>true</code> to run an import data repository task to import metadata from the data repository to the
     * file system after the data repository association is created. Default is <code>false</code>.
     * </p>
     * 
     * @return Set to <code>true</code> to run an import data repository task to import metadata from the data
     *         repository to the file system after the data repository association is created. Default is
     *         <code>false</code>.
     */
    public final Boolean batchImportMetaDataOnCreate() {
        return batchImportMetaDataOnCreate;
    }

    /**
     * <p>
     * For files imported from a data repository, this value determines the stripe count and maximum amount of data per
     * file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped
     * across is limited by the total number of disks that make up the file system.
     * </p>
     * <p>
     * The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a
     * maximum size of 5 TB.
     * </p>
     * 
     * @return For files imported from a data repository, this value determines the stripe count and maximum amount of
     *         data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file
     *         can be striped across is limited by the total number of disks that make up the file system.</p>
     *         <p>
     *         The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3
     *         objects have a maximum size of 5 TB.
     */
    public final Integer importedFileChunkSize() {
        return importedFileChunkSize;
    }

    /**
     * <p>
     * The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data
     * repository association. The configuration defines which file events (new, changed, or deleted files or
     * directories) are automatically imported from the linked data repository to the file system or automatically
     * exported from the file system to the data repository.
     * </p>
     * 
     * @return The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data
     *         repository association. The configuration defines which file events (new, changed, or deleted files or
     *         directories) are automatically imported from the linked data repository to the file system or
     *         automatically exported from the file system to the data repository.
     */
    public final S3DataRepositoryConfiguration s3() {
        return s3;
    }

    /**
     * Returns the value of the ClientRequestToken property for this object.
     * 
     * @return The value of the ClientRequestToken property for this object.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemPath());
        hashCode = 31 * hashCode + Objects.hashCode(dataRepositoryPath());
        hashCode = 31 * hashCode + Objects.hashCode(batchImportMetaDataOnCreate());
        hashCode = 31 * hashCode + Objects.hashCode(importedFileChunkSize());
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataRepositoryAssociationRequest)) {
            return false;
        }
        CreateDataRepositoryAssociationRequest other = (CreateDataRepositoryAssociationRequest) obj;
        return Objects.equals(fileSystemId(), other.fileSystemId()) && Objects.equals(fileSystemPath(), other.fileSystemPath())
                && Objects.equals(dataRepositoryPath(), other.dataRepositoryPath())
                && Objects.equals(batchImportMetaDataOnCreate(), other.batchImportMetaDataOnCreate())
                && Objects.equals(importedFileChunkSize(), other.importedFileChunkSize()) && Objects.equals(s3(), other.s3())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataRepositoryAssociationRequest").add("FileSystemId", fileSystemId())
                .add("FileSystemPath", fileSystemPath()).add("DataRepositoryPath", dataRepositoryPath())
                .add("BatchImportMetaDataOnCreate", batchImportMetaDataOnCreate())
                .add("ImportedFileChunkSize", importedFileChunkSize()).add("S3", s3())
                .add("ClientRequestToken", clientRequestToken()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "FileSystemPath":
            return Optional.ofNullable(clazz.cast(fileSystemPath()));
        case "DataRepositoryPath":
            return Optional.ofNullable(clazz.cast(dataRepositoryPath()));
        case "BatchImportMetaDataOnCreate":
            return Optional.ofNullable(clazz.cast(batchImportMetaDataOnCreate()));
        case "ImportedFileChunkSize":
            return Optional.ofNullable(clazz.cast(importedFileChunkSize()));
        case "S3":
            return Optional.ofNullable(clazz.cast(s3()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataRepositoryAssociationRequest, T> g) {
        return obj -> g.apply((CreateDataRepositoryAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDataRepositoryAssociationRequest> {
        /**
         * Sets the value of the FileSystemId property for this object.
         *
         * @param fileSystemId
         *        The new value for the FileSystemId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * A path on the file system that points to a high-level directory (such as <code>/ns1/</code>) or subdirectory
         * (such as <code>/ns1/subdir/</code>) that will be mapped 1-1 with <code>DataRepositoryPath</code>. The leading
         * forward slash in the name is required. Two data repository associations cannot have overlapping file system
         * paths. For example, if a data repository is associated with file system path <code>/ns1/</code>, then you
         * cannot link another data repository with file system path <code>/ns1/ns2</code>.
         * </p>
         * <p>
         * This path specifies where in your file system files will be exported from or imported to. This file system
         * directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.
         * </p>
         * 
         * @param fileSystemPath
         *        A path on the file system that points to a high-level directory (such as <code>/ns1/</code>) or
         *        subdirectory (such as <code>/ns1/subdir/</code>) that will be mapped 1-1 with
         *        <code>DataRepositoryPath</code>. The leading forward slash in the name is required. Two data
         *        repository associations cannot have overlapping file system paths. For example, if a data repository
         *        is associated with file system path <code>/ns1/</code>, then you cannot link another data repository
         *        with file system path <code>/ns1/ns2</code>.</p>
         *        <p>
         *        This path specifies where in your file system files will be exported from or imported to. This file
         *        system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to
         *        the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemPath(String fileSystemPath);

        /**
         * <p>
         * The path to the Amazon S3 data repository that will be linked to the file system. The path can be an S3
         * bucket or prefix in the format <code>s3://myBucket/myPrefix/</code>. This path specifies where in the S3 data
         * repository files will be imported from or exported to.
         * </p>
         * 
         * @param dataRepositoryPath
         *        The path to the Amazon S3 data repository that will be linked to the file system. The path can be an
         *        S3 bucket or prefix in the format <code>s3://myBucket/myPrefix/</code>. This path specifies where in
         *        the S3 data repository files will be imported from or exported to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataRepositoryPath(String dataRepositoryPath);

        /**
         * <p>
         * Set to <code>true</code> to run an import data repository task to import metadata from the data repository to
         * the file system after the data repository association is created. Default is <code>false</code>.
         * </p>
         * 
         * @param batchImportMetaDataOnCreate
         *        Set to <code>true</code> to run an import data repository task to import metadata from the data
         *        repository to the file system after the data repository association is created. Default is
         *        <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchImportMetaDataOnCreate(Boolean batchImportMetaDataOnCreate);

        /**
         * <p>
         * For files imported from a data repository, this value determines the stripe count and maximum amount of data
         * per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be
         * striped across is limited by the total number of disks that make up the file system.
         * </p>
         * <p>
         * The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects
         * have a maximum size of 5 TB.
         * </p>
         * 
         * @param importedFileChunkSize
         *        For files imported from a data repository, this value determines the stripe count and maximum amount
         *        of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single
         *        file can be striped across is limited by the total number of disks that make up the file system.</p>
         *        <p>
         *        The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3
         *        objects have a maximum size of 5 TB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedFileChunkSize(Integer importedFileChunkSize);

        /**
         * <p>
         * The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data
         * repository association. The configuration defines which file events (new, changed, or deleted files or
         * directories) are automatically imported from the linked data repository to the file system or automatically
         * exported from the file system to the data repository.
         * </p>
         * 
         * @param s3
         *        The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a
         *        data repository association. The configuration defines which file events (new, changed, or deleted
         *        files or directories) are automatically imported from the linked data repository to the file system or
         *        automatically exported from the file system to the data repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(S3DataRepositoryConfiguration s3);

        /**
         * <p>
         * The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data
         * repository association. The configuration defines which file events (new, changed, or deleted files or
         * directories) are automatically imported from the linked data repository to the file system or automatically
         * exported from the file system to the data repository.
         * </p>
         * This is a convenience that creates an instance of the {@link S3DataRepositoryConfiguration.Builder} avoiding
         * the need to create one manually via {@link S3DataRepositoryConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3DataRepositoryConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #s3(S3DataRepositoryConfiguration)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link S3DataRepositoryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(S3DataRepositoryConfiguration)
         */
        default Builder s3(Consumer<S3DataRepositoryConfiguration.Builder> s3) {
            return s3(S3DataRepositoryConfiguration.builder().applyMutation(s3).build());
        }

        /**
         * Sets the value of the ClientRequestToken property for this object.
         *
         * @param clientRequestToken
         *        The new value for the ClientRequestToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FSxRequest.BuilderImpl implements Builder {
        private String fileSystemId;

        private String fileSystemPath;

        private String dataRepositoryPath;

        private Boolean batchImportMetaDataOnCreate;

        private Integer importedFileChunkSize;

        private S3DataRepositoryConfiguration s3;

        private String clientRequestToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataRepositoryAssociationRequest model) {
            super(model);
            fileSystemId(model.fileSystemId);
            fileSystemPath(model.fileSystemPath);
            dataRepositoryPath(model.dataRepositoryPath);
            batchImportMetaDataOnCreate(model.batchImportMetaDataOnCreate);
            importedFileChunkSize(model.importedFileChunkSize);
            s3(model.s3);
            clientRequestToken(model.clientRequestToken);
            tags(model.tags);
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        @Transient
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getFileSystemPath() {
            return fileSystemPath;
        }

        public final void setFileSystemPath(String fileSystemPath) {
            this.fileSystemPath = fileSystemPath;
        }

        @Override
        @Transient
        public final Builder fileSystemPath(String fileSystemPath) {
            this.fileSystemPath = fileSystemPath;
            return this;
        }

        public final String getDataRepositoryPath() {
            return dataRepositoryPath;
        }

        public final void setDataRepositoryPath(String dataRepositoryPath) {
            this.dataRepositoryPath = dataRepositoryPath;
        }

        @Override
        @Transient
        public final Builder dataRepositoryPath(String dataRepositoryPath) {
            this.dataRepositoryPath = dataRepositoryPath;
            return this;
        }

        public final Boolean getBatchImportMetaDataOnCreate() {
            return batchImportMetaDataOnCreate;
        }

        public final void setBatchImportMetaDataOnCreate(Boolean batchImportMetaDataOnCreate) {
            this.batchImportMetaDataOnCreate = batchImportMetaDataOnCreate;
        }

        @Override
        @Transient
        public final Builder batchImportMetaDataOnCreate(Boolean batchImportMetaDataOnCreate) {
            this.batchImportMetaDataOnCreate = batchImportMetaDataOnCreate;
            return this;
        }

        public final Integer getImportedFileChunkSize() {
            return importedFileChunkSize;
        }

        public final void setImportedFileChunkSize(Integer importedFileChunkSize) {
            this.importedFileChunkSize = importedFileChunkSize;
        }

        @Override
        @Transient
        public final Builder importedFileChunkSize(Integer importedFileChunkSize) {
            this.importedFileChunkSize = importedFileChunkSize;
            return this;
        }

        public final S3DataRepositoryConfiguration.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        public final void setS3(S3DataRepositoryConfiguration.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        @Transient
        public final Builder s3(S3DataRepositoryConfiguration s3) {
            this.s3 = s3;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataRepositoryAssociationRequest build() {
            return new CreateDataRepositoryAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
