/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDataRepositoryAssociationResponse extends FSxResponse implements
        ToCopyableBuilder<DeleteDataRepositoryAssociationResponse.Builder, DeleteDataRepositoryAssociationResponse> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationId").getter(getter(DeleteDataRepositoryAssociationResponse::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()).build();

    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Lifecycle").getter(getter(DeleteDataRepositoryAssociationResponse::lifecycleAsString))
            .setter(setter(Builder::lifecycle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()).build();

    private static final SdkField<Boolean> DELETE_DATA_IN_FILE_SYSTEM_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteDataInFileSystem").getter(getter(DeleteDataRepositoryAssociationResponse::deleteDataInFileSystem))
            .setter(setter(Builder::deleteDataInFileSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteDataInFileSystem").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD,
            LIFECYCLE_FIELD, DELETE_DATA_IN_FILE_SYSTEM_FIELD));

    private final String associationId;

    private final String lifecycle;

    private final Boolean deleteDataInFileSystem;

    private DeleteDataRepositoryAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.associationId = builder.associationId;
        this.lifecycle = builder.lifecycle;
        this.deleteDataInFileSystem = builder.deleteDataInFileSystem;
    }

    /**
     * <p>
     * The ID of the data repository association being deleted.
     * </p>
     * 
     * @return The ID of the data repository association being deleted.
     */
    public final String associationId() {
        return associationId;
    }

    /**
     * <p>
     * Describes the lifecycle state of the data repository association being deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link DataRepositoryLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifecycleAsString}.
     * </p>
     * 
     * @return Describes the lifecycle state of the data repository association being deleted.
     * @see DataRepositoryLifecycle
     */
    public final DataRepositoryLifecycle lifecycle() {
        return DataRepositoryLifecycle.fromValue(lifecycle);
    }

    /**
     * <p>
     * Describes the lifecycle state of the data repository association being deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link DataRepositoryLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifecycleAsString}.
     * </p>
     * 
     * @return Describes the lifecycle state of the data repository association being deleted.
     * @see DataRepositoryLifecycle
     */
    public final String lifecycleAsString() {
        return lifecycle;
    }

    /**
     * <p>
     * Indicates whether data in the file system that corresponds to the data repository association is being deleted.
     * Default is <code>false</code>.
     * </p>
     * 
     * @return Indicates whether data in the file system that corresponds to the data repository association is being
     *         deleted. Default is <code>false</code>.
     */
    public final Boolean deleteDataInFileSystem() {
        return deleteDataInFileSystem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deleteDataInFileSystem());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDataRepositoryAssociationResponse)) {
            return false;
        }
        DeleteDataRepositoryAssociationResponse other = (DeleteDataRepositoryAssociationResponse) obj;
        return Objects.equals(associationId(), other.associationId())
                && Objects.equals(lifecycleAsString(), other.lifecycleAsString())
                && Objects.equals(deleteDataInFileSystem(), other.deleteDataInFileSystem());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteDataRepositoryAssociationResponse").add("AssociationId", associationId())
                .add("Lifecycle", lifecycleAsString()).add("DeleteDataInFileSystem", deleteDataInFileSystem()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycleAsString()));
        case "DeleteDataInFileSystem":
            return Optional.ofNullable(clazz.cast(deleteDataInFileSystem()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDataRepositoryAssociationResponse, T> g) {
        return obj -> g.apply((DeleteDataRepositoryAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteDataRepositoryAssociationResponse> {
        /**
         * <p>
         * The ID of the data repository association being deleted.
         * </p>
         * 
         * @param associationId
         *        The ID of the data repository association being deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * Describes the lifecycle state of the data repository association being deleted.
         * </p>
         * 
         * @param lifecycle
         *        Describes the lifecycle state of the data repository association being deleted.
         * @see DataRepositoryLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataRepositoryLifecycle
         */
        Builder lifecycle(String lifecycle);

        /**
         * <p>
         * Describes the lifecycle state of the data repository association being deleted.
         * </p>
         * 
         * @param lifecycle
         *        Describes the lifecycle state of the data repository association being deleted.
         * @see DataRepositoryLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataRepositoryLifecycle
         */
        Builder lifecycle(DataRepositoryLifecycle lifecycle);

        /**
         * <p>
         * Indicates whether data in the file system that corresponds to the data repository association is being
         * deleted. Default is <code>false</code>.
         * </p>
         * 
         * @param deleteDataInFileSystem
         *        Indicates whether data in the file system that corresponds to the data repository association is being
         *        deleted. Default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteDataInFileSystem(Boolean deleteDataInFileSystem);
    }

    static final class BuilderImpl extends FSxResponse.BuilderImpl implements Builder {
        private String associationId;

        private String lifecycle;

        private Boolean deleteDataInFileSystem;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDataRepositoryAssociationResponse model) {
            super(model);
            associationId(model.associationId);
            lifecycle(model.lifecycle);
            deleteDataInFileSystem(model.deleteDataInFileSystem);
        }

        public final String getAssociationId() {
            return associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        @Transient
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getLifecycle() {
            return lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        @Transient
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        @Transient
        public final Builder lifecycle(DataRepositoryLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final Boolean getDeleteDataInFileSystem() {
            return deleteDataInFileSystem;
        }

        public final void setDeleteDataInFileSystem(Boolean deleteDataInFileSystem) {
            this.deleteDataInFileSystem = deleteDataInFileSystem;
        }

        @Override
        @Transient
        public final Builder deleteDataInFileSystem(Boolean deleteDataInFileSystem) {
            this.deleteDataInFileSystem = deleteDataInFileSystem;
            return this;
        }

        @Override
        public DeleteDataRepositoryAssociationResponse build() {
            return new DeleteDataRepositoryAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
