/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDataRepositoryAssociationsResponse extends FSxResponse implements
        ToCopyableBuilder<DescribeDataRepositoryAssociationsResponse.Builder, DescribeDataRepositoryAssociationsResponse> {
    private static final SdkField<List<DataRepositoryAssociation>> ASSOCIATIONS_FIELD = SdkField
            .<List<DataRepositoryAssociation>> builder(MarshallingType.LIST)
            .memberName("Associations")
            .getter(getter(DescribeDataRepositoryAssociationsResponse::associations))
            .setter(setter(Builder::associations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Associations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataRepositoryAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataRepositoryAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeDataRepositoryAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DataRepositoryAssociation> associations;

    private final String nextToken;

    private DescribeDataRepositoryAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.associations = builder.associations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Associations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociations() {
        return associations != null && !(associations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of one ore more data repository association descriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociations} method.
     * </p>
     * 
     * @return An array of one ore more data repository association descriptions.
     */
    public final List<DataRepositoryAssociation> associations() {
        return associations;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociations() ? associations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataRepositoryAssociationsResponse)) {
            return false;
        }
        DescribeDataRepositoryAssociationsResponse other = (DescribeDataRepositoryAssociationsResponse) obj;
        return hasAssociations() == other.hasAssociations() && Objects.equals(associations(), other.associations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDataRepositoryAssociationsResponse")
                .add("Associations", hasAssociations() ? associations() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Associations":
            return Optional.ofNullable(clazz.cast(associations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDataRepositoryAssociationsResponse, T> g) {
        return obj -> g.apply((DescribeDataRepositoryAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDataRepositoryAssociationsResponse> {
        /**
         * <p>
         * An array of one ore more data repository association descriptions.
         * </p>
         * 
         * @param associations
         *        An array of one ore more data repository association descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(Collection<DataRepositoryAssociation> associations);

        /**
         * <p>
         * An array of one ore more data repository association descriptions.
         * </p>
         * 
         * @param associations
         *        An array of one ore more data repository association descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(DataRepositoryAssociation... associations);

        /**
         * <p>
         * An array of one ore more data repository association descriptions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DataRepositoryAssociation>.Builder}
         * avoiding the need to create one manually via {@link List<DataRepositoryAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataRepositoryAssociation>.Builder#build()} is called
         * immediately and its result is passed to {@link #associations(List<DataRepositoryAssociation>)}.
         * 
         * @param associations
         *        a consumer that will call methods on {@link List<DataRepositoryAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associations(List<DataRepositoryAssociation>)
         */
        Builder associations(Consumer<DataRepositoryAssociation.Builder>... associations);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FSxResponse.BuilderImpl implements Builder {
        private List<DataRepositoryAssociation> associations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataRepositoryAssociationsResponse model) {
            super(model);
            associations(model.associations);
            nextToken(model.nextToken);
        }

        public final List<DataRepositoryAssociation.Builder> getAssociations() {
            List<DataRepositoryAssociation.Builder> result = DataRepositoryAssociationsCopier.copyToBuilder(this.associations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociations(Collection<DataRepositoryAssociation.BuilderImpl> associations) {
            this.associations = DataRepositoryAssociationsCopier.copyFromBuilder(associations);
        }

        @Override
        @Transient
        public final Builder associations(Collection<DataRepositoryAssociation> associations) {
            this.associations = DataRepositoryAssociationsCopier.copy(associations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder associations(DataRepositoryAssociation... associations) {
            associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder associations(Consumer<DataRepositoryAssociation.Builder>... associations) {
            associations(Stream.of(associations).map(c -> DataRepositoryAssociation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeDataRepositoryAssociationsResponse build() {
            return new DescribeDataRepositoryAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
