/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStorageVirtualMachinesResponse extends FSxResponse implements
        ToCopyableBuilder<DescribeStorageVirtualMachinesResponse.Builder, DescribeStorageVirtualMachinesResponse> {
    private static final SdkField<List<StorageVirtualMachine>> STORAGE_VIRTUAL_MACHINES_FIELD = SdkField
            .<List<StorageVirtualMachine>> builder(MarshallingType.LIST)
            .memberName("StorageVirtualMachines")
            .getter(getter(DescribeStorageVirtualMachinesResponse::storageVirtualMachines))
            .setter(setter(Builder::storageVirtualMachines))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageVirtualMachines").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StorageVirtualMachine> builder(MarshallingType.SDK_POJO)
                                            .constructor(StorageVirtualMachine::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeStorageVirtualMachinesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STORAGE_VIRTUAL_MACHINES_FIELD, NEXT_TOKEN_FIELD));

    private final List<StorageVirtualMachine> storageVirtualMachines;

    private final String nextToken;

    private DescribeStorageVirtualMachinesResponse(BuilderImpl builder) {
        super(builder);
        this.storageVirtualMachines = builder.storageVirtualMachines;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the StorageVirtualMachines property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStorageVirtualMachines() {
        return storageVirtualMachines != null && !(storageVirtualMachines instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returned after a successful <code>DescribeStorageVirtualMachines</code> operation, describing each SVM.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStorageVirtualMachines} method.
     * </p>
     * 
     * @return Returned after a successful <code>DescribeStorageVirtualMachines</code> operation, describing each SVM.
     */
    public final List<StorageVirtualMachine> storageVirtualMachines() {
        return storageVirtualMachines;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStorageVirtualMachines() ? storageVirtualMachines() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStorageVirtualMachinesResponse)) {
            return false;
        }
        DescribeStorageVirtualMachinesResponse other = (DescribeStorageVirtualMachinesResponse) obj;
        return hasStorageVirtualMachines() == other.hasStorageVirtualMachines()
                && Objects.equals(storageVirtualMachines(), other.storageVirtualMachines())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStorageVirtualMachinesResponse")
                .add("StorageVirtualMachines", hasStorageVirtualMachines() ? storageVirtualMachines() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageVirtualMachines":
            return Optional.ofNullable(clazz.cast(storageVirtualMachines()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStorageVirtualMachinesResponse, T> g) {
        return obj -> g.apply((DescribeStorageVirtualMachinesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeStorageVirtualMachinesResponse> {
        /**
         * <p>
         * Returned after a successful <code>DescribeStorageVirtualMachines</code> operation, describing each SVM.
         * </p>
         * 
         * @param storageVirtualMachines
         *        Returned after a successful <code>DescribeStorageVirtualMachines</code> operation, describing each
         *        SVM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageVirtualMachines(Collection<StorageVirtualMachine> storageVirtualMachines);

        /**
         * <p>
         * Returned after a successful <code>DescribeStorageVirtualMachines</code> operation, describing each SVM.
         * </p>
         * 
         * @param storageVirtualMachines
         *        Returned after a successful <code>DescribeStorageVirtualMachines</code> operation, describing each
         *        SVM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageVirtualMachines(StorageVirtualMachine... storageVirtualMachines);

        /**
         * <p>
         * Returned after a successful <code>DescribeStorageVirtualMachines</code> operation, describing each SVM.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StorageVirtualMachine>.Builder} avoiding
         * the need to create one manually via {@link List<StorageVirtualMachine>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StorageVirtualMachine>.Builder#build()} is called
         * immediately and its result is passed to {@link #storageVirtualMachines(List<StorageVirtualMachine>)}.
         * 
         * @param storageVirtualMachines
         *        a consumer that will call methods on {@link List<StorageVirtualMachine>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageVirtualMachines(List<StorageVirtualMachine>)
         */
        Builder storageVirtualMachines(Consumer<StorageVirtualMachine.Builder>... storageVirtualMachines);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FSxResponse.BuilderImpl implements Builder {
        private List<StorageVirtualMachine> storageVirtualMachines = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStorageVirtualMachinesResponse model) {
            super(model);
            storageVirtualMachines(model.storageVirtualMachines);
            nextToken(model.nextToken);
        }

        public final List<StorageVirtualMachine.Builder> getStorageVirtualMachines() {
            List<StorageVirtualMachine.Builder> result = StorageVirtualMachinesCopier.copyToBuilder(this.storageVirtualMachines);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageVirtualMachines(Collection<StorageVirtualMachine.BuilderImpl> storageVirtualMachines) {
            this.storageVirtualMachines = StorageVirtualMachinesCopier.copyFromBuilder(storageVirtualMachines);
        }

        @Override
        @Transient
        public final Builder storageVirtualMachines(Collection<StorageVirtualMachine> storageVirtualMachines) {
            this.storageVirtualMachines = StorageVirtualMachinesCopier.copy(storageVirtualMachines);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder storageVirtualMachines(StorageVirtualMachine... storageVirtualMachines) {
            storageVirtualMachines(Arrays.asList(storageVirtualMachines));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder storageVirtualMachines(Consumer<StorageVirtualMachine.Builder>... storageVirtualMachines) {
            storageVirtualMachines(Stream.of(storageVirtualMachines)
                    .map(c -> StorageVirtualMachine.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeStorageVirtualMachinesResponse build() {
            return new DescribeStorageVirtualMachinesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
