/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreVolumeFromSnapshotRequest extends FSxRequest implements
        ToCopyableBuilder<RestoreVolumeFromSnapshotRequest.Builder, RestoreVolumeFromSnapshotRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(RestoreVolumeFromSnapshotRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeId").getter(getter(RestoreVolumeFromSnapshotRequest::volumeId)).setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId").getter(getter(RestoreVolumeFromSnapshotRequest::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()).build();

    private static final SdkField<List<String>> OPTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Options")
            .getter(getter(RestoreVolumeFromSnapshotRequest::optionsAsStrings))
            .setter(setter(Builder::optionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD,
            VOLUME_ID_FIELD, SNAPSHOT_ID_FIELD, OPTIONS_FIELD));

    private final String clientRequestToken;

    private final String volumeId;

    private final String snapshotId;

    private final List<String> options;

    private RestoreVolumeFromSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.volumeId = builder.volumeId;
        this.snapshotId = builder.snapshotId;
        this.options = builder.options;
    }

    /**
     * Returns the value of the ClientRequestToken property for this object.
     * 
     * @return The value of the ClientRequestToken property for this object.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The ID of the volume that you are restoring.
     * </p>
     * 
     * @return The ID of the volume that you are restoring.
     */
    public final String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * The ID of the source snapshot. Specifies the snapshot that you are restoring from.
     * </p>
     * 
     * @return The ID of the source snapshot. Specifies the snapshot that you are restoring from.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The settings used when restoring the specified volume from snapshot.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots between the current state and the specified
     * snapshot. If there are intermediate snapshots and this option isn't used, <code>RestoreVolumeFromSnapshot</code>
     * fails.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_CLONED_VOLUMES</code> - Deletes any volumes cloned from this volume. If there are any cloned volumes
     * and this option isn't used, <code>RestoreVolumeFromSnapshot</code> fails.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptions} method.
     * </p>
     * 
     * @return The settings used when restoring the specified volume from snapshot. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots between the current state and the
     *         specified snapshot. If there are intermediate snapshots and this option isn't used,
     *         <code>RestoreVolumeFromSnapshot</code> fails.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_CLONED_VOLUMES</code> - Deletes any volumes cloned from this volume. If there are any cloned
     *         volumes and this option isn't used, <code>RestoreVolumeFromSnapshot</code> fails.
     *         </p>
     *         </li>
     */
    public final List<RestoreOpenZFSVolumeOption> options() {
        return RestoreOpenZFSVolumeOptionsCopier.copyStringToEnum(options);
    }

    /**
     * For responses, this returns true if the service returned a value for the Options property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOptions() {
        return options != null && !(options instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The settings used when restoring the specified volume from snapshot.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots between the current state and the specified
     * snapshot. If there are intermediate snapshots and this option isn't used, <code>RestoreVolumeFromSnapshot</code>
     * fails.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_CLONED_VOLUMES</code> - Deletes any volumes cloned from this volume. If there are any cloned volumes
     * and this option isn't used, <code>RestoreVolumeFromSnapshot</code> fails.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptions} method.
     * </p>
     * 
     * @return The settings used when restoring the specified volume from snapshot. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots between the current state and the
     *         specified snapshot. If there are intermediate snapshots and this option isn't used,
     *         <code>RestoreVolumeFromSnapshot</code> fails.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_CLONED_VOLUMES</code> - Deletes any volumes cloned from this volume. If there are any cloned
     *         volumes and this option isn't used, <code>RestoreVolumeFromSnapshot</code> fails.
     *         </p>
     *         </li>
     */
    public final List<String> optionsAsStrings() {
        return options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptions() ? optionsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreVolumeFromSnapshotRequest)) {
            return false;
        }
        RestoreVolumeFromSnapshotRequest other = (RestoreVolumeFromSnapshotRequest) obj;
        return Objects.equals(clientRequestToken(), other.clientRequestToken()) && Objects.equals(volumeId(), other.volumeId())
                && Objects.equals(snapshotId(), other.snapshotId()) && hasOptions() == other.hasOptions()
                && Objects.equals(optionsAsStrings(), other.optionsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreVolumeFromSnapshotRequest").add("ClientRequestToken", clientRequestToken())
                .add("VolumeId", volumeId()).add("SnapshotId", snapshotId())
                .add("Options", hasOptions() ? optionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "Options":
            return Optional.ofNullable(clazz.cast(optionsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreVolumeFromSnapshotRequest, T> g) {
        return obj -> g.apply((RestoreVolumeFromSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxRequest.Builder, SdkPojo, CopyableBuilder<Builder, RestoreVolumeFromSnapshotRequest> {
        /**
         * Sets the value of the ClientRequestToken property for this object.
         *
         * @param clientRequestToken
         *        The new value for the ClientRequestToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The ID of the volume that you are restoring.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume that you are restoring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The ID of the source snapshot. Specifies the snapshot that you are restoring from.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the source snapshot. Specifies the snapshot that you are restoring from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The settings used when restoring the specified volume from snapshot.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots between the current state and the specified
         * snapshot. If there are intermediate snapshots and this option isn't used,
         * <code>RestoreVolumeFromSnapshot</code> fails.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_CLONED_VOLUMES</code> - Deletes any volumes cloned from this volume. If there are any cloned
         * volumes and this option isn't used, <code>RestoreVolumeFromSnapshot</code> fails.
         * </p>
         * </li>
         * </ul>
         * 
         * @param options
         *        The settings used when restoring the specified volume from snapshot. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots between the current state and the
         *        specified snapshot. If there are intermediate snapshots and this option isn't used,
         *        <code>RestoreVolumeFromSnapshot</code> fails.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_CLONED_VOLUMES</code> - Deletes any volumes cloned from this volume. If there are any
         *        cloned volumes and this option isn't used, <code>RestoreVolumeFromSnapshot</code> fails.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionsWithStrings(Collection<String> options);

        /**
         * <p>
         * The settings used when restoring the specified volume from snapshot.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots between the current state and the specified
         * snapshot. If there are intermediate snapshots and this option isn't used,
         * <code>RestoreVolumeFromSnapshot</code> fails.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_CLONED_VOLUMES</code> - Deletes any volumes cloned from this volume. If there are any cloned
         * volumes and this option isn't used, <code>RestoreVolumeFromSnapshot</code> fails.
         * </p>
         * </li>
         * </ul>
         * 
         * @param options
         *        The settings used when restoring the specified volume from snapshot. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots between the current state and the
         *        specified snapshot. If there are intermediate snapshots and this option isn't used,
         *        <code>RestoreVolumeFromSnapshot</code> fails.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_CLONED_VOLUMES</code> - Deletes any volumes cloned from this volume. If there are any
         *        cloned volumes and this option isn't used, <code>RestoreVolumeFromSnapshot</code> fails.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionsWithStrings(String... options);

        /**
         * <p>
         * The settings used when restoring the specified volume from snapshot.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots between the current state and the specified
         * snapshot. If there are intermediate snapshots and this option isn't used,
         * <code>RestoreVolumeFromSnapshot</code> fails.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_CLONED_VOLUMES</code> - Deletes any volumes cloned from this volume. If there are any cloned
         * volumes and this option isn't used, <code>RestoreVolumeFromSnapshot</code> fails.
         * </p>
         * </li>
         * </ul>
         * 
         * @param options
         *        The settings used when restoring the specified volume from snapshot. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots between the current state and the
         *        specified snapshot. If there are intermediate snapshots and this option isn't used,
         *        <code>RestoreVolumeFromSnapshot</code> fails.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_CLONED_VOLUMES</code> - Deletes any volumes cloned from this volume. If there are any
         *        cloned volumes and this option isn't used, <code>RestoreVolumeFromSnapshot</code> fails.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Collection<RestoreOpenZFSVolumeOption> options);

        /**
         * <p>
         * The settings used when restoring the specified volume from snapshot.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots between the current state and the specified
         * snapshot. If there are intermediate snapshots and this option isn't used,
         * <code>RestoreVolumeFromSnapshot</code> fails.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_CLONED_VOLUMES</code> - Deletes any volumes cloned from this volume. If there are any cloned
         * volumes and this option isn't used, <code>RestoreVolumeFromSnapshot</code> fails.
         * </p>
         * </li>
         * </ul>
         * 
         * @param options
         *        The settings used when restoring the specified volume from snapshot. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots between the current state and the
         *        specified snapshot. If there are intermediate snapshots and this option isn't used,
         *        <code>RestoreVolumeFromSnapshot</code> fails.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_CLONED_VOLUMES</code> - Deletes any volumes cloned from this volume. If there are any
         *        cloned volumes and this option isn't used, <code>RestoreVolumeFromSnapshot</code> fails.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(RestoreOpenZFSVolumeOption... options);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FSxRequest.BuilderImpl implements Builder {
        private String clientRequestToken;

        private String volumeId;

        private String snapshotId;

        private List<String> options = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreVolumeFromSnapshotRequest model) {
            super(model);
            clientRequestToken(model.clientRequestToken);
            volumeId(model.volumeId);
            snapshotId(model.snapshotId);
            optionsWithStrings(model.options);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        @Transient
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        @Transient
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final Collection<String> getOptions() {
            if (options instanceof SdkAutoConstructList) {
                return null;
            }
            return options;
        }

        public final void setOptions(Collection<String> options) {
            this.options = RestoreOpenZFSVolumeOptionsCopier.copy(options);
        }

        @Override
        @Transient
        public final Builder optionsWithStrings(Collection<String> options) {
            this.options = RestoreOpenZFSVolumeOptionsCopier.copy(options);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder optionsWithStrings(String... options) {
            optionsWithStrings(Arrays.asList(options));
            return this;
        }

        @Override
        @Transient
        public final Builder options(Collection<RestoreOpenZFSVolumeOption> options) {
            this.options = RestoreOpenZFSVolumeOptionsCopier.copyEnumToString(options);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder options(RestoreOpenZFSVolumeOption... options) {
            options(Arrays.asList(options));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreVolumeFromSnapshotRequest build() {
            return new RestoreVolumeFromSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
