/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of the Microsoft Active Directory (AD) directory to which the Amazon FSx for ONTAP
 * storage virtual machine (SVM) is joined. Pleae note, account credentials are not returned in the response payload.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SvmActiveDirectoryConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SvmActiveDirectoryConfiguration.Builder, SvmActiveDirectoryConfiguration> {
    private static final SdkField<String> NET_BIOS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetBiosName").getter(getter(SvmActiveDirectoryConfiguration::netBiosName))
            .setter(setter(Builder::netBiosName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetBiosName").build()).build();

    private static final SdkField<SelfManagedActiveDirectoryAttributes> SELF_MANAGED_ACTIVE_DIRECTORY_CONFIGURATION_FIELD = SdkField
            .<SelfManagedActiveDirectoryAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("SelfManagedActiveDirectoryConfiguration")
            .getter(getter(SvmActiveDirectoryConfiguration::selfManagedActiveDirectoryConfiguration))
            .setter(setter(Builder::selfManagedActiveDirectoryConfiguration))
            .constructor(SelfManagedActiveDirectoryAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SelfManagedActiveDirectoryConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NET_BIOS_NAME_FIELD,
            SELF_MANAGED_ACTIVE_DIRECTORY_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String netBiosName;

    private final SelfManagedActiveDirectoryAttributes selfManagedActiveDirectoryConfiguration;

    private SvmActiveDirectoryConfiguration(BuilderImpl builder) {
        this.netBiosName = builder.netBiosName;
        this.selfManagedActiveDirectoryConfiguration = builder.selfManagedActiveDirectoryConfiguration;
    }

    /**
     * <p>
     * The NetBIOS name of the Active Directory computer object that is joined to your SVM.
     * </p>
     * 
     * @return The NetBIOS name of the Active Directory computer object that is joined to your SVM.
     */
    public final String netBiosName() {
        return netBiosName;
    }

    /**
     * Returns the value of the SelfManagedActiveDirectoryConfiguration property for this object.
     * 
     * @return The value of the SelfManagedActiveDirectoryConfiguration property for this object.
     */
    public final SelfManagedActiveDirectoryAttributes selfManagedActiveDirectoryConfiguration() {
        return selfManagedActiveDirectoryConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(netBiosName());
        hashCode = 31 * hashCode + Objects.hashCode(selfManagedActiveDirectoryConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SvmActiveDirectoryConfiguration)) {
            return false;
        }
        SvmActiveDirectoryConfiguration other = (SvmActiveDirectoryConfiguration) obj;
        return Objects.equals(netBiosName(), other.netBiosName())
                && Objects.equals(selfManagedActiveDirectoryConfiguration(), other.selfManagedActiveDirectoryConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SvmActiveDirectoryConfiguration").add("NetBiosName", netBiosName())
                .add("SelfManagedActiveDirectoryConfiguration", selfManagedActiveDirectoryConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetBiosName":
            return Optional.ofNullable(clazz.cast(netBiosName()));
        case "SelfManagedActiveDirectoryConfiguration":
            return Optional.ofNullable(clazz.cast(selfManagedActiveDirectoryConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SvmActiveDirectoryConfiguration, T> g) {
        return obj -> g.apply((SvmActiveDirectoryConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SvmActiveDirectoryConfiguration> {
        /**
         * <p>
         * The NetBIOS name of the Active Directory computer object that is joined to your SVM.
         * </p>
         * 
         * @param netBiosName
         *        The NetBIOS name of the Active Directory computer object that is joined to your SVM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder netBiosName(String netBiosName);

        /**
         * Sets the value of the SelfManagedActiveDirectoryConfiguration property for this object.
         *
         * @param selfManagedActiveDirectoryConfiguration
         *        The new value for the SelfManagedActiveDirectoryConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfManagedActiveDirectoryConfiguration(
                SelfManagedActiveDirectoryAttributes selfManagedActiveDirectoryConfiguration);

        /**
         * Sets the value of the SelfManagedActiveDirectoryConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link SelfManagedActiveDirectoryAttributes.Builder}
         * avoiding the need to create one manually via {@link SelfManagedActiveDirectoryAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link SelfManagedActiveDirectoryAttributes.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryAttributes)}.
         * 
         * @param selfManagedActiveDirectoryConfiguration
         *        a consumer that will call methods on {@link SelfManagedActiveDirectoryAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryAttributes)
         */
        default Builder selfManagedActiveDirectoryConfiguration(
                Consumer<SelfManagedActiveDirectoryAttributes.Builder> selfManagedActiveDirectoryConfiguration) {
            return selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryAttributes.builder()
                    .applyMutation(selfManagedActiveDirectoryConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String netBiosName;

        private SelfManagedActiveDirectoryAttributes selfManagedActiveDirectoryConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SvmActiveDirectoryConfiguration model) {
            netBiosName(model.netBiosName);
            selfManagedActiveDirectoryConfiguration(model.selfManagedActiveDirectoryConfiguration);
        }

        public final String getNetBiosName() {
            return netBiosName;
        }

        public final void setNetBiosName(String netBiosName) {
            this.netBiosName = netBiosName;
        }

        @Override
        @Transient
        public final Builder netBiosName(String netBiosName) {
            this.netBiosName = netBiosName;
            return this;
        }

        public final SelfManagedActiveDirectoryAttributes.Builder getSelfManagedActiveDirectoryConfiguration() {
            return selfManagedActiveDirectoryConfiguration != null ? selfManagedActiveDirectoryConfiguration.toBuilder() : null;
        }

        public final void setSelfManagedActiveDirectoryConfiguration(
                SelfManagedActiveDirectoryAttributes.BuilderImpl selfManagedActiveDirectoryConfiguration) {
            this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration != null ? selfManagedActiveDirectoryConfiguration
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder selfManagedActiveDirectoryConfiguration(
                SelfManagedActiveDirectoryAttributes selfManagedActiveDirectoryConfiguration) {
            this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration;
            return this;
        }

        @Override
        public SvmActiveDirectoryConfiguration build() {
            return new SvmActiveDirectoryConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
