/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the data tiering policy for an ONTAP volume. When enabled, Amazon FSx for ONTAP's intelligent tiering
 * automatically transitions a volume's data between the file system's primary storage and capacity pool storage based
 * on your access patterns.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TieringPolicy implements SdkPojo, Serializable, ToCopyableBuilder<TieringPolicy.Builder, TieringPolicy> {
    private static final SdkField<Integer> COOLING_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CoolingPeriod").getter(getter(TieringPolicy::coolingPeriod)).setter(setter(Builder::coolingPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoolingPeriod").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(TieringPolicy::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COOLING_PERIOD_FIELD,
            NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer coolingPeriod;

    private final String name;

    private TieringPolicy(BuilderImpl builder) {
        this.coolingPeriod = builder.coolingPeriod;
        this.name = builder.name;
    }

    /**
     * <p>
     * Specifies the number of days that user data in a volume must remain inactive before it is considered "cold" and
     * moved to the capacity pool. Used with the <code>AUTO</code> and <code>SNAPSHOT_ONLY</code> tiering policies.
     * Enter a whole number between 2 and 183. Default values are 31 days for <code>AUTO</code> and 2 days for
     * <code>SNAPSHOT_ONLY</code>.
     * </p>
     * 
     * @return Specifies the number of days that user data in a volume must remain inactive before it is considered
     *         "cold" and moved to the capacity pool. Used with the <code>AUTO</code> and <code>SNAPSHOT_ONLY</code>
     *         tiering policies. Enter a whole number between 2 and 183. Default values are 31 days for
     *         <code>AUTO</code> and 2 days for <code>SNAPSHOT_ONLY</code>.
     */
    public final Integer coolingPeriod() {
        return coolingPeriod;
    }

    /**
     * <p>
     * Specifies the tiering policy used to transition data. Default value is <code>SNAPSHOT_ONLY</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SNAPSHOT_ONLY</code> - moves cold snapshots to the capacity pool storage tier.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier based on your access
     * patterns.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to the storage
     * pool tier.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code> - keeps a volume's data in the primary storage tier, preventing it from being moved to the
     * capacity pool tier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link TieringPolicyName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Specifies the tiering policy used to transition data. Default value is <code>SNAPSHOT_ONLY</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SNAPSHOT_ONLY</code> - moves cold snapshots to the capacity pool storage tier.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier based on your
     *         access patterns.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to the
     *         storage pool tier.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code> - keeps a volume's data in the primary storage tier, preventing it from being moved to
     *         the capacity pool tier.
     *         </p>
     *         </li>
     * @see TieringPolicyName
     */
    public final TieringPolicyName name() {
        return TieringPolicyName.fromValue(name);
    }

    /**
     * <p>
     * Specifies the tiering policy used to transition data. Default value is <code>SNAPSHOT_ONLY</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SNAPSHOT_ONLY</code> - moves cold snapshots to the capacity pool storage tier.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier based on your access
     * patterns.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to the storage
     * pool tier.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code> - keeps a volume's data in the primary storage tier, preventing it from being moved to the
     * capacity pool tier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link TieringPolicyName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Specifies the tiering policy used to transition data. Default value is <code>SNAPSHOT_ONLY</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SNAPSHOT_ONLY</code> - moves cold snapshots to the capacity pool storage tier.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier based on your
     *         access patterns.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to the
     *         storage pool tier.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code> - keeps a volume's data in the primary storage tier, preventing it from being moved to
     *         the capacity pool tier.
     *         </p>
     *         </li>
     * @see TieringPolicyName
     */
    public final String nameAsString() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(coolingPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TieringPolicy)) {
            return false;
        }
        TieringPolicy other = (TieringPolicy) obj;
        return Objects.equals(coolingPeriod(), other.coolingPeriod()) && Objects.equals(nameAsString(), other.nameAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TieringPolicy").add("CoolingPeriod", coolingPeriod()).add("Name", nameAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoolingPeriod":
            return Optional.ofNullable(clazz.cast(coolingPeriod()));
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TieringPolicy, T> g) {
        return obj -> g.apply((TieringPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TieringPolicy> {
        /**
         * <p>
         * Specifies the number of days that user data in a volume must remain inactive before it is considered "cold"
         * and moved to the capacity pool. Used with the <code>AUTO</code> and <code>SNAPSHOT_ONLY</code> tiering
         * policies. Enter a whole number between 2 and 183. Default values are 31 days for <code>AUTO</code> and 2 days
         * for <code>SNAPSHOT_ONLY</code>.
         * </p>
         * 
         * @param coolingPeriod
         *        Specifies the number of days that user data in a volume must remain inactive before it is considered
         *        "cold" and moved to the capacity pool. Used with the <code>AUTO</code> and <code>SNAPSHOT_ONLY</code>
         *        tiering policies. Enter a whole number between 2 and 183. Default values are 31 days for
         *        <code>AUTO</code> and 2 days for <code>SNAPSHOT_ONLY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coolingPeriod(Integer coolingPeriod);

        /**
         * <p>
         * Specifies the tiering policy used to transition data. Default value is <code>SNAPSHOT_ONLY</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SNAPSHOT_ONLY</code> - moves cold snapshots to the capacity pool storage tier.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier based on your access
         * patterns.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to the
         * storage pool tier.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> - keeps a volume's data in the primary storage tier, preventing it from being moved to the
         * capacity pool tier.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        Specifies the tiering policy used to transition data. Default value is <code>SNAPSHOT_ONLY</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SNAPSHOT_ONLY</code> - moves cold snapshots to the capacity pool storage tier.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier based on your
         *        access patterns.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to
         *        the storage pool tier.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code> - keeps a volume's data in the primary storage tier, preventing it from being moved
         *        to the capacity pool tier.
         *        </p>
         *        </li>
         * @see TieringPolicyName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TieringPolicyName
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the tiering policy used to transition data. Default value is <code>SNAPSHOT_ONLY</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SNAPSHOT_ONLY</code> - moves cold snapshots to the capacity pool storage tier.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier based on your access
         * patterns.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to the
         * storage pool tier.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> - keeps a volume's data in the primary storage tier, preventing it from being moved to the
         * capacity pool tier.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        Specifies the tiering policy used to transition data. Default value is <code>SNAPSHOT_ONLY</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SNAPSHOT_ONLY</code> - moves cold snapshots to the capacity pool storage tier.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier based on your
         *        access patterns.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to
         *        the storage pool tier.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code> - keeps a volume's data in the primary storage tier, preventing it from being moved
         *        to the capacity pool tier.
         *        </p>
         *        </li>
         * @see TieringPolicyName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TieringPolicyName
         */
        Builder name(TieringPolicyName name);
    }

    static final class BuilderImpl implements Builder {
        private Integer coolingPeriod;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(TieringPolicy model) {
            coolingPeriod(model.coolingPeriod);
            name(model.name);
        }

        public final Integer getCoolingPeriod() {
            return coolingPeriod;
        }

        public final void setCoolingPeriod(Integer coolingPeriod) {
            this.coolingPeriod = coolingPeriod;
        }

        @Override
        @Transient
        public final Builder coolingPeriod(Integer coolingPeriod) {
            this.coolingPeriod = coolingPeriod;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @Transient
        public final Builder name(TieringPolicyName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        @Override
        public TieringPolicy build() {
            return new TieringPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
