/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request object for the <code>UpdateFileSystem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFileSystemRequest extends FSxRequest implements
        ToCopyableBuilder<UpdateFileSystemRequest.Builder, UpdateFileSystemRequest> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemId").getter(getter(UpdateFileSystemRequest::fileSystemId))
            .setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(UpdateFileSystemRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StorageCapacity").getter(getter(UpdateFileSystemRequest::storageCapacity))
            .setter(setter(Builder::storageCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageCapacity").build()).build();

    private static final SdkField<UpdateFileSystemWindowsConfiguration> WINDOWS_CONFIGURATION_FIELD = SdkField
            .<UpdateFileSystemWindowsConfiguration> builder(MarshallingType.SDK_POJO).memberName("WindowsConfiguration")
            .getter(getter(UpdateFileSystemRequest::windowsConfiguration)).setter(setter(Builder::windowsConfiguration))
            .constructor(UpdateFileSystemWindowsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowsConfiguration").build())
            .build();

    private static final SdkField<UpdateFileSystemLustreConfiguration> LUSTRE_CONFIGURATION_FIELD = SdkField
            .<UpdateFileSystemLustreConfiguration> builder(MarshallingType.SDK_POJO).memberName("LustreConfiguration")
            .getter(getter(UpdateFileSystemRequest::lustreConfiguration)).setter(setter(Builder::lustreConfiguration))
            .constructor(UpdateFileSystemLustreConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LustreConfiguration").build())
            .build();

    private static final SdkField<UpdateFileSystemOntapConfiguration> ONTAP_CONFIGURATION_FIELD = SdkField
            .<UpdateFileSystemOntapConfiguration> builder(MarshallingType.SDK_POJO).memberName("OntapConfiguration")
            .getter(getter(UpdateFileSystemRequest::ontapConfiguration)).setter(setter(Builder::ontapConfiguration))
            .constructor(UpdateFileSystemOntapConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OntapConfiguration").build())
            .build();

    private static final SdkField<UpdateFileSystemOpenZFSConfiguration> OPEN_ZFS_CONFIGURATION_FIELD = SdkField
            .<UpdateFileSystemOpenZFSConfiguration> builder(MarshallingType.SDK_POJO).memberName("OpenZFSConfiguration")
            .getter(getter(UpdateFileSystemRequest::openZFSConfiguration)).setter(setter(Builder::openZFSConfiguration))
            .constructor(UpdateFileSystemOpenZFSConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenZFSConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, STORAGE_CAPACITY_FIELD, WINDOWS_CONFIGURATION_FIELD, LUSTRE_CONFIGURATION_FIELD,
            ONTAP_CONFIGURATION_FIELD, OPEN_ZFS_CONFIGURATION_FIELD));

    private final String fileSystemId;

    private final String clientRequestToken;

    private final Integer storageCapacity;

    private final UpdateFileSystemWindowsConfiguration windowsConfiguration;

    private final UpdateFileSystemLustreConfiguration lustreConfiguration;

    private final UpdateFileSystemOntapConfiguration ontapConfiguration;

    private final UpdateFileSystemOpenZFSConfiguration openZFSConfiguration;

    private UpdateFileSystemRequest(BuilderImpl builder) {
        super(builder);
        this.fileSystemId = builder.fileSystemId;
        this.clientRequestToken = builder.clientRequestToken;
        this.storageCapacity = builder.storageCapacity;
        this.windowsConfiguration = builder.windowsConfiguration;
        this.lustreConfiguration = builder.lustreConfiguration;
        this.ontapConfiguration = builder.ontapConfiguration;
        this.openZFSConfiguration = builder.openZFSConfiguration;
    }

    /**
     * <p>
     * The ID of the file system that you are updating.
     * </p>
     * 
     * @return The ID of the file system that you are updating.
     */
    public final String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent updates. This string is
     * automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.
     * </p>
     * 
     * @return A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent updates. This string is
     *         automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web
     *         Services SDK.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * Use this parameter to increase the storage capacity of an Amazon FSx for Windows File Server or Amazon FSx for
     * Lustre file system. Specifies the storage capacity target value, in GiB, to increase the storage capacity for the
     * file system that you're updating.
     * </p>
     * <note>
     * <p>
     * You can't make a storage capacity increase request if there is an existing storage capacity increase request in
     * progress.
     * </p>
     * </note>
     * <p>
     * For Windows file systems, the storage capacity target value must be at least 10 percent greater than the current
     * storage capacity value. To increase storage capacity, the file system must have at least 16 MBps of throughput
     * capacity.
     * </p>
     * <p>
     * For Lustre file systems, the storage capacity target value can be the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>SCRATCH_2</code> and <code>PERSISTENT_1 SSD</code> deployment types, valid values are in multiples of
     * 2400 GiB. The value must be greater than the current storage capacity.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>PERSISTENT HDD</code> file systems, valid values are multiples of 6000 GiB for 12-MBps throughput per
     * TiB file systems and multiples of 1800 GiB for 40-MBps throughput per TiB file systems. The values must be
     * greater than the current storage capacity.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>SCRATCH_1</code> file systems, you can't increase the storage capacity.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For OpenZFS file systems, the input/output operations per second (IOPS) automatically scale with increases to the
     * storage capacity if IOPS is configured for automatic scaling. If the storage capacity increase would result in
     * less than 3 IOPS per GiB of storage, this operation returns an error.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html">Managing storage
     * capacity</a> in the <i>Amazon FSx for Windows File Server User Guide</i>, <a
     * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html">Managing storage and
     * throughput capacity</a> in the <i>Amazon FSx for Lustre User Guide</i>, and <a
     * href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/managing-storage-capacity.html">Managing storage
     * capacity</a> in the <i>Amazon FSx for OpenZFS User Guide</i>.
     * </p>
     * 
     * @return Use this parameter to increase the storage capacity of an Amazon FSx for Windows File Server or Amazon
     *         FSx for Lustre file system. Specifies the storage capacity target value, in GiB, to increase the storage
     *         capacity for the file system that you're updating. </p> <note>
     *         <p>
     *         You can't make a storage capacity increase request if there is an existing storage capacity increase
     *         request in progress.
     *         </p>
     *         </note>
     *         <p>
     *         For Windows file systems, the storage capacity target value must be at least 10 percent greater than the
     *         current storage capacity value. To increase storage capacity, the file system must have at least 16 MBps
     *         of throughput capacity.
     *         </p>
     *         <p>
     *         For Lustre file systems, the storage capacity target value can be the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For <code>SCRATCH_2</code> and <code>PERSISTENT_1 SSD</code> deployment types, valid values are in
     *         multiples of 2400 GiB. The value must be greater than the current storage capacity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <code>PERSISTENT HDD</code> file systems, valid values are multiples of 6000 GiB for 12-MBps
     *         throughput per TiB file systems and multiples of 1800 GiB for 40-MBps throughput per TiB file systems.
     *         The values must be greater than the current storage capacity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <code>SCRATCH_1</code> file systems, you can't increase the storage capacity.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For OpenZFS file systems, the input/output operations per second (IOPS) automatically scale with
     *         increases to the storage capacity if IOPS is configured for automatic scaling. If the storage capacity
     *         increase would result in less than 3 IOPS per GiB of storage, this operation returns an error.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html">Managing
     *         storage capacity</a> in the <i>Amazon FSx for Windows File Server User Guide</i>, <a
     *         href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html">Managing storage
     *         and throughput capacity</a> in the <i>Amazon FSx for Lustre User Guide</i>, and <a
     *         href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/managing-storage-capacity.html">Managing
     *         storage capacity</a> in the <i>Amazon FSx for OpenZFS User Guide</i>.
     */
    public final Integer storageCapacity() {
        return storageCapacity;
    }

    /**
     * <p>
     * The configuration updates for an Amazon FSx for Windows File Server file system.
     * </p>
     * 
     * @return The configuration updates for an Amazon FSx for Windows File Server file system.
     */
    public final UpdateFileSystemWindowsConfiguration windowsConfiguration() {
        return windowsConfiguration;
    }

    /**
     * Returns the value of the LustreConfiguration property for this object.
     * 
     * @return The value of the LustreConfiguration property for this object.
     */
    public final UpdateFileSystemLustreConfiguration lustreConfiguration() {
        return lustreConfiguration;
    }

    /**
     * Returns the value of the OntapConfiguration property for this object.
     * 
     * @return The value of the OntapConfiguration property for this object.
     */
    public final UpdateFileSystemOntapConfiguration ontapConfiguration() {
        return ontapConfiguration;
    }

    /**
     * <p>
     * The configuration updates for an Amazon FSx for OpenZFS file system.
     * </p>
     * 
     * @return The configuration updates for an Amazon FSx for OpenZFS file system.
     */
    public final UpdateFileSystemOpenZFSConfiguration openZFSConfiguration() {
        return openZFSConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(storageCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(windowsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(lustreConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(ontapConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(openZFSConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFileSystemRequest)) {
            return false;
        }
        UpdateFileSystemRequest other = (UpdateFileSystemRequest) obj;
        return Objects.equals(fileSystemId(), other.fileSystemId())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(storageCapacity(), other.storageCapacity())
                && Objects.equals(windowsConfiguration(), other.windowsConfiguration())
                && Objects.equals(lustreConfiguration(), other.lustreConfiguration())
                && Objects.equals(ontapConfiguration(), other.ontapConfiguration())
                && Objects.equals(openZFSConfiguration(), other.openZFSConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFileSystemRequest").add("FileSystemId", fileSystemId())
                .add("ClientRequestToken", clientRequestToken()).add("StorageCapacity", storageCapacity())
                .add("WindowsConfiguration", windowsConfiguration()).add("LustreConfiguration", lustreConfiguration())
                .add("OntapConfiguration", ontapConfiguration()).add("OpenZFSConfiguration", openZFSConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "StorageCapacity":
            return Optional.ofNullable(clazz.cast(storageCapacity()));
        case "WindowsConfiguration":
            return Optional.ofNullable(clazz.cast(windowsConfiguration()));
        case "LustreConfiguration":
            return Optional.ofNullable(clazz.cast(lustreConfiguration()));
        case "OntapConfiguration":
            return Optional.ofNullable(clazz.cast(ontapConfiguration()));
        case "OpenZFSConfiguration":
            return Optional.ofNullable(clazz.cast(openZFSConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFileSystemRequest, T> g) {
        return obj -> g.apply((UpdateFileSystemRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFileSystemRequest> {
        /**
         * <p>
         * The ID of the file system that you are updating.
         * </p>
         * 
         * @param fileSystemId
         *        The ID of the file system that you are updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent updates. This string is
         * automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services
         * SDK.
         * </p>
         * 
         * @param clientRequestToken
         *        A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent updates. This string
         *        is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web
         *        Services SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * Use this parameter to increase the storage capacity of an Amazon FSx for Windows File Server or Amazon FSx
         * for Lustre file system. Specifies the storage capacity target value, in GiB, to increase the storage capacity
         * for the file system that you're updating.
         * </p>
         * <note>
         * <p>
         * You can't make a storage capacity increase request if there is an existing storage capacity increase request
         * in progress.
         * </p>
         * </note>
         * <p>
         * For Windows file systems, the storage capacity target value must be at least 10 percent greater than the
         * current storage capacity value. To increase storage capacity, the file system must have at least 16 MBps of
         * throughput capacity.
         * </p>
         * <p>
         * For Lustre file systems, the storage capacity target value can be the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <code>SCRATCH_2</code> and <code>PERSISTENT_1 SSD</code> deployment types, valid values are in multiples
         * of 2400 GiB. The value must be greater than the current storage capacity.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <code>PERSISTENT HDD</code> file systems, valid values are multiples of 6000 GiB for 12-MBps throughput
         * per TiB file systems and multiples of 1800 GiB for 40-MBps throughput per TiB file systems. The values must
         * be greater than the current storage capacity.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <code>SCRATCH_1</code> file systems, you can't increase the storage capacity.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For OpenZFS file systems, the input/output operations per second (IOPS) automatically scale with increases to
         * the storage capacity if IOPS is configured for automatic scaling. If the storage capacity increase would
         * result in less than 3 IOPS per GiB of storage, this operation returns an error.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html">Managing storage
         * capacity</a> in the <i>Amazon FSx for Windows File Server User Guide</i>, <a
         * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html">Managing storage and
         * throughput capacity</a> in the <i>Amazon FSx for Lustre User Guide</i>, and <a
         * href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/managing-storage-capacity.html">Managing storage
         * capacity</a> in the <i>Amazon FSx for OpenZFS User Guide</i>.
         * </p>
         * 
         * @param storageCapacity
         *        Use this parameter to increase the storage capacity of an Amazon FSx for Windows File Server or Amazon
         *        FSx for Lustre file system. Specifies the storage capacity target value, in GiB, to increase the
         *        storage capacity for the file system that you're updating. </p> <note>
         *        <p>
         *        You can't make a storage capacity increase request if there is an existing storage capacity increase
         *        request in progress.
         *        </p>
         *        </note>
         *        <p>
         *        For Windows file systems, the storage capacity target value must be at least 10 percent greater than
         *        the current storage capacity value. To increase storage capacity, the file system must have at least
         *        16 MBps of throughput capacity.
         *        </p>
         *        <p>
         *        For Lustre file systems, the storage capacity target value can be the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For <code>SCRATCH_2</code> and <code>PERSISTENT_1 SSD</code> deployment types, valid values are in
         *        multiples of 2400 GiB. The value must be greater than the current storage capacity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <code>PERSISTENT HDD</code> file systems, valid values are multiples of 6000 GiB for 12-MBps
         *        throughput per TiB file systems and multiples of 1800 GiB for 40-MBps throughput per TiB file systems.
         *        The values must be greater than the current storage capacity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <code>SCRATCH_1</code> file systems, you can't increase the storage capacity.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For OpenZFS file systems, the input/output operations per second (IOPS) automatically scale with
         *        increases to the storage capacity if IOPS is configured for automatic scaling. If the storage capacity
         *        increase would result in less than 3 IOPS per GiB of storage, this operation returns an error.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html">Managing
         *        storage capacity</a> in the <i>Amazon FSx for Windows File Server User Guide</i>, <a
         *        href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html">Managing
         *        storage and throughput capacity</a> in the <i>Amazon FSx for Lustre User Guide</i>, and <a
         *        href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/managing-storage-capacity.html">Managing
         *        storage capacity</a> in the <i>Amazon FSx for OpenZFS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageCapacity(Integer storageCapacity);

        /**
         * <p>
         * The configuration updates for an Amazon FSx for Windows File Server file system.
         * </p>
         * 
         * @param windowsConfiguration
         *        The configuration updates for an Amazon FSx for Windows File Server file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowsConfiguration(UpdateFileSystemWindowsConfiguration windowsConfiguration);

        /**
         * <p>
         * The configuration updates for an Amazon FSx for Windows File Server file system.
         * </p>
         * This is a convenience that creates an instance of the {@link UpdateFileSystemWindowsConfiguration.Builder}
         * avoiding the need to create one manually via {@link UpdateFileSystemWindowsConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateFileSystemWindowsConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #windowsConfiguration(UpdateFileSystemWindowsConfiguration)}.
         * 
         * @param windowsConfiguration
         *        a consumer that will call methods on {@link UpdateFileSystemWindowsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #windowsConfiguration(UpdateFileSystemWindowsConfiguration)
         */
        default Builder windowsConfiguration(Consumer<UpdateFileSystemWindowsConfiguration.Builder> windowsConfiguration) {
            return windowsConfiguration(UpdateFileSystemWindowsConfiguration.builder().applyMutation(windowsConfiguration)
                    .build());
        }

        /**
         * Sets the value of the LustreConfiguration property for this object.
         *
         * @param lustreConfiguration
         *        The new value for the LustreConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lustreConfiguration(UpdateFileSystemLustreConfiguration lustreConfiguration);

        /**
         * Sets the value of the LustreConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link UpdateFileSystemLustreConfiguration.Builder}
         * avoiding the need to create one manually via {@link UpdateFileSystemLustreConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateFileSystemLustreConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #lustreConfiguration(UpdateFileSystemLustreConfiguration)}.
         * 
         * @param lustreConfiguration
         *        a consumer that will call methods on {@link UpdateFileSystemLustreConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lustreConfiguration(UpdateFileSystemLustreConfiguration)
         */
        default Builder lustreConfiguration(Consumer<UpdateFileSystemLustreConfiguration.Builder> lustreConfiguration) {
            return lustreConfiguration(UpdateFileSystemLustreConfiguration.builder().applyMutation(lustreConfiguration).build());
        }

        /**
         * Sets the value of the OntapConfiguration property for this object.
         *
         * @param ontapConfiguration
         *        The new value for the OntapConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ontapConfiguration(UpdateFileSystemOntapConfiguration ontapConfiguration);

        /**
         * Sets the value of the OntapConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link UpdateFileSystemOntapConfiguration.Builder}
         * avoiding the need to create one manually via {@link UpdateFileSystemOntapConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateFileSystemOntapConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #ontapConfiguration(UpdateFileSystemOntapConfiguration)}.
         * 
         * @param ontapConfiguration
         *        a consumer that will call methods on {@link UpdateFileSystemOntapConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ontapConfiguration(UpdateFileSystemOntapConfiguration)
         */
        default Builder ontapConfiguration(Consumer<UpdateFileSystemOntapConfiguration.Builder> ontapConfiguration) {
            return ontapConfiguration(UpdateFileSystemOntapConfiguration.builder().applyMutation(ontapConfiguration).build());
        }

        /**
         * <p>
         * The configuration updates for an Amazon FSx for OpenZFS file system.
         * </p>
         * 
         * @param openZFSConfiguration
         *        The configuration updates for an Amazon FSx for OpenZFS file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openZFSConfiguration(UpdateFileSystemOpenZFSConfiguration openZFSConfiguration);

        /**
         * <p>
         * The configuration updates for an Amazon FSx for OpenZFS file system.
         * </p>
         * This is a convenience that creates an instance of the {@link UpdateFileSystemOpenZFSConfiguration.Builder}
         * avoiding the need to create one manually via {@link UpdateFileSystemOpenZFSConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateFileSystemOpenZFSConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #openZFSConfiguration(UpdateFileSystemOpenZFSConfiguration)}.
         * 
         * @param openZFSConfiguration
         *        a consumer that will call methods on {@link UpdateFileSystemOpenZFSConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openZFSConfiguration(UpdateFileSystemOpenZFSConfiguration)
         */
        default Builder openZFSConfiguration(Consumer<UpdateFileSystemOpenZFSConfiguration.Builder> openZFSConfiguration) {
            return openZFSConfiguration(UpdateFileSystemOpenZFSConfiguration.builder().applyMutation(openZFSConfiguration)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FSxRequest.BuilderImpl implements Builder {
        private String fileSystemId;

        private String clientRequestToken;

        private Integer storageCapacity;

        private UpdateFileSystemWindowsConfiguration windowsConfiguration;

        private UpdateFileSystemLustreConfiguration lustreConfiguration;

        private UpdateFileSystemOntapConfiguration ontapConfiguration;

        private UpdateFileSystemOpenZFSConfiguration openZFSConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFileSystemRequest model) {
            super(model);
            fileSystemId(model.fileSystemId);
            clientRequestToken(model.clientRequestToken);
            storageCapacity(model.storageCapacity);
            windowsConfiguration(model.windowsConfiguration);
            lustreConfiguration(model.lustreConfiguration);
            ontapConfiguration(model.ontapConfiguration);
            openZFSConfiguration(model.openZFSConfiguration);
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        @Transient
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Integer getStorageCapacity() {
            return storageCapacity;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        @Override
        @Transient
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        public final UpdateFileSystemWindowsConfiguration.Builder getWindowsConfiguration() {
            return windowsConfiguration != null ? windowsConfiguration.toBuilder() : null;
        }

        public final void setWindowsConfiguration(UpdateFileSystemWindowsConfiguration.BuilderImpl windowsConfiguration) {
            this.windowsConfiguration = windowsConfiguration != null ? windowsConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder windowsConfiguration(UpdateFileSystemWindowsConfiguration windowsConfiguration) {
            this.windowsConfiguration = windowsConfiguration;
            return this;
        }

        public final UpdateFileSystemLustreConfiguration.Builder getLustreConfiguration() {
            return lustreConfiguration != null ? lustreConfiguration.toBuilder() : null;
        }

        public final void setLustreConfiguration(UpdateFileSystemLustreConfiguration.BuilderImpl lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration != null ? lustreConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder lustreConfiguration(UpdateFileSystemLustreConfiguration lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration;
            return this;
        }

        public final UpdateFileSystemOntapConfiguration.Builder getOntapConfiguration() {
            return ontapConfiguration != null ? ontapConfiguration.toBuilder() : null;
        }

        public final void setOntapConfiguration(UpdateFileSystemOntapConfiguration.BuilderImpl ontapConfiguration) {
            this.ontapConfiguration = ontapConfiguration != null ? ontapConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder ontapConfiguration(UpdateFileSystemOntapConfiguration ontapConfiguration) {
            this.ontapConfiguration = ontapConfiguration;
            return this;
        }

        public final UpdateFileSystemOpenZFSConfiguration.Builder getOpenZFSConfiguration() {
            return openZFSConfiguration != null ? openZFSConfiguration.toBuilder() : null;
        }

        public final void setOpenZFSConfiguration(UpdateFileSystemOpenZFSConfiguration.BuilderImpl openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration != null ? openZFSConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder openZFSConfiguration(UpdateFileSystemOpenZFSConfiguration openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFileSystemRequest build() {
            return new UpdateFileSystemRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
