/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates the configuration for an existing Amazon FSx for Windows File Server file system. Amazon FSx only overwrites
 * existing properties with non-null values provided in the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFileSystemWindowsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateFileSystemWindowsConfiguration.Builder, UpdateFileSystemWindowsConfiguration> {
    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WeeklyMaintenanceStartTime")
            .getter(getter(UpdateFileSystemWindowsConfiguration::weeklyMaintenanceStartTime))
            .setter(setter(Builder::weeklyMaintenanceStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build())
            .build();

    private static final SdkField<String> DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DailyAutomaticBackupStartTime")
            .getter(getter(UpdateFileSystemWindowsConfiguration::dailyAutomaticBackupStartTime))
            .setter(setter(Builder::dailyAutomaticBackupStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyAutomaticBackupStartTime")
                    .build()).build();

    private static final SdkField<Integer> AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AutomaticBackupRetentionDays")
            .getter(getter(UpdateFileSystemWindowsConfiguration::automaticBackupRetentionDays))
            .setter(setter(Builder::automaticBackupRetentionDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticBackupRetentionDays")
                    .build()).build();

    private static final SdkField<Integer> THROUGHPUT_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ThroughputCapacity").getter(getter(UpdateFileSystemWindowsConfiguration::throughputCapacity))
            .setter(setter(Builder::throughputCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputCapacity").build())
            .build();

    private static final SdkField<SelfManagedActiveDirectoryConfigurationUpdates> SELF_MANAGED_ACTIVE_DIRECTORY_CONFIGURATION_FIELD = SdkField
            .<SelfManagedActiveDirectoryConfigurationUpdates> builder(MarshallingType.SDK_POJO)
            .memberName("SelfManagedActiveDirectoryConfiguration")
            .getter(getter(UpdateFileSystemWindowsConfiguration::selfManagedActiveDirectoryConfiguration))
            .setter(setter(Builder::selfManagedActiveDirectoryConfiguration))
            .constructor(SelfManagedActiveDirectoryConfigurationUpdates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SelfManagedActiveDirectoryConfiguration").build()).build();

    private static final SdkField<WindowsAuditLogCreateConfiguration> AUDIT_LOG_CONFIGURATION_FIELD = SdkField
            .<WindowsAuditLogCreateConfiguration> builder(MarshallingType.SDK_POJO).memberName("AuditLogConfiguration")
            .getter(getter(UpdateFileSystemWindowsConfiguration::auditLogConfiguration))
            .setter(setter(Builder::auditLogConfiguration)).constructor(WindowsAuditLogCreateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditLogConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            WEEKLY_MAINTENANCE_START_TIME_FIELD, DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD, AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD,
            THROUGHPUT_CAPACITY_FIELD, SELF_MANAGED_ACTIVE_DIRECTORY_CONFIGURATION_FIELD, AUDIT_LOG_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String weeklyMaintenanceStartTime;

    private final String dailyAutomaticBackupStartTime;

    private final Integer automaticBackupRetentionDays;

    private final Integer throughputCapacity;

    private final SelfManagedActiveDirectoryConfigurationUpdates selfManagedActiveDirectoryConfiguration;

    private final WindowsAuditLogCreateConfiguration auditLogConfiguration;

    private UpdateFileSystemWindowsConfiguration(BuilderImpl builder) {
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.dailyAutomaticBackupStartTime = builder.dailyAutomaticBackupStartTime;
        this.automaticBackupRetentionDays = builder.automaticBackupRetentionDays;
        this.throughputCapacity = builder.throughputCapacity;
        this.selfManagedActiveDirectoryConfiguration = builder.selfManagedActiveDirectoryConfiguration;
        this.auditLogConfiguration = builder.auditLogConfiguration;
    }

    /**
     * <p>
     * The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone. Where d is the
     * weekday number, from 1 through 7, with 1 = Monday and 7 = Sunday.
     * </p>
     * 
     * @return The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone. Where d
     *         is the weekday number, from 1 through 7, with 1 = Monday and 7 = Sunday.
     */
    public final String weeklyMaintenanceStartTime() {
        return weeklyMaintenanceStartTime;
    }

    /**
     * <p>
     * The preferred time to start the daily automatic backup, in the UTC time zone, for example, <code>02:00</code>
     * </p>
     * 
     * @return The preferred time to start the daily automatic backup, in the UTC time zone, for example,
     *         <code>02:00</code>
     */
    public final String dailyAutomaticBackupStartTime() {
        return dailyAutomaticBackupStartTime;
    }

    /**
     * <p>
     * The number of days to retain automatic daily backups. Setting this to zero (0) disables automatic daily backups.
     * You can retain automatic daily backups for a maximum of 90 days. For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html#automatic-backups">Working with
     * Automatic Daily Backups</a>.
     * </p>
     * 
     * @return The number of days to retain automatic daily backups. Setting this to zero (0) disables automatic daily
     *         backups. You can retain automatic daily backups for a maximum of 90 days. For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html#automatic-backups">Working
     *         with Automatic Daily Backups</a>.
     */
    public final Integer automaticBackupRetentionDays() {
        return automaticBackupRetentionDays;
    }

    /**
     * <p>
     * Sets the target value for a file system's throughput capacity, in MB/s, that you are updating the file system to.
     * Valid values are 8, 16, 32, 64, 128, 256, 512, 1024, 2048. You cannot make a throughput capacity update request
     * if there is an existing throughput capacity update request in progress. For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-throughput-capacity.html">Managing Throughput
     * Capacity</a>.
     * </p>
     * 
     * @return Sets the target value for a file system's throughput capacity, in MB/s, that you are updating the file
     *         system to. Valid values are 8, 16, 32, 64, 128, 256, 512, 1024, 2048. You cannot make a throughput
     *         capacity update request if there is an existing throughput capacity update request in progress. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-throughput-capacity.html">Managing
     *         Throughput Capacity</a>.
     */
    public final Integer throughputCapacity() {
        return throughputCapacity;
    }

    /**
     * <p>
     * The configuration Amazon FSx uses to join the Windows File Server instance to the self-managed Microsoft AD
     * directory. You cannot make a self-managed Microsoft AD update request if there is an existing self-managed
     * Microsoft AD update request in progress.
     * </p>
     * 
     * @return The configuration Amazon FSx uses to join the Windows File Server instance to the self-managed Microsoft
     *         AD directory. You cannot make a self-managed Microsoft AD update request if there is an existing
     *         self-managed Microsoft AD update request in progress.
     */
    public final SelfManagedActiveDirectoryConfigurationUpdates selfManagedActiveDirectoryConfiguration() {
        return selfManagedActiveDirectoryConfiguration;
    }

    /**
     * <p>
     * The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders,
     * and file shares on the Amazon FSx for Windows File Server file system..
     * </p>
     * 
     * @return The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files,
     *         folders, and file shares on the Amazon FSx for Windows File Server file system..
     */
    public final WindowsAuditLogCreateConfiguration auditLogConfiguration() {
        return auditLogConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(dailyAutomaticBackupStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(automaticBackupRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(throughputCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(selfManagedActiveDirectoryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(auditLogConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFileSystemWindowsConfiguration)) {
            return false;
        }
        UpdateFileSystemWindowsConfiguration other = (UpdateFileSystemWindowsConfiguration) obj;
        return Objects.equals(weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime())
                && Objects.equals(dailyAutomaticBackupStartTime(), other.dailyAutomaticBackupStartTime())
                && Objects.equals(automaticBackupRetentionDays(), other.automaticBackupRetentionDays())
                && Objects.equals(throughputCapacity(), other.throughputCapacity())
                && Objects.equals(selfManagedActiveDirectoryConfiguration(), other.selfManagedActiveDirectoryConfiguration())
                && Objects.equals(auditLogConfiguration(), other.auditLogConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFileSystemWindowsConfiguration")
                .add("WeeklyMaintenanceStartTime", weeklyMaintenanceStartTime())
                .add("DailyAutomaticBackupStartTime", dailyAutomaticBackupStartTime())
                .add("AutomaticBackupRetentionDays", automaticBackupRetentionDays())
                .add("ThroughputCapacity", throughputCapacity())
                .add("SelfManagedActiveDirectoryConfiguration", selfManagedActiveDirectoryConfiguration())
                .add("AuditLogConfiguration", auditLogConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WeeklyMaintenanceStartTime":
            return Optional.ofNullable(clazz.cast(weeklyMaintenanceStartTime()));
        case "DailyAutomaticBackupStartTime":
            return Optional.ofNullable(clazz.cast(dailyAutomaticBackupStartTime()));
        case "AutomaticBackupRetentionDays":
            return Optional.ofNullable(clazz.cast(automaticBackupRetentionDays()));
        case "ThroughputCapacity":
            return Optional.ofNullable(clazz.cast(throughputCapacity()));
        case "SelfManagedActiveDirectoryConfiguration":
            return Optional.ofNullable(clazz.cast(selfManagedActiveDirectoryConfiguration()));
        case "AuditLogConfiguration":
            return Optional.ofNullable(clazz.cast(auditLogConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFileSystemWindowsConfiguration, T> g) {
        return obj -> g.apply((UpdateFileSystemWindowsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateFileSystemWindowsConfiguration> {
        /**
         * <p>
         * The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone. Where d is
         * the weekday number, from 1 through 7, with 1 = Monday and 7 = Sunday.
         * </p>
         * 
         * @param weeklyMaintenanceStartTime
         *        The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone. Where
         *        d is the weekday number, from 1 through 7, with 1 = Monday and 7 = Sunday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime);

        /**
         * <p>
         * The preferred time to start the daily automatic backup, in the UTC time zone, for example, <code>02:00</code>
         * </p>
         * 
         * @param dailyAutomaticBackupStartTime
         *        The preferred time to start the daily automatic backup, in the UTC time zone, for example,
         *        <code>02:00</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime);

        /**
         * <p>
         * The number of days to retain automatic daily backups. Setting this to zero (0) disables automatic daily
         * backups. You can retain automatic daily backups for a maximum of 90 days. For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html#automatic-backups">Working with
         * Automatic Daily Backups</a>.
         * </p>
         * 
         * @param automaticBackupRetentionDays
         *        The number of days to retain automatic daily backups. Setting this to zero (0) disables automatic
         *        daily backups. You can retain automatic daily backups for a maximum of 90 days. For more information,
         *        see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html#automatic-backups">
         *        Working with Automatic Daily Backups</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays);

        /**
         * <p>
         * Sets the target value for a file system's throughput capacity, in MB/s, that you are updating the file system
         * to. Valid values are 8, 16, 32, 64, 128, 256, 512, 1024, 2048. You cannot make a throughput capacity update
         * request if there is an existing throughput capacity update request in progress. For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-throughput-capacity.html">Managing
         * Throughput Capacity</a>.
         * </p>
         * 
         * @param throughputCapacity
         *        Sets the target value for a file system's throughput capacity, in MB/s, that you are updating the file
         *        system to. Valid values are 8, 16, 32, 64, 128, 256, 512, 1024, 2048. You cannot make a throughput
         *        capacity update request if there is an existing throughput capacity update request in progress. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-throughput-capacity.html">Managing
         *        Throughput Capacity</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughputCapacity(Integer throughputCapacity);

        /**
         * <p>
         * The configuration Amazon FSx uses to join the Windows File Server instance to the self-managed Microsoft AD
         * directory. You cannot make a self-managed Microsoft AD update request if there is an existing self-managed
         * Microsoft AD update request in progress.
         * </p>
         * 
         * @param selfManagedActiveDirectoryConfiguration
         *        The configuration Amazon FSx uses to join the Windows File Server instance to the self-managed
         *        Microsoft AD directory. You cannot make a self-managed Microsoft AD update request if there is an
         *        existing self-managed Microsoft AD update request in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfManagedActiveDirectoryConfiguration(
                SelfManagedActiveDirectoryConfigurationUpdates selfManagedActiveDirectoryConfiguration);

        /**
         * <p>
         * The configuration Amazon FSx uses to join the Windows File Server instance to the self-managed Microsoft AD
         * directory. You cannot make a self-managed Microsoft AD update request if there is an existing self-managed
         * Microsoft AD update request in progress.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link SelfManagedActiveDirectoryConfigurationUpdates.Builder} avoiding the need to create one manually via
         * {@link SelfManagedActiveDirectoryConfigurationUpdates#builder()}.
         *
         * When the {@link Consumer} completes, {@link SelfManagedActiveDirectoryConfigurationUpdates.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryConfigurationUpdates)}.
         * 
         * @param selfManagedActiveDirectoryConfiguration
         *        a consumer that will call methods on {@link SelfManagedActiveDirectoryConfigurationUpdates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryConfigurationUpdates)
         */
        default Builder selfManagedActiveDirectoryConfiguration(
                Consumer<SelfManagedActiveDirectoryConfigurationUpdates.Builder> selfManagedActiveDirectoryConfiguration) {
            return selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryConfigurationUpdates.builder()
                    .applyMutation(selfManagedActiveDirectoryConfiguration).build());
        }

        /**
         * <p>
         * The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files,
         * folders, and file shares on the Amazon FSx for Windows File Server file system..
         * </p>
         * 
         * @param auditLogConfiguration
         *        The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of
         *        files, folders, and file shares on the Amazon FSx for Windows File Server file system..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditLogConfiguration(WindowsAuditLogCreateConfiguration auditLogConfiguration);

        /**
         * <p>
         * The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files,
         * folders, and file shares on the Amazon FSx for Windows File Server file system..
         * </p>
         * This is a convenience that creates an instance of the {@link WindowsAuditLogCreateConfiguration.Builder}
         * avoiding the need to create one manually via {@link WindowsAuditLogCreateConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link WindowsAuditLogCreateConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #auditLogConfiguration(WindowsAuditLogCreateConfiguration)}.
         * 
         * @param auditLogConfiguration
         *        a consumer that will call methods on {@link WindowsAuditLogCreateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #auditLogConfiguration(WindowsAuditLogCreateConfiguration)
         */
        default Builder auditLogConfiguration(Consumer<WindowsAuditLogCreateConfiguration.Builder> auditLogConfiguration) {
            return auditLogConfiguration(WindowsAuditLogCreateConfiguration.builder().applyMutation(auditLogConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String weeklyMaintenanceStartTime;

        private String dailyAutomaticBackupStartTime;

        private Integer automaticBackupRetentionDays;

        private Integer throughputCapacity;

        private SelfManagedActiveDirectoryConfigurationUpdates selfManagedActiveDirectoryConfiguration;

        private WindowsAuditLogCreateConfiguration auditLogConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFileSystemWindowsConfiguration model) {
            weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            dailyAutomaticBackupStartTime(model.dailyAutomaticBackupStartTime);
            automaticBackupRetentionDays(model.automaticBackupRetentionDays);
            throughputCapacity(model.throughputCapacity);
            selfManagedActiveDirectoryConfiguration(model.selfManagedActiveDirectoryConfiguration);
            auditLogConfiguration(model.auditLogConfiguration);
        }

        public final String getWeeklyMaintenanceStartTime() {
            return weeklyMaintenanceStartTime;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        @Override
        @Transient
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final String getDailyAutomaticBackupStartTime() {
            return dailyAutomaticBackupStartTime;
        }

        public final void setDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
        }

        @Override
        @Transient
        public final Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
            return this;
        }

        public final Integer getAutomaticBackupRetentionDays() {
            return automaticBackupRetentionDays;
        }

        public final void setAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
        }

        @Override
        @Transient
        public final Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
            return this;
        }

        public final Integer getThroughputCapacity() {
            return throughputCapacity;
        }

        public final void setThroughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
        }

        @Override
        @Transient
        public final Builder throughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
            return this;
        }

        public final SelfManagedActiveDirectoryConfigurationUpdates.Builder getSelfManagedActiveDirectoryConfiguration() {
            return selfManagedActiveDirectoryConfiguration != null ? selfManagedActiveDirectoryConfiguration.toBuilder() : null;
        }

        public final void setSelfManagedActiveDirectoryConfiguration(
                SelfManagedActiveDirectoryConfigurationUpdates.BuilderImpl selfManagedActiveDirectoryConfiguration) {
            this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration != null ? selfManagedActiveDirectoryConfiguration
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder selfManagedActiveDirectoryConfiguration(
                SelfManagedActiveDirectoryConfigurationUpdates selfManagedActiveDirectoryConfiguration) {
            this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration;
            return this;
        }

        public final WindowsAuditLogCreateConfiguration.Builder getAuditLogConfiguration() {
            return auditLogConfiguration != null ? auditLogConfiguration.toBuilder() : null;
        }

        public final void setAuditLogConfiguration(WindowsAuditLogCreateConfiguration.BuilderImpl auditLogConfiguration) {
            this.auditLogConfiguration = auditLogConfiguration != null ? auditLogConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder auditLogConfiguration(WindowsAuditLogCreateConfiguration auditLogConfiguration) {
            this.auditLogConfiguration = auditLogConfiguration;
            return this;
        }

        @Override
        public UpdateFileSystemWindowsConfiguration build() {
            return new UpdateFileSystemWindowsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
