/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyBackupRequest extends FSxRequest implements
        ToCopyableBuilder<CopyBackupRequest.Builder, CopyBackupRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CopyBackupRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> SOURCE_BACKUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceBackupId").getter(getter(CopyBackupRequest::sourceBackupId))
            .setter(setter(Builder::sourceBackupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBackupId").build()).build();

    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceRegion").getter(getter(CopyBackupRequest::sourceRegion)).setter(setter(Builder::sourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CopyBackupRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTags").getter(getter(CopyBackupRequest::copyTags)).setter(setter(Builder::copyTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTags").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CopyBackupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD,
            SOURCE_BACKUP_ID_FIELD, SOURCE_REGION_FIELD, KMS_KEY_ID_FIELD, COPY_TAGS_FIELD, TAGS_FIELD));

    private final String clientRequestToken;

    private final String sourceBackupId;

    private final String sourceRegion;

    private final String kmsKeyId;

    private final Boolean copyTags;

    private final List<Tag> tags;

    private CopyBackupRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.sourceBackupId = builder.sourceBackupId;
        this.sourceRegion = builder.sourceRegion;
        this.kmsKeyId = builder.kmsKeyId;
        this.copyTags = builder.copyTags;
        this.tags = builder.tags;
    }

    /**
     * Returns the value of the ClientRequestToken property for this object.
     * 
     * @return The value of the ClientRequestToken property for this object.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The ID of the source backup. Specifies the ID of the backup that's being copied.
     * </p>
     * 
     * @return The ID of the source backup. Specifies the ID of the backup that's being copied.
     */
    public final String sourceBackupId() {
        return sourceBackupId;
    }

    /**
     * <p>
     * The source Amazon Web Services Region of the backup. Specifies the Amazon Web Services Region from which the
     * backup is being copied. The source and destination Regions must be in the same Amazon Web Services partition. If
     * you don't specify a Region, <code>SourceRegion</code> defaults to the Region where the request is sent from
     * (in-Region copy).
     * </p>
     * 
     * @return The source Amazon Web Services Region of the backup. Specifies the Amazon Web Services Region from which
     *         the backup is being copied. The source and destination Regions must be in the same Amazon Web Services
     *         partition. If you don't specify a Region, <code>SourceRegion</code> defaults to the Region where the
     *         request is sent from (in-Region copy).
     */
    public final String sourceRegion() {
        return sourceRegion;
    }

    /**
     * Returns the value of the KmsKeyId property for this object.
     * 
     * @return The value of the KmsKeyId property for this object.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * A Boolean flag indicating whether tags from the source backup should be copied to the backup copy. This value
     * defaults to <code>false</code>.
     * </p>
     * <p>
     * If you set <code>CopyTags</code> to <code>true</code> and the source backup has existing tags, you can use the
     * <code>Tags</code> parameter to create new tags, provided that the sum of the source backup tags and the new tags
     * doesn't exceed 50. Both sets of tags are merged. If there are tag conflicts (for example, two tags with the same
     * key but different values), the tags created with the <code>Tags</code> parameter take precedence.
     * </p>
     * 
     * @return A Boolean flag indicating whether tags from the source backup should be copied to the backup copy. This
     *         value defaults to <code>false</code>.</p>
     *         <p>
     *         If you set <code>CopyTags</code> to <code>true</code> and the source backup has existing tags, you can
     *         use the <code>Tags</code> parameter to create new tags, provided that the sum of the source backup tags
     *         and the new tags doesn't exceed 50. Both sets of tags are merged. If there are tag conflicts (for
     *         example, two tags with the same key but different values), the tags created with the <code>Tags</code>
     *         parameter take precedence.
     */
    public final Boolean copyTags() {
        return copyTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(sourceBackupId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyBackupRequest)) {
            return false;
        }
        CopyBackupRequest other = (CopyBackupRequest) obj;
        return Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(sourceBackupId(), other.sourceBackupId())
                && Objects.equals(sourceRegion(), other.sourceRegion()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(copyTags(), other.copyTags()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyBackupRequest").add("ClientRequestToken", clientRequestToken())
                .add("SourceBackupId", sourceBackupId()).add("SourceRegion", sourceRegion()).add("KmsKeyId", kmsKeyId())
                .add("CopyTags", copyTags()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "SourceBackupId":
            return Optional.ofNullable(clazz.cast(sourceBackupId()));
        case "SourceRegion":
            return Optional.ofNullable(clazz.cast(sourceRegion()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "CopyTags":
            return Optional.ofNullable(clazz.cast(copyTags()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyBackupRequest, T> g) {
        return obj -> g.apply((CopyBackupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxRequest.Builder, SdkPojo, CopyableBuilder<Builder, CopyBackupRequest> {
        /**
         * Sets the value of the ClientRequestToken property for this object.
         *
         * @param clientRequestToken
         *        The new value for the ClientRequestToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The ID of the source backup. Specifies the ID of the backup that's being copied.
         * </p>
         * 
         * @param sourceBackupId
         *        The ID of the source backup. Specifies the ID of the backup that's being copied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceBackupId(String sourceBackupId);

        /**
         * <p>
         * The source Amazon Web Services Region of the backup. Specifies the Amazon Web Services Region from which the
         * backup is being copied. The source and destination Regions must be in the same Amazon Web Services partition.
         * If you don't specify a Region, <code>SourceRegion</code> defaults to the Region where the request is sent
         * from (in-Region copy).
         * </p>
         * 
         * @param sourceRegion
         *        The source Amazon Web Services Region of the backup. Specifies the Amazon Web Services Region from
         *        which the backup is being copied. The source and destination Regions must be in the same Amazon Web
         *        Services partition. If you don't specify a Region, <code>SourceRegion</code> defaults to the Region
         *        where the request is sent from (in-Region copy).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRegion(String sourceRegion);

        /**
         * Sets the value of the KmsKeyId property for this object.
         *
         * @param kmsKeyId
         *        The new value for the KmsKeyId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * A Boolean flag indicating whether tags from the source backup should be copied to the backup copy. This value
         * defaults to <code>false</code>.
         * </p>
         * <p>
         * If you set <code>CopyTags</code> to <code>true</code> and the source backup has existing tags, you can use
         * the <code>Tags</code> parameter to create new tags, provided that the sum of the source backup tags and the
         * new tags doesn't exceed 50. Both sets of tags are merged. If there are tag conflicts (for example, two tags
         * with the same key but different values), the tags created with the <code>Tags</code> parameter take
         * precedence.
         * </p>
         * 
         * @param copyTags
         *        A Boolean flag indicating whether tags from the source backup should be copied to the backup copy.
         *        This value defaults to <code>false</code>.</p>
         *        <p>
         *        If you set <code>CopyTags</code> to <code>true</code> and the source backup has existing tags, you can
         *        use the <code>Tags</code> parameter to create new tags, provided that the sum of the source backup
         *        tags and the new tags doesn't exceed 50. Both sets of tags are merged. If there are tag conflicts (for
         *        example, two tags with the same key but different values), the tags created with the <code>Tags</code>
         *        parameter take precedence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTags(Boolean copyTags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FSxRequest.BuilderImpl implements Builder {
        private String clientRequestToken;

        private String sourceBackupId;

        private String sourceRegion;

        private String kmsKeyId;

        private Boolean copyTags;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CopyBackupRequest model) {
            super(model);
            clientRequestToken(model.clientRequestToken);
            sourceBackupId(model.sourceBackupId);
            sourceRegion(model.sourceRegion);
            kmsKeyId(model.kmsKeyId);
            copyTags(model.copyTags);
            tags(model.tags);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getSourceBackupId() {
            return sourceBackupId;
        }

        public final void setSourceBackupId(String sourceBackupId) {
            this.sourceBackupId = sourceBackupId;
        }

        @Override
        public final Builder sourceBackupId(String sourceBackupId) {
            this.sourceBackupId = sourceBackupId;
            return this;
        }

        public final String getSourceRegion() {
            return sourceRegion;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Boolean getCopyTags() {
            return copyTags;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyBackupRequest build() {
            return new CopyBackupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
