/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request object for <code>DeleteFileSystem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFileSystemRequest extends FSxRequest implements
        ToCopyableBuilder<DeleteFileSystemRequest.Builder, DeleteFileSystemRequest> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemId").getter(getter(DeleteFileSystemRequest::fileSystemId))
            .setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(DeleteFileSystemRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<DeleteFileSystemWindowsConfiguration> WINDOWS_CONFIGURATION_FIELD = SdkField
            .<DeleteFileSystemWindowsConfiguration> builder(MarshallingType.SDK_POJO).memberName("WindowsConfiguration")
            .getter(getter(DeleteFileSystemRequest::windowsConfiguration)).setter(setter(Builder::windowsConfiguration))
            .constructor(DeleteFileSystemWindowsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowsConfiguration").build())
            .build();

    private static final SdkField<DeleteFileSystemLustreConfiguration> LUSTRE_CONFIGURATION_FIELD = SdkField
            .<DeleteFileSystemLustreConfiguration> builder(MarshallingType.SDK_POJO).memberName("LustreConfiguration")
            .getter(getter(DeleteFileSystemRequest::lustreConfiguration)).setter(setter(Builder::lustreConfiguration))
            .constructor(DeleteFileSystemLustreConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LustreConfiguration").build())
            .build();

    private static final SdkField<DeleteFileSystemOpenZFSConfiguration> OPEN_ZFS_CONFIGURATION_FIELD = SdkField
            .<DeleteFileSystemOpenZFSConfiguration> builder(MarshallingType.SDK_POJO).memberName("OpenZFSConfiguration")
            .getter(getter(DeleteFileSystemRequest::openZFSConfiguration)).setter(setter(Builder::openZFSConfiguration))
            .constructor(DeleteFileSystemOpenZFSConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenZFSConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, WINDOWS_CONFIGURATION_FIELD, LUSTRE_CONFIGURATION_FIELD, OPEN_ZFS_CONFIGURATION_FIELD));

    private final String fileSystemId;

    private final String clientRequestToken;

    private final DeleteFileSystemWindowsConfiguration windowsConfiguration;

    private final DeleteFileSystemLustreConfiguration lustreConfiguration;

    private final DeleteFileSystemOpenZFSConfiguration openZFSConfiguration;

    private DeleteFileSystemRequest(BuilderImpl builder) {
        super(builder);
        this.fileSystemId = builder.fileSystemId;
        this.clientRequestToken = builder.clientRequestToken;
        this.windowsConfiguration = builder.windowsConfiguration;
        this.lustreConfiguration = builder.lustreConfiguration;
        this.openZFSConfiguration = builder.openZFSConfiguration;
    }

    /**
     * <p>
     * The ID of the file system that you want to delete.
     * </p>
     * 
     * @return The ID of the file system that you want to delete.
     */
    public final String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent deletion. This token is
     * automatically filled on your behalf when using the Command Line Interface (CLI) or an Amazon Web Services SDK.
     * </p>
     * 
     * @return A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent deletion. This token is
     *         automatically filled on your behalf when using the Command Line Interface (CLI) or an Amazon Web Services
     *         SDK.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * Returns the value of the WindowsConfiguration property for this object.
     * 
     * @return The value of the WindowsConfiguration property for this object.
     */
    public final DeleteFileSystemWindowsConfiguration windowsConfiguration() {
        return windowsConfiguration;
    }

    /**
     * Returns the value of the LustreConfiguration property for this object.
     * 
     * @return The value of the LustreConfiguration property for this object.
     */
    public final DeleteFileSystemLustreConfiguration lustreConfiguration() {
        return lustreConfiguration;
    }

    /**
     * <p>
     * The configuration object for the OpenZFS file system used in the <code>DeleteFileSystem</code> operation.
     * </p>
     * 
     * @return The configuration object for the OpenZFS file system used in the <code>DeleteFileSystem</code> operation.
     */
    public final DeleteFileSystemOpenZFSConfiguration openZFSConfiguration() {
        return openZFSConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(windowsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(lustreConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(openZFSConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFileSystemRequest)) {
            return false;
        }
        DeleteFileSystemRequest other = (DeleteFileSystemRequest) obj;
        return Objects.equals(fileSystemId(), other.fileSystemId())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(windowsConfiguration(), other.windowsConfiguration())
                && Objects.equals(lustreConfiguration(), other.lustreConfiguration())
                && Objects.equals(openZFSConfiguration(), other.openZFSConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteFileSystemRequest").add("FileSystemId", fileSystemId())
                .add("ClientRequestToken", clientRequestToken()).add("WindowsConfiguration", windowsConfiguration())
                .add("LustreConfiguration", lustreConfiguration()).add("OpenZFSConfiguration", openZFSConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "WindowsConfiguration":
            return Optional.ofNullable(clazz.cast(windowsConfiguration()));
        case "LustreConfiguration":
            return Optional.ofNullable(clazz.cast(lustreConfiguration()));
        case "OpenZFSConfiguration":
            return Optional.ofNullable(clazz.cast(openZFSConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFileSystemRequest, T> g) {
        return obj -> g.apply((DeleteFileSystemRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteFileSystemRequest> {
        /**
         * <p>
         * The ID of the file system that you want to delete.
         * </p>
         * 
         * @param fileSystemId
         *        The ID of the file system that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent deletion. This token is
         * automatically filled on your behalf when using the Command Line Interface (CLI) or an Amazon Web Services
         * SDK.
         * </p>
         * 
         * @param clientRequestToken
         *        A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent deletion. This token
         *        is automatically filled on your behalf when using the Command Line Interface (CLI) or an Amazon Web
         *        Services SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * Sets the value of the WindowsConfiguration property for this object.
         *
         * @param windowsConfiguration
         *        The new value for the WindowsConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowsConfiguration(DeleteFileSystemWindowsConfiguration windowsConfiguration);

        /**
         * Sets the value of the WindowsConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link DeleteFileSystemWindowsConfiguration.Builder} avoiding the need to create one manually via
         * {@link DeleteFileSystemWindowsConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeleteFileSystemWindowsConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #windowsConfiguration(DeleteFileSystemWindowsConfiguration)}.
         * 
         * @param windowsConfiguration
         *        a consumer that will call methods on {@link DeleteFileSystemWindowsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #windowsConfiguration(DeleteFileSystemWindowsConfiguration)
         */
        default Builder windowsConfiguration(Consumer<DeleteFileSystemWindowsConfiguration.Builder> windowsConfiguration) {
            return windowsConfiguration(DeleteFileSystemWindowsConfiguration.builder().applyMutation(windowsConfiguration)
                    .build());
        }

        /**
         * Sets the value of the LustreConfiguration property for this object.
         *
         * @param lustreConfiguration
         *        The new value for the LustreConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lustreConfiguration(DeleteFileSystemLustreConfiguration lustreConfiguration);

        /**
         * Sets the value of the LustreConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link DeleteFileSystemLustreConfiguration.Builder} avoiding the need to create one manually via
         * {@link DeleteFileSystemLustreConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeleteFileSystemLustreConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #lustreConfiguration(DeleteFileSystemLustreConfiguration)}.
         * 
         * @param lustreConfiguration
         *        a consumer that will call methods on {@link DeleteFileSystemLustreConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lustreConfiguration(DeleteFileSystemLustreConfiguration)
         */
        default Builder lustreConfiguration(Consumer<DeleteFileSystemLustreConfiguration.Builder> lustreConfiguration) {
            return lustreConfiguration(DeleteFileSystemLustreConfiguration.builder().applyMutation(lustreConfiguration).build());
        }

        /**
         * <p>
         * The configuration object for the OpenZFS file system used in the <code>DeleteFileSystem</code> operation.
         * </p>
         * 
         * @param openZFSConfiguration
         *        The configuration object for the OpenZFS file system used in the <code>DeleteFileSystem</code>
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openZFSConfiguration(DeleteFileSystemOpenZFSConfiguration openZFSConfiguration);

        /**
         * <p>
         * The configuration object for the OpenZFS file system used in the <code>DeleteFileSystem</code> operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DeleteFileSystemOpenZFSConfiguration.Builder} avoiding the need to create one manually via
         * {@link DeleteFileSystemOpenZFSConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeleteFileSystemOpenZFSConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #openZFSConfiguration(DeleteFileSystemOpenZFSConfiguration)}.
         * 
         * @param openZFSConfiguration
         *        a consumer that will call methods on {@link DeleteFileSystemOpenZFSConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openZFSConfiguration(DeleteFileSystemOpenZFSConfiguration)
         */
        default Builder openZFSConfiguration(Consumer<DeleteFileSystemOpenZFSConfiguration.Builder> openZFSConfiguration) {
            return openZFSConfiguration(DeleteFileSystemOpenZFSConfiguration.builder().applyMutation(openZFSConfiguration)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FSxRequest.BuilderImpl implements Builder {
        private String fileSystemId;

        private String clientRequestToken;

        private DeleteFileSystemWindowsConfiguration windowsConfiguration;

        private DeleteFileSystemLustreConfiguration lustreConfiguration;

        private DeleteFileSystemOpenZFSConfiguration openZFSConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFileSystemRequest model) {
            super(model);
            fileSystemId(model.fileSystemId);
            clientRequestToken(model.clientRequestToken);
            windowsConfiguration(model.windowsConfiguration);
            lustreConfiguration(model.lustreConfiguration);
            openZFSConfiguration(model.openZFSConfiguration);
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final DeleteFileSystemWindowsConfiguration.Builder getWindowsConfiguration() {
            return windowsConfiguration != null ? windowsConfiguration.toBuilder() : null;
        }

        public final void setWindowsConfiguration(DeleteFileSystemWindowsConfiguration.BuilderImpl windowsConfiguration) {
            this.windowsConfiguration = windowsConfiguration != null ? windowsConfiguration.build() : null;
        }

        @Override
        public final Builder windowsConfiguration(DeleteFileSystemWindowsConfiguration windowsConfiguration) {
            this.windowsConfiguration = windowsConfiguration;
            return this;
        }

        public final DeleteFileSystemLustreConfiguration.Builder getLustreConfiguration() {
            return lustreConfiguration != null ? lustreConfiguration.toBuilder() : null;
        }

        public final void setLustreConfiguration(DeleteFileSystemLustreConfiguration.BuilderImpl lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration != null ? lustreConfiguration.build() : null;
        }

        @Override
        public final Builder lustreConfiguration(DeleteFileSystemLustreConfiguration lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration;
            return this;
        }

        public final DeleteFileSystemOpenZFSConfiguration.Builder getOpenZFSConfiguration() {
            return openZFSConfiguration != null ? openZFSConfiguration.toBuilder() : null;
        }

        public final void setOpenZFSConfiguration(DeleteFileSystemOpenZFSConfiguration.BuilderImpl openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration != null ? openZFSConfiguration.build() : null;
        }

        @Override
        public final Builder openZFSConfiguration(DeleteFileSystemOpenZFSConfiguration openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteFileSystemRequest build() {
            return new DeleteFileSystemRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
