/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDataRepositoryTasksResponse extends FSxResponse implements
        ToCopyableBuilder<DescribeDataRepositoryTasksResponse.Builder, DescribeDataRepositoryTasksResponse> {
    private static final SdkField<List<DataRepositoryTask>> DATA_REPOSITORY_TASKS_FIELD = SdkField
            .<List<DataRepositoryTask>> builder(MarshallingType.LIST)
            .memberName("DataRepositoryTasks")
            .getter(getter(DescribeDataRepositoryTasksResponse::dataRepositoryTasks))
            .setter(setter(Builder::dataRepositoryTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRepositoryTasks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataRepositoryTask> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataRepositoryTask::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeDataRepositoryTasksResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_REPOSITORY_TASKS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DataRepositoryTask> dataRepositoryTasks;

    private final String nextToken;

    private DescribeDataRepositoryTasksResponse(BuilderImpl builder) {
        super(builder);
        this.dataRepositoryTasks = builder.dataRepositoryTasks;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataRepositoryTasks property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataRepositoryTasks() {
        return dataRepositoryTasks != null && !(dataRepositoryTasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The collection of data repository task descriptions returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataRepositoryTasks} method.
     * </p>
     * 
     * @return The collection of data repository task descriptions returned.
     */
    public final List<DataRepositoryTask> dataRepositoryTasks() {
        return dataRepositoryTasks;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDataRepositoryTasks() ? dataRepositoryTasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataRepositoryTasksResponse)) {
            return false;
        }
        DescribeDataRepositoryTasksResponse other = (DescribeDataRepositoryTasksResponse) obj;
        return hasDataRepositoryTasks() == other.hasDataRepositoryTasks()
                && Objects.equals(dataRepositoryTasks(), other.dataRepositoryTasks())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDataRepositoryTasksResponse")
                .add("DataRepositoryTasks", hasDataRepositoryTasks() ? dataRepositoryTasks() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataRepositoryTasks":
            return Optional.ofNullable(clazz.cast(dataRepositoryTasks()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDataRepositoryTasksResponse, T> g) {
        return obj -> g.apply((DescribeDataRepositoryTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDataRepositoryTasksResponse> {
        /**
         * <p>
         * The collection of data repository task descriptions returned.
         * </p>
         * 
         * @param dataRepositoryTasks
         *        The collection of data repository task descriptions returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataRepositoryTasks(Collection<DataRepositoryTask> dataRepositoryTasks);

        /**
         * <p>
         * The collection of data repository task descriptions returned.
         * </p>
         * 
         * @param dataRepositoryTasks
         *        The collection of data repository task descriptions returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataRepositoryTasks(DataRepositoryTask... dataRepositoryTasks);

        /**
         * <p>
         * The collection of data repository task descriptions returned.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<DataRepositoryTask>.Builder}
         * avoiding the need to create one manually via {@link List<DataRepositoryTask>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataRepositoryTask>.Builder#build()} is called immediately
         * and its result is passed to {@link #dataRepositoryTasks(List<DataRepositoryTask>)}.
         * 
         * @param dataRepositoryTasks
         *        a consumer that will call methods on {@link List<DataRepositoryTask>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataRepositoryTasks(List<DataRepositoryTask>)
         */
        Builder dataRepositoryTasks(Consumer<DataRepositoryTask.Builder>... dataRepositoryTasks);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FSxResponse.BuilderImpl implements Builder {
        private List<DataRepositoryTask> dataRepositoryTasks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataRepositoryTasksResponse model) {
            super(model);
            dataRepositoryTasks(model.dataRepositoryTasks);
            nextToken(model.nextToken);
        }

        public final List<DataRepositoryTask.Builder> getDataRepositoryTasks() {
            List<DataRepositoryTask.Builder> result = DataRepositoryTasksCopier.copyToBuilder(this.dataRepositoryTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataRepositoryTasks(Collection<DataRepositoryTask.BuilderImpl> dataRepositoryTasks) {
            this.dataRepositoryTasks = DataRepositoryTasksCopier.copyFromBuilder(dataRepositoryTasks);
        }

        @Override
        public final Builder dataRepositoryTasks(Collection<DataRepositoryTask> dataRepositoryTasks) {
            this.dataRepositoryTasks = DataRepositoryTasksCopier.copy(dataRepositoryTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataRepositoryTasks(DataRepositoryTask... dataRepositoryTasks) {
            dataRepositoryTasks(Arrays.asList(dataRepositoryTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataRepositoryTasks(Consumer<DataRepositoryTask.Builder>... dataRepositoryTasks) {
            dataRepositoryTasks(Stream.of(dataRepositoryTasks).map(c -> DataRepositoryTask.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeDataRepositoryTasksResponse build() {
            return new DescribeDataRepositoryTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
