/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVolumesRequest extends FSxRequest implements
        ToCopyableBuilder<DescribeVolumesRequest.Builder, DescribeVolumesRequest> {
    private static final SdkField<List<String>> VOLUME_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VolumeIds")
            .getter(getter(DescribeVolumesRequest::volumeIds))
            .setter(setter(Builder::volumeIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<VolumeFilter>> FILTERS_FIELD = SdkField
            .<List<VolumeFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeVolumesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VolumeFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(VolumeFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeVolumesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeVolumesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_IDS_FIELD,
            FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> volumeIds;

    private final List<VolumeFilter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeVolumesRequest(BuilderImpl builder) {
        super(builder);
        this.volumeIds = builder.volumeIds;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the VolumeIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVolumeIds() {
        return volumeIds != null && !(volumeIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the volumes whose descriptions you want to retrieve.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVolumeIds} method.
     * </p>
     * 
     * @return The IDs of the volumes whose descriptions you want to retrieve.
     */
    public final List<String> volumeIds() {
        return volumeIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Enter a filter <code>Name</code> and <code>Values</code> pair to view a select set of volumes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Enter a filter <code>Name</code> and <code>Values</code> pair to view a select set of volumes.
     */
    public final List<VolumeFilter> filters() {
        return filters;
    }

    /**
     * Returns the value of the MaxResults property for this object.
     * 
     * @return The value of the MaxResults property for this object.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumeIds() ? volumeIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumesRequest)) {
            return false;
        }
        DescribeVolumesRequest other = (DescribeVolumesRequest) obj;
        return hasVolumeIds() == other.hasVolumeIds() && Objects.equals(volumeIds(), other.volumeIds())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeVolumesRequest").add("VolumeIds", hasVolumeIds() ? volumeIds() : null)
                .add("Filters", hasFilters() ? filters() : null).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeIds":
            return Optional.ofNullable(clazz.cast(volumeIds()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVolumesRequest, T> g) {
        return obj -> g.apply((DescribeVolumesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeVolumesRequest> {
        /**
         * <p>
         * The IDs of the volumes whose descriptions you want to retrieve.
         * </p>
         * 
         * @param volumeIds
         *        The IDs of the volumes whose descriptions you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeIds(Collection<String> volumeIds);

        /**
         * <p>
         * The IDs of the volumes whose descriptions you want to retrieve.
         * </p>
         * 
         * @param volumeIds
         *        The IDs of the volumes whose descriptions you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeIds(String... volumeIds);

        /**
         * <p>
         * Enter a filter <code>Name</code> and <code>Values</code> pair to view a select set of volumes.
         * </p>
         * 
         * @param filters
         *        Enter a filter <code>Name</code> and <code>Values</code> pair to view a select set of volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<VolumeFilter> filters);

        /**
         * <p>
         * Enter a filter <code>Name</code> and <code>Values</code> pair to view a select set of volumes.
         * </p>
         * 
         * @param filters
         *        Enter a filter <code>Name</code> and <code>Values</code> pair to view a select set of volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(VolumeFilter... filters);

        /**
         * <p>
         * Enter a filter <code>Name</code> and <code>Values</code> pair to view a select set of volumes.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<VolumeFilter>.Builder} avoiding the
         * need to create one manually via {@link List<VolumeFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VolumeFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<VolumeFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<VolumeFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<VolumeFilter>)
         */
        Builder filters(Consumer<VolumeFilter.Builder>... filters);

        /**
         * Sets the value of the MaxResults property for this object.
         *
         * @param maxResults
         *        The new value for the MaxResults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FSxRequest.BuilderImpl implements Builder {
        private List<String> volumeIds = DefaultSdkAutoConstructList.getInstance();

        private List<VolumeFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumesRequest model) {
            super(model);
            volumeIds(model.volumeIds);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getVolumeIds() {
            if (volumeIds instanceof SdkAutoConstructList) {
                return null;
            }
            return volumeIds;
        }

        public final void setVolumeIds(Collection<String> volumeIds) {
            this.volumeIds = VolumeIdsCopier.copy(volumeIds);
        }

        @Override
        public final Builder volumeIds(Collection<String> volumeIds) {
            this.volumeIds = VolumeIdsCopier.copy(volumeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeIds(String... volumeIds) {
            volumeIds(Arrays.asList(volumeIds));
            return this;
        }

        public final List<VolumeFilter.Builder> getFilters() {
            List<VolumeFilter.Builder> result = VolumeFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<VolumeFilter.BuilderImpl> filters) {
            this.filters = VolumeFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<VolumeFilter> filters) {
            this.filters = VolumeFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(VolumeFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<VolumeFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> VolumeFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeVolumesRequest build() {
            return new DescribeVolumesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
