/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Lustre logging configuration used when creating or updating an Amazon FSx for Lustre file system. Lustre logging
 * writes the enabled logging events for your file system to Amazon CloudWatch Logs.
 * </p>
 * <p>
 * Error and warning events can be logged from the following data repository operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Automatic export
 * </p>
 * </li>
 * <li>
 * <p>
 * Data repository tasks
 * </p>
 * </li>
 * </ul>
 * <p>
 * To learn more about Lustre logging, see <a
 * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/cw-event-logging.html">Logging to Amazon CloudWatch
 * Logs</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LustreLogCreateConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LustreLogCreateConfiguration.Builder, LustreLogCreateConfiguration> {
    private static final SdkField<String> LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Level")
            .getter(getter(LustreLogCreateConfiguration::levelAsString)).setter(setter(Builder::level))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Level").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Destination").getter(getter(LustreLogCreateConfiguration::destination))
            .setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LEVEL_FIELD, DESTINATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String level;

    private final String destination;

    private LustreLogCreateConfiguration(BuilderImpl builder) {
        this.level = builder.level;
        this.destination = builder.destination;
    }

    /**
     * <p>
     * Sets which data repository events are logged by Amazon FSx.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>WARN_ONLY</code> - only warning events are logged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR_ONLY</code> - only error events are logged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WARN_ERROR</code> - both warning events and error events are logged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> - logging of data repository events is turned off.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #level} will return
     * {@link LustreAccessAuditLogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #levelAsString}.
     * </p>
     * 
     * @return Sets which data repository events are logged by Amazon FSx.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>WARN_ONLY</code> - only warning events are logged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR_ONLY</code> - only error events are logged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WARN_ERROR</code> - both warning events and error events are logged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - logging of data repository events is turned off.
     *         </p>
     *         </li>
     * @see LustreAccessAuditLogLevel
     */
    public final LustreAccessAuditLogLevel level() {
        return LustreAccessAuditLogLevel.fromValue(level);
    }

    /**
     * <p>
     * Sets which data repository events are logged by Amazon FSx.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>WARN_ONLY</code> - only warning events are logged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR_ONLY</code> - only error events are logged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WARN_ERROR</code> - both warning events and error events are logged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> - logging of data repository events is turned off.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #level} will return
     * {@link LustreAccessAuditLogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #levelAsString}.
     * </p>
     * 
     * @return Sets which data repository events are logged by Amazon FSx.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>WARN_ONLY</code> - only warning events are logged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR_ONLY</code> - only error events are logged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WARN_ERROR</code> - both warning events and error events are logged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - logging of data repository events is turned off.
     *         </p>
     *         </li>
     * @see LustreAccessAuditLogLevel
     */
    public final String levelAsString() {
        return level;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that specifies the destination of the logs.
     * </p>
     * <p>
     * The destination can be any Amazon CloudWatch Logs log group ARN, with the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The destination ARN that you provide must be in the same Amazon Web Services partition, Amazon Web Services
     * Region, and Amazon Web Services account as your Amazon FSx file system.
     * </p>
     * </li>
     * <li>
     * <p>
     * The name of the Amazon CloudWatch Logs log group must begin with the <code>/aws/fsx</code> prefix.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you do not provide a destination, Amazon FSx will create and use a log stream in the CloudWatch Logs
     * <code>/aws/fsx/lustre</code> log group.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>Destination</code> is provided and the resource does not exist, the request will fail with a
     * <code>BadRequest</code> error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>Level</code> is set to <code>DISABLED</code>, you cannot specify a destination in
     * <code>Destination</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) that specifies the destination of the logs.</p>
     *         <p>
     *         The destination can be any Amazon CloudWatch Logs log group ARN, with the following requirements:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The destination ARN that you provide must be in the same Amazon Web Services partition, Amazon Web
     *         Services Region, and Amazon Web Services account as your Amazon FSx file system.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The name of the Amazon CloudWatch Logs log group must begin with the <code>/aws/fsx</code> prefix.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you do not provide a destination, Amazon FSx will create and use a log stream in the CloudWatch Logs
     *         <code>/aws/fsx/lustre</code> log group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>Destination</code> is provided and the resource does not exist, the request will fail with a
     *         <code>BadRequest</code> error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>Level</code> is set to <code>DISABLED</code>, you cannot specify a destination in
     *         <code>Destination</code>.
     *         </p>
     *         </li>
     */
    public final String destination() {
        return destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(levelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LustreLogCreateConfiguration)) {
            return false;
        }
        LustreLogCreateConfiguration other = (LustreLogCreateConfiguration) obj;
        return Objects.equals(levelAsString(), other.levelAsString()) && Objects.equals(destination(), other.destination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LustreLogCreateConfiguration").add("Level", levelAsString()).add("Destination", destination())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Level":
            return Optional.ofNullable(clazz.cast(levelAsString()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LustreLogCreateConfiguration, T> g) {
        return obj -> g.apply((LustreLogCreateConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LustreLogCreateConfiguration> {
        /**
         * <p>
         * Sets which data repository events are logged by Amazon FSx.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>WARN_ONLY</code> - only warning events are logged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR_ONLY</code> - only error events are logged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WARN_ERROR</code> - both warning events and error events are logged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> - logging of data repository events is turned off.
         * </p>
         * </li>
         * </ul>
         * 
         * @param level
         *        Sets which data repository events are logged by Amazon FSx.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>WARN_ONLY</code> - only warning events are logged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR_ONLY</code> - only error events are logged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WARN_ERROR</code> - both warning events and error events are logged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - logging of data repository events is turned off.
         *        </p>
         *        </li>
         * @see LustreAccessAuditLogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LustreAccessAuditLogLevel
         */
        Builder level(String level);

        /**
         * <p>
         * Sets which data repository events are logged by Amazon FSx.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>WARN_ONLY</code> - only warning events are logged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR_ONLY</code> - only error events are logged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WARN_ERROR</code> - both warning events and error events are logged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> - logging of data repository events is turned off.
         * </p>
         * </li>
         * </ul>
         * 
         * @param level
         *        Sets which data repository events are logged by Amazon FSx.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>WARN_ONLY</code> - only warning events are logged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR_ONLY</code> - only error events are logged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WARN_ERROR</code> - both warning events and error events are logged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - logging of data repository events is turned off.
         *        </p>
         *        </li>
         * @see LustreAccessAuditLogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LustreAccessAuditLogLevel
         */
        Builder level(LustreAccessAuditLogLevel level);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that specifies the destination of the logs.
         * </p>
         * <p>
         * The destination can be any Amazon CloudWatch Logs log group ARN, with the following requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The destination ARN that you provide must be in the same Amazon Web Services partition, Amazon Web Services
         * Region, and Amazon Web Services account as your Amazon FSx file system.
         * </p>
         * </li>
         * <li>
         * <p>
         * The name of the Amazon CloudWatch Logs log group must begin with the <code>/aws/fsx</code> prefix.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you do not provide a destination, Amazon FSx will create and use a log stream in the CloudWatch Logs
         * <code>/aws/fsx/lustre</code> log group.
         * </p>
         * </li>
         * <li>
         * <p>
         * If <code>Destination</code> is provided and the resource does not exist, the request will fail with a
         * <code>BadRequest</code> error.
         * </p>
         * </li>
         * <li>
         * <p>
         * If <code>Level</code> is set to <code>DISABLED</code>, you cannot specify a destination in
         * <code>Destination</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param destination
         *        The Amazon Resource Name (ARN) that specifies the destination of the logs.</p>
         *        <p>
         *        The destination can be any Amazon CloudWatch Logs log group ARN, with the following requirements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The destination ARN that you provide must be in the same Amazon Web Services partition, Amazon Web
         *        Services Region, and Amazon Web Services account as your Amazon FSx file system.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The name of the Amazon CloudWatch Logs log group must begin with the <code>/aws/fsx</code> prefix.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you do not provide a destination, Amazon FSx will create and use a log stream in the CloudWatch
         *        Logs <code>/aws/fsx/lustre</code> log group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If <code>Destination</code> is provided and the resource does not exist, the request will fail with a
         *        <code>BadRequest</code> error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If <code>Level</code> is set to <code>DISABLED</code>, you cannot specify a destination in
         *        <code>Destination</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);
    }

    static final class BuilderImpl implements Builder {
        private String level;

        private String destination;

        private BuilderImpl() {
        }

        private BuilderImpl(LustreLogCreateConfiguration model) {
            level(model.level);
            destination(model.destination);
        }

        public final String getLevel() {
            return level;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(LustreAccessAuditLogLevel level) {
            this.level(level == null ? null : level.toString());
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public LustreLogCreateConfiguration build() {
            return new LustreLogCreateConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
