/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreVolumeFromSnapshotResponse extends FSxResponse implements
        ToCopyableBuilder<RestoreVolumeFromSnapshotResponse.Builder, RestoreVolumeFromSnapshotResponse> {
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeId").getter(getter(RestoreVolumeFromSnapshotResponse::volumeId)).setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()).build();

    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Lifecycle").getter(getter(RestoreVolumeFromSnapshotResponse::lifecycleAsString))
            .setter(setter(Builder::lifecycle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ID_FIELD,
            LIFECYCLE_FIELD));

    private final String volumeId;

    private final String lifecycle;

    private RestoreVolumeFromSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.volumeId = builder.volumeId;
        this.lifecycle = builder.lifecycle;
    }

    /**
     * <p>
     * The ID of the volume that you restored.
     * </p>
     * 
     * @return The ID of the volume that you restored.
     */
    public final String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * The lifecycle state of the volume being restored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link VolumeLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lifecycleAsString}.
     * </p>
     * 
     * @return The lifecycle state of the volume being restored.
     * @see VolumeLifecycle
     */
    public final VolumeLifecycle lifecycle() {
        return VolumeLifecycle.fromValue(lifecycle);
    }

    /**
     * <p>
     * The lifecycle state of the volume being restored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link VolumeLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lifecycleAsString}.
     * </p>
     * 
     * @return The lifecycle state of the volume being restored.
     * @see VolumeLifecycle
     */
    public final String lifecycleAsString() {
        return lifecycle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreVolumeFromSnapshotResponse)) {
            return false;
        }
        RestoreVolumeFromSnapshotResponse other = (RestoreVolumeFromSnapshotResponse) obj;
        return Objects.equals(volumeId(), other.volumeId()) && Objects.equals(lifecycleAsString(), other.lifecycleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreVolumeFromSnapshotResponse").add("VolumeId", volumeId())
                .add("Lifecycle", lifecycleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreVolumeFromSnapshotResponse, T> g) {
        return obj -> g.apply((RestoreVolumeFromSnapshotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxResponse.Builder, SdkPojo, CopyableBuilder<Builder, RestoreVolumeFromSnapshotResponse> {
        /**
         * <p>
         * The ID of the volume that you restored.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume that you restored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The lifecycle state of the volume being restored.
         * </p>
         * 
         * @param lifecycle
         *        The lifecycle state of the volume being restored.
         * @see VolumeLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeLifecycle
         */
        Builder lifecycle(String lifecycle);

        /**
         * <p>
         * The lifecycle state of the volume being restored.
         * </p>
         * 
         * @param lifecycle
         *        The lifecycle state of the volume being restored.
         * @see VolumeLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeLifecycle
         */
        Builder lifecycle(VolumeLifecycle lifecycle);
    }

    static final class BuilderImpl extends FSxResponse.BuilderImpl implements Builder {
        private String volumeId;

        private String lifecycle;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreVolumeFromSnapshotResponse model) {
            super(model);
            volumeId(model.volumeId);
            lifecycle(model.lifecycle);
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getLifecycle() {
            return lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(VolumeLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        @Override
        public RestoreVolumeFromSnapshotResponse build() {
            return new RestoreVolumeFromSnapshotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
