/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * <p>
 * The types of limits on your service utilization. Limits include file system count, total throughput capacity, total
 * storage, and total user-initiated backups. These limits apply for a specific account in a specific Amazon Web
 * Services Region. You can increase some of them by contacting Amazon Web Services Support.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public enum ServiceLimit {
    FILE_SYSTEM_COUNT("FILE_SYSTEM_COUNT"),

    TOTAL_THROUGHPUT_CAPACITY("TOTAL_THROUGHPUT_CAPACITY"),

    TOTAL_STORAGE("TOTAL_STORAGE"),

    TOTAL_USER_INITIATED_BACKUPS("TOTAL_USER_INITIATED_BACKUPS"),

    TOTAL_USER_TAGS("TOTAL_USER_TAGS"),

    TOTAL_IN_PROGRESS_COPY_BACKUPS("TOTAL_IN_PROGRESS_COPY_BACKUPS"),

    STORAGE_VIRTUAL_MACHINES_PER_FILE_SYSTEM("STORAGE_VIRTUAL_MACHINES_PER_FILE_SYSTEM"),

    VOLUMES_PER_FILE_SYSTEM("VOLUMES_PER_FILE_SYSTEM"),

    TOTAL_SSD_IOPS("TOTAL_SSD_IOPS"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServiceLimit> VALUE_MAP = EnumUtils.uniqueIndex(ServiceLimit.class, ServiceLimit::toString);

    private final String value;

    private ServiceLimit(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ServiceLimit corresponding to the value
     */
    public static ServiceLimit fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ServiceLimit}s
     */
    public static Set<ServiceLimit> knownValues() {
        Set<ServiceLimit> knownValues = EnumSet.allOf(ServiceLimit.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
