/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response object for the <code>UpdateFileSystem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFileSystemResponse extends FSxResponse implements
        ToCopyableBuilder<UpdateFileSystemResponse.Builder, UpdateFileSystemResponse> {
    private static final SdkField<FileSystem> FILE_SYSTEM_FIELD = SdkField.<FileSystem> builder(MarshallingType.SDK_POJO)
            .memberName("FileSystem").getter(getter(UpdateFileSystemResponse::fileSystem)).setter(setter(Builder::fileSystem))
            .constructor(FileSystem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystem").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_FIELD));

    private final FileSystem fileSystem;

    private UpdateFileSystemResponse(BuilderImpl builder) {
        super(builder);
        this.fileSystem = builder.fileSystem;
    }

    /**
     * <p>
     * A description of the file system that was updated.
     * </p>
     * 
     * @return A description of the file system that was updated.
     */
    public final FileSystem fileSystem() {
        return fileSystem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileSystem());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFileSystemResponse)) {
            return false;
        }
        UpdateFileSystemResponse other = (UpdateFileSystemResponse) obj;
        return Objects.equals(fileSystem(), other.fileSystem());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFileSystemResponse").add("FileSystem", fileSystem()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileSystem":
            return Optional.ofNullable(clazz.cast(fileSystem()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFileSystemResponse, T> g) {
        return obj -> g.apply((UpdateFileSystemResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFileSystemResponse> {
        /**
         * <p>
         * A description of the file system that was updated.
         * </p>
         * 
         * @param fileSystem
         *        A description of the file system that was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystem(FileSystem fileSystem);

        /**
         * <p>
         * A description of the file system that was updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileSystem.Builder} avoiding the need to
         * create one manually via {@link FileSystem#builder()}.
         *
         * When the {@link Consumer} completes, {@link FileSystem.Builder#build()} is called immediately and its result
         * is passed to {@link #fileSystem(FileSystem)}.
         * 
         * @param fileSystem
         *        a consumer that will call methods on {@link FileSystem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileSystem(FileSystem)
         */
        default Builder fileSystem(Consumer<FileSystem.Builder> fileSystem) {
            return fileSystem(FileSystem.builder().applyMutation(fileSystem).build());
        }
    }

    static final class BuilderImpl extends FSxResponse.BuilderImpl implements Builder {
        private FileSystem fileSystem;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFileSystemResponse model) {
            super(model);
            fileSystem(model.fileSystem);
        }

        public final FileSystem.Builder getFileSystem() {
            return fileSystem != null ? fileSystem.toBuilder() : null;
        }

        public final void setFileSystem(FileSystem.BuilderImpl fileSystem) {
            this.fileSystem = fileSystem != null ? fileSystem.build() : null;
        }

        @Override
        public final Builder fileSystem(FileSystem fileSystem) {
            this.fileSystem = fileSystem;
            return this;
        }

        @Override
        public UpdateFileSystemResponse build() {
            return new UpdateFileSystemResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
