/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration of the ONTAP volume that you are creating.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOntapVolumeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateOntapVolumeConfiguration.Builder, CreateOntapVolumeConfiguration> {
    private static final SdkField<String> JUNCTION_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JunctionPath").getter(getter(CreateOntapVolumeConfiguration::junctionPath))
            .setter(setter(Builder::junctionPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JunctionPath").build()).build();

    private static final SdkField<String> SECURITY_STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityStyle").getter(getter(CreateOntapVolumeConfiguration::securityStyleAsString))
            .setter(setter(Builder::securityStyle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityStyle").build()).build();

    private static final SdkField<Integer> SIZE_IN_MEGABYTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SizeInMegabytes").getter(getter(CreateOntapVolumeConfiguration::sizeInMegabytes))
            .setter(setter(Builder::sizeInMegabytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInMegabytes").build()).build();

    private static final SdkField<Boolean> STORAGE_EFFICIENCY_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StorageEfficiencyEnabled").getter(getter(CreateOntapVolumeConfiguration::storageEfficiencyEnabled))
            .setter(setter(Builder::storageEfficiencyEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEfficiencyEnabled").build())
            .build();

    private static final SdkField<String> STORAGE_VIRTUAL_MACHINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageVirtualMachineId").getter(getter(CreateOntapVolumeConfiguration::storageVirtualMachineId))
            .setter(setter(Builder::storageVirtualMachineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageVirtualMachineId").build())
            .build();

    private static final SdkField<TieringPolicy> TIERING_POLICY_FIELD = SdkField
            .<TieringPolicy> builder(MarshallingType.SDK_POJO).memberName("TieringPolicy")
            .getter(getter(CreateOntapVolumeConfiguration::tieringPolicy)).setter(setter(Builder::tieringPolicy))
            .constructor(TieringPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JUNCTION_PATH_FIELD,
            SECURITY_STYLE_FIELD, SIZE_IN_MEGABYTES_FIELD, STORAGE_EFFICIENCY_ENABLED_FIELD, STORAGE_VIRTUAL_MACHINE_ID_FIELD,
            TIERING_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String junctionPath;

    private final String securityStyle;

    private final Integer sizeInMegabytes;

    private final Boolean storageEfficiencyEnabled;

    private final String storageVirtualMachineId;

    private final TieringPolicy tieringPolicy;

    private CreateOntapVolumeConfiguration(BuilderImpl builder) {
        this.junctionPath = builder.junctionPath;
        this.securityStyle = builder.securityStyle;
        this.sizeInMegabytes = builder.sizeInMegabytes;
        this.storageEfficiencyEnabled = builder.storageEfficiencyEnabled;
        this.storageVirtualMachineId = builder.storageVirtualMachineId;
        this.tieringPolicy = builder.tieringPolicy;
    }

    /**
     * <p>
     * Specifies the location in the SVM's namespace where the volume is mounted. The <code>JunctionPath</code> must
     * have a leading forward slash, such as <code>/vol3</code>.
     * </p>
     * 
     * @return Specifies the location in the SVM's namespace where the volume is mounted. The <code>JunctionPath</code>
     *         must have a leading forward slash, such as <code>/vol3</code>.
     */
    public final String junctionPath() {
        return junctionPath;
    }

    /**
     * <p>
     * Specifies the security style for the volume. If a volume's security style is not specified, it is automatically
     * set to the root volume's security style. The security style determines the type of permissions that FSx for ONTAP
     * uses to control data access. For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html#volume-security-style">Volume
     * security style</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>. Specify one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS clients,
     * and an application accessing the data uses a UNIX user as the service account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB
     * clients, and an application accessing the data uses a Windows user as the service account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users consist of
     * both NFS and SMB clients.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #securityStyle}
     * will return {@link SecurityStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #securityStyleAsString}.
     * </p>
     * 
     * @return Specifies the security style for the volume. If a volume's security style is not specified, it is
     *         automatically set to the root volume's security style. The security style determines the type of
     *         permissions that FSx for ONTAP uses to control data access. For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html#volume-security-style"
     *         >Volume security style</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>. Specify one of the
     *         following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS
     *         clients, and an application accessing the data uses a UNIX user as the service account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB
     *         clients, and an application accessing the data uses a Windows user as the service account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users
     *         consist of both NFS and SMB clients.
     *         </p>
     *         </li>
     * @see SecurityStyle
     */
    public final SecurityStyle securityStyle() {
        return SecurityStyle.fromValue(securityStyle);
    }

    /**
     * <p>
     * Specifies the security style for the volume. If a volume's security style is not specified, it is automatically
     * set to the root volume's security style. The security style determines the type of permissions that FSx for ONTAP
     * uses to control data access. For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html#volume-security-style">Volume
     * security style</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>. Specify one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS clients,
     * and an application accessing the data uses a UNIX user as the service account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB
     * clients, and an application accessing the data uses a Windows user as the service account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users consist of
     * both NFS and SMB clients.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #securityStyle}
     * will return {@link SecurityStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #securityStyleAsString}.
     * </p>
     * 
     * @return Specifies the security style for the volume. If a volume's security style is not specified, it is
     *         automatically set to the root volume's security style. The security style determines the type of
     *         permissions that FSx for ONTAP uses to control data access. For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html#volume-security-style"
     *         >Volume security style</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>. Specify one of the
     *         following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS
     *         clients, and an application accessing the data uses a UNIX user as the service account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB
     *         clients, and an application accessing the data uses a Windows user as the service account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users
     *         consist of both NFS and SMB clients.
     *         </p>
     *         </li>
     * @see SecurityStyle
     */
    public final String securityStyleAsString() {
        return securityStyle;
    }

    /**
     * <p>
     * Specifies the size of the volume, in megabytes (MB), that you are creating.
     * </p>
     * 
     * @return Specifies the size of the volume, in megabytes (MB), that you are creating.
     */
    public final Integer sizeInMegabytes() {
        return sizeInMegabytes;
    }

    /**
     * <p>
     * Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
     * </p>
     * 
     * @return Set to true to enable deduplication, compression, and compaction storage efficiency features on the
     *         volume.
     */
    public final Boolean storageEfficiencyEnabled() {
        return storageEfficiencyEnabled;
    }

    /**
     * <p>
     * Specifies the ONTAP SVM in which to create the volume.
     * </p>
     * 
     * @return Specifies the ONTAP SVM in which to create the volume.
     */
    public final String storageVirtualMachineId() {
        return storageVirtualMachineId;
    }

    /**
     * Returns the value of the TieringPolicy property for this object.
     * 
     * @return The value of the TieringPolicy property for this object.
     */
    public final TieringPolicy tieringPolicy() {
        return tieringPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(junctionPath());
        hashCode = 31 * hashCode + Objects.hashCode(securityStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInMegabytes());
        hashCode = 31 * hashCode + Objects.hashCode(storageEfficiencyEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(storageVirtualMachineId());
        hashCode = 31 * hashCode + Objects.hashCode(tieringPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOntapVolumeConfiguration)) {
            return false;
        }
        CreateOntapVolumeConfiguration other = (CreateOntapVolumeConfiguration) obj;
        return Objects.equals(junctionPath(), other.junctionPath())
                && Objects.equals(securityStyleAsString(), other.securityStyleAsString())
                && Objects.equals(sizeInMegabytes(), other.sizeInMegabytes())
                && Objects.equals(storageEfficiencyEnabled(), other.storageEfficiencyEnabled())
                && Objects.equals(storageVirtualMachineId(), other.storageVirtualMachineId())
                && Objects.equals(tieringPolicy(), other.tieringPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateOntapVolumeConfiguration").add("JunctionPath", junctionPath())
                .add("SecurityStyle", securityStyleAsString()).add("SizeInMegabytes", sizeInMegabytes())
                .add("StorageEfficiencyEnabled", storageEfficiencyEnabled())
                .add("StorageVirtualMachineId", storageVirtualMachineId()).add("TieringPolicy", tieringPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JunctionPath":
            return Optional.ofNullable(clazz.cast(junctionPath()));
        case "SecurityStyle":
            return Optional.ofNullable(clazz.cast(securityStyleAsString()));
        case "SizeInMegabytes":
            return Optional.ofNullable(clazz.cast(sizeInMegabytes()));
        case "StorageEfficiencyEnabled":
            return Optional.ofNullable(clazz.cast(storageEfficiencyEnabled()));
        case "StorageVirtualMachineId":
            return Optional.ofNullable(clazz.cast(storageVirtualMachineId()));
        case "TieringPolicy":
            return Optional.ofNullable(clazz.cast(tieringPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOntapVolumeConfiguration, T> g) {
        return obj -> g.apply((CreateOntapVolumeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateOntapVolumeConfiguration> {
        /**
         * <p>
         * Specifies the location in the SVM's namespace where the volume is mounted. The <code>JunctionPath</code> must
         * have a leading forward slash, such as <code>/vol3</code>.
         * </p>
         * 
         * @param junctionPath
         *        Specifies the location in the SVM's namespace where the volume is mounted. The
         *        <code>JunctionPath</code> must have a leading forward slash, such as <code>/vol3</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder junctionPath(String junctionPath);

        /**
         * <p>
         * Specifies the security style for the volume. If a volume's security style is not specified, it is
         * automatically set to the root volume's security style. The security style determines the type of permissions
         * that FSx for ONTAP uses to control data access. For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html#volume-security-style">Volume
         * security style</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>. Specify one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS
         * clients, and an application accessing the data uses a UNIX user as the service account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB
         * clients, and an application accessing the data uses a Windows user as the service account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users consist of
         * both NFS and SMB clients.
         * </p>
         * </li>
         * </ul>
         * 
         * @param securityStyle
         *        Specifies the security style for the volume. If a volume's security style is not specified, it is
         *        automatically set to the root volume's security style. The security style determines the type of
         *        permissions that FSx for ONTAP uses to control data access. For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html#volume-security-style"
         *        >Volume security style</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>. Specify one of the
         *        following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS
         *        clients, and an application accessing the data uses a UNIX user as the service account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are
         *        SMB clients, and an application accessing the data uses a Windows user as the service account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users
         *        consist of both NFS and SMB clients.
         *        </p>
         *        </li>
         * @see SecurityStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityStyle
         */
        Builder securityStyle(String securityStyle);

        /**
         * <p>
         * Specifies the security style for the volume. If a volume's security style is not specified, it is
         * automatically set to the root volume's security style. The security style determines the type of permissions
         * that FSx for ONTAP uses to control data access. For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html#volume-security-style">Volume
         * security style</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>. Specify one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS
         * clients, and an application accessing the data uses a UNIX user as the service account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB
         * clients, and an application accessing the data uses a Windows user as the service account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users consist of
         * both NFS and SMB clients.
         * </p>
         * </li>
         * </ul>
         * 
         * @param securityStyle
         *        Specifies the security style for the volume. If a volume's security style is not specified, it is
         *        automatically set to the root volume's security style. The security style determines the type of
         *        permissions that FSx for ONTAP uses to control data access. For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html#volume-security-style"
         *        >Volume security style</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>. Specify one of the
         *        following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS
         *        clients, and an application accessing the data uses a UNIX user as the service account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are
         *        SMB clients, and an application accessing the data uses a Windows user as the service account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users
         *        consist of both NFS and SMB clients.
         *        </p>
         *        </li>
         * @see SecurityStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityStyle
         */
        Builder securityStyle(SecurityStyle securityStyle);

        /**
         * <p>
         * Specifies the size of the volume, in megabytes (MB), that you are creating.
         * </p>
         * 
         * @param sizeInMegabytes
         *        Specifies the size of the volume, in megabytes (MB), that you are creating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInMegabytes(Integer sizeInMegabytes);

        /**
         * <p>
         * Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
         * </p>
         * 
         * @param storageEfficiencyEnabled
         *        Set to true to enable deduplication, compression, and compaction storage efficiency features on the
         *        volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageEfficiencyEnabled(Boolean storageEfficiencyEnabled);

        /**
         * <p>
         * Specifies the ONTAP SVM in which to create the volume.
         * </p>
         * 
         * @param storageVirtualMachineId
         *        Specifies the ONTAP SVM in which to create the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageVirtualMachineId(String storageVirtualMachineId);

        /**
         * Sets the value of the TieringPolicy property for this object.
         *
         * @param tieringPolicy
         *        The new value for the TieringPolicy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tieringPolicy(TieringPolicy tieringPolicy);

        /**
         * Sets the value of the TieringPolicy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TieringPolicy.Builder} avoiding the need
         * to create one manually via {@link TieringPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TieringPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #tieringPolicy(TieringPolicy)}.
         * 
         * @param tieringPolicy
         *        a consumer that will call methods on {@link TieringPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tieringPolicy(TieringPolicy)
         */
        default Builder tieringPolicy(Consumer<TieringPolicy.Builder> tieringPolicy) {
            return tieringPolicy(TieringPolicy.builder().applyMutation(tieringPolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String junctionPath;

        private String securityStyle;

        private Integer sizeInMegabytes;

        private Boolean storageEfficiencyEnabled;

        private String storageVirtualMachineId;

        private TieringPolicy tieringPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOntapVolumeConfiguration model) {
            junctionPath(model.junctionPath);
            securityStyle(model.securityStyle);
            sizeInMegabytes(model.sizeInMegabytes);
            storageEfficiencyEnabled(model.storageEfficiencyEnabled);
            storageVirtualMachineId(model.storageVirtualMachineId);
            tieringPolicy(model.tieringPolicy);
        }

        public final String getJunctionPath() {
            return junctionPath;
        }

        public final void setJunctionPath(String junctionPath) {
            this.junctionPath = junctionPath;
        }

        @Override
        public final Builder junctionPath(String junctionPath) {
            this.junctionPath = junctionPath;
            return this;
        }

        public final String getSecurityStyle() {
            return securityStyle;
        }

        public final void setSecurityStyle(String securityStyle) {
            this.securityStyle = securityStyle;
        }

        @Override
        public final Builder securityStyle(String securityStyle) {
            this.securityStyle = securityStyle;
            return this;
        }

        @Override
        public final Builder securityStyle(SecurityStyle securityStyle) {
            this.securityStyle(securityStyle == null ? null : securityStyle.toString());
            return this;
        }

        public final Integer getSizeInMegabytes() {
            return sizeInMegabytes;
        }

        public final void setSizeInMegabytes(Integer sizeInMegabytes) {
            this.sizeInMegabytes = sizeInMegabytes;
        }

        @Override
        public final Builder sizeInMegabytes(Integer sizeInMegabytes) {
            this.sizeInMegabytes = sizeInMegabytes;
            return this;
        }

        public final Boolean getStorageEfficiencyEnabled() {
            return storageEfficiencyEnabled;
        }

        public final void setStorageEfficiencyEnabled(Boolean storageEfficiencyEnabled) {
            this.storageEfficiencyEnabled = storageEfficiencyEnabled;
        }

        @Override
        public final Builder storageEfficiencyEnabled(Boolean storageEfficiencyEnabled) {
            this.storageEfficiencyEnabled = storageEfficiencyEnabled;
            return this;
        }

        public final String getStorageVirtualMachineId() {
            return storageVirtualMachineId;
        }

        public final void setStorageVirtualMachineId(String storageVirtualMachineId) {
            this.storageVirtualMachineId = storageVirtualMachineId;
        }

        @Override
        public final Builder storageVirtualMachineId(String storageVirtualMachineId) {
            this.storageVirtualMachineId = storageVirtualMachineId;
            return this;
        }

        public final TieringPolicy.Builder getTieringPolicy() {
            return tieringPolicy != null ? tieringPolicy.toBuilder() : null;
        }

        public final void setTieringPolicy(TieringPolicy.BuilderImpl tieringPolicy) {
            this.tieringPolicy = tieringPolicy != null ? tieringPolicy.build() : null;
        }

        @Override
        public final Builder tieringPolicy(TieringPolicy tieringPolicy) {
            this.tieringPolicy = tieringPolicy;
            return this;
        }

        @Override
        public CreateOntapVolumeConfiguration build() {
            return new CreateOntapVolumeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
