/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of an Amazon FSx for NetApp ONTAP volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OntapVolumeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OntapVolumeConfiguration.Builder, OntapVolumeConfiguration> {
    private static final SdkField<String> FLEX_CACHE_ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlexCacheEndpointType").getter(getter(OntapVolumeConfiguration::flexCacheEndpointTypeAsString))
            .setter(setter(Builder::flexCacheEndpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlexCacheEndpointType").build())
            .build();

    private static final SdkField<String> JUNCTION_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JunctionPath").getter(getter(OntapVolumeConfiguration::junctionPath))
            .setter(setter(Builder::junctionPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JunctionPath").build()).build();

    private static final SdkField<String> SECURITY_STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityStyle").getter(getter(OntapVolumeConfiguration::securityStyleAsString))
            .setter(setter(Builder::securityStyle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityStyle").build()).build();

    private static final SdkField<Integer> SIZE_IN_MEGABYTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SizeInMegabytes").getter(getter(OntapVolumeConfiguration::sizeInMegabytes))
            .setter(setter(Builder::sizeInMegabytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInMegabytes").build()).build();

    private static final SdkField<Boolean> STORAGE_EFFICIENCY_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StorageEfficiencyEnabled").getter(getter(OntapVolumeConfiguration::storageEfficiencyEnabled))
            .setter(setter(Builder::storageEfficiencyEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEfficiencyEnabled").build())
            .build();

    private static final SdkField<String> STORAGE_VIRTUAL_MACHINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageVirtualMachineId").getter(getter(OntapVolumeConfiguration::storageVirtualMachineId))
            .setter(setter(Builder::storageVirtualMachineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageVirtualMachineId").build())
            .build();

    private static final SdkField<Boolean> STORAGE_VIRTUAL_MACHINE_ROOT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("StorageVirtualMachineRoot")
            .getter(getter(OntapVolumeConfiguration::storageVirtualMachineRoot))
            .setter(setter(Builder::storageVirtualMachineRoot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageVirtualMachineRoot").build())
            .build();

    private static final SdkField<TieringPolicy> TIERING_POLICY_FIELD = SdkField
            .<TieringPolicy> builder(MarshallingType.SDK_POJO).memberName("TieringPolicy")
            .getter(getter(OntapVolumeConfiguration::tieringPolicy)).setter(setter(Builder::tieringPolicy))
            .constructor(TieringPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringPolicy").build()).build();

    private static final SdkField<String> UUID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UUID")
            .getter(getter(OntapVolumeConfiguration::uuid)).setter(setter(Builder::uuid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UUID").build()).build();

    private static final SdkField<String> ONTAP_VOLUME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OntapVolumeType").getter(getter(OntapVolumeConfiguration::ontapVolumeTypeAsString))
            .setter(setter(Builder::ontapVolumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OntapVolumeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FLEX_CACHE_ENDPOINT_TYPE_FIELD, JUNCTION_PATH_FIELD, SECURITY_STYLE_FIELD, SIZE_IN_MEGABYTES_FIELD,
            STORAGE_EFFICIENCY_ENABLED_FIELD, STORAGE_VIRTUAL_MACHINE_ID_FIELD, STORAGE_VIRTUAL_MACHINE_ROOT_FIELD,
            TIERING_POLICY_FIELD, UUID_FIELD, ONTAP_VOLUME_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String flexCacheEndpointType;

    private final String junctionPath;

    private final String securityStyle;

    private final Integer sizeInMegabytes;

    private final Boolean storageEfficiencyEnabled;

    private final String storageVirtualMachineId;

    private final Boolean storageVirtualMachineRoot;

    private final TieringPolicy tieringPolicy;

    private final String uuid;

    private final String ontapVolumeType;

    private OntapVolumeConfiguration(BuilderImpl builder) {
        this.flexCacheEndpointType = builder.flexCacheEndpointType;
        this.junctionPath = builder.junctionPath;
        this.securityStyle = builder.securityStyle;
        this.sizeInMegabytes = builder.sizeInMegabytes;
        this.storageEfficiencyEnabled = builder.storageEfficiencyEnabled;
        this.storageVirtualMachineId = builder.storageVirtualMachineId;
        this.storageVirtualMachineRoot = builder.storageVirtualMachineRoot;
        this.tieringPolicy = builder.tieringPolicy;
        this.uuid = builder.uuid;
        this.ontapVolumeType = builder.ontapVolumeType;
    }

    /**
     * <p>
     * Specifies the FlexCache endpoint type of the volume. Valid values are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code> specifies that the volume doesn't have a FlexCache configuration. <code>NONE</code> is the
     * default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ORIGIN</code> specifies that the volume is the origin volume for a FlexCache volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CACHE</code> specifies that the volume is a FlexCache volume.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #flexCacheEndpointType} will return {@link FlexCacheEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #flexCacheEndpointTypeAsString}.
     * </p>
     * 
     * @return Specifies the FlexCache endpoint type of the volume. Valid values are the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code> specifies that the volume doesn't have a FlexCache configuration. <code>NONE</code> is
     *         the default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ORIGIN</code> specifies that the volume is the origin volume for a FlexCache volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CACHE</code> specifies that the volume is a FlexCache volume.
     *         </p>
     *         </li>
     * @see FlexCacheEndpointType
     */
    public final FlexCacheEndpointType flexCacheEndpointType() {
        return FlexCacheEndpointType.fromValue(flexCacheEndpointType);
    }

    /**
     * <p>
     * Specifies the FlexCache endpoint type of the volume. Valid values are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code> specifies that the volume doesn't have a FlexCache configuration. <code>NONE</code> is the
     * default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ORIGIN</code> specifies that the volume is the origin volume for a FlexCache volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CACHE</code> specifies that the volume is a FlexCache volume.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #flexCacheEndpointType} will return {@link FlexCacheEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #flexCacheEndpointTypeAsString}.
     * </p>
     * 
     * @return Specifies the FlexCache endpoint type of the volume. Valid values are the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code> specifies that the volume doesn't have a FlexCache configuration. <code>NONE</code> is
     *         the default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ORIGIN</code> specifies that the volume is the origin volume for a FlexCache volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CACHE</code> specifies that the volume is a FlexCache volume.
     *         </p>
     *         </li>
     * @see FlexCacheEndpointType
     */
    public final String flexCacheEndpointTypeAsString() {
        return flexCacheEndpointType;
    }

    /**
     * <p>
     * Specifies the directory that network-attached storage (NAS) clients use to mount the volume, along with the
     * storage virtual machine (SVM) Domain Name System (DNS) name or IP address. You can create a
     * <code>JunctionPath</code> directly below a parent volume junction or on a directory within a volume. A
     * <code>JunctionPath</code> for a volume named <code>vol3</code> might be <code>/vol1/vol2/vol3</code>, or
     * <code>/vol1/dir2/vol3</code>, or even <code>/dir1/dir2/vol3</code>.
     * </p>
     * 
     * @return Specifies the directory that network-attached storage (NAS) clients use to mount the volume, along with
     *         the storage virtual machine (SVM) Domain Name System (DNS) name or IP address. You can create a
     *         <code>JunctionPath</code> directly below a parent volume junction or on a directory within a volume. A
     *         <code>JunctionPath</code> for a volume named <code>vol3</code> might be <code>/vol1/vol2/vol3</code>, or
     *         <code>/vol1/dir2/vol3</code>, or even <code>/dir1/dir2/vol3</code>.
     */
    public final String junctionPath() {
        return junctionPath;
    }

    /**
     * <p>
     * The security style for the volume, which can be <code>UNIX</code>, <code>NTFS</code>, or <code>MIXED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #securityStyle}
     * will return {@link SecurityStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #securityStyleAsString}.
     * </p>
     * 
     * @return The security style for the volume, which can be <code>UNIX</code>, <code>NTFS</code>, or
     *         <code>MIXED</code>.
     * @see SecurityStyle
     */
    public final SecurityStyle securityStyle() {
        return SecurityStyle.fromValue(securityStyle);
    }

    /**
     * <p>
     * The security style for the volume, which can be <code>UNIX</code>, <code>NTFS</code>, or <code>MIXED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #securityStyle}
     * will return {@link SecurityStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #securityStyleAsString}.
     * </p>
     * 
     * @return The security style for the volume, which can be <code>UNIX</code>, <code>NTFS</code>, or
     *         <code>MIXED</code>.
     * @see SecurityStyle
     */
    public final String securityStyleAsString() {
        return securityStyle;
    }

    /**
     * <p>
     * The configured size of the volume, in megabytes (MBs).
     * </p>
     * 
     * @return The configured size of the volume, in megabytes (MBs).
     */
    public final Integer sizeInMegabytes() {
        return sizeInMegabytes;
    }

    /**
     * <p>
     * The volume's storage efficiency setting.
     * </p>
     * 
     * @return The volume's storage efficiency setting.
     */
    public final Boolean storageEfficiencyEnabled() {
        return storageEfficiencyEnabled;
    }

    /**
     * <p>
     * The ID of the volume's storage virtual machine.
     * </p>
     * 
     * @return The ID of the volume's storage virtual machine.
     */
    public final String storageVirtualMachineId() {
        return storageVirtualMachineId;
    }

    /**
     * <p>
     * A Boolean flag indicating whether this volume is the root volume for its storage virtual machine (SVM). Only one
     * volume on an SVM can be the root volume. This value defaults to <code>false</code>. If this value is
     * <code>true</code>, then this is the SVM root volume.
     * </p>
     * <p>
     * This flag is useful when you're deleting an SVM, because you must first delete all non-root volumes. This flag,
     * when set to <code>false</code>, helps you identify which volumes to delete before you can delete the SVM.
     * </p>
     * 
     * @return A Boolean flag indicating whether this volume is the root volume for its storage virtual machine (SVM).
     *         Only one volume on an SVM can be the root volume. This value defaults to <code>false</code>. If this
     *         value is <code>true</code>, then this is the SVM root volume.</p>
     *         <p>
     *         This flag is useful when you're deleting an SVM, because you must first delete all non-root volumes. This
     *         flag, when set to <code>false</code>, helps you identify which volumes to delete before you can delete
     *         the SVM.
     */
    public final Boolean storageVirtualMachineRoot() {
        return storageVirtualMachineRoot;
    }

    /**
     * <p>
     * The volume's <code>TieringPolicy</code> setting.
     * </p>
     * 
     * @return The volume's <code>TieringPolicy</code> setting.
     */
    public final TieringPolicy tieringPolicy() {
        return tieringPolicy;
    }

    /**
     * <p>
     * The volume's universally unique identifier (UUID).
     * </p>
     * 
     * @return The volume's universally unique identifier (UUID).
     */
    public final String uuid() {
        return uuid;
    }

    /**
     * <p>
     * Specifies the type of volume. Valid values are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RW</code> specifies a read/write volume. <code>RW</code> is the default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DP</code> specifies a data-protection volume. You can protect data by replicating it to data-protection
     * mirror copies. If a disaster occurs, you can use these data-protection mirror copies to recover data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LS</code> specifies a load-sharing mirror volume. A load-sharing mirror reduces the network traffic to a
     * FlexVol volume by providing additional read-only access to clients.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ontapVolumeType}
     * will return {@link OntapVolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ontapVolumeTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of volume. Valid values are the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RW</code> specifies a read/write volume. <code>RW</code> is the default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DP</code> specifies a data-protection volume. You can protect data by replicating it to
     *         data-protection mirror copies. If a disaster occurs, you can use these data-protection mirror copies to
     *         recover data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LS</code> specifies a load-sharing mirror volume. A load-sharing mirror reduces the network traffic
     *         to a FlexVol volume by providing additional read-only access to clients.
     *         </p>
     *         </li>
     * @see OntapVolumeType
     */
    public final OntapVolumeType ontapVolumeType() {
        return OntapVolumeType.fromValue(ontapVolumeType);
    }

    /**
     * <p>
     * Specifies the type of volume. Valid values are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RW</code> specifies a read/write volume. <code>RW</code> is the default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DP</code> specifies a data-protection volume. You can protect data by replicating it to data-protection
     * mirror copies. If a disaster occurs, you can use these data-protection mirror copies to recover data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LS</code> specifies a load-sharing mirror volume. A load-sharing mirror reduces the network traffic to a
     * FlexVol volume by providing additional read-only access to clients.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ontapVolumeType}
     * will return {@link OntapVolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ontapVolumeTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of volume. Valid values are the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RW</code> specifies a read/write volume. <code>RW</code> is the default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DP</code> specifies a data-protection volume. You can protect data by replicating it to
     *         data-protection mirror copies. If a disaster occurs, you can use these data-protection mirror copies to
     *         recover data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LS</code> specifies a load-sharing mirror volume. A load-sharing mirror reduces the network traffic
     *         to a FlexVol volume by providing additional read-only access to clients.
     *         </p>
     *         </li>
     * @see OntapVolumeType
     */
    public final String ontapVolumeTypeAsString() {
        return ontapVolumeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flexCacheEndpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(junctionPath());
        hashCode = 31 * hashCode + Objects.hashCode(securityStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInMegabytes());
        hashCode = 31 * hashCode + Objects.hashCode(storageEfficiencyEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(storageVirtualMachineId());
        hashCode = 31 * hashCode + Objects.hashCode(storageVirtualMachineRoot());
        hashCode = 31 * hashCode + Objects.hashCode(tieringPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(uuid());
        hashCode = 31 * hashCode + Objects.hashCode(ontapVolumeTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OntapVolumeConfiguration)) {
            return false;
        }
        OntapVolumeConfiguration other = (OntapVolumeConfiguration) obj;
        return Objects.equals(flexCacheEndpointTypeAsString(), other.flexCacheEndpointTypeAsString())
                && Objects.equals(junctionPath(), other.junctionPath())
                && Objects.equals(securityStyleAsString(), other.securityStyleAsString())
                && Objects.equals(sizeInMegabytes(), other.sizeInMegabytes())
                && Objects.equals(storageEfficiencyEnabled(), other.storageEfficiencyEnabled())
                && Objects.equals(storageVirtualMachineId(), other.storageVirtualMachineId())
                && Objects.equals(storageVirtualMachineRoot(), other.storageVirtualMachineRoot())
                && Objects.equals(tieringPolicy(), other.tieringPolicy()) && Objects.equals(uuid(), other.uuid())
                && Objects.equals(ontapVolumeTypeAsString(), other.ontapVolumeTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OntapVolumeConfiguration").add("FlexCacheEndpointType", flexCacheEndpointTypeAsString())
                .add("JunctionPath", junctionPath()).add("SecurityStyle", securityStyleAsString())
                .add("SizeInMegabytes", sizeInMegabytes()).add("StorageEfficiencyEnabled", storageEfficiencyEnabled())
                .add("StorageVirtualMachineId", storageVirtualMachineId())
                .add("StorageVirtualMachineRoot", storageVirtualMachineRoot()).add("TieringPolicy", tieringPolicy())
                .add("UUID", uuid()).add("OntapVolumeType", ontapVolumeTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlexCacheEndpointType":
            return Optional.ofNullable(clazz.cast(flexCacheEndpointTypeAsString()));
        case "JunctionPath":
            return Optional.ofNullable(clazz.cast(junctionPath()));
        case "SecurityStyle":
            return Optional.ofNullable(clazz.cast(securityStyleAsString()));
        case "SizeInMegabytes":
            return Optional.ofNullable(clazz.cast(sizeInMegabytes()));
        case "StorageEfficiencyEnabled":
            return Optional.ofNullable(clazz.cast(storageEfficiencyEnabled()));
        case "StorageVirtualMachineId":
            return Optional.ofNullable(clazz.cast(storageVirtualMachineId()));
        case "StorageVirtualMachineRoot":
            return Optional.ofNullable(clazz.cast(storageVirtualMachineRoot()));
        case "TieringPolicy":
            return Optional.ofNullable(clazz.cast(tieringPolicy()));
        case "UUID":
            return Optional.ofNullable(clazz.cast(uuid()));
        case "OntapVolumeType":
            return Optional.ofNullable(clazz.cast(ontapVolumeTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OntapVolumeConfiguration, T> g) {
        return obj -> g.apply((OntapVolumeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OntapVolumeConfiguration> {
        /**
         * <p>
         * Specifies the FlexCache endpoint type of the volume. Valid values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code> specifies that the volume doesn't have a FlexCache configuration. <code>NONE</code> is the
         * default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ORIGIN</code> specifies that the volume is the origin volume for a FlexCache volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CACHE</code> specifies that the volume is a FlexCache volume.
         * </p>
         * </li>
         * </ul>
         * 
         * @param flexCacheEndpointType
         *        Specifies the FlexCache endpoint type of the volume. Valid values are the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code> specifies that the volume doesn't have a FlexCache configuration. <code>NONE</code>
         *        is the default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ORIGIN</code> specifies that the volume is the origin volume for a FlexCache volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CACHE</code> specifies that the volume is a FlexCache volume.
         *        </p>
         *        </li>
         * @see FlexCacheEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlexCacheEndpointType
         */
        Builder flexCacheEndpointType(String flexCacheEndpointType);

        /**
         * <p>
         * Specifies the FlexCache endpoint type of the volume. Valid values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code> specifies that the volume doesn't have a FlexCache configuration. <code>NONE</code> is the
         * default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ORIGIN</code> specifies that the volume is the origin volume for a FlexCache volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CACHE</code> specifies that the volume is a FlexCache volume.
         * </p>
         * </li>
         * </ul>
         * 
         * @param flexCacheEndpointType
         *        Specifies the FlexCache endpoint type of the volume. Valid values are the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code> specifies that the volume doesn't have a FlexCache configuration. <code>NONE</code>
         *        is the default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ORIGIN</code> specifies that the volume is the origin volume for a FlexCache volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CACHE</code> specifies that the volume is a FlexCache volume.
         *        </p>
         *        </li>
         * @see FlexCacheEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlexCacheEndpointType
         */
        Builder flexCacheEndpointType(FlexCacheEndpointType flexCacheEndpointType);

        /**
         * <p>
         * Specifies the directory that network-attached storage (NAS) clients use to mount the volume, along with the
         * storage virtual machine (SVM) Domain Name System (DNS) name or IP address. You can create a
         * <code>JunctionPath</code> directly below a parent volume junction or on a directory within a volume. A
         * <code>JunctionPath</code> for a volume named <code>vol3</code> might be <code>/vol1/vol2/vol3</code>, or
         * <code>/vol1/dir2/vol3</code>, or even <code>/dir1/dir2/vol3</code>.
         * </p>
         * 
         * @param junctionPath
         *        Specifies the directory that network-attached storage (NAS) clients use to mount the volume, along
         *        with the storage virtual machine (SVM) Domain Name System (DNS) name or IP address. You can create a
         *        <code>JunctionPath</code> directly below a parent volume junction or on a directory within a volume. A
         *        <code>JunctionPath</code> for a volume named <code>vol3</code> might be <code>/vol1/vol2/vol3</code>,
         *        or <code>/vol1/dir2/vol3</code>, or even <code>/dir1/dir2/vol3</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder junctionPath(String junctionPath);

        /**
         * <p>
         * The security style for the volume, which can be <code>UNIX</code>, <code>NTFS</code>, or <code>MIXED</code>.
         * </p>
         * 
         * @param securityStyle
         *        The security style for the volume, which can be <code>UNIX</code>, <code>NTFS</code>, or
         *        <code>MIXED</code>.
         * @see SecurityStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityStyle
         */
        Builder securityStyle(String securityStyle);

        /**
         * <p>
         * The security style for the volume, which can be <code>UNIX</code>, <code>NTFS</code>, or <code>MIXED</code>.
         * </p>
         * 
         * @param securityStyle
         *        The security style for the volume, which can be <code>UNIX</code>, <code>NTFS</code>, or
         *        <code>MIXED</code>.
         * @see SecurityStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityStyle
         */
        Builder securityStyle(SecurityStyle securityStyle);

        /**
         * <p>
         * The configured size of the volume, in megabytes (MBs).
         * </p>
         * 
         * @param sizeInMegabytes
         *        The configured size of the volume, in megabytes (MBs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInMegabytes(Integer sizeInMegabytes);

        /**
         * <p>
         * The volume's storage efficiency setting.
         * </p>
         * 
         * @param storageEfficiencyEnabled
         *        The volume's storage efficiency setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageEfficiencyEnabled(Boolean storageEfficiencyEnabled);

        /**
         * <p>
         * The ID of the volume's storage virtual machine.
         * </p>
         * 
         * @param storageVirtualMachineId
         *        The ID of the volume's storage virtual machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageVirtualMachineId(String storageVirtualMachineId);

        /**
         * <p>
         * A Boolean flag indicating whether this volume is the root volume for its storage virtual machine (SVM). Only
         * one volume on an SVM can be the root volume. This value defaults to <code>false</code>. If this value is
         * <code>true</code>, then this is the SVM root volume.
         * </p>
         * <p>
         * This flag is useful when you're deleting an SVM, because you must first delete all non-root volumes. This
         * flag, when set to <code>false</code>, helps you identify which volumes to delete before you can delete the
         * SVM.
         * </p>
         * 
         * @param storageVirtualMachineRoot
         *        A Boolean flag indicating whether this volume is the root volume for its storage virtual machine
         *        (SVM). Only one volume on an SVM can be the root volume. This value defaults to <code>false</code>. If
         *        this value is <code>true</code>, then this is the SVM root volume.</p>
         *        <p>
         *        This flag is useful when you're deleting an SVM, because you must first delete all non-root volumes.
         *        This flag, when set to <code>false</code>, helps you identify which volumes to delete before you can
         *        delete the SVM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageVirtualMachineRoot(Boolean storageVirtualMachineRoot);

        /**
         * <p>
         * The volume's <code>TieringPolicy</code> setting.
         * </p>
         * 
         * @param tieringPolicy
         *        The volume's <code>TieringPolicy</code> setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tieringPolicy(TieringPolicy tieringPolicy);

        /**
         * <p>
         * The volume's <code>TieringPolicy</code> setting.
         * </p>
         * This is a convenience method that creates an instance of the {@link TieringPolicy.Builder} avoiding the need
         * to create one manually via {@link TieringPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TieringPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #tieringPolicy(TieringPolicy)}.
         * 
         * @param tieringPolicy
         *        a consumer that will call methods on {@link TieringPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tieringPolicy(TieringPolicy)
         */
        default Builder tieringPolicy(Consumer<TieringPolicy.Builder> tieringPolicy) {
            return tieringPolicy(TieringPolicy.builder().applyMutation(tieringPolicy).build());
        }

        /**
         * <p>
         * The volume's universally unique identifier (UUID).
         * </p>
         * 
         * @param uuid
         *        The volume's universally unique identifier (UUID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uuid(String uuid);

        /**
         * <p>
         * Specifies the type of volume. Valid values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RW</code> specifies a read/write volume. <code>RW</code> is the default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DP</code> specifies a data-protection volume. You can protect data by replicating it to data-protection
         * mirror copies. If a disaster occurs, you can use these data-protection mirror copies to recover data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LS</code> specifies a load-sharing mirror volume. A load-sharing mirror reduces the network traffic to
         * a FlexVol volume by providing additional read-only access to clients.
         * </p>
         * </li>
         * </ul>
         * 
         * @param ontapVolumeType
         *        Specifies the type of volume. Valid values are the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RW</code> specifies a read/write volume. <code>RW</code> is the default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DP</code> specifies a data-protection volume. You can protect data by replicating it to
         *        data-protection mirror copies. If a disaster occurs, you can use these data-protection mirror copies
         *        to recover data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LS</code> specifies a load-sharing mirror volume. A load-sharing mirror reduces the network
         *        traffic to a FlexVol volume by providing additional read-only access to clients.
         *        </p>
         *        </li>
         * @see OntapVolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OntapVolumeType
         */
        Builder ontapVolumeType(String ontapVolumeType);

        /**
         * <p>
         * Specifies the type of volume. Valid values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RW</code> specifies a read/write volume. <code>RW</code> is the default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DP</code> specifies a data-protection volume. You can protect data by replicating it to data-protection
         * mirror copies. If a disaster occurs, you can use these data-protection mirror copies to recover data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LS</code> specifies a load-sharing mirror volume. A load-sharing mirror reduces the network traffic to
         * a FlexVol volume by providing additional read-only access to clients.
         * </p>
         * </li>
         * </ul>
         * 
         * @param ontapVolumeType
         *        Specifies the type of volume. Valid values are the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RW</code> specifies a read/write volume. <code>RW</code> is the default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DP</code> specifies a data-protection volume. You can protect data by replicating it to
         *        data-protection mirror copies. If a disaster occurs, you can use these data-protection mirror copies
         *        to recover data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LS</code> specifies a load-sharing mirror volume. A load-sharing mirror reduces the network
         *        traffic to a FlexVol volume by providing additional read-only access to clients.
         *        </p>
         *        </li>
         * @see OntapVolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OntapVolumeType
         */
        Builder ontapVolumeType(OntapVolumeType ontapVolumeType);
    }

    static final class BuilderImpl implements Builder {
        private String flexCacheEndpointType;

        private String junctionPath;

        private String securityStyle;

        private Integer sizeInMegabytes;

        private Boolean storageEfficiencyEnabled;

        private String storageVirtualMachineId;

        private Boolean storageVirtualMachineRoot;

        private TieringPolicy tieringPolicy;

        private String uuid;

        private String ontapVolumeType;

        private BuilderImpl() {
        }

        private BuilderImpl(OntapVolumeConfiguration model) {
            flexCacheEndpointType(model.flexCacheEndpointType);
            junctionPath(model.junctionPath);
            securityStyle(model.securityStyle);
            sizeInMegabytes(model.sizeInMegabytes);
            storageEfficiencyEnabled(model.storageEfficiencyEnabled);
            storageVirtualMachineId(model.storageVirtualMachineId);
            storageVirtualMachineRoot(model.storageVirtualMachineRoot);
            tieringPolicy(model.tieringPolicy);
            uuid(model.uuid);
            ontapVolumeType(model.ontapVolumeType);
        }

        public final String getFlexCacheEndpointType() {
            return flexCacheEndpointType;
        }

        public final void setFlexCacheEndpointType(String flexCacheEndpointType) {
            this.flexCacheEndpointType = flexCacheEndpointType;
        }

        @Override
        public final Builder flexCacheEndpointType(String flexCacheEndpointType) {
            this.flexCacheEndpointType = flexCacheEndpointType;
            return this;
        }

        @Override
        public final Builder flexCacheEndpointType(FlexCacheEndpointType flexCacheEndpointType) {
            this.flexCacheEndpointType(flexCacheEndpointType == null ? null : flexCacheEndpointType.toString());
            return this;
        }

        public final String getJunctionPath() {
            return junctionPath;
        }

        public final void setJunctionPath(String junctionPath) {
            this.junctionPath = junctionPath;
        }

        @Override
        public final Builder junctionPath(String junctionPath) {
            this.junctionPath = junctionPath;
            return this;
        }

        public final String getSecurityStyle() {
            return securityStyle;
        }

        public final void setSecurityStyle(String securityStyle) {
            this.securityStyle = securityStyle;
        }

        @Override
        public final Builder securityStyle(String securityStyle) {
            this.securityStyle = securityStyle;
            return this;
        }

        @Override
        public final Builder securityStyle(SecurityStyle securityStyle) {
            this.securityStyle(securityStyle == null ? null : securityStyle.toString());
            return this;
        }

        public final Integer getSizeInMegabytes() {
            return sizeInMegabytes;
        }

        public final void setSizeInMegabytes(Integer sizeInMegabytes) {
            this.sizeInMegabytes = sizeInMegabytes;
        }

        @Override
        public final Builder sizeInMegabytes(Integer sizeInMegabytes) {
            this.sizeInMegabytes = sizeInMegabytes;
            return this;
        }

        public final Boolean getStorageEfficiencyEnabled() {
            return storageEfficiencyEnabled;
        }

        public final void setStorageEfficiencyEnabled(Boolean storageEfficiencyEnabled) {
            this.storageEfficiencyEnabled = storageEfficiencyEnabled;
        }

        @Override
        public final Builder storageEfficiencyEnabled(Boolean storageEfficiencyEnabled) {
            this.storageEfficiencyEnabled = storageEfficiencyEnabled;
            return this;
        }

        public final String getStorageVirtualMachineId() {
            return storageVirtualMachineId;
        }

        public final void setStorageVirtualMachineId(String storageVirtualMachineId) {
            this.storageVirtualMachineId = storageVirtualMachineId;
        }

        @Override
        public final Builder storageVirtualMachineId(String storageVirtualMachineId) {
            this.storageVirtualMachineId = storageVirtualMachineId;
            return this;
        }

        public final Boolean getStorageVirtualMachineRoot() {
            return storageVirtualMachineRoot;
        }

        public final void setStorageVirtualMachineRoot(Boolean storageVirtualMachineRoot) {
            this.storageVirtualMachineRoot = storageVirtualMachineRoot;
        }

        @Override
        public final Builder storageVirtualMachineRoot(Boolean storageVirtualMachineRoot) {
            this.storageVirtualMachineRoot = storageVirtualMachineRoot;
            return this;
        }

        public final TieringPolicy.Builder getTieringPolicy() {
            return tieringPolicy != null ? tieringPolicy.toBuilder() : null;
        }

        public final void setTieringPolicy(TieringPolicy.BuilderImpl tieringPolicy) {
            this.tieringPolicy = tieringPolicy != null ? tieringPolicy.build() : null;
        }

        @Override
        public final Builder tieringPolicy(TieringPolicy tieringPolicy) {
            this.tieringPolicy = tieringPolicy;
            return this;
        }

        public final String getUuid() {
            return uuid;
        }

        public final void setUuid(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public final Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public final String getOntapVolumeType() {
            return ontapVolumeType;
        }

        public final void setOntapVolumeType(String ontapVolumeType) {
            this.ontapVolumeType = ontapVolumeType;
        }

        @Override
        public final Builder ontapVolumeType(String ontapVolumeType) {
            this.ontapVolumeType = ontapVolumeType;
            return this;
        }

        @Override
        public final Builder ontapVolumeType(OntapVolumeType ontapVolumeType) {
            this.ontapVolumeType(ontapVolumeType == null ? null : ontapVolumeType.toString());
            return this;
        }

        @Override
        public OntapVolumeConfiguration build() {
            return new OntapVolumeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
