/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.CompletionReport;
import software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFailureDetails;
import software.amazon.awssdk.services.fsx.model.DataRepositoryTaskLifecycle;
import software.amazon.awssdk.services.fsx.model.DataRepositoryTaskPathsCopier;
import software.amazon.awssdk.services.fsx.model.DataRepositoryTaskStatus;
import software.amazon.awssdk.services.fsx.model.DataRepositoryTaskType;
import software.amazon.awssdk.services.fsx.model.Tag;
import software.amazon.awssdk.services.fsx.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataRepositoryTask
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataRepositoryTask> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskId").getter(DataRepositoryTask.getter(DataRepositoryTask::taskId)).setter(DataRepositoryTask.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskId").build()}).build();
    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Lifecycle").getter(DataRepositoryTask.getter(DataRepositoryTask::lifecycleAsString)).setter(DataRepositoryTask.setter(Builder::lifecycle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DataRepositoryTask.getter(DataRepositoryTask::typeAsString)).setter(DataRepositoryTask.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DataRepositoryTask.getter(DataRepositoryTask::creationTime)).setter(DataRepositoryTask.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(DataRepositoryTask.getter(DataRepositoryTask::startTime)).setter(DataRepositoryTask.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(DataRepositoryTask.getter(DataRepositoryTask::endTime)).setter(DataRepositoryTask.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceARN").getter(DataRepositoryTask.getter(DataRepositoryTask::resourceARN)).setter(DataRepositoryTask.setter(Builder::resourceARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARN").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(DataRepositoryTask.getter(DataRepositoryTask::tags)).setter(DataRepositoryTask.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemId").getter(DataRepositoryTask.getter(DataRepositoryTask::fileSystemId)).setter(DataRepositoryTask.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()}).build();
    private static final SdkField<List<String>> PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Paths").getter(DataRepositoryTask.getter(DataRepositoryTask::paths)).setter(DataRepositoryTask.setter(Builder::paths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Paths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataRepositoryTaskFailureDetails> FAILURE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FailureDetails").getter(DataRepositoryTask.getter(DataRepositoryTask::failureDetails)).setter(DataRepositoryTask.setter(Builder::failureDetails)).constructor(DataRepositoryTaskFailureDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureDetails").build()}).build();
    private static final SdkField<DataRepositoryTaskStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(DataRepositoryTask.getter(DataRepositoryTask::status)).setter(DataRepositoryTask.setter(Builder::status)).constructor(DataRepositoryTaskStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<CompletionReport> REPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Report").getter(DataRepositoryTask.getter(DataRepositoryTask::report)).setter(DataRepositoryTask.setter(Builder::report)).constructor(CompletionReport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Report").build()}).build();
    private static final SdkField<Long> CAPACITY_TO_RELEASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CapacityToRelease").getter(DataRepositoryTask.getter(DataRepositoryTask::capacityToRelease)).setter(DataRepositoryTask.setter(Builder::capacityToRelease)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityToRelease").build()}).build();
    private static final SdkField<String> FILE_CACHE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileCacheId").getter(DataRepositoryTask.getter(DataRepositoryTask::fileCacheId)).setter(DataRepositoryTask.setter(Builder::fileCacheId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileCacheId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, LIFECYCLE_FIELD, TYPE_FIELD, CREATION_TIME_FIELD, START_TIME_FIELD, END_TIME_FIELD, RESOURCE_ARN_FIELD, TAGS_FIELD, FILE_SYSTEM_ID_FIELD, PATHS_FIELD, FAILURE_DETAILS_FIELD, STATUS_FIELD, REPORT_FIELD, CAPACITY_TO_RELEASE_FIELD, FILE_CACHE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String taskId;
    private final String lifecycle;
    private final String type;
    private final Instant creationTime;
    private final Instant startTime;
    private final Instant endTime;
    private final String resourceARN;
    private final List<Tag> tags;
    private final String fileSystemId;
    private final List<String> paths;
    private final DataRepositoryTaskFailureDetails failureDetails;
    private final DataRepositoryTaskStatus status;
    private final CompletionReport report;
    private final Long capacityToRelease;
    private final String fileCacheId;

    private DataRepositoryTask(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.lifecycle = builder.lifecycle;
        this.type = builder.type;
        this.creationTime = builder.creationTime;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.resourceARN = builder.resourceARN;
        this.tags = builder.tags;
        this.fileSystemId = builder.fileSystemId;
        this.paths = builder.paths;
        this.failureDetails = builder.failureDetails;
        this.status = builder.status;
        this.report = builder.report;
        this.capacityToRelease = builder.capacityToRelease;
        this.fileCacheId = builder.fileCacheId;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final DataRepositoryTaskLifecycle lifecycle() {
        return DataRepositoryTaskLifecycle.fromValue(this.lifecycle);
    }

    public final String lifecycleAsString() {
        return this.lifecycle;
    }

    public final DataRepositoryTaskType type() {
        return DataRepositoryTaskType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String resourceARN() {
        return this.resourceARN;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final boolean hasPaths() {
        return this.paths != null && !(this.paths instanceof SdkAutoConstructList);
    }

    public final List<String> paths() {
        return this.paths;
    }

    public final DataRepositoryTaskFailureDetails failureDetails() {
        return this.failureDetails;
    }

    public final DataRepositoryTaskStatus status() {
        return this.status;
    }

    public final CompletionReport report() {
        return this.report;
    }

    public final Long capacityToRelease() {
        return this.capacityToRelease;
    }

    public final String fileCacheId() {
        return this.fileCacheId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPaths() ? this.paths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.failureDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.report());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityToRelease());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileCacheId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataRepositoryTask)) {
            return false;
        }
        DataRepositoryTask other = (DataRepositoryTask)obj;
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.lifecycleAsString(), other.lifecycleAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.resourceARN(), other.resourceARN()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.fileSystemId(), other.fileSystemId()) && this.hasPaths() == other.hasPaths() && Objects.equals(this.paths(), other.paths()) && Objects.equals(this.failureDetails(), other.failureDetails()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.report(), other.report()) && Objects.equals(this.capacityToRelease(), other.capacityToRelease()) && Objects.equals(this.fileCacheId(), other.fileCacheId());
    }

    public final String toString() {
        return ToString.builder((String)"DataRepositoryTask").add("TaskId", (Object)this.taskId()).add("Lifecycle", (Object)this.lifecycleAsString()).add("Type", (Object)this.typeAsString()).add("CreationTime", (Object)this.creationTime()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("ResourceARN", (Object)this.resourceARN()).add("Tags", this.hasTags() ? this.tags() : null).add("FileSystemId", (Object)this.fileSystemId()).add("Paths", this.hasPaths() ? this.paths() : null).add("FailureDetails", (Object)this.failureDetails()).add("Status", (Object)this.status()).add("Report", (Object)this.report()).add("CapacityToRelease", (Object)this.capacityToRelease()).add("FileCacheId", (Object)this.fileCacheId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycleAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "ResourceARN": {
                return Optional.ofNullable(clazz.cast(this.resourceARN()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "Paths": {
                return Optional.ofNullable(clazz.cast(this.paths()));
            }
            case "FailureDetails": {
                return Optional.ofNullable(clazz.cast(this.failureDetails()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Report": {
                return Optional.ofNullable(clazz.cast(this.report()));
            }
            case "CapacityToRelease": {
                return Optional.ofNullable(clazz.cast(this.capacityToRelease()));
            }
            case "FileCacheId": {
                return Optional.ofNullable(clazz.cast(this.fileCacheId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataRepositoryTask, T> g) {
        return obj -> g.apply((DataRepositoryTask)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskId;
        private String lifecycle;
        private String type;
        private Instant creationTime;
        private Instant startTime;
        private Instant endTime;
        private String resourceARN;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String fileSystemId;
        private List<String> paths = DefaultSdkAutoConstructList.getInstance();
        private DataRepositoryTaskFailureDetails failureDetails;
        private DataRepositoryTaskStatus status;
        private CompletionReport report;
        private Long capacityToRelease;
        private String fileCacheId;

        private BuilderImpl() {
        }

        private BuilderImpl(DataRepositoryTask model) {
            this.taskId(model.taskId);
            this.lifecycle(model.lifecycle);
            this.type(model.type);
            this.creationTime(model.creationTime);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.resourceARN(model.resourceARN);
            this.tags(model.tags);
            this.fileSystemId(model.fileSystemId);
            this.paths(model.paths);
            this.failureDetails(model.failureDetails);
            this.status(model.status);
            this.report(model.report);
            this.capacityToRelease(model.capacityToRelease);
            this.fileCacheId(model.fileCacheId);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getLifecycle() {
            return this.lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(DataRepositoryTaskLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataRepositoryTaskType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getResourceARN() {
            return this.resourceARN;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final Collection<String> getPaths() {
            if (this.paths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.paths;
        }

        public final void setPaths(Collection<String> paths) {
            this.paths = DataRepositoryTaskPathsCopier.copy(paths);
        }

        @Override
        public final Builder paths(Collection<String> paths) {
            this.paths = DataRepositoryTaskPathsCopier.copy(paths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder paths(String ... paths) {
            this.paths(Arrays.asList(paths));
            return this;
        }

        public final DataRepositoryTaskFailureDetails.Builder getFailureDetails() {
            return this.failureDetails != null ? this.failureDetails.toBuilder() : null;
        }

        public final void setFailureDetails(DataRepositoryTaskFailureDetails.BuilderImpl failureDetails) {
            this.failureDetails = failureDetails != null ? failureDetails.build() : null;
        }

        @Override
        public final Builder failureDetails(DataRepositoryTaskFailureDetails failureDetails) {
            this.failureDetails = failureDetails;
            return this;
        }

        public final DataRepositoryTaskStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(DataRepositoryTaskStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(DataRepositoryTaskStatus status) {
            this.status = status;
            return this;
        }

        public final CompletionReport.Builder getReport() {
            return this.report != null ? this.report.toBuilder() : null;
        }

        public final void setReport(CompletionReport.BuilderImpl report) {
            this.report = report != null ? report.build() : null;
        }

        @Override
        public final Builder report(CompletionReport report) {
            this.report = report;
            return this;
        }

        public final Long getCapacityToRelease() {
            return this.capacityToRelease;
        }

        public final void setCapacityToRelease(Long capacityToRelease) {
            this.capacityToRelease = capacityToRelease;
        }

        @Override
        public final Builder capacityToRelease(Long capacityToRelease) {
            this.capacityToRelease = capacityToRelease;
            return this;
        }

        public final String getFileCacheId() {
            return this.fileCacheId;
        }

        public final void setFileCacheId(String fileCacheId) {
            this.fileCacheId = fileCacheId;
        }

        @Override
        public final Builder fileCacheId(String fileCacheId) {
            this.fileCacheId = fileCacheId;
            return this;
        }

        public DataRepositoryTask build() {
            return new DataRepositoryTask(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataRepositoryTask> {
        public Builder taskId(String var1);

        public Builder lifecycle(String var1);

        public Builder lifecycle(DataRepositoryTaskLifecycle var1);

        public Builder type(String var1);

        public Builder type(DataRepositoryTaskType var1);

        public Builder creationTime(Instant var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder resourceARN(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder fileSystemId(String var1);

        public Builder paths(Collection<String> var1);

        public Builder paths(String ... var1);

        public Builder failureDetails(DataRepositoryTaskFailureDetails var1);

        default public Builder failureDetails(Consumer<DataRepositoryTaskFailureDetails.Builder> failureDetails) {
            return this.failureDetails((DataRepositoryTaskFailureDetails)((DataRepositoryTaskFailureDetails.Builder)DataRepositoryTaskFailureDetails.builder().applyMutation(failureDetails)).build());
        }

        public Builder status(DataRepositoryTaskStatus var1);

        default public Builder status(Consumer<DataRepositoryTaskStatus.Builder> status) {
            return this.status((DataRepositoryTaskStatus)((DataRepositoryTaskStatus.Builder)DataRepositoryTaskStatus.builder().applyMutation(status)).build());
        }

        public Builder report(CompletionReport var1);

        default public Builder report(Consumer<CompletionReport.Builder> report) {
            return this.report((CompletionReport)((CompletionReport.Builder)CompletionReport.builder().applyMutation(report)).build());
        }

        public Builder capacityToRelease(Long var1);

        public Builder fileCacheId(String var1);
    }
}

