/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon FSx for OpenZFS configuration properties for the file system that you are creating.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFileSystemOpenZFSConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateFileSystemOpenZFSConfiguration.Builder, CreateFileSystemOpenZFSConfiguration> {
    private static final SdkField<Integer> AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AutomaticBackupRetentionDays")
            .getter(getter(CreateFileSystemOpenZFSConfiguration::automaticBackupRetentionDays))
            .setter(setter(Builder::automaticBackupRetentionDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticBackupRetentionDays")
                    .build()).build();

    private static final SdkField<Boolean> COPY_TAGS_TO_BACKUPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToBackups").getter(getter(CreateFileSystemOpenZFSConfiguration::copyTagsToBackups))
            .setter(setter(Builder::copyTagsToBackups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToBackups").build()).build();

    private static final SdkField<Boolean> COPY_TAGS_TO_VOLUMES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToVolumes").getter(getter(CreateFileSystemOpenZFSConfiguration::copyTagsToVolumes))
            .setter(setter(Builder::copyTagsToVolumes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToVolumes").build()).build();

    private static final SdkField<String> DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DailyAutomaticBackupStartTime")
            .getter(getter(CreateFileSystemOpenZFSConfiguration::dailyAutomaticBackupStartTime))
            .setter(setter(Builder::dailyAutomaticBackupStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyAutomaticBackupStartTime")
                    .build()).build();

    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentType").getter(getter(CreateFileSystemOpenZFSConfiguration::deploymentTypeAsString))
            .setter(setter(Builder::deploymentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentType").build()).build();

    private static final SdkField<Integer> THROUGHPUT_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ThroughputCapacity").getter(getter(CreateFileSystemOpenZFSConfiguration::throughputCapacity))
            .setter(setter(Builder::throughputCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputCapacity").build())
            .build();

    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WeeklyMaintenanceStartTime")
            .getter(getter(CreateFileSystemOpenZFSConfiguration::weeklyMaintenanceStartTime))
            .setter(setter(Builder::weeklyMaintenanceStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build())
            .build();

    private static final SdkField<DiskIopsConfiguration> DISK_IOPS_CONFIGURATION_FIELD = SdkField
            .<DiskIopsConfiguration> builder(MarshallingType.SDK_POJO).memberName("DiskIopsConfiguration")
            .getter(getter(CreateFileSystemOpenZFSConfiguration::diskIopsConfiguration))
            .setter(setter(Builder::diskIopsConfiguration)).constructor(DiskIopsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskIopsConfiguration").build())
            .build();

    private static final SdkField<OpenZFSCreateRootVolumeConfiguration> ROOT_VOLUME_CONFIGURATION_FIELD = SdkField
            .<OpenZFSCreateRootVolumeConfiguration> builder(MarshallingType.SDK_POJO).memberName("RootVolumeConfiguration")
            .getter(getter(CreateFileSystemOpenZFSConfiguration::rootVolumeConfiguration))
            .setter(setter(Builder::rootVolumeConfiguration)).constructor(OpenZFSCreateRootVolumeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootVolumeConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD, COPY_TAGS_TO_BACKUPS_FIELD, COPY_TAGS_TO_VOLUMES_FIELD,
            DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD, DEPLOYMENT_TYPE_FIELD, THROUGHPUT_CAPACITY_FIELD,
            WEEKLY_MAINTENANCE_START_TIME_FIELD, DISK_IOPS_CONFIGURATION_FIELD, ROOT_VOLUME_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer automaticBackupRetentionDays;

    private final Boolean copyTagsToBackups;

    private final Boolean copyTagsToVolumes;

    private final String dailyAutomaticBackupStartTime;

    private final String deploymentType;

    private final Integer throughputCapacity;

    private final String weeklyMaintenanceStartTime;

    private final DiskIopsConfiguration diskIopsConfiguration;

    private final OpenZFSCreateRootVolumeConfiguration rootVolumeConfiguration;

    private CreateFileSystemOpenZFSConfiguration(BuilderImpl builder) {
        this.automaticBackupRetentionDays = builder.automaticBackupRetentionDays;
        this.copyTagsToBackups = builder.copyTagsToBackups;
        this.copyTagsToVolumes = builder.copyTagsToVolumes;
        this.dailyAutomaticBackupStartTime = builder.dailyAutomaticBackupStartTime;
        this.deploymentType = builder.deploymentType;
        this.throughputCapacity = builder.throughputCapacity;
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.diskIopsConfiguration = builder.diskIopsConfiguration;
        this.rootVolumeConfiguration = builder.rootVolumeConfiguration;
    }

    /**
     * Returns the value of the AutomaticBackupRetentionDays property for this object.
     * 
     * @return The value of the AutomaticBackupRetentionDays property for this object.
     */
    public final Integer automaticBackupRetentionDays() {
        return automaticBackupRetentionDays;
    }

    /**
     * <p>
     * A Boolean value indicating whether tags for the file system should be copied to backups. This value defaults to
     * <code>false</code>. If it's set to <code>true</code>, all tags for the file system are copied to all automatic
     * and user-initiated backups where the user doesn't specify tags. If this value is <code>true</code>, and you
     * specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when
     * creating a user-initiated backup, no tags are copied from the file system, regardless of this value.
     * </p>
     * 
     * @return A Boolean value indicating whether tags for the file system should be copied to backups. This value
     *         defaults to <code>false</code>. If it's set to <code>true</code>, all tags for the file system are copied
     *         to all automatic and user-initiated backups where the user doesn't specify tags. If this value is
     *         <code>true</code>, and you specify one or more tags, only the specified tags are copied to backups. If
     *         you specify one or more tags when creating a user-initiated backup, no tags are copied from the file
     *         system, regardless of this value.
     */
    public final Boolean copyTagsToBackups() {
        return copyTagsToBackups;
    }

    /**
     * <p>
     * A Boolean value indicating whether tags for the file system should be copied to volumes. This value defaults to
     * <code>false</code>. If it's set to <code>true</code>, all tags for the file system are copied to volumes where
     * the user doesn't specify tags. If this value is <code>true</code>, and you specify one or more tags, only the
     * specified tags are copied to volumes. If you specify one or more tags when creating the volume, no tags are
     * copied from the file system, regardless of this value.
     * </p>
     * 
     * @return A Boolean value indicating whether tags for the file system should be copied to volumes. This value
     *         defaults to <code>false</code>. If it's set to <code>true</code>, all tags for the file system are copied
     *         to volumes where the user doesn't specify tags. If this value is <code>true</code>, and you specify one
     *         or more tags, only the specified tags are copied to volumes. If you specify one or more tags when
     *         creating the volume, no tags are copied from the file system, regardless of this value.
     */
    public final Boolean copyTagsToVolumes() {
        return copyTagsToVolumes;
    }

    /**
     * Returns the value of the DailyAutomaticBackupStartTime property for this object.
     * 
     * @return The value of the DailyAutomaticBackupStartTime property for this object.
     */
    public final String dailyAutomaticBackupStartTime() {
        return dailyAutomaticBackupStartTime;
    }

    /**
     * <p>
     * Specifies the file system deployment type. Single AZ deployment types are configured for redundancy within a
     * single Availability Zone in an Amazon Web Services Region . Valid values are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SINGLE_AZ_1</code>- (Default) Creates file systems with throughput capacities of 64 - 4,096 MB/s.
     * <code>Single_AZ_1</code> is available in all Amazon Web Services Regions where Amazon FSx for OpenZFS is
     * available, except US West (Oregon).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SINGLE_AZ_2</code>- Creates file systems with throughput capacities of 160 - 10,240 MB/s using an NVMe
     * L2ARC cache. <code>Single_AZ_2</code> is available only in the US East (N. Virginia), US East (Ohio), US West
     * (Oregon), and Europe (Ireland) Amazon Web Services Regions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see: <a
     * href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/availability-durability.html#available-aws-regions"
     * >Deployment type availability</a> and <a
     * href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#zfs-fs-performance">File system
     * performance</a> in the <i>Amazon FSx for OpenZFS User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link OpenZFSDeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return Specifies the file system deployment type. Single AZ deployment types are configured for redundancy
     *         within a single Availability Zone in an Amazon Web Services Region . Valid values are the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SINGLE_AZ_1</code>- (Default) Creates file systems with throughput capacities of 64 - 4,096 MB/s.
     *         <code>Single_AZ_1</code> is available in all Amazon Web Services Regions where Amazon FSx for OpenZFS is
     *         available, except US West (Oregon).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SINGLE_AZ_2</code>- Creates file systems with throughput capacities of 160 - 10,240 MB/s using an
     *         NVMe L2ARC cache. <code>Single_AZ_2</code> is available only in the US East (N. Virginia), US East
     *         (Ohio), US West (Oregon), and Europe (Ireland) Amazon Web Services Regions.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see: <a href=
     *         "https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/availability-durability.html#available-aws-regions"
     *         >Deployment type availability</a> and <a
     *         href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#zfs-fs-performance">File
     *         system performance</a> in the <i>Amazon FSx for OpenZFS User Guide</i>.
     * @see OpenZFSDeploymentType
     */
    public final OpenZFSDeploymentType deploymentType() {
        return OpenZFSDeploymentType.fromValue(deploymentType);
    }

    /**
     * <p>
     * Specifies the file system deployment type. Single AZ deployment types are configured for redundancy within a
     * single Availability Zone in an Amazon Web Services Region . Valid values are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SINGLE_AZ_1</code>- (Default) Creates file systems with throughput capacities of 64 - 4,096 MB/s.
     * <code>Single_AZ_1</code> is available in all Amazon Web Services Regions where Amazon FSx for OpenZFS is
     * available, except US West (Oregon).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SINGLE_AZ_2</code>- Creates file systems with throughput capacities of 160 - 10,240 MB/s using an NVMe
     * L2ARC cache. <code>Single_AZ_2</code> is available only in the US East (N. Virginia), US East (Ohio), US West
     * (Oregon), and Europe (Ireland) Amazon Web Services Regions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see: <a
     * href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/availability-durability.html#available-aws-regions"
     * >Deployment type availability</a> and <a
     * href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#zfs-fs-performance">File system
     * performance</a> in the <i>Amazon FSx for OpenZFS User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link OpenZFSDeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return Specifies the file system deployment type. Single AZ deployment types are configured for redundancy
     *         within a single Availability Zone in an Amazon Web Services Region . Valid values are the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SINGLE_AZ_1</code>- (Default) Creates file systems with throughput capacities of 64 - 4,096 MB/s.
     *         <code>Single_AZ_1</code> is available in all Amazon Web Services Regions where Amazon FSx for OpenZFS is
     *         available, except US West (Oregon).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SINGLE_AZ_2</code>- Creates file systems with throughput capacities of 160 - 10,240 MB/s using an
     *         NVMe L2ARC cache. <code>Single_AZ_2</code> is available only in the US East (N. Virginia), US East
     *         (Ohio), US West (Oregon), and Europe (Ireland) Amazon Web Services Regions.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see: <a href=
     *         "https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/availability-durability.html#available-aws-regions"
     *         >Deployment type availability</a> and <a
     *         href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#zfs-fs-performance">File
     *         system performance</a> in the <i>Amazon FSx for OpenZFS User Guide</i>.
     * @see OpenZFSDeploymentType
     */
    public final String deploymentTypeAsString() {
        return deploymentType;
    }

    /**
     * <p>
     * Specifies the throughput of an Amazon FSx for OpenZFS file system, measured in megabytes per second (MB/s). Valid
     * values depend on the DeploymentType you choose, as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>SINGLE_AZ_1</code>, valid values are 64, 128, 256, 512, 1024, 2048, 3072, or 4096 MB/s.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>SINGLE_AZ_2</code>, valid values are 160, 320, 640, 1280, 2560, 3840, 5120, 7680, or 10240 MB/s.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You pay for additional throughput capacity that you provision.
     * </p>
     * 
     * @return Specifies the throughput of an Amazon FSx for OpenZFS file system, measured in megabytes per second
     *         (MB/s). Valid values depend on the DeploymentType you choose, as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For <code>SINGLE_AZ_1</code>, valid values are 64, 128, 256, 512, 1024, 2048, 3072, or 4096 MB/s.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <code>SINGLE_AZ_2</code>, valid values are 160, 320, 640, 1280, 2560, 3840, 5120, 7680, or 10240
     *         MB/s.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You pay for additional throughput capacity that you provision.
     */
    public final Integer throughputCapacity() {
        return throughputCapacity;
    }

    /**
     * Returns the value of the WeeklyMaintenanceStartTime property for this object.
     * 
     * @return The value of the WeeklyMaintenanceStartTime property for this object.
     */
    public final String weeklyMaintenanceStartTime() {
        return weeklyMaintenanceStartTime;
    }

    /**
     * Returns the value of the DiskIopsConfiguration property for this object.
     * 
     * @return The value of the DiskIopsConfiguration property for this object.
     */
    public final DiskIopsConfiguration diskIopsConfiguration() {
        return diskIopsConfiguration;
    }

    /**
     * <p>
     * The configuration Amazon FSx uses when creating the root value of the Amazon FSx for OpenZFS file system. All
     * volumes are children of the root volume.
     * </p>
     * 
     * @return The configuration Amazon FSx uses when creating the root value of the Amazon FSx for OpenZFS file system.
     *         All volumes are children of the root volume.
     */
    public final OpenZFSCreateRootVolumeConfiguration rootVolumeConfiguration() {
        return rootVolumeConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automaticBackupRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToBackups());
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToVolumes());
        hashCode = 31 * hashCode + Objects.hashCode(dailyAutomaticBackupStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(throughputCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(diskIopsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(rootVolumeConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFileSystemOpenZFSConfiguration)) {
            return false;
        }
        CreateFileSystemOpenZFSConfiguration other = (CreateFileSystemOpenZFSConfiguration) obj;
        return Objects.equals(automaticBackupRetentionDays(), other.automaticBackupRetentionDays())
                && Objects.equals(copyTagsToBackups(), other.copyTagsToBackups())
                && Objects.equals(copyTagsToVolumes(), other.copyTagsToVolumes())
                && Objects.equals(dailyAutomaticBackupStartTime(), other.dailyAutomaticBackupStartTime())
                && Objects.equals(deploymentTypeAsString(), other.deploymentTypeAsString())
                && Objects.equals(throughputCapacity(), other.throughputCapacity())
                && Objects.equals(weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime())
                && Objects.equals(diskIopsConfiguration(), other.diskIopsConfiguration())
                && Objects.equals(rootVolumeConfiguration(), other.rootVolumeConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFileSystemOpenZFSConfiguration")
                .add("AutomaticBackupRetentionDays", automaticBackupRetentionDays())
                .add("CopyTagsToBackups", copyTagsToBackups()).add("CopyTagsToVolumes", copyTagsToVolumes())
                .add("DailyAutomaticBackupStartTime", dailyAutomaticBackupStartTime())
                .add("DeploymentType", deploymentTypeAsString()).add("ThroughputCapacity", throughputCapacity())
                .add("WeeklyMaintenanceStartTime", weeklyMaintenanceStartTime())
                .add("DiskIopsConfiguration", diskIopsConfiguration()).add("RootVolumeConfiguration", rootVolumeConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomaticBackupRetentionDays":
            return Optional.ofNullable(clazz.cast(automaticBackupRetentionDays()));
        case "CopyTagsToBackups":
            return Optional.ofNullable(clazz.cast(copyTagsToBackups()));
        case "CopyTagsToVolumes":
            return Optional.ofNullable(clazz.cast(copyTagsToVolumes()));
        case "DailyAutomaticBackupStartTime":
            return Optional.ofNullable(clazz.cast(dailyAutomaticBackupStartTime()));
        case "DeploymentType":
            return Optional.ofNullable(clazz.cast(deploymentTypeAsString()));
        case "ThroughputCapacity":
            return Optional.ofNullable(clazz.cast(throughputCapacity()));
        case "WeeklyMaintenanceStartTime":
            return Optional.ofNullable(clazz.cast(weeklyMaintenanceStartTime()));
        case "DiskIopsConfiguration":
            return Optional.ofNullable(clazz.cast(diskIopsConfiguration()));
        case "RootVolumeConfiguration":
            return Optional.ofNullable(clazz.cast(rootVolumeConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFileSystemOpenZFSConfiguration, T> g) {
        return obj -> g.apply((CreateFileSystemOpenZFSConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateFileSystemOpenZFSConfiguration> {
        /**
         * Sets the value of the AutomaticBackupRetentionDays property for this object.
         *
         * @param automaticBackupRetentionDays
         *        The new value for the AutomaticBackupRetentionDays property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays);

        /**
         * <p>
         * A Boolean value indicating whether tags for the file system should be copied to backups. This value defaults
         * to <code>false</code>. If it's set to <code>true</code>, all tags for the file system are copied to all
         * automatic and user-initiated backups where the user doesn't specify tags. If this value is <code>true</code>,
         * and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more
         * tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this
         * value.
         * </p>
         * 
         * @param copyTagsToBackups
         *        A Boolean value indicating whether tags for the file system should be copied to backups. This value
         *        defaults to <code>false</code>. If it's set to <code>true</code>, all tags for the file system are
         *        copied to all automatic and user-initiated backups where the user doesn't specify tags. If this value
         *        is <code>true</code>, and you specify one or more tags, only the specified tags are copied to backups.
         *        If you specify one or more tags when creating a user-initiated backup, no tags are copied from the
         *        file system, regardless of this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToBackups(Boolean copyTagsToBackups);

        /**
         * <p>
         * A Boolean value indicating whether tags for the file system should be copied to volumes. This value defaults
         * to <code>false</code>. If it's set to <code>true</code>, all tags for the file system are copied to volumes
         * where the user doesn't specify tags. If this value is <code>true</code>, and you specify one or more tags,
         * only the specified tags are copied to volumes. If you specify one or more tags when creating the volume, no
         * tags are copied from the file system, regardless of this value.
         * </p>
         * 
         * @param copyTagsToVolumes
         *        A Boolean value indicating whether tags for the file system should be copied to volumes. This value
         *        defaults to <code>false</code>. If it's set to <code>true</code>, all tags for the file system are
         *        copied to volumes where the user doesn't specify tags. If this value is <code>true</code>, and you
         *        specify one or more tags, only the specified tags are copied to volumes. If you specify one or more
         *        tags when creating the volume, no tags are copied from the file system, regardless of this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToVolumes(Boolean copyTagsToVolumes);

        /**
         * Sets the value of the DailyAutomaticBackupStartTime property for this object.
         *
         * @param dailyAutomaticBackupStartTime
         *        The new value for the DailyAutomaticBackupStartTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime);

        /**
         * <p>
         * Specifies the file system deployment type. Single AZ deployment types are configured for redundancy within a
         * single Availability Zone in an Amazon Web Services Region . Valid values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SINGLE_AZ_1</code>- (Default) Creates file systems with throughput capacities of 64 - 4,096 MB/s.
         * <code>Single_AZ_1</code> is available in all Amazon Web Services Regions where Amazon FSx for OpenZFS is
         * available, except US West (Oregon).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SINGLE_AZ_2</code>- Creates file systems with throughput capacities of 160 - 10,240 MB/s using an NVMe
         * L2ARC cache. <code>Single_AZ_2</code> is available only in the US East (N. Virginia), US East (Ohio), US West
         * (Oregon), and Europe (Ireland) Amazon Web Services Regions.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see: <a href=
         * "https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/availability-durability.html#available-aws-regions"
         * >Deployment type availability</a> and <a
         * href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#zfs-fs-performance">File system
         * performance</a> in the <i>Amazon FSx for OpenZFS User Guide</i>.
         * </p>
         * 
         * @param deploymentType
         *        Specifies the file system deployment type. Single AZ deployment types are configured for redundancy
         *        within a single Availability Zone in an Amazon Web Services Region . Valid values are the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SINGLE_AZ_1</code>- (Default) Creates file systems with throughput capacities of 64 - 4,096
         *        MB/s. <code>Single_AZ_1</code> is available in all Amazon Web Services Regions where Amazon FSx for
         *        OpenZFS is available, except US West (Oregon).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SINGLE_AZ_2</code>- Creates file systems with throughput capacities of 160 - 10,240 MB/s using
         *        an NVMe L2ARC cache. <code>Single_AZ_2</code> is available only in the US East (N. Virginia), US East
         *        (Ohio), US West (Oregon), and Europe (Ireland) Amazon Web Services Regions.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see: <a href=
         *        "https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/availability-durability.html#available-aws-regions"
         *        >Deployment type availability</a> and <a
         *        href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#zfs-fs-performance">File
         *        system performance</a> in the <i>Amazon FSx for OpenZFS User Guide</i>.
         * @see OpenZFSDeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenZFSDeploymentType
         */
        Builder deploymentType(String deploymentType);

        /**
         * <p>
         * Specifies the file system deployment type. Single AZ deployment types are configured for redundancy within a
         * single Availability Zone in an Amazon Web Services Region . Valid values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SINGLE_AZ_1</code>- (Default) Creates file systems with throughput capacities of 64 - 4,096 MB/s.
         * <code>Single_AZ_1</code> is available in all Amazon Web Services Regions where Amazon FSx for OpenZFS is
         * available, except US West (Oregon).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SINGLE_AZ_2</code>- Creates file systems with throughput capacities of 160 - 10,240 MB/s using an NVMe
         * L2ARC cache. <code>Single_AZ_2</code> is available only in the US East (N. Virginia), US East (Ohio), US West
         * (Oregon), and Europe (Ireland) Amazon Web Services Regions.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see: <a href=
         * "https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/availability-durability.html#available-aws-regions"
         * >Deployment type availability</a> and <a
         * href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#zfs-fs-performance">File system
         * performance</a> in the <i>Amazon FSx for OpenZFS User Guide</i>.
         * </p>
         * 
         * @param deploymentType
         *        Specifies the file system deployment type. Single AZ deployment types are configured for redundancy
         *        within a single Availability Zone in an Amazon Web Services Region . Valid values are the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SINGLE_AZ_1</code>- (Default) Creates file systems with throughput capacities of 64 - 4,096
         *        MB/s. <code>Single_AZ_1</code> is available in all Amazon Web Services Regions where Amazon FSx for
         *        OpenZFS is available, except US West (Oregon).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SINGLE_AZ_2</code>- Creates file systems with throughput capacities of 160 - 10,240 MB/s using
         *        an NVMe L2ARC cache. <code>Single_AZ_2</code> is available only in the US East (N. Virginia), US East
         *        (Ohio), US West (Oregon), and Europe (Ireland) Amazon Web Services Regions.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see: <a href=
         *        "https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/availability-durability.html#available-aws-regions"
         *        >Deployment type availability</a> and <a
         *        href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#zfs-fs-performance">File
         *        system performance</a> in the <i>Amazon FSx for OpenZFS User Guide</i>.
         * @see OpenZFSDeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenZFSDeploymentType
         */
        Builder deploymentType(OpenZFSDeploymentType deploymentType);

        /**
         * <p>
         * Specifies the throughput of an Amazon FSx for OpenZFS file system, measured in megabytes per second (MB/s).
         * Valid values depend on the DeploymentType you choose, as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <code>SINGLE_AZ_1</code>, valid values are 64, 128, 256, 512, 1024, 2048, 3072, or 4096 MB/s.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <code>SINGLE_AZ_2</code>, valid values are 160, 320, 640, 1280, 2560, 3840, 5120, 7680, or 10240 MB/s.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You pay for additional throughput capacity that you provision.
         * </p>
         * 
         * @param throughputCapacity
         *        Specifies the throughput of an Amazon FSx for OpenZFS file system, measured in megabytes per second
         *        (MB/s). Valid values depend on the DeploymentType you choose, as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For <code>SINGLE_AZ_1</code>, valid values are 64, 128, 256, 512, 1024, 2048, 3072, or 4096 MB/s.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <code>SINGLE_AZ_2</code>, valid values are 160, 320, 640, 1280, 2560, 3840, 5120, 7680, or 10240
         *        MB/s.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You pay for additional throughput capacity that you provision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughputCapacity(Integer throughputCapacity);

        /**
         * Sets the value of the WeeklyMaintenanceStartTime property for this object.
         *
         * @param weeklyMaintenanceStartTime
         *        The new value for the WeeklyMaintenanceStartTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime);

        /**
         * Sets the value of the DiskIopsConfiguration property for this object.
         *
         * @param diskIopsConfiguration
         *        The new value for the DiskIopsConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskIopsConfiguration(DiskIopsConfiguration diskIopsConfiguration);

        /**
         * Sets the value of the DiskIopsConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DiskIopsConfiguration.Builder} avoiding
         * the need to create one manually via {@link DiskIopsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DiskIopsConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #diskIopsConfiguration(DiskIopsConfiguration)}.
         * 
         * @param diskIopsConfiguration
         *        a consumer that will call methods on {@link DiskIopsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #diskIopsConfiguration(DiskIopsConfiguration)
         */
        default Builder diskIopsConfiguration(Consumer<DiskIopsConfiguration.Builder> diskIopsConfiguration) {
            return diskIopsConfiguration(DiskIopsConfiguration.builder().applyMutation(diskIopsConfiguration).build());
        }

        /**
         * <p>
         * The configuration Amazon FSx uses when creating the root value of the Amazon FSx for OpenZFS file system. All
         * volumes are children of the root volume.
         * </p>
         * 
         * @param rootVolumeConfiguration
         *        The configuration Amazon FSx uses when creating the root value of the Amazon FSx for OpenZFS file
         *        system. All volumes are children of the root volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootVolumeConfiguration(OpenZFSCreateRootVolumeConfiguration rootVolumeConfiguration);

        /**
         * <p>
         * The configuration Amazon FSx uses when creating the root value of the Amazon FSx for OpenZFS file system. All
         * volumes are children of the root volume.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link OpenZFSCreateRootVolumeConfiguration.Builder} avoiding the need to create one manually via
         * {@link OpenZFSCreateRootVolumeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenZFSCreateRootVolumeConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #rootVolumeConfiguration(OpenZFSCreateRootVolumeConfiguration)}.
         * 
         * @param rootVolumeConfiguration
         *        a consumer that will call methods on {@link OpenZFSCreateRootVolumeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rootVolumeConfiguration(OpenZFSCreateRootVolumeConfiguration)
         */
        default Builder rootVolumeConfiguration(Consumer<OpenZFSCreateRootVolumeConfiguration.Builder> rootVolumeConfiguration) {
            return rootVolumeConfiguration(OpenZFSCreateRootVolumeConfiguration.builder().applyMutation(rootVolumeConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer automaticBackupRetentionDays;

        private Boolean copyTagsToBackups;

        private Boolean copyTagsToVolumes;

        private String dailyAutomaticBackupStartTime;

        private String deploymentType;

        private Integer throughputCapacity;

        private String weeklyMaintenanceStartTime;

        private DiskIopsConfiguration diskIopsConfiguration;

        private OpenZFSCreateRootVolumeConfiguration rootVolumeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFileSystemOpenZFSConfiguration model) {
            automaticBackupRetentionDays(model.automaticBackupRetentionDays);
            copyTagsToBackups(model.copyTagsToBackups);
            copyTagsToVolumes(model.copyTagsToVolumes);
            dailyAutomaticBackupStartTime(model.dailyAutomaticBackupStartTime);
            deploymentType(model.deploymentType);
            throughputCapacity(model.throughputCapacity);
            weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            diskIopsConfiguration(model.diskIopsConfiguration);
            rootVolumeConfiguration(model.rootVolumeConfiguration);
        }

        public final Integer getAutomaticBackupRetentionDays() {
            return automaticBackupRetentionDays;
        }

        public final void setAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
        }

        @Override
        public final Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
            return this;
        }

        public final Boolean getCopyTagsToBackups() {
            return copyTagsToBackups;
        }

        public final void setCopyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
        }

        @Override
        public final Builder copyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
            return this;
        }

        public final Boolean getCopyTagsToVolumes() {
            return copyTagsToVolumes;
        }

        public final void setCopyTagsToVolumes(Boolean copyTagsToVolumes) {
            this.copyTagsToVolumes = copyTagsToVolumes;
        }

        @Override
        public final Builder copyTagsToVolumes(Boolean copyTagsToVolumes) {
            this.copyTagsToVolumes = copyTagsToVolumes;
            return this;
        }

        public final String getDailyAutomaticBackupStartTime() {
            return dailyAutomaticBackupStartTime;
        }

        public final void setDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
        }

        @Override
        public final Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
            return this;
        }

        public final String getDeploymentType() {
            return deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(OpenZFSDeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final Integer getThroughputCapacity() {
            return throughputCapacity;
        }

        public final void setThroughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
        }

        @Override
        public final Builder throughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
            return this;
        }

        public final String getWeeklyMaintenanceStartTime() {
            return weeklyMaintenanceStartTime;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        @Override
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final DiskIopsConfiguration.Builder getDiskIopsConfiguration() {
            return diskIopsConfiguration != null ? diskIopsConfiguration.toBuilder() : null;
        }

        public final void setDiskIopsConfiguration(DiskIopsConfiguration.BuilderImpl diskIopsConfiguration) {
            this.diskIopsConfiguration = diskIopsConfiguration != null ? diskIopsConfiguration.build() : null;
        }

        @Override
        public final Builder diskIopsConfiguration(DiskIopsConfiguration diskIopsConfiguration) {
            this.diskIopsConfiguration = diskIopsConfiguration;
            return this;
        }

        public final OpenZFSCreateRootVolumeConfiguration.Builder getRootVolumeConfiguration() {
            return rootVolumeConfiguration != null ? rootVolumeConfiguration.toBuilder() : null;
        }

        public final void setRootVolumeConfiguration(OpenZFSCreateRootVolumeConfiguration.BuilderImpl rootVolumeConfiguration) {
            this.rootVolumeConfiguration = rootVolumeConfiguration != null ? rootVolumeConfiguration.build() : null;
        }

        @Override
        public final Builder rootVolumeConfiguration(OpenZFSCreateRootVolumeConfiguration rootVolumeConfiguration) {
            this.rootVolumeConfiguration = rootVolumeConfiguration;
            return this;
        }

        @Override
        public CreateFileSystemOpenZFSConfiguration build() {
            return new CreateFileSystemOpenZFSConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
