/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fsx.FSxClient;
import software.amazon.awssdk.services.fsx.internal.UserAgentUtils;
import software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesRequest;
import software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesResponse;

public class DescribeFileSystemAliasesIterable
implements SdkIterable<DescribeFileSystemAliasesResponse> {
    private final FSxClient client;
    private final DescribeFileSystemAliasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeFileSystemAliasesIterable(FSxClient client, DescribeFileSystemAliasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeFileSystemAliasesResponseFetcher();
    }

    public Iterator<DescribeFileSystemAliasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeFileSystemAliasesResponseFetcher
    implements SyncPageFetcher<DescribeFileSystemAliasesResponse> {
        private DescribeFileSystemAliasesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFileSystemAliasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeFileSystemAliasesResponse nextPage(DescribeFileSystemAliasesResponse previousPage) {
            if (previousPage == null) {
                return DescribeFileSystemAliasesIterable.this.client.describeFileSystemAliases(DescribeFileSystemAliasesIterable.this.firstRequest);
            }
            return DescribeFileSystemAliasesIterable.this.client.describeFileSystemAliases((DescribeFileSystemAliasesRequest)((Object)DescribeFileSystemAliasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

