/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used to specify the configuration options for an FSx for ONTAP volume's storage aggregate or aggregates.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAggregateConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateAggregateConfiguration.Builder, CreateAggregateConfiguration> {
    private static final SdkField<List<String>> AGGREGATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Aggregates")
            .getter(getter(CreateAggregateConfiguration::aggregates))
            .setter(setter(Builder::aggregates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> CONSTITUENTS_PER_AGGREGATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ConstituentsPerAggregate").getter(getter(CreateAggregateConfiguration::constituentsPerAggregate))
            .setter(setter(Builder::constituentsPerAggregate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstituentsPerAggregate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATES_FIELD,
            CONSTITUENTS_PER_AGGREGATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> aggregates;

    private final Integer constituentsPerAggregate;

    private CreateAggregateConfiguration(BuilderImpl builder) {
        this.aggregates = builder.aggregates;
        this.constituentsPerAggregate = builder.constituentsPerAggregate;
    }

    /**
     * For responses, this returns true if the service returned a value for the Aggregates property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAggregates() {
        return aggregates != null && !(aggregates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Used to specify the names of aggregates on which the volume will be created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregates} method.
     * </p>
     * 
     * @return Used to specify the names of aggregates on which the volume will be created.
     */
    public final List<String> aggregates() {
        return aggregates;
    }

    /**
     * <p>
     * Used to explicitly set the number of constituents within the FlexGroup per storage aggregate. This field is
     * optional when creating a FlexGroup volume. If unspecified, the default value will be 8. This field cannot be
     * provided when creating a FlexVol volume.
     * </p>
     * 
     * @return Used to explicitly set the number of constituents within the FlexGroup per storage aggregate. This field
     *         is optional when creating a FlexGroup volume. If unspecified, the default value will be 8. This field
     *         cannot be provided when creating a FlexVol volume.
     */
    public final Integer constituentsPerAggregate() {
        return constituentsPerAggregate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregates() ? aggregates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(constituentsPerAggregate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAggregateConfiguration)) {
            return false;
        }
        CreateAggregateConfiguration other = (CreateAggregateConfiguration) obj;
        return hasAggregates() == other.hasAggregates() && Objects.equals(aggregates(), other.aggregates())
                && Objects.equals(constituentsPerAggregate(), other.constituentsPerAggregate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAggregateConfiguration").add("Aggregates", hasAggregates() ? aggregates() : null)
                .add("ConstituentsPerAggregate", constituentsPerAggregate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Aggregates":
            return Optional.ofNullable(clazz.cast(aggregates()));
        case "ConstituentsPerAggregate":
            return Optional.ofNullable(clazz.cast(constituentsPerAggregate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAggregateConfiguration, T> g) {
        return obj -> g.apply((CreateAggregateConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateAggregateConfiguration> {
        /**
         * <p>
         * Used to specify the names of aggregates on which the volume will be created.
         * </p>
         * 
         * @param aggregates
         *        Used to specify the names of aggregates on which the volume will be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregates(Collection<String> aggregates);

        /**
         * <p>
         * Used to specify the names of aggregates on which the volume will be created.
         * </p>
         * 
         * @param aggregates
         *        Used to specify the names of aggregates on which the volume will be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregates(String... aggregates);

        /**
         * <p>
         * Used to explicitly set the number of constituents within the FlexGroup per storage aggregate. This field is
         * optional when creating a FlexGroup volume. If unspecified, the default value will be 8. This field cannot be
         * provided when creating a FlexVol volume.
         * </p>
         * 
         * @param constituentsPerAggregate
         *        Used to explicitly set the number of constituents within the FlexGroup per storage aggregate. This
         *        field is optional when creating a FlexGroup volume. If unspecified, the default value will be 8. This
         *        field cannot be provided when creating a FlexVol volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constituentsPerAggregate(Integer constituentsPerAggregate);
    }

    static final class BuilderImpl implements Builder {
        private List<String> aggregates = DefaultSdkAutoConstructList.getInstance();

        private Integer constituentsPerAggregate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAggregateConfiguration model) {
            aggregates(model.aggregates);
            constituentsPerAggregate(model.constituentsPerAggregate);
        }

        public final Collection<String> getAggregates() {
            if (aggregates instanceof SdkAutoConstructList) {
                return null;
            }
            return aggregates;
        }

        public final void setAggregates(Collection<String> aggregates) {
            this.aggregates = AggregatesCopier.copy(aggregates);
        }

        @Override
        public final Builder aggregates(Collection<String> aggregates) {
            this.aggregates = AggregatesCopier.copy(aggregates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregates(String... aggregates) {
            aggregates(Arrays.asList(aggregates));
            return this;
        }

        public final Integer getConstituentsPerAggregate() {
            return constituentsPerAggregate;
        }

        public final void setConstituentsPerAggregate(Integer constituentsPerAggregate) {
            this.constituentsPerAggregate = constituentsPerAggregate;
        }

        @Override
        public final Builder constituentsPerAggregate(Integer constituentsPerAggregate) {
            this.constituentsPerAggregate = constituentsPerAggregate;
            return this;
        }

        @Override
        public CreateAggregateConfiguration build() {
            return new CreateAggregateConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
