/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used to specify configuration options for a volume’s storage aggregate or aggregates.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregateConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregateConfiguration.Builder, AggregateConfiguration> {
    private static final SdkField<List<String>> AGGREGATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Aggregates")
            .getter(getter(AggregateConfiguration::aggregates))
            .setter(setter(Builder::aggregates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> TOTAL_CONSTITUENTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalConstituents").getter(getter(AggregateConfiguration::totalConstituents))
            .setter(setter(Builder::totalConstituents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalConstituents").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATES_FIELD,
            TOTAL_CONSTITUENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> aggregates;

    private final Integer totalConstituents;

    private AggregateConfiguration(BuilderImpl builder) {
        this.aggregates = builder.aggregates;
        this.totalConstituents = builder.totalConstituents;
    }

    /**
     * For responses, this returns true if the service returned a value for the Aggregates property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAggregates() {
        return aggregates != null && !(aggregates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of aggregates that this volume resides on. Aggregates are storage pools which make up your primary
     * storage tier. Each high-availability (HA) pair has one aggregate. The names of the aggregates map to the names of
     * the aggregates in the ONTAP CLI and REST API. For FlexVols, there will always be a single entry.
     * </p>
     * <p>
     * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The strings in the value of <code>Aggregates</code> are not are not formatted as <code>aggrX</code>, where X is a
     * number between 1 and 6.
     * </p>
     * </li>
     * <li>
     * <p>
     * The value of <code>Aggregates</code> contains aggregates that are not present.
     * </p>
     * </li>
     * <li>
     * <p>
     * One or more of the aggregates supplied are too close to the volume limit to support adding more volumes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregates} method.
     * </p>
     * 
     * @return The list of aggregates that this volume resides on. Aggregates are storage pools which make up your
     *         primary storage tier. Each high-availability (HA) pair has one aggregate. The names of the aggregates map
     *         to the names of the aggregates in the ONTAP CLI and REST API. For FlexVols, there will always be a single
     *         entry.</p>
     *         <p>
     *         Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The strings in the value of <code>Aggregates</code> are not are not formatted as <code>aggrX</code>,
     *         where X is a number between 1 and 6.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The value of <code>Aggregates</code> contains aggregates that are not present.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the aggregates supplied are too close to the volume limit to support adding more volumes.
     *         </p>
     *         </li>
     */
    public final List<String> aggregates() {
        return aggregates;
    }

    /**
     * <p>
     * The total number of constituents this FlexGroup volume has. Not applicable for FlexVols.
     * </p>
     * 
     * @return The total number of constituents this FlexGroup volume has. Not applicable for FlexVols.
     */
    public final Integer totalConstituents() {
        return totalConstituents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregates() ? aggregates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalConstituents());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateConfiguration)) {
            return false;
        }
        AggregateConfiguration other = (AggregateConfiguration) obj;
        return hasAggregates() == other.hasAggregates() && Objects.equals(aggregates(), other.aggregates())
                && Objects.equals(totalConstituents(), other.totalConstituents());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregateConfiguration").add("Aggregates", hasAggregates() ? aggregates() : null)
                .add("TotalConstituents", totalConstituents()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Aggregates":
            return Optional.ofNullable(clazz.cast(aggregates()));
        case "TotalConstituents":
            return Optional.ofNullable(clazz.cast(totalConstituents()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregateConfiguration, T> g) {
        return obj -> g.apply((AggregateConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregateConfiguration> {
        /**
         * <p>
         * The list of aggregates that this volume resides on. Aggregates are storage pools which make up your primary
         * storage tier. Each high-availability (HA) pair has one aggregate. The names of the aggregates map to the
         * names of the aggregates in the ONTAP CLI and REST API. For FlexVols, there will always be a single entry.
         * </p>
         * <p>
         * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The strings in the value of <code>Aggregates</code> are not are not formatted as <code>aggrX</code>, where X
         * is a number between 1 and 6.
         * </p>
         * </li>
         * <li>
         * <p>
         * The value of <code>Aggregates</code> contains aggregates that are not present.
         * </p>
         * </li>
         * <li>
         * <p>
         * One or more of the aggregates supplied are too close to the volume limit to support adding more volumes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param aggregates
         *        The list of aggregates that this volume resides on. Aggregates are storage pools which make up your
         *        primary storage tier. Each high-availability (HA) pair has one aggregate. The names of the aggregates
         *        map to the names of the aggregates in the ONTAP CLI and REST API. For FlexVols, there will always be a
         *        single entry.</p>
         *        <p>
         *        Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The strings in the value of <code>Aggregates</code> are not are not formatted as <code>aggrX</code>,
         *        where X is a number between 1 and 6.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The value of <code>Aggregates</code> contains aggregates that are not present.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        One or more of the aggregates supplied are too close to the volume limit to support adding more
         *        volumes.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregates(Collection<String> aggregates);

        /**
         * <p>
         * The list of aggregates that this volume resides on. Aggregates are storage pools which make up your primary
         * storage tier. Each high-availability (HA) pair has one aggregate. The names of the aggregates map to the
         * names of the aggregates in the ONTAP CLI and REST API. For FlexVols, there will always be a single entry.
         * </p>
         * <p>
         * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The strings in the value of <code>Aggregates</code> are not are not formatted as <code>aggrX</code>, where X
         * is a number between 1 and 6.
         * </p>
         * </li>
         * <li>
         * <p>
         * The value of <code>Aggregates</code> contains aggregates that are not present.
         * </p>
         * </li>
         * <li>
         * <p>
         * One or more of the aggregates supplied are too close to the volume limit to support adding more volumes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param aggregates
         *        The list of aggregates that this volume resides on. Aggregates are storage pools which make up your
         *        primary storage tier. Each high-availability (HA) pair has one aggregate. The names of the aggregates
         *        map to the names of the aggregates in the ONTAP CLI and REST API. For FlexVols, there will always be a
         *        single entry.</p>
         *        <p>
         *        Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The strings in the value of <code>Aggregates</code> are not are not formatted as <code>aggrX</code>,
         *        where X is a number between 1 and 6.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The value of <code>Aggregates</code> contains aggregates that are not present.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        One or more of the aggregates supplied are too close to the volume limit to support adding more
         *        volumes.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregates(String... aggregates);

        /**
         * <p>
         * The total number of constituents this FlexGroup volume has. Not applicable for FlexVols.
         * </p>
         * 
         * @param totalConstituents
         *        The total number of constituents this FlexGroup volume has. Not applicable for FlexVols.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalConstituents(Integer totalConstituents);
    }

    static final class BuilderImpl implements Builder {
        private List<String> aggregates = DefaultSdkAutoConstructList.getInstance();

        private Integer totalConstituents;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateConfiguration model) {
            aggregates(model.aggregates);
            totalConstituents(model.totalConstituents);
        }

        public final Collection<String> getAggregates() {
            if (aggregates instanceof SdkAutoConstructList) {
                return null;
            }
            return aggregates;
        }

        public final void setAggregates(Collection<String> aggregates) {
            this.aggregates = AggregatesCopier.copy(aggregates);
        }

        @Override
        public final Builder aggregates(Collection<String> aggregates) {
            this.aggregates = AggregatesCopier.copy(aggregates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregates(String... aggregates) {
            aggregates(Arrays.asList(aggregates));
            return this;
        }

        public final Integer getTotalConstituents() {
            return totalConstituents;
        }

        public final void setTotalConstituents(Integer totalConstituents) {
            this.totalConstituents = totalConstituents;
        }

        @Override
        public final Builder totalConstituents(Integer totalConstituents) {
            this.totalConstituents = totalConstituents;
            return this;
        }

        @Override
        public AggregateConfiguration build() {
            return new AggregateConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
