/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration of the ONTAP volume that you are creating.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOntapVolumeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateOntapVolumeConfiguration.Builder, CreateOntapVolumeConfiguration> {
    private static final SdkField<String> JUNCTION_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JunctionPath").getter(getter(CreateOntapVolumeConfiguration::junctionPath))
            .setter(setter(Builder::junctionPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JunctionPath").build()).build();

    private static final SdkField<String> SECURITY_STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityStyle").getter(getter(CreateOntapVolumeConfiguration::securityStyleAsString))
            .setter(setter(Builder::securityStyle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityStyle").build()).build();

    private static final SdkField<Integer> SIZE_IN_MEGABYTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SizeInMegabytes").getter(getter(CreateOntapVolumeConfiguration::sizeInMegabytes))
            .setter(setter(Builder::sizeInMegabytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInMegabytes").build()).build();

    private static final SdkField<Boolean> STORAGE_EFFICIENCY_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StorageEfficiencyEnabled").getter(getter(CreateOntapVolumeConfiguration::storageEfficiencyEnabled))
            .setter(setter(Builder::storageEfficiencyEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEfficiencyEnabled").build())
            .build();

    private static final SdkField<String> STORAGE_VIRTUAL_MACHINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageVirtualMachineId").getter(getter(CreateOntapVolumeConfiguration::storageVirtualMachineId))
            .setter(setter(Builder::storageVirtualMachineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageVirtualMachineId").build())
            .build();

    private static final SdkField<TieringPolicy> TIERING_POLICY_FIELD = SdkField
            .<TieringPolicy> builder(MarshallingType.SDK_POJO).memberName("TieringPolicy")
            .getter(getter(CreateOntapVolumeConfiguration::tieringPolicy)).setter(setter(Builder::tieringPolicy))
            .constructor(TieringPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringPolicy").build()).build();

    private static final SdkField<String> ONTAP_VOLUME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OntapVolumeType").getter(getter(CreateOntapVolumeConfiguration::ontapVolumeTypeAsString))
            .setter(setter(Builder::ontapVolumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OntapVolumeType").build()).build();

    private static final SdkField<String> SNAPSHOT_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotPolicy").getter(getter(CreateOntapVolumeConfiguration::snapshotPolicy))
            .setter(setter(Builder::snapshotPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotPolicy").build()).build();

    private static final SdkField<Boolean> COPY_TAGS_TO_BACKUPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToBackups").getter(getter(CreateOntapVolumeConfiguration::copyTagsToBackups))
            .setter(setter(Builder::copyTagsToBackups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToBackups").build()).build();

    private static final SdkField<CreateSnaplockConfiguration> SNAPLOCK_CONFIGURATION_FIELD = SdkField
            .<CreateSnaplockConfiguration> builder(MarshallingType.SDK_POJO).memberName("SnaplockConfiguration")
            .getter(getter(CreateOntapVolumeConfiguration::snaplockConfiguration)).setter(setter(Builder::snaplockConfiguration))
            .constructor(CreateSnaplockConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnaplockConfiguration").build())
            .build();

    private static final SdkField<String> VOLUME_STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeStyle").getter(getter(CreateOntapVolumeConfiguration::volumeStyleAsString))
            .setter(setter(Builder::volumeStyle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeStyle").build()).build();

    private static final SdkField<CreateAggregateConfiguration> AGGREGATE_CONFIGURATION_FIELD = SdkField
            .<CreateAggregateConfiguration> builder(MarshallingType.SDK_POJO).memberName("AggregateConfiguration")
            .getter(getter(CreateOntapVolumeConfiguration::aggregateConfiguration))
            .setter(setter(Builder::aggregateConfiguration)).constructor(CreateAggregateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregateConfiguration").build())
            .build();

    private static final SdkField<Long> SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("SizeInBytes").getter(getter(CreateOntapVolumeConfiguration::sizeInBytes))
            .setter(setter(Builder::sizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInBytes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JUNCTION_PATH_FIELD,
            SECURITY_STYLE_FIELD, SIZE_IN_MEGABYTES_FIELD, STORAGE_EFFICIENCY_ENABLED_FIELD, STORAGE_VIRTUAL_MACHINE_ID_FIELD,
            TIERING_POLICY_FIELD, ONTAP_VOLUME_TYPE_FIELD, SNAPSHOT_POLICY_FIELD, COPY_TAGS_TO_BACKUPS_FIELD,
            SNAPLOCK_CONFIGURATION_FIELD, VOLUME_STYLE_FIELD, AGGREGATE_CONFIGURATION_FIELD, SIZE_IN_BYTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String junctionPath;

    private final String securityStyle;

    private final Integer sizeInMegabytes;

    private final Boolean storageEfficiencyEnabled;

    private final String storageVirtualMachineId;

    private final TieringPolicy tieringPolicy;

    private final String ontapVolumeType;

    private final String snapshotPolicy;

    private final Boolean copyTagsToBackups;

    private final CreateSnaplockConfiguration snaplockConfiguration;

    private final String volumeStyle;

    private final CreateAggregateConfiguration aggregateConfiguration;

    private final Long sizeInBytes;

    private CreateOntapVolumeConfiguration(BuilderImpl builder) {
        this.junctionPath = builder.junctionPath;
        this.securityStyle = builder.securityStyle;
        this.sizeInMegabytes = builder.sizeInMegabytes;
        this.storageEfficiencyEnabled = builder.storageEfficiencyEnabled;
        this.storageVirtualMachineId = builder.storageVirtualMachineId;
        this.tieringPolicy = builder.tieringPolicy;
        this.ontapVolumeType = builder.ontapVolumeType;
        this.snapshotPolicy = builder.snapshotPolicy;
        this.copyTagsToBackups = builder.copyTagsToBackups;
        this.snaplockConfiguration = builder.snaplockConfiguration;
        this.volumeStyle = builder.volumeStyle;
        this.aggregateConfiguration = builder.aggregateConfiguration;
        this.sizeInBytes = builder.sizeInBytes;
    }

    /**
     * <p>
     * Specifies the location in the SVM's namespace where the volume is mounted. This parameter is required. The
     * <code>JunctionPath</code> must have a leading forward slash, such as <code>/vol3</code>.
     * </p>
     * 
     * @return Specifies the location in the SVM's namespace where the volume is mounted. This parameter is required.
     *         The <code>JunctionPath</code> must have a leading forward slash, such as <code>/vol3</code>.
     */
    public final String junctionPath() {
        return junctionPath;
    }

    /**
     * <p>
     * Specifies the security style for the volume. If a volume's security style is not specified, it is automatically
     * set to the root volume's security style. The security style determines the type of permissions that FSx for ONTAP
     * uses to control data access. For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-security-style">Volume security style</a> in the
     * <i>Amazon FSx for NetApp ONTAP User Guide</i>. Specify one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS clients,
     * and an application accessing the data uses a UNIX user as the service account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB
     * clients, and an application accessing the data uses a Windows user as the service account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MIXED</code> This is an advanced setting. For more information, see the topic <a
     * href="https://docs.netapp.com/us-en/ontap/nfs-admin/security-styles-their-effects-concept.html">What the security
     * styles and their effects are</a> in the NetApp Documentation Center.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-security-style.html">Volume security style</a> in
     * the FSx for ONTAP User Guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #securityStyle}
     * will return {@link SecurityStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #securityStyleAsString}.
     * </p>
     * 
     * @return Specifies the security style for the volume. If a volume's security style is not specified, it is
     *         automatically set to the root volume's security style. The security style determines the type of
     *         permissions that FSx for ONTAP uses to control data access. For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-security-style">Volume security style</a>
     *         in the <i>Amazon FSx for NetApp ONTAP User Guide</i>. Specify one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS
     *         clients, and an application accessing the data uses a UNIX user as the service account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB
     *         clients, and an application accessing the data uses a Windows user as the service account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MIXED</code> This is an advanced setting. For more information, see the topic <a
     *         href="https://docs.netapp.com/us-en/ontap/nfs-admin/security-styles-their-effects-concept.html">What the
     *         security styles and their effects are</a> in the NetApp Documentation Center.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-security-style.html">Volume security
     *         style</a> in the FSx for ONTAP User Guide.
     * @see SecurityStyle
     */
    public final SecurityStyle securityStyle() {
        return SecurityStyle.fromValue(securityStyle);
    }

    /**
     * <p>
     * Specifies the security style for the volume. If a volume's security style is not specified, it is automatically
     * set to the root volume's security style. The security style determines the type of permissions that FSx for ONTAP
     * uses to control data access. For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-security-style">Volume security style</a> in the
     * <i>Amazon FSx for NetApp ONTAP User Guide</i>. Specify one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS clients,
     * and an application accessing the data uses a UNIX user as the service account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB
     * clients, and an application accessing the data uses a Windows user as the service account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MIXED</code> This is an advanced setting. For more information, see the topic <a
     * href="https://docs.netapp.com/us-en/ontap/nfs-admin/security-styles-their-effects-concept.html">What the security
     * styles and their effects are</a> in the NetApp Documentation Center.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-security-style.html">Volume security style</a> in
     * the FSx for ONTAP User Guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #securityStyle}
     * will return {@link SecurityStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #securityStyleAsString}.
     * </p>
     * 
     * @return Specifies the security style for the volume. If a volume's security style is not specified, it is
     *         automatically set to the root volume's security style. The security style determines the type of
     *         permissions that FSx for ONTAP uses to control data access. For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-security-style">Volume security style</a>
     *         in the <i>Amazon FSx for NetApp ONTAP User Guide</i>. Specify one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS
     *         clients, and an application accessing the data uses a UNIX user as the service account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB
     *         clients, and an application accessing the data uses a Windows user as the service account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MIXED</code> This is an advanced setting. For more information, see the topic <a
     *         href="https://docs.netapp.com/us-en/ontap/nfs-admin/security-styles-their-effects-concept.html">What the
     *         security styles and their effects are</a> in the NetApp Documentation Center.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-security-style.html">Volume security
     *         style</a> in the FSx for ONTAP User Guide.
     * @see SecurityStyle
     */
    public final String securityStyleAsString() {
        return securityStyle;
    }

    /**
     * <p>
     * Use <code>SizeInBytes</code> instead. Specifies the size of the volume, in megabytes (MB), that you are creating.
     * </p>
     * 
     * @return Use <code>SizeInBytes</code> instead. Specifies the size of the volume, in megabytes (MB), that you are
     *         creating.
     * @deprecated This property is deprecated, use SizeInBytes instead
     */
    @Deprecated
    public final Integer sizeInMegabytes() {
        return sizeInMegabytes;
    }

    /**
     * <p>
     * Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume, or
     * set to false to disable them.
     * </p>
     * <p>
     * <code>StorageEfficiencyEnabled</code> is required when creating a <code>RW</code> volume (
     * <code>OntapVolumeType</code> set to <code>RW</code>).
     * </p>
     * 
     * @return Set to true to enable deduplication, compression, and compaction storage efficiency features on the
     *         volume, or set to false to disable them.</p>
     *         <p>
     *         <code>StorageEfficiencyEnabled</code> is required when creating a <code>RW</code> volume (
     *         <code>OntapVolumeType</code> set to <code>RW</code>).
     */
    public final Boolean storageEfficiencyEnabled() {
        return storageEfficiencyEnabled;
    }

    /**
     * <p>
     * Specifies the ONTAP SVM in which to create the volume.
     * </p>
     * 
     * @return Specifies the ONTAP SVM in which to create the volume.
     */
    public final String storageVirtualMachineId() {
        return storageVirtualMachineId;
    }

    /**
     * Returns the value of the TieringPolicy property for this object.
     * 
     * @return The value of the TieringPolicy property for this object.
     */
    public final TieringPolicy tieringPolicy() {
        return tieringPolicy;
    }

    /**
     * <p>
     * Specifies the type of volume you are creating. Valid values are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RW</code> specifies a read/write volume. <code>RW</code> is the default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DP</code> specifies a data-protection volume. A <code>DP</code> volume is read-only and can be used as the
     * destination of a NetApp SnapMirror relationship.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-types">Volume
     * types</a> in the Amazon FSx for NetApp ONTAP User Guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ontapVolumeType}
     * will return {@link InputOntapVolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #ontapVolumeTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of volume you are creating. Valid values are the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RW</code> specifies a read/write volume. <code>RW</code> is the default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DP</code> specifies a data-protection volume. A <code>DP</code> volume is read-only and can be used
     *         as the destination of a NetApp SnapMirror relationship.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-types">Volume
     *         types</a> in the Amazon FSx for NetApp ONTAP User Guide.
     * @see InputOntapVolumeType
     */
    public final InputOntapVolumeType ontapVolumeType() {
        return InputOntapVolumeType.fromValue(ontapVolumeType);
    }

    /**
     * <p>
     * Specifies the type of volume you are creating. Valid values are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RW</code> specifies a read/write volume. <code>RW</code> is the default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DP</code> specifies a data-protection volume. A <code>DP</code> volume is read-only and can be used as the
     * destination of a NetApp SnapMirror relationship.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-types">Volume
     * types</a> in the Amazon FSx for NetApp ONTAP User Guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ontapVolumeType}
     * will return {@link InputOntapVolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #ontapVolumeTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of volume you are creating. Valid values are the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RW</code> specifies a read/write volume. <code>RW</code> is the default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DP</code> specifies a data-protection volume. A <code>DP</code> volume is read-only and can be used
     *         as the destination of a NetApp SnapMirror relationship.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-types">Volume
     *         types</a> in the Amazon FSx for NetApp ONTAP User Guide.
     * @see InputOntapVolumeType
     */
    public final String ontapVolumeTypeAsString() {
        return ontapVolumeType;
    }

    /**
     * <p>
     * Specifies the snapshot policy for the volume. There are three built-in snapshot policies:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>default</code>: This is the default policy. A maximum of six hourly snapshots taken five minutes past the
     * hour. A maximum of two daily snapshots taken Monday through Saturday at 10 minutes after midnight. A maximum of
     * two weekly snapshots taken every Sunday at 15 minutes after midnight.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>default-1weekly</code>: This policy is the same as the <code>default</code> policy except that it only
     * retains one snapshot from the weekly schedule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>none</code>: This policy does not take any snapshots. This policy can be assigned to volumes to prevent
     * automatic snapshots from being taken.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also provide the name of a custom policy that you created with the ONTAP CLI or REST API.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies">Snapshot
     * policies</a> in the Amazon FSx for NetApp ONTAP User Guide.
     * </p>
     * 
     * @return Specifies the snapshot policy for the volume. There are three built-in snapshot policies:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>default</code>: This is the default policy. A maximum of six hourly snapshots taken five minutes
     *         past the hour. A maximum of two daily snapshots taken Monday through Saturday at 10 minutes after
     *         midnight. A maximum of two weekly snapshots taken every Sunday at 15 minutes after midnight.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>default-1weekly</code>: This policy is the same as the <code>default</code> policy except that it
     *         only retains one snapshot from the weekly schedule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>none</code>: This policy does not take any snapshots. This policy can be assigned to volumes to
     *         prevent automatic snapshots from being taken.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can also provide the name of a custom policy that you created with the ONTAP CLI or REST API.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies">Snapshot
     *         policies</a> in the Amazon FSx for NetApp ONTAP User Guide.
     */
    public final String snapshotPolicy() {
        return snapshotPolicy;
    }

    /**
     * <p>
     * A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to false.
     * If it's set to true, all tags for the volume are copied to all automatic and user-initiated backups where the
     * user doesn't specify tags. If this value is true, and you specify one or more tags, only the specified tags are
     * copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from
     * the volume, regardless of this value.
     * </p>
     * 
     * @return A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to
     *         false. If it's set to true, all tags for the volume are copied to all automatic and user-initiated
     *         backups where the user doesn't specify tags. If this value is true, and you specify one or more tags,
     *         only the specified tags are copied to backups. If you specify one or more tags when creating a
     *         user-initiated backup, no tags are copied from the volume, regardless of this value.
     */
    public final Boolean copyTagsToBackups() {
        return copyTagsToBackups;
    }

    /**
     * <p>
     * Specifies the SnapLock configuration for an FSx for ONTAP volume.
     * </p>
     * 
     * @return Specifies the SnapLock configuration for an FSx for ONTAP volume.
     */
    public final CreateSnaplockConfiguration snaplockConfiguration() {
        return snaplockConfiguration;
    }

    /**
     * <p>
     * Use to specify the style of an ONTAP volume. FSx for ONTAP offers two styles of volumes that you can use for
     * different purposes, FlexVol and FlexGroup volumes. For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-styles.html">Volume styles</a> in the Amazon FSx
     * for NetApp ONTAP User Guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeStyle} will
     * return {@link VolumeStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeStyleAsString}.
     * </p>
     * 
     * @return Use to specify the style of an ONTAP volume. FSx for ONTAP offers two styles of volumes that you can use
     *         for different purposes, FlexVol and FlexGroup volumes. For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-styles.html">Volume styles</a> in the
     *         Amazon FSx for NetApp ONTAP User Guide.
     * @see VolumeStyle
     */
    public final VolumeStyle volumeStyle() {
        return VolumeStyle.fromValue(volumeStyle);
    }

    /**
     * <p>
     * Use to specify the style of an ONTAP volume. FSx for ONTAP offers two styles of volumes that you can use for
     * different purposes, FlexVol and FlexGroup volumes. For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-styles.html">Volume styles</a> in the Amazon FSx
     * for NetApp ONTAP User Guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeStyle} will
     * return {@link VolumeStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeStyleAsString}.
     * </p>
     * 
     * @return Use to specify the style of an ONTAP volume. FSx for ONTAP offers two styles of volumes that you can use
     *         for different purposes, FlexVol and FlexGroup volumes. For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-styles.html">Volume styles</a> in the
     *         Amazon FSx for NetApp ONTAP User Guide.
     * @see VolumeStyle
     */
    public final String volumeStyleAsString() {
        return volumeStyle;
    }

    /**
     * <p>
     * Use to specify configuration options for a volume’s storage aggregate or aggregates.
     * </p>
     * 
     * @return Use to specify configuration options for a volume’s storage aggregate or aggregates.
     */
    public final CreateAggregateConfiguration aggregateConfiguration() {
        return aggregateConfiguration;
    }

    /**
     * <p>
     * Specifies the configured size of the volume, in bytes.
     * </p>
     * 
     * @return Specifies the configured size of the volume, in bytes.
     */
    public final Long sizeInBytes() {
        return sizeInBytes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(junctionPath());
        hashCode = 31 * hashCode + Objects.hashCode(securityStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInMegabytes());
        hashCode = 31 * hashCode + Objects.hashCode(storageEfficiencyEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(storageVirtualMachineId());
        hashCode = 31 * hashCode + Objects.hashCode(tieringPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(ontapVolumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToBackups());
        hashCode = 31 * hashCode + Objects.hashCode(snaplockConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(volumeStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aggregateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInBytes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOntapVolumeConfiguration)) {
            return false;
        }
        CreateOntapVolumeConfiguration other = (CreateOntapVolumeConfiguration) obj;
        return Objects.equals(junctionPath(), other.junctionPath())
                && Objects.equals(securityStyleAsString(), other.securityStyleAsString())
                && Objects.equals(sizeInMegabytes(), other.sizeInMegabytes())
                && Objects.equals(storageEfficiencyEnabled(), other.storageEfficiencyEnabled())
                && Objects.equals(storageVirtualMachineId(), other.storageVirtualMachineId())
                && Objects.equals(tieringPolicy(), other.tieringPolicy())
                && Objects.equals(ontapVolumeTypeAsString(), other.ontapVolumeTypeAsString())
                && Objects.equals(snapshotPolicy(), other.snapshotPolicy())
                && Objects.equals(copyTagsToBackups(), other.copyTagsToBackups())
                && Objects.equals(snaplockConfiguration(), other.snaplockConfiguration())
                && Objects.equals(volumeStyleAsString(), other.volumeStyleAsString())
                && Objects.equals(aggregateConfiguration(), other.aggregateConfiguration())
                && Objects.equals(sizeInBytes(), other.sizeInBytes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateOntapVolumeConfiguration").add("JunctionPath", junctionPath())
                .add("SecurityStyle", securityStyleAsString()).add("SizeInMegabytes", sizeInMegabytes())
                .add("StorageEfficiencyEnabled", storageEfficiencyEnabled())
                .add("StorageVirtualMachineId", storageVirtualMachineId()).add("TieringPolicy", tieringPolicy())
                .add("OntapVolumeType", ontapVolumeTypeAsString()).add("SnapshotPolicy", snapshotPolicy())
                .add("CopyTagsToBackups", copyTagsToBackups()).add("SnaplockConfiguration", snaplockConfiguration())
                .add("VolumeStyle", volumeStyleAsString()).add("AggregateConfiguration", aggregateConfiguration())
                .add("SizeInBytes", sizeInBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JunctionPath":
            return Optional.ofNullable(clazz.cast(junctionPath()));
        case "SecurityStyle":
            return Optional.ofNullable(clazz.cast(securityStyleAsString()));
        case "SizeInMegabytes":
            return Optional.ofNullable(clazz.cast(sizeInMegabytes()));
        case "StorageEfficiencyEnabled":
            return Optional.ofNullable(clazz.cast(storageEfficiencyEnabled()));
        case "StorageVirtualMachineId":
            return Optional.ofNullable(clazz.cast(storageVirtualMachineId()));
        case "TieringPolicy":
            return Optional.ofNullable(clazz.cast(tieringPolicy()));
        case "OntapVolumeType":
            return Optional.ofNullable(clazz.cast(ontapVolumeTypeAsString()));
        case "SnapshotPolicy":
            return Optional.ofNullable(clazz.cast(snapshotPolicy()));
        case "CopyTagsToBackups":
            return Optional.ofNullable(clazz.cast(copyTagsToBackups()));
        case "SnaplockConfiguration":
            return Optional.ofNullable(clazz.cast(snaplockConfiguration()));
        case "VolumeStyle":
            return Optional.ofNullable(clazz.cast(volumeStyleAsString()));
        case "AggregateConfiguration":
            return Optional.ofNullable(clazz.cast(aggregateConfiguration()));
        case "SizeInBytes":
            return Optional.ofNullable(clazz.cast(sizeInBytes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOntapVolumeConfiguration, T> g) {
        return obj -> g.apply((CreateOntapVolumeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateOntapVolumeConfiguration> {
        /**
         * <p>
         * Specifies the location in the SVM's namespace where the volume is mounted. This parameter is required. The
         * <code>JunctionPath</code> must have a leading forward slash, such as <code>/vol3</code>.
         * </p>
         * 
         * @param junctionPath
         *        Specifies the location in the SVM's namespace where the volume is mounted. This parameter is required.
         *        The <code>JunctionPath</code> must have a leading forward slash, such as <code>/vol3</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder junctionPath(String junctionPath);

        /**
         * <p>
         * Specifies the security style for the volume. If a volume's security style is not specified, it is
         * automatically set to the root volume's security style. The security style determines the type of permissions
         * that FSx for ONTAP uses to control data access. For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-security-style">Volume security style</a> in
         * the <i>Amazon FSx for NetApp ONTAP User Guide</i>. Specify one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS
         * clients, and an application accessing the data uses a UNIX user as the service account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB
         * clients, and an application accessing the data uses a Windows user as the service account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MIXED</code> This is an advanced setting. For more information, see the topic <a
         * href="https://docs.netapp.com/us-en/ontap/nfs-admin/security-styles-their-effects-concept.html">What the
         * security styles and their effects are</a> in the NetApp Documentation Center.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-security-style.html">Volume security style</a>
         * in the FSx for ONTAP User Guide.
         * </p>
         * 
         * @param securityStyle
         *        Specifies the security style for the volume. If a volume's security style is not specified, it is
         *        automatically set to the root volume's security style. The security style determines the type of
         *        permissions that FSx for ONTAP uses to control data access. For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-security-style">Volume security
         *        style</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>. Specify one of the following
         *        values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS
         *        clients, and an application accessing the data uses a UNIX user as the service account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are
         *        SMB clients, and an application accessing the data uses a Windows user as the service account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MIXED</code> This is an advanced setting. For more information, see the topic <a
         *        href="https://docs.netapp.com/us-en/ontap/nfs-admin/security-styles-their-effects-concept.html">What
         *        the security styles and their effects are</a> in the NetApp Documentation Center.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-security-style.html">Volume security
         *        style</a> in the FSx for ONTAP User Guide.
         * @see SecurityStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityStyle
         */
        Builder securityStyle(String securityStyle);

        /**
         * <p>
         * Specifies the security style for the volume. If a volume's security style is not specified, it is
         * automatically set to the root volume's security style. The security style determines the type of permissions
         * that FSx for ONTAP uses to control data access. For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-security-style">Volume security style</a> in
         * the <i>Amazon FSx for NetApp ONTAP User Guide</i>. Specify one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS
         * clients, and an application accessing the data uses a UNIX user as the service account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB
         * clients, and an application accessing the data uses a Windows user as the service account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MIXED</code> This is an advanced setting. For more information, see the topic <a
         * href="https://docs.netapp.com/us-en/ontap/nfs-admin/security-styles-their-effects-concept.html">What the
         * security styles and their effects are</a> in the NetApp Documentation Center.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-security-style.html">Volume security style</a>
         * in the FSx for ONTAP User Guide.
         * </p>
         * 
         * @param securityStyle
         *        Specifies the security style for the volume. If a volume's security style is not specified, it is
         *        automatically set to the root volume's security style. The security style determines the type of
         *        permissions that FSx for ONTAP uses to control data access. For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-security-style">Volume security
         *        style</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>. Specify one of the following
         *        values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS
         *        clients, and an application accessing the data uses a UNIX user as the service account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are
         *        SMB clients, and an application accessing the data uses a Windows user as the service account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MIXED</code> This is an advanced setting. For more information, see the topic <a
         *        href="https://docs.netapp.com/us-en/ontap/nfs-admin/security-styles-their-effects-concept.html">What
         *        the security styles and their effects are</a> in the NetApp Documentation Center.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-security-style.html">Volume security
         *        style</a> in the FSx for ONTAP User Guide.
         * @see SecurityStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityStyle
         */
        Builder securityStyle(SecurityStyle securityStyle);

        /**
         * <p>
         * Use <code>SizeInBytes</code> instead. Specifies the size of the volume, in megabytes (MB), that you are
         * creating.
         * </p>
         * 
         * @param sizeInMegabytes
         *        Use <code>SizeInBytes</code> instead. Specifies the size of the volume, in megabytes (MB), that you
         *        are creating.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This property is deprecated, use SizeInBytes instead
         */
        @Deprecated
        Builder sizeInMegabytes(Integer sizeInMegabytes);

        /**
         * <p>
         * Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume,
         * or set to false to disable them.
         * </p>
         * <p>
         * <code>StorageEfficiencyEnabled</code> is required when creating a <code>RW</code> volume (
         * <code>OntapVolumeType</code> set to <code>RW</code>).
         * </p>
         * 
         * @param storageEfficiencyEnabled
         *        Set to true to enable deduplication, compression, and compaction storage efficiency features on the
         *        volume, or set to false to disable them.</p>
         *        <p>
         *        <code>StorageEfficiencyEnabled</code> is required when creating a <code>RW</code> volume (
         *        <code>OntapVolumeType</code> set to <code>RW</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageEfficiencyEnabled(Boolean storageEfficiencyEnabled);

        /**
         * <p>
         * Specifies the ONTAP SVM in which to create the volume.
         * </p>
         * 
         * @param storageVirtualMachineId
         *        Specifies the ONTAP SVM in which to create the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageVirtualMachineId(String storageVirtualMachineId);

        /**
         * Sets the value of the TieringPolicy property for this object.
         *
         * @param tieringPolicy
         *        The new value for the TieringPolicy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tieringPolicy(TieringPolicy tieringPolicy);

        /**
         * Sets the value of the TieringPolicy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TieringPolicy.Builder} avoiding the need
         * to create one manually via {@link TieringPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TieringPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #tieringPolicy(TieringPolicy)}.
         * 
         * @param tieringPolicy
         *        a consumer that will call methods on {@link TieringPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tieringPolicy(TieringPolicy)
         */
        default Builder tieringPolicy(Consumer<TieringPolicy.Builder> tieringPolicy) {
            return tieringPolicy(TieringPolicy.builder().applyMutation(tieringPolicy).build());
        }

        /**
         * <p>
         * Specifies the type of volume you are creating. Valid values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RW</code> specifies a read/write volume. <code>RW</code> is the default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DP</code> specifies a data-protection volume. A <code>DP</code> volume is read-only and can be used as
         * the destination of a NetApp SnapMirror relationship.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-types">Volume
         * types</a> in the Amazon FSx for NetApp ONTAP User Guide.
         * </p>
         * 
         * @param ontapVolumeType
         *        Specifies the type of volume you are creating. Valid values are the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RW</code> specifies a read/write volume. <code>RW</code> is the default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DP</code> specifies a data-protection volume. A <code>DP</code> volume is read-only and can be
         *        used as the destination of a NetApp SnapMirror relationship.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-types">Volume types</a> in the Amazon
         *        FSx for NetApp ONTAP User Guide.
         * @see InputOntapVolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputOntapVolumeType
         */
        Builder ontapVolumeType(String ontapVolumeType);

        /**
         * <p>
         * Specifies the type of volume you are creating. Valid values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RW</code> specifies a read/write volume. <code>RW</code> is the default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DP</code> specifies a data-protection volume. A <code>DP</code> volume is read-only and can be used as
         * the destination of a NetApp SnapMirror relationship.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-types">Volume
         * types</a> in the Amazon FSx for NetApp ONTAP User Guide.
         * </p>
         * 
         * @param ontapVolumeType
         *        Specifies the type of volume you are creating. Valid values are the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RW</code> specifies a read/write volume. <code>RW</code> is the default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DP</code> specifies a data-protection volume. A <code>DP</code> volume is read-only and can be
         *        used as the destination of a NetApp SnapMirror relationship.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-types">Volume types</a> in the Amazon
         *        FSx for NetApp ONTAP User Guide.
         * @see InputOntapVolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputOntapVolumeType
         */
        Builder ontapVolumeType(InputOntapVolumeType ontapVolumeType);

        /**
         * <p>
         * Specifies the snapshot policy for the volume. There are three built-in snapshot policies:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>default</code>: This is the default policy. A maximum of six hourly snapshots taken five minutes past
         * the hour. A maximum of two daily snapshots taken Monday through Saturday at 10 minutes after midnight. A
         * maximum of two weekly snapshots taken every Sunday at 15 minutes after midnight.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>default-1weekly</code>: This policy is the same as the <code>default</code> policy except that it only
         * retains one snapshot from the weekly schedule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>none</code>: This policy does not take any snapshots. This policy can be assigned to volumes to prevent
         * automatic snapshots from being taken.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can also provide the name of a custom policy that you created with the ONTAP CLI or REST API.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies">Snapshot
         * policies</a> in the Amazon FSx for NetApp ONTAP User Guide.
         * </p>
         * 
         * @param snapshotPolicy
         *        Specifies the snapshot policy for the volume. There are three built-in snapshot policies:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>default</code>: This is the default policy. A maximum of six hourly snapshots taken five minutes
         *        past the hour. A maximum of two daily snapshots taken Monday through Saturday at 10 minutes after
         *        midnight. A maximum of two weekly snapshots taken every Sunday at 15 minutes after midnight.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>default-1weekly</code>: This policy is the same as the <code>default</code> policy except that
         *        it only retains one snapshot from the weekly schedule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>none</code>: This policy does not take any snapshots. This policy can be assigned to volumes to
         *        prevent automatic snapshots from being taken.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can also provide the name of a custom policy that you created with the ONTAP CLI or REST API.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies"
         *        >Snapshot policies</a> in the Amazon FSx for NetApp ONTAP User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotPolicy(String snapshotPolicy);

        /**
         * <p>
         * A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to
         * false. If it's set to true, all tags for the volume are copied to all automatic and user-initiated backups
         * where the user doesn't specify tags. If this value is true, and you specify one or more tags, only the
         * specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup,
         * no tags are copied from the volume, regardless of this value.
         * </p>
         * 
         * @param copyTagsToBackups
         *        A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults
         *        to false. If it's set to true, all tags for the volume are copied to all automatic and user-initiated
         *        backups where the user doesn't specify tags. If this value is true, and you specify one or more tags,
         *        only the specified tags are copied to backups. If you specify one or more tags when creating a
         *        user-initiated backup, no tags are copied from the volume, regardless of this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToBackups(Boolean copyTagsToBackups);

        /**
         * <p>
         * Specifies the SnapLock configuration for an FSx for ONTAP volume.
         * </p>
         * 
         * @param snaplockConfiguration
         *        Specifies the SnapLock configuration for an FSx for ONTAP volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snaplockConfiguration(CreateSnaplockConfiguration snaplockConfiguration);

        /**
         * <p>
         * Specifies the SnapLock configuration for an FSx for ONTAP volume.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreateSnaplockConfiguration.Builder}
         * avoiding the need to create one manually via {@link CreateSnaplockConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateSnaplockConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #snaplockConfiguration(CreateSnaplockConfiguration)}.
         * 
         * @param snaplockConfiguration
         *        a consumer that will call methods on {@link CreateSnaplockConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snaplockConfiguration(CreateSnaplockConfiguration)
         */
        default Builder snaplockConfiguration(Consumer<CreateSnaplockConfiguration.Builder> snaplockConfiguration) {
            return snaplockConfiguration(CreateSnaplockConfiguration.builder().applyMutation(snaplockConfiguration).build());
        }

        /**
         * <p>
         * Use to specify the style of an ONTAP volume. FSx for ONTAP offers two styles of volumes that you can use for
         * different purposes, FlexVol and FlexGroup volumes. For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-styles.html">Volume styles</a> in the Amazon
         * FSx for NetApp ONTAP User Guide.
         * </p>
         * 
         * @param volumeStyle
         *        Use to specify the style of an ONTAP volume. FSx for ONTAP offers two styles of volumes that you can
         *        use for different purposes, FlexVol and FlexGroup volumes. For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-styles.html">Volume styles</a> in the
         *        Amazon FSx for NetApp ONTAP User Guide.
         * @see VolumeStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeStyle
         */
        Builder volumeStyle(String volumeStyle);

        /**
         * <p>
         * Use to specify the style of an ONTAP volume. FSx for ONTAP offers two styles of volumes that you can use for
         * different purposes, FlexVol and FlexGroup volumes. For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-styles.html">Volume styles</a> in the Amazon
         * FSx for NetApp ONTAP User Guide.
         * </p>
         * 
         * @param volumeStyle
         *        Use to specify the style of an ONTAP volume. FSx for ONTAP offers two styles of volumes that you can
         *        use for different purposes, FlexVol and FlexGroup volumes. For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-styles.html">Volume styles</a> in the
         *        Amazon FSx for NetApp ONTAP User Guide.
         * @see VolumeStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeStyle
         */
        Builder volumeStyle(VolumeStyle volumeStyle);

        /**
         * <p>
         * Use to specify configuration options for a volume’s storage aggregate or aggregates.
         * </p>
         * 
         * @param aggregateConfiguration
         *        Use to specify configuration options for a volume’s storage aggregate or aggregates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateConfiguration(CreateAggregateConfiguration aggregateConfiguration);

        /**
         * <p>
         * Use to specify configuration options for a volume’s storage aggregate or aggregates.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreateAggregateConfiguration.Builder}
         * avoiding the need to create one manually via {@link CreateAggregateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateAggregateConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #aggregateConfiguration(CreateAggregateConfiguration)}.
         * 
         * @param aggregateConfiguration
         *        a consumer that will call methods on {@link CreateAggregateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregateConfiguration(CreateAggregateConfiguration)
         */
        default Builder aggregateConfiguration(Consumer<CreateAggregateConfiguration.Builder> aggregateConfiguration) {
            return aggregateConfiguration(CreateAggregateConfiguration.builder().applyMutation(aggregateConfiguration).build());
        }

        /**
         * <p>
         * Specifies the configured size of the volume, in bytes.
         * </p>
         * 
         * @param sizeInBytes
         *        Specifies the configured size of the volume, in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInBytes(Long sizeInBytes);
    }

    static final class BuilderImpl implements Builder {
        private String junctionPath;

        private String securityStyle;

        private Integer sizeInMegabytes;

        private Boolean storageEfficiencyEnabled;

        private String storageVirtualMachineId;

        private TieringPolicy tieringPolicy;

        private String ontapVolumeType;

        private String snapshotPolicy;

        private Boolean copyTagsToBackups;

        private CreateSnaplockConfiguration snaplockConfiguration;

        private String volumeStyle;

        private CreateAggregateConfiguration aggregateConfiguration;

        private Long sizeInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOntapVolumeConfiguration model) {
            junctionPath(model.junctionPath);
            securityStyle(model.securityStyle);
            sizeInMegabytes(model.sizeInMegabytes);
            storageEfficiencyEnabled(model.storageEfficiencyEnabled);
            storageVirtualMachineId(model.storageVirtualMachineId);
            tieringPolicy(model.tieringPolicy);
            ontapVolumeType(model.ontapVolumeType);
            snapshotPolicy(model.snapshotPolicy);
            copyTagsToBackups(model.copyTagsToBackups);
            snaplockConfiguration(model.snaplockConfiguration);
            volumeStyle(model.volumeStyle);
            aggregateConfiguration(model.aggregateConfiguration);
            sizeInBytes(model.sizeInBytes);
        }

        public final String getJunctionPath() {
            return junctionPath;
        }

        public final void setJunctionPath(String junctionPath) {
            this.junctionPath = junctionPath;
        }

        @Override
        public final Builder junctionPath(String junctionPath) {
            this.junctionPath = junctionPath;
            return this;
        }

        public final String getSecurityStyle() {
            return securityStyle;
        }

        public final void setSecurityStyle(String securityStyle) {
            this.securityStyle = securityStyle;
        }

        @Override
        public final Builder securityStyle(String securityStyle) {
            this.securityStyle = securityStyle;
            return this;
        }

        @Override
        public final Builder securityStyle(SecurityStyle securityStyle) {
            this.securityStyle(securityStyle == null ? null : securityStyle.toString());
            return this;
        }

        @Deprecated
        public final Integer getSizeInMegabytes() {
            return sizeInMegabytes;
        }

        @Deprecated
        public final void setSizeInMegabytes(Integer sizeInMegabytes) {
            this.sizeInMegabytes = sizeInMegabytes;
        }

        @Override
        @Deprecated
        public final Builder sizeInMegabytes(Integer sizeInMegabytes) {
            this.sizeInMegabytes = sizeInMegabytes;
            return this;
        }

        public final Boolean getStorageEfficiencyEnabled() {
            return storageEfficiencyEnabled;
        }

        public final void setStorageEfficiencyEnabled(Boolean storageEfficiencyEnabled) {
            this.storageEfficiencyEnabled = storageEfficiencyEnabled;
        }

        @Override
        public final Builder storageEfficiencyEnabled(Boolean storageEfficiencyEnabled) {
            this.storageEfficiencyEnabled = storageEfficiencyEnabled;
            return this;
        }

        public final String getStorageVirtualMachineId() {
            return storageVirtualMachineId;
        }

        public final void setStorageVirtualMachineId(String storageVirtualMachineId) {
            this.storageVirtualMachineId = storageVirtualMachineId;
        }

        @Override
        public final Builder storageVirtualMachineId(String storageVirtualMachineId) {
            this.storageVirtualMachineId = storageVirtualMachineId;
            return this;
        }

        public final TieringPolicy.Builder getTieringPolicy() {
            return tieringPolicy != null ? tieringPolicy.toBuilder() : null;
        }

        public final void setTieringPolicy(TieringPolicy.BuilderImpl tieringPolicy) {
            this.tieringPolicy = tieringPolicy != null ? tieringPolicy.build() : null;
        }

        @Override
        public final Builder tieringPolicy(TieringPolicy tieringPolicy) {
            this.tieringPolicy = tieringPolicy;
            return this;
        }

        public final String getOntapVolumeType() {
            return ontapVolumeType;
        }

        public final void setOntapVolumeType(String ontapVolumeType) {
            this.ontapVolumeType = ontapVolumeType;
        }

        @Override
        public final Builder ontapVolumeType(String ontapVolumeType) {
            this.ontapVolumeType = ontapVolumeType;
            return this;
        }

        @Override
        public final Builder ontapVolumeType(InputOntapVolumeType ontapVolumeType) {
            this.ontapVolumeType(ontapVolumeType == null ? null : ontapVolumeType.toString());
            return this;
        }

        public final String getSnapshotPolicy() {
            return snapshotPolicy;
        }

        public final void setSnapshotPolicy(String snapshotPolicy) {
            this.snapshotPolicy = snapshotPolicy;
        }

        @Override
        public final Builder snapshotPolicy(String snapshotPolicy) {
            this.snapshotPolicy = snapshotPolicy;
            return this;
        }

        public final Boolean getCopyTagsToBackups() {
            return copyTagsToBackups;
        }

        public final void setCopyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
        }

        @Override
        public final Builder copyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
            return this;
        }

        public final CreateSnaplockConfiguration.Builder getSnaplockConfiguration() {
            return snaplockConfiguration != null ? snaplockConfiguration.toBuilder() : null;
        }

        public final void setSnaplockConfiguration(CreateSnaplockConfiguration.BuilderImpl snaplockConfiguration) {
            this.snaplockConfiguration = snaplockConfiguration != null ? snaplockConfiguration.build() : null;
        }

        @Override
        public final Builder snaplockConfiguration(CreateSnaplockConfiguration snaplockConfiguration) {
            this.snaplockConfiguration = snaplockConfiguration;
            return this;
        }

        public final String getVolumeStyle() {
            return volumeStyle;
        }

        public final void setVolumeStyle(String volumeStyle) {
            this.volumeStyle = volumeStyle;
        }

        @Override
        public final Builder volumeStyle(String volumeStyle) {
            this.volumeStyle = volumeStyle;
            return this;
        }

        @Override
        public final Builder volumeStyle(VolumeStyle volumeStyle) {
            this.volumeStyle(volumeStyle == null ? null : volumeStyle.toString());
            return this;
        }

        public final CreateAggregateConfiguration.Builder getAggregateConfiguration() {
            return aggregateConfiguration != null ? aggregateConfiguration.toBuilder() : null;
        }

        public final void setAggregateConfiguration(CreateAggregateConfiguration.BuilderImpl aggregateConfiguration) {
            this.aggregateConfiguration = aggregateConfiguration != null ? aggregateConfiguration.build() : null;
        }

        @Override
        public final Builder aggregateConfiguration(CreateAggregateConfiguration aggregateConfiguration) {
            this.aggregateConfiguration = aggregateConfiguration;
            return this;
        }

        public final Long getSizeInBytes() {
            return sizeInBytes;
        }

        public final void setSizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        @Override
        public final Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        @Override
        public CreateOntapVolumeConfiguration build() {
            return new CreateOntapVolumeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
