/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSharedVpcConfigurationResponse extends FSxResponse implements
        ToCopyableBuilder<DescribeSharedVpcConfigurationResponse.Builder, DescribeSharedVpcConfigurationResponse> {
    private static final SdkField<String> ENABLE_FSX_ROUTE_TABLE_UPDATES_FROM_PARTICIPANT_ACCOUNTS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EnableFsxRouteTableUpdatesFromParticipantAccounts")
            .getter(getter(DescribeSharedVpcConfigurationResponse::enableFsxRouteTableUpdatesFromParticipantAccounts))
            .setter(setter(Builder::enableFsxRouteTableUpdatesFromParticipantAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EnableFsxRouteTableUpdatesFromParticipantAccounts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ENABLE_FSX_ROUTE_TABLE_UPDATES_FROM_PARTICIPANT_ACCOUNTS_FIELD));

    private final String enableFsxRouteTableUpdatesFromParticipantAccounts;

    private DescribeSharedVpcConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.enableFsxRouteTableUpdatesFromParticipantAccounts = builder.enableFsxRouteTableUpdatesFromParticipantAccounts;
    }

    /**
     * <p>
     * Indicates whether participant accounts can create FSx for ONTAP Multi-AZ file systems in shared subnets.
     * </p>
     * 
     * @return Indicates whether participant accounts can create FSx for ONTAP Multi-AZ file systems in shared subnets.
     */
    public final String enableFsxRouteTableUpdatesFromParticipantAccounts() {
        return enableFsxRouteTableUpdatesFromParticipantAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(enableFsxRouteTableUpdatesFromParticipantAccounts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSharedVpcConfigurationResponse)) {
            return false;
        }
        DescribeSharedVpcConfigurationResponse other = (DescribeSharedVpcConfigurationResponse) obj;
        return Objects.equals(enableFsxRouteTableUpdatesFromParticipantAccounts(),
                other.enableFsxRouteTableUpdatesFromParticipantAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSharedVpcConfigurationResponse")
                .add("EnableFsxRouteTableUpdatesFromParticipantAccounts", enableFsxRouteTableUpdatesFromParticipantAccounts())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableFsxRouteTableUpdatesFromParticipantAccounts":
            return Optional.ofNullable(clazz.cast(enableFsxRouteTableUpdatesFromParticipantAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSharedVpcConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeSharedVpcConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSharedVpcConfigurationResponse> {
        /**
         * <p>
         * Indicates whether participant accounts can create FSx for ONTAP Multi-AZ file systems in shared subnets.
         * </p>
         * 
         * @param enableFsxRouteTableUpdatesFromParticipantAccounts
         *        Indicates whether participant accounts can create FSx for ONTAP Multi-AZ file systems in shared
         *        subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableFsxRouteTableUpdatesFromParticipantAccounts(String enableFsxRouteTableUpdatesFromParticipantAccounts);
    }

    static final class BuilderImpl extends FSxResponse.BuilderImpl implements Builder {
        private String enableFsxRouteTableUpdatesFromParticipantAccounts;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSharedVpcConfigurationResponse model) {
            super(model);
            enableFsxRouteTableUpdatesFromParticipantAccounts(model.enableFsxRouteTableUpdatesFromParticipantAccounts);
        }

        public final String getEnableFsxRouteTableUpdatesFromParticipantAccounts() {
            return enableFsxRouteTableUpdatesFromParticipantAccounts;
        }

        public final void setEnableFsxRouteTableUpdatesFromParticipantAccounts(
                String enableFsxRouteTableUpdatesFromParticipantAccounts) {
            this.enableFsxRouteTableUpdatesFromParticipantAccounts = enableFsxRouteTableUpdatesFromParticipantAccounts;
        }

        @Override
        public final Builder enableFsxRouteTableUpdatesFromParticipantAccounts(
                String enableFsxRouteTableUpdatesFromParticipantAccounts) {
            this.enableFsxRouteTableUpdatesFromParticipantAccounts = enableFsxRouteTableUpdatesFromParticipantAccounts;
            return this;
        }

        @Override
        public DescribeSharedVpcConfigurationResponse build() {
            return new DescribeSharedVpcConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
